/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.adobe;

import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.adobe.AdobeJpegDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdobeJpegDescriptor
extends TagDescriptor<AdobeJpegDirectory> {
    public AdobeJpegDescriptor(AdobeJpegDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 3: {
                return this.getColorTransformDescription();
            }
            case 0: {
                return this.getDctEncodeVersionDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    private String getDctEncodeVersionDescription() {
        Integer value = ((AdobeJpegDirectory)this._directory).getInteger(3);
        return value == null ? null : (value == 100 ? "100" : Integer.toString(value));
    }

    @Nullable
    private String getColorTransformDescription() {
        Integer value = ((AdobeJpegDirectory)this._directory).getInteger(3);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Unknown (RGB or CMYK)";
            }
            case 1: {
                return "YCbCr";
            }
            case 2: {
                return "YCCK";
            }
        }
        return String.format("Unknown transform (%d)", value);
    }
}

