/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lbel;

class Token {
    private int type;
    private Object value;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int OR = 10;
    public static final int AND = 11;
    public static final int NOT = 12;
    public static final int LITERAL = 20;
    public static final int NUMBER = 21;
    public static final int OPERATOR = 30;
    public static final int LP = 40;
    public static final int RP = 41;
    public static final int LOGGER = 100;
    public static final int MESSAGE = 110;
    public static final int LEVEL = 120;
    public static final int TIMESTAMP = 130;
    public static final int THREAD = 140;
    public static final int PROPERTY = 150;
    public static final int DATE = 160;
    public static final int CLASS = 170;
    public static final int METHOD = 180;
    public static final int NULL = 190;
    public static final int DOT = 200;
    public static final int EOF = 1000;

    public Token(int type) {
        this(type, null);
    }

    public Token(int type, Object value) {
        this.type = type;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        String typeStr = null;
        switch (this.type) {
            case 1: {
                typeStr = "TRUE";
                break;
            }
            case 2: {
                typeStr = "FALSE";
                break;
            }
            case 10: {
                typeStr = "OR";
                break;
            }
            case 11: {
                typeStr = "AND";
                break;
            }
            case 12: {
                typeStr = "NOT";
                break;
            }
            case 20: {
                typeStr = "IDENTIFIER";
                break;
            }
            case 21: {
                typeStr = "NUMBER";
                break;
            }
            case 30: {
                typeStr = "OPERATOR";
                break;
            }
            case 40: {
                typeStr = "LP";
                break;
            }
            case 41: {
                typeStr = "RP";
                break;
            }
            case 100: {
                typeStr = "LOGGER";
                break;
            }
            case 110: {
                typeStr = "MESSAGE";
                break;
            }
            case 120: {
                typeStr = "LEVEL";
                break;
            }
            case 130: {
                typeStr = "TIMESTAMP";
                break;
            }
            case 140: {
                typeStr = "THREAD";
                break;
            }
            case 150: {
                typeStr = "PROPERTY";
                break;
            }
            case 160: {
                typeStr = "DATE";
                break;
            }
            case 1000: {
                typeStr = "EOF";
                break;
            }
            default: {
                typeStr = "UNKNOWN";
            }
        }
        return "Token(" + typeStr + ", " + this.value + ")";
    }
}

