/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.FastCopyHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CopyOnWriteWeakMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final Queue<K, V> queue = new Queue();
    private static final FastCopyHashMap EMPTY = new FastCopyHashMap(32, 0.25f);
    private volatile FastCopyHashMap<K, Node<K, V>> map = this.empty();

    CopyOnWriteWeakMap() {
    }

    private FastCopyHashMap<K, Node<K, V>> empty() {
        return EMPTY;
    }

    private FastCopyHashMap<K, Node<K, V>> cleanCopyForRemove() {
        Reference ref;
        assert (Thread.holdsLock(this));
        FastCopyHashMap<K, Node<K, V>> oldMap = this.map;
        Queue<K, V> queue = this.queue;
        if (oldMap.isEmpty()) {
            queue.clear();
            return this.empty();
        }
        FastCopyHashMap<K, Node<K, V>> newMap = new FastCopyHashMap<K, Node<K, V>>(oldMap);
        while ((ref = queue.poll()) != null) {
            Object key = ((Node)ref).getKey();
            if (newMap.get(key) != ref) continue;
            newMap.remove(key);
            if (!newMap.isEmpty()) continue;
            queue.clear();
            return this.empty();
        }
        return newMap;
    }

    private FastCopyHashMap<K, Node<K, V>> cleanCopyForMod() {
        Reference ref;
        assert (Thread.holdsLock(this));
        FastCopyHashMap<K, Node<K, V>> oldMap = this.map;
        Queue<K, V> queue = this.queue;
        if (oldMap.isEmpty()) {
            queue.clear();
            return this.empty().clone();
        }
        FastCopyHashMap<K, Node<K, V>> newMap = new FastCopyHashMap<K, Node<K, V>>(oldMap);
        while ((ref = queue.poll()) != null) {
            Object key = ((Node)ref).getKey();
            if (newMap.get(key) != ref) continue;
            newMap.remove(key);
            if (!newMap.isEmpty()) continue;
            queue.clear();
            return this.empty().clone();
        }
        return newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        CopyOnWriteWeakMap copyOnWriteWeakMap = this;
        synchronized (copyOnWriteWeakMap) {
            Object val;
            Node<K, V> oldNode = this.map.get(key);
            if (oldNode != null && (val = oldNode.get()) != null) {
                return (V)val;
            }
            FastCopyHashMap<K, Node<K, Node<K, Node<K, V>>>> newMap = this.cleanCopyForMod();
            newMap.put(key, new Node<K, V>(key, value, this.queue));
            this.map = newMap;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        CopyOnWriteWeakMap copyOnWriteWeakMap = this;
        synchronized (copyOnWriteWeakMap) {
            Node<K, V> oldNode = this.map.get(key);
            Object existing = oldNode.get();
            if (existing != null && existing.equals(value)) {
                FastCopyHashMap<K, Node<K, Node<K, V>>> newMap = this.cleanCopyForRemove();
                newMap.remove(key);
                this.map = newMap;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        if (oldValue == null) {
            return false;
        }
        CopyOnWriteWeakMap copyOnWriteWeakMap = this;
        synchronized (copyOnWriteWeakMap) {
            Node<K, V> oldNode = this.map.get(key);
            Object existing = oldNode.get();
            if (existing != null && existing.equals(oldValue)) {
                FastCopyHashMap<K, Node<K, Node<K, V>>> newMap = this.cleanCopyForMod();
                this.map.put(key, new Node<K, V>(key, newValue, this.queue));
                this.map = newMap;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        CopyOnWriteWeakMap copyOnWriteWeakMap = this;
        synchronized (copyOnWriteWeakMap) {
            Node<K, V> oldNode = this.map.get(key);
            Object existing = oldNode.get();
            if (existing != null) {
                FastCopyHashMap<K, Node<K, Node<K, V>>> newMap = this.cleanCopyForMod();
                this.map.put(key, new Node<K, V>(key, value, this.queue));
                this.map = newMap;
            }
            return (V)existing;
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (Node<K, V> node : this.map.values()) {
            if (!value.equals(node.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Node<K, V> node = this.map.get(key);
        return node == null ? null : (V)node.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        CopyOnWriteWeakMap copyOnWriteWeakMap = this;
        synchronized (copyOnWriteWeakMap) {
            FastCopyHashMap<K, Node<K, Node<K, Node<K, V>>>> newMap = this.cleanCopyForMod();
            Node<K, V> old = newMap.put(key, new Node<K, V>(key, value, this.queue));
            this.map = newMap;
            return old == null ? null : (V)old.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        CopyOnWriteWeakMap copyOnWriteWeakMap = this;
        synchronized (copyOnWriteWeakMap) {
            FastCopyHashMap<K, Node<K, Node<K, V>>> newMap = this.cleanCopyForRemove();
            Node<K, V> old = newMap.remove(key);
            this.map = newMap;
            return old == null ? null : (V)old.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        CopyOnWriteWeakMap copyOnWriteWeakMap = this;
        synchronized (copyOnWriteWeakMap) {
            this.map = this.empty();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        FastCopyHashMap<K, Node<K, V>> snapshot = this.map;
        HashMap copyMap = new HashMap();
        for (Node<K, V> node : snapshot.values()) {
            Object value = node.get();
            if (value == null) continue;
            K key = node.getKey();
            copyMap.put(key, value);
        }
        return Collections.unmodifiableMap(copyMap).entrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Queue<K, V>
    extends ReferenceQueue<V> {
        private Queue() {
        }

        public Node<K, V> poll() {
            return (Node)super.poll();
        }

        void clear() {
            while (this.poll() != null) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node<K, V>
    extends WeakReference<V> {
        private final K key;

        Node(K key, V value, ReferenceQueue<? super V> queue) {
            super(value, queue);
            this.key = key;
        }

        K getKey() {
            return this.key;
        }
    }
}

