/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.logmanager;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.LoggerPluginInstance;
import org.jboss.logging.MDCProvider;
import org.jboss.logging.MDCSupport;
import org.jboss.logging.NDCProvider;
import org.jboss.logging.NDCSupport;
import org.jboss.logging.logmanager.LoggerPluginInstanceImpl;
import org.jboss.logging.logmanager.MDCProviderImpl;
import org.jboss.logging.logmanager.NDCProviderImpl;
import org.jboss.logmanager.Logger;

public class LoggerPluginImpl
implements LoggerPlugin,
MDCSupport,
NDCSupport {
    private final MDCProvider mdcProvider = new MDCProviderImpl();
    private final NDCProvider ndcProvider = new NDCProviderImpl();
    private static final Logger.AttachmentKey<LoggerPluginInstance> KEY = new Logger.AttachmentKey();

    public LoggerPluginInstance getInstance(String name, String resourceBundleName) {
        Logger logger = resourceBundleName == null ? Logger.getLogger((String)name) : Logger.getLogger((String)name, (String)resourceBundleName);
        Object lpi = (LoggerPluginInstance)logger.getAttachment(KEY);
        if (lpi == null) {
            SecurityManager sm = System.getSecurityManager();
            lpi = new LoggerPluginInstanceImpl(name, resourceBundleName, logger, this);
            if (sm != null) {
                return AccessController.doPrivileged(new AttachAction(logger, (LoggerPluginInstance)lpi));
            }
            return LoggerPluginImpl.doAttach(logger, lpi);
        }
        return lpi;
    }

    public MDCProvider getMDCProvider() {
        return this.mdcProvider;
    }

    public NDCProvider getNDCProvider() {
        return this.ndcProvider;
    }

    private static LoggerPluginInstance doAttach(Logger logger, LoggerPluginInstance attachment) {
        LoggerPluginInstance appeared = (LoggerPluginInstance)logger.attachIfAbsent(KEY, (Object)attachment);
        if (appeared != null) {
            return appeared;
        }
        return attachment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AttachAction
    implements PrivilegedAction<LoggerPluginInstance> {
        private final Logger logger;
        private final LoggerPluginInstance attachment;

        private AttachAction(Logger logger, LoggerPluginInstance attachment) {
            this.logger = logger;
            this.attachment = attachment;
        }

        @Override
        public LoggerPluginInstance run() {
            Logger logger = this.logger;
            LoggerPluginInstance attachment = this.attachment;
            return LoggerPluginImpl.doAttach(logger, attachment);
        }
    }
}

