/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JetFormat {
    public static final int MAX_RECORD_SIZE = 1900;
    public static final short TEXT_FIELD_UNIT_SIZE = 2;
    public static final short TEXT_FIELD_MAX_LENGTH = 510;
    private static final int OFFSET_VERSION = 20;
    private static final byte CODE_VERSION_3 = 0;
    private static final byte CODE_VERSION_4 = 1;
    private static final byte CODE_VERSION_12 = 2;
    private static final byte CODE_VERSION_14 = 3;
    static final int OFFSET_ENGINE_NAME = 4;
    static final int LENGTH_ENGINE_NAME = 15;
    private static final int HEADER_LENGTH = 21;
    private static final byte[] MSISAM_ENGINE = new byte[]{77, 83, 73, 83, 65, 77, 32, 68, 97, 116, 97, 98, 97, 115, 101};
    private static final byte[] BASE_HEADER_MASK = new byte[]{-75, 111, 3, 98, 97, 8, -62, 85, -21, -87, 103, 114, 67, 63, 0, -100, 122, -97, -112, -1, -128, -102, 49, -59, 121, -70, -19, 48, -68, -33, -52, -99, 99, -39, -28, -61, 123, 66, -5, -118, -68, 78, -122, -5, -20, 55, 93, 68, -100, -6, -58, 94, 40, -26, 19, -74, -118, 96, 84, -108, 123, 54, -11, 114, -33, -79, 119, -12, 19, 67, -49, -81, -79, 51, 52, 97, 121, 91, -110, -75, 124, 42, 5, -15, 124, -103, 1, 27, -104, -3, 18, 79, 74, -108, 108, 62, 96, 38, 95, -107, -8, -48, -119, 36, -123, 103, -58, 31, 39, 68, -46, -18, -49, 101, -19, -1, 7, -57, 70, -95, 120, 22, 12, -19, -23, 45, 98, -44};
    private static final String ACCESS_VERSION_2000 = "08.50";
    private static final String ACCESS_VERSION_2003 = "09.50";
    static final byte[][] PROPERTY_MAP_TYPES = new byte[][]{{77, 82, 50, 0}, {75, 75, 68, 0}};
    private static final Set<DataType> V14_CALC_TYPES = EnumSet.of(DataType.BOOLEAN, new DataType[]{DataType.BYTE, DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.GUID, DataType.SHORT_DATE_TIME, DataType.MONEY, DataType.NUMERIC, DataType.TEXT, DataType.MEMO});
    public static final JetFormat VERSION_3 = new Jet3Format();
    public static final JetFormat VERSION_4 = new Jet4Format();
    public static final JetFormat VERSION_MSISAM = new MSISAMFormat();
    public static final JetFormat VERSION_12 = new Jet12Format();
    public static final JetFormat VERSION_14 = new Jet14Format();
    private final String _name;
    public final boolean READ_ONLY;
    public final boolean INDEXES_SUPPORTED;
    public final CodecType CODEC_TYPE;
    public final int PAGE_SIZE;
    public final long MAX_DATABASE_SIZE;
    public final int MAX_ROW_SIZE;
    public final int DATA_PAGE_INITIAL_FREE_SPACE;
    public final int OFFSET_MASKED_HEADER;
    public final byte[] HEADER_MASK;
    public final int OFFSET_HEADER_DATE;
    public final int OFFSET_PASSWORD;
    public final int SIZE_PASSWORD;
    public final int OFFSET_SORT_ORDER;
    public final int SIZE_SORT_ORDER;
    public final int OFFSET_CODE_PAGE;
    public final int OFFSET_ENCODING_KEY;
    public final int OFFSET_NEXT_TABLE_DEF_PAGE;
    public final int OFFSET_NUM_ROWS;
    public final int OFFSET_NEXT_AUTO_NUMBER;
    public final int OFFSET_NEXT_COMPLEX_AUTO_NUMBER;
    public final int OFFSET_TABLE_TYPE;
    public final int OFFSET_MAX_COLS;
    public final int OFFSET_NUM_VAR_COLS;
    public final int OFFSET_NUM_COLS;
    public final int OFFSET_NUM_INDEX_SLOTS;
    public final int OFFSET_NUM_INDEXES;
    public final int OFFSET_OWNED_PAGES;
    public final int OFFSET_FREE_SPACE_PAGES;
    public final int OFFSET_INDEX_DEF_BLOCK;
    public final int SIZE_INDEX_COLUMN_BLOCK;
    public final int SIZE_INDEX_INFO_BLOCK;
    public final int OFFSET_COLUMN_TYPE;
    public final int OFFSET_COLUMN_NUMBER;
    public final int OFFSET_COLUMN_PRECISION;
    public final int OFFSET_COLUMN_SCALE;
    public final int OFFSET_COLUMN_SORT_ORDER;
    public final int OFFSET_COLUMN_CODE_PAGE;
    public final int OFFSET_COLUMN_COMPLEX_ID;
    public final int OFFSET_COLUMN_FLAGS;
    public final int OFFSET_COLUMN_EXT_FLAGS;
    public final int OFFSET_COLUMN_LENGTH;
    public final int OFFSET_COLUMN_VARIABLE_TABLE_INDEX;
    public final int OFFSET_COLUMN_FIXED_DATA_OFFSET;
    public final int OFFSET_COLUMN_FIXED_DATA_ROW_OFFSET;
    public final int OFFSET_TABLE_DEF_LOCATION;
    public final int OFFSET_ROW_START;
    public final int OFFSET_USAGE_MAP_START;
    public final int OFFSET_USAGE_MAP_PAGE_DATA;
    public final int OFFSET_REFERENCE_MAP_PAGE_NUMBERS;
    public final int OFFSET_FREE_SPACE;
    public final int OFFSET_NUM_ROWS_ON_DATA_PAGE;
    public final int MAX_NUM_ROWS_ON_DATA_PAGE;
    public final int OFFSET_INDEX_COMPRESSED_BYTE_COUNT;
    public final int OFFSET_INDEX_ENTRY_MASK;
    public final int OFFSET_PREV_INDEX_PAGE;
    public final int OFFSET_NEXT_INDEX_PAGE;
    public final int OFFSET_CHILD_TAIL_INDEX_PAGE;
    public final int SIZE_INDEX_DEFINITION;
    public final int SIZE_COLUMN_HEADER;
    public final int SIZE_ROW_LOCATION;
    public final int SIZE_LONG_VALUE_DEF;
    public final int MAX_INLINE_LONG_VALUE_SIZE;
    public final int MAX_LONG_VALUE_ROW_SIZE;
    public final int MAX_COMPRESSED_UNICODE_SIZE;
    public final int SIZE_TDEF_HEADER;
    public final int SIZE_TDEF_TRAILER;
    public final int SIZE_COLUMN_DEF_BLOCK;
    public final int SIZE_INDEX_ENTRY_MASK;
    public final int SKIP_BEFORE_INDEX_FLAGS;
    public final int SKIP_AFTER_INDEX_FLAGS;
    public final int SKIP_BEFORE_INDEX_SLOT;
    public final int SKIP_AFTER_INDEX_SLOT;
    public final int SKIP_BEFORE_INDEX;
    public final int SIZE_NAME_LENGTH;
    public final int SIZE_ROW_COLUMN_COUNT;
    public final int SIZE_ROW_VAR_COL_OFFSET;
    public final int USAGE_MAP_TABLE_BYTE_LENGTH;
    public final int MAX_COLUMNS_PER_TABLE;
    public final int MAX_INDEXES_PER_TABLE;
    public final int MAX_TABLE_NAME_LENGTH;
    public final int MAX_COLUMN_NAME_LENGTH;
    public final int MAX_INDEX_NAME_LENGTH;
    public final boolean LEGACY_NUMERIC_INDEXES;
    public final Charset CHARSET;
    public final ColumnImpl.SortOrder DEFAULT_SORT_ORDER;
    public final byte[] PROPERTY_MAP_TYPE;

    public static JetFormat getFormat(FileChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(21);
        int bytesRead = channel.read(buffer, 0L);
        if (bytesRead < 21) {
            throw new IOException("Empty database file");
        }
        buffer.flip();
        byte version = buffer.get(20);
        if (version == 0) {
            return VERSION_3;
        }
        if (version == 1) {
            if (ByteUtil.matchesRange(buffer, 4, MSISAM_ENGINE)) {
                return VERSION_MSISAM;
            }
            return VERSION_4;
        }
        if (version == 2) {
            return VERSION_12;
        }
        if (version == 3) {
            return VERSION_14;
        }
        throw new IOException("Unsupported " + (version < 0 ? "older" : "newer") + " version: " + version);
    }

    private JetFormat(String name) {
        this._name = name;
        this.READ_ONLY = this.defineReadOnly();
        this.INDEXES_SUPPORTED = this.defineIndexesSupported();
        this.CODEC_TYPE = this.defineCodecType();
        this.PAGE_SIZE = this.definePageSize();
        this.MAX_DATABASE_SIZE = this.defineMaxDatabaseSize();
        this.MAX_ROW_SIZE = this.defineMaxRowSize();
        this.DATA_PAGE_INITIAL_FREE_SPACE = this.defineDataPageInitialFreeSpace();
        this.OFFSET_MASKED_HEADER = this.defineOffsetMaskedHeader();
        this.HEADER_MASK = this.defineHeaderMask();
        this.OFFSET_HEADER_DATE = this.defineOffsetHeaderDate();
        this.OFFSET_PASSWORD = this.defineOffsetPassword();
        this.SIZE_PASSWORD = this.defineSizePassword();
        this.OFFSET_SORT_ORDER = this.defineOffsetSortOrder();
        this.SIZE_SORT_ORDER = this.defineSizeSortOrder();
        this.OFFSET_CODE_PAGE = this.defineOffsetCodePage();
        this.OFFSET_ENCODING_KEY = this.defineOffsetEncodingKey();
        this.OFFSET_NEXT_TABLE_DEF_PAGE = this.defineOffsetNextTableDefPage();
        this.OFFSET_NUM_ROWS = this.defineOffsetNumRows();
        this.OFFSET_NEXT_AUTO_NUMBER = this.defineOffsetNextAutoNumber();
        this.OFFSET_NEXT_COMPLEX_AUTO_NUMBER = this.defineOffsetNextComplexAutoNumber();
        this.OFFSET_TABLE_TYPE = this.defineOffsetTableType();
        this.OFFSET_MAX_COLS = this.defineOffsetMaxCols();
        this.OFFSET_NUM_VAR_COLS = this.defineOffsetNumVarCols();
        this.OFFSET_NUM_COLS = this.defineOffsetNumCols();
        this.OFFSET_NUM_INDEX_SLOTS = this.defineOffsetNumIndexSlots();
        this.OFFSET_NUM_INDEXES = this.defineOffsetNumIndexes();
        this.OFFSET_OWNED_PAGES = this.defineOffsetOwnedPages();
        this.OFFSET_FREE_SPACE_PAGES = this.defineOffsetFreeSpacePages();
        this.OFFSET_INDEX_DEF_BLOCK = this.defineOffsetIndexDefBlock();
        this.SIZE_INDEX_COLUMN_BLOCK = this.defineSizeIndexColumnBlock();
        this.SIZE_INDEX_INFO_BLOCK = this.defineSizeIndexInfoBlock();
        this.OFFSET_COLUMN_TYPE = this.defineOffsetColumnType();
        this.OFFSET_COLUMN_NUMBER = this.defineOffsetColumnNumber();
        this.OFFSET_COLUMN_PRECISION = this.defineOffsetColumnPrecision();
        this.OFFSET_COLUMN_SCALE = this.defineOffsetColumnScale();
        this.OFFSET_COLUMN_SORT_ORDER = this.defineOffsetColumnSortOrder();
        this.OFFSET_COLUMN_CODE_PAGE = this.defineOffsetColumnCodePage();
        this.OFFSET_COLUMN_COMPLEX_ID = this.defineOffsetColumnComplexId();
        this.OFFSET_COLUMN_FLAGS = this.defineOffsetColumnFlags();
        this.OFFSET_COLUMN_EXT_FLAGS = this.defineOffsetColumnExtFlags();
        this.OFFSET_COLUMN_LENGTH = this.defineOffsetColumnLength();
        this.OFFSET_COLUMN_VARIABLE_TABLE_INDEX = this.defineOffsetColumnVariableTableIndex();
        this.OFFSET_COLUMN_FIXED_DATA_OFFSET = this.defineOffsetColumnFixedDataOffset();
        this.OFFSET_COLUMN_FIXED_DATA_ROW_OFFSET = this.defineOffsetColumnFixedDataRowOffset();
        this.OFFSET_TABLE_DEF_LOCATION = this.defineOffsetTableDefLocation();
        this.OFFSET_ROW_START = this.defineOffsetRowStart();
        this.OFFSET_USAGE_MAP_START = this.defineOffsetUsageMapStart();
        this.OFFSET_USAGE_MAP_PAGE_DATA = this.defineOffsetUsageMapPageData();
        this.OFFSET_REFERENCE_MAP_PAGE_NUMBERS = this.defineOffsetReferenceMapPageNumbers();
        this.OFFSET_FREE_SPACE = this.defineOffsetFreeSpace();
        this.OFFSET_NUM_ROWS_ON_DATA_PAGE = this.defineOffsetNumRowsOnDataPage();
        this.MAX_NUM_ROWS_ON_DATA_PAGE = this.defineMaxNumRowsOnDataPage();
        this.OFFSET_INDEX_COMPRESSED_BYTE_COUNT = this.defineOffsetIndexCompressedByteCount();
        this.OFFSET_INDEX_ENTRY_MASK = this.defineOffsetIndexEntryMask();
        this.OFFSET_PREV_INDEX_PAGE = this.defineOffsetPrevIndexPage();
        this.OFFSET_NEXT_INDEX_PAGE = this.defineOffsetNextIndexPage();
        this.OFFSET_CHILD_TAIL_INDEX_PAGE = this.defineOffsetChildTailIndexPage();
        this.SIZE_INDEX_DEFINITION = this.defineSizeIndexDefinition();
        this.SIZE_COLUMN_HEADER = this.defineSizeColumnHeader();
        this.SIZE_ROW_LOCATION = this.defineSizeRowLocation();
        this.SIZE_LONG_VALUE_DEF = this.defineSizeLongValueDef();
        this.MAX_INLINE_LONG_VALUE_SIZE = this.defineMaxInlineLongValueSize();
        this.MAX_LONG_VALUE_ROW_SIZE = this.defineMaxLongValueRowSize();
        this.MAX_COMPRESSED_UNICODE_SIZE = this.defineMaxCompressedUnicodeSize();
        this.SIZE_TDEF_HEADER = this.defineSizeTdefHeader();
        this.SIZE_TDEF_TRAILER = this.defineSizeTdefTrailer();
        this.SIZE_COLUMN_DEF_BLOCK = this.defineSizeColumnDefBlock();
        this.SIZE_INDEX_ENTRY_MASK = this.defineSizeIndexEntryMask();
        this.SKIP_BEFORE_INDEX_FLAGS = this.defineSkipBeforeIndexFlags();
        this.SKIP_AFTER_INDEX_FLAGS = this.defineSkipAfterIndexFlags();
        this.SKIP_BEFORE_INDEX_SLOT = this.defineSkipBeforeIndexSlot();
        this.SKIP_AFTER_INDEX_SLOT = this.defineSkipAfterIndexSlot();
        this.SKIP_BEFORE_INDEX = this.defineSkipBeforeIndex();
        this.SIZE_NAME_LENGTH = this.defineSizeNameLength();
        this.SIZE_ROW_COLUMN_COUNT = this.defineSizeRowColumnCount();
        this.SIZE_ROW_VAR_COL_OFFSET = this.defineSizeRowVarColOffset();
        this.USAGE_MAP_TABLE_BYTE_LENGTH = this.defineUsageMapTableByteLength();
        this.MAX_COLUMNS_PER_TABLE = this.defineMaxColumnsPerTable();
        this.MAX_INDEXES_PER_TABLE = this.defineMaxIndexesPerTable();
        this.MAX_TABLE_NAME_LENGTH = this.defineMaxTableNameLength();
        this.MAX_COLUMN_NAME_LENGTH = this.defineMaxColumnNameLength();
        this.MAX_INDEX_NAME_LENGTH = this.defineMaxIndexNameLength();
        this.LEGACY_NUMERIC_INDEXES = this.defineLegacyNumericIndexes();
        this.CHARSET = this.defineCharset();
        this.DEFAULT_SORT_ORDER = this.defineDefaultSortOrder();
        this.PROPERTY_MAP_TYPE = this.definePropMapType();
    }

    protected abstract boolean defineReadOnly();

    protected abstract boolean defineIndexesSupported();

    protected abstract CodecType defineCodecType();

    protected abstract int definePageSize();

    protected abstract long defineMaxDatabaseSize();

    protected abstract int defineMaxRowSize();

    protected abstract int defineDataPageInitialFreeSpace();

    protected abstract int defineOffsetMaskedHeader();

    protected abstract byte[] defineHeaderMask();

    protected abstract int defineOffsetHeaderDate();

    protected abstract int defineOffsetPassword();

    protected abstract int defineSizePassword();

    protected abstract int defineOffsetSortOrder();

    protected abstract int defineSizeSortOrder();

    protected abstract int defineOffsetCodePage();

    protected abstract int defineOffsetEncodingKey();

    protected abstract int defineOffsetNextTableDefPage();

    protected abstract int defineOffsetNumRows();

    protected abstract int defineOffsetNextAutoNumber();

    protected abstract int defineOffsetNextComplexAutoNumber();

    protected abstract int defineOffsetTableType();

    protected abstract int defineOffsetMaxCols();

    protected abstract int defineOffsetNumVarCols();

    protected abstract int defineOffsetNumCols();

    protected abstract int defineOffsetNumIndexSlots();

    protected abstract int defineOffsetNumIndexes();

    protected abstract int defineOffsetOwnedPages();

    protected abstract int defineOffsetFreeSpacePages();

    protected abstract int defineOffsetIndexDefBlock();

    protected abstract int defineSizeIndexColumnBlock();

    protected abstract int defineSizeIndexInfoBlock();

    protected abstract int defineOffsetColumnType();

    protected abstract int defineOffsetColumnNumber();

    protected abstract int defineOffsetColumnPrecision();

    protected abstract int defineOffsetColumnScale();

    protected abstract int defineOffsetColumnSortOrder();

    protected abstract int defineOffsetColumnCodePage();

    protected abstract int defineOffsetColumnComplexId();

    protected abstract int defineOffsetColumnFlags();

    protected abstract int defineOffsetColumnExtFlags();

    protected abstract int defineOffsetColumnLength();

    protected abstract int defineOffsetColumnVariableTableIndex();

    protected abstract int defineOffsetColumnFixedDataOffset();

    protected abstract int defineOffsetColumnFixedDataRowOffset();

    protected abstract int defineOffsetTableDefLocation();

    protected abstract int defineOffsetRowStart();

    protected abstract int defineOffsetUsageMapStart();

    protected abstract int defineOffsetUsageMapPageData();

    protected abstract int defineOffsetReferenceMapPageNumbers();

    protected abstract int defineOffsetFreeSpace();

    protected abstract int defineOffsetNumRowsOnDataPage();

    protected abstract int defineMaxNumRowsOnDataPage();

    protected abstract int defineOffsetIndexCompressedByteCount();

    protected abstract int defineOffsetIndexEntryMask();

    protected abstract int defineOffsetPrevIndexPage();

    protected abstract int defineOffsetNextIndexPage();

    protected abstract int defineOffsetChildTailIndexPage();

    protected abstract int defineSizeIndexDefinition();

    protected abstract int defineSizeColumnHeader();

    protected abstract int defineSizeRowLocation();

    protected abstract int defineSizeLongValueDef();

    protected abstract int defineMaxInlineLongValueSize();

    protected abstract int defineMaxLongValueRowSize();

    protected abstract int defineMaxCompressedUnicodeSize();

    protected abstract int defineSizeTdefHeader();

    protected abstract int defineSizeTdefTrailer();

    protected abstract int defineSizeColumnDefBlock();

    protected abstract int defineSizeIndexEntryMask();

    protected abstract int defineSkipBeforeIndexFlags();

    protected abstract int defineSkipAfterIndexFlags();

    protected abstract int defineSkipBeforeIndexSlot();

    protected abstract int defineSkipAfterIndexSlot();

    protected abstract int defineSkipBeforeIndex();

    protected abstract int defineSizeNameLength();

    protected abstract int defineSizeRowColumnCount();

    protected abstract int defineSizeRowVarColOffset();

    protected abstract int defineUsageMapTableByteLength();

    protected abstract int defineMaxColumnsPerTable();

    protected abstract int defineMaxIndexesPerTable();

    protected abstract int defineMaxTableNameLength();

    protected abstract int defineMaxColumnNameLength();

    protected abstract int defineMaxIndexNameLength();

    protected abstract Charset defineCharset();

    protected abstract ColumnImpl.SortOrder defineDefaultSortOrder();

    protected abstract byte[] definePropMapType();

    protected abstract boolean defineLegacyNumericIndexes();

    protected abstract Map<String, Database.FileFormat> getPossibleFileFormats();

    public abstract boolean isSupportedDataType(DataType var1);

    public abstract boolean isSupportedCalculatedDataType(DataType var1);

    public String toString() {
        return this._name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Jet14Format
    extends Jet12Format {
        private Jet14Format() {
            super("VERSION_14");
        }

        @Override
        protected ColumnImpl.SortOrder defineDefaultSortOrder() {
            return ColumnImpl.GENERAL_SORT_ORDER;
        }

        @Override
        protected byte[] definePropMapType() {
            return PROPERTY_MAP_TYPES[0];
        }

        @Override
        protected Map<String, Database.FileFormat> getPossibleFileFormats() {
            return PossibleFileFormats.POSSIBLE_VERSION_14;
        }

        @Override
        public boolean isSupportedCalculatedDataType(DataType type) {
            return V14_CALC_TYPES.contains((Object)type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jet12Format
    extends Jet4Format {
        private Jet12Format() {
            super("VERSION_12");
        }

        private Jet12Format(String name) {
            super(name);
        }

        @Override
        protected CodecType defineCodecType() {
            return CodecType.OFFICE;
        }

        @Override
        protected boolean defineLegacyNumericIndexes() {
            return false;
        }

        @Override
        protected Map<String, Database.FileFormat> getPossibleFileFormats() {
            return PossibleFileFormats.POSSIBLE_VERSION_12;
        }

        @Override
        protected int defineOffsetNextComplexAutoNumber() {
            return 28;
        }

        @Override
        protected int defineOffsetColumnComplexId() {
            return 11;
        }

        @Override
        public boolean isSupportedDataType(DataType type) {
            return true;
        }

        @Override
        public boolean isSupportedCalculatedDataType(DataType type) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MSISAMFormat
    extends Jet4Format {
        private MSISAMFormat() {
            super("MSISAM");
        }

        @Override
        protected CodecType defineCodecType() {
            return CodecType.MSISAM;
        }

        @Override
        protected Map<String, Database.FileFormat> getPossibleFileFormats() {
            return PossibleFileFormats.POSSIBLE_VERSION_MSISAM;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jet4Format
    extends JetFormat {
        private Jet4Format() {
            this("VERSION_4");
        }

        private Jet4Format(String name) {
            super(name);
        }

        @Override
        protected boolean defineReadOnly() {
            return false;
        }

        @Override
        protected boolean defineIndexesSupported() {
            return true;
        }

        @Override
        protected CodecType defineCodecType() {
            return CodecType.JET;
        }

        @Override
        protected int definePageSize() {
            return 4096;
        }

        @Override
        protected long defineMaxDatabaseSize() {
            return 0x80000000L;
        }

        @Override
        protected int defineMaxRowSize() {
            return 4060;
        }

        @Override
        protected int defineDataPageInitialFreeSpace() {
            return this.PAGE_SIZE - 14;
        }

        @Override
        protected int defineOffsetMaskedHeader() {
            return 24;
        }

        @Override
        protected byte[] defineHeaderMask() {
            return BASE_HEADER_MASK;
        }

        @Override
        protected int defineOffsetHeaderDate() {
            return 114;
        }

        @Override
        protected int defineOffsetPassword() {
            return 66;
        }

        @Override
        protected int defineSizePassword() {
            return 40;
        }

        @Override
        protected int defineOffsetSortOrder() {
            return 110;
        }

        @Override
        protected int defineSizeSortOrder() {
            return 4;
        }

        @Override
        protected int defineOffsetCodePage() {
            return 60;
        }

        @Override
        protected int defineOffsetEncodingKey() {
            return 62;
        }

        @Override
        protected int defineOffsetNextTableDefPage() {
            return 4;
        }

        @Override
        protected int defineOffsetNumRows() {
            return 16;
        }

        @Override
        protected int defineOffsetNextAutoNumber() {
            return 20;
        }

        @Override
        protected int defineOffsetNextComplexAutoNumber() {
            return -1;
        }

        @Override
        protected int defineOffsetTableType() {
            return 40;
        }

        @Override
        protected int defineOffsetMaxCols() {
            return 41;
        }

        @Override
        protected int defineOffsetNumVarCols() {
            return 43;
        }

        @Override
        protected int defineOffsetNumCols() {
            return 45;
        }

        @Override
        protected int defineOffsetNumIndexSlots() {
            return 47;
        }

        @Override
        protected int defineOffsetNumIndexes() {
            return 51;
        }

        @Override
        protected int defineOffsetOwnedPages() {
            return 55;
        }

        @Override
        protected int defineOffsetFreeSpacePages() {
            return 59;
        }

        @Override
        protected int defineOffsetIndexDefBlock() {
            return 63;
        }

        @Override
        protected int defineSizeIndexColumnBlock() {
            return 52;
        }

        @Override
        protected int defineSizeIndexInfoBlock() {
            return 28;
        }

        @Override
        protected int defineOffsetColumnType() {
            return 0;
        }

        @Override
        protected int defineOffsetColumnNumber() {
            return 5;
        }

        @Override
        protected int defineOffsetColumnPrecision() {
            return 11;
        }

        @Override
        protected int defineOffsetColumnScale() {
            return 12;
        }

        @Override
        protected int defineOffsetColumnSortOrder() {
            return 11;
        }

        @Override
        protected int defineOffsetColumnCodePage() {
            return -1;
        }

        @Override
        protected int defineOffsetColumnComplexId() {
            return -1;
        }

        @Override
        protected int defineOffsetColumnFlags() {
            return 15;
        }

        @Override
        protected int defineOffsetColumnExtFlags() {
            return 16;
        }

        @Override
        protected int defineOffsetColumnLength() {
            return 23;
        }

        @Override
        protected int defineOffsetColumnVariableTableIndex() {
            return 7;
        }

        @Override
        protected int defineOffsetColumnFixedDataOffset() {
            return 21;
        }

        @Override
        protected int defineOffsetColumnFixedDataRowOffset() {
            return 2;
        }

        @Override
        protected int defineOffsetTableDefLocation() {
            return 4;
        }

        @Override
        protected int defineOffsetRowStart() {
            return 14;
        }

        @Override
        protected int defineOffsetUsageMapStart() {
            return 5;
        }

        @Override
        protected int defineOffsetUsageMapPageData() {
            return 4;
        }

        @Override
        protected int defineOffsetReferenceMapPageNumbers() {
            return 1;
        }

        @Override
        protected int defineOffsetFreeSpace() {
            return 2;
        }

        @Override
        protected int defineOffsetNumRowsOnDataPage() {
            return 12;
        }

        @Override
        protected int defineMaxNumRowsOnDataPage() {
            return 255;
        }

        @Override
        protected int defineOffsetIndexCompressedByteCount() {
            return 24;
        }

        @Override
        protected int defineOffsetIndexEntryMask() {
            return 27;
        }

        @Override
        protected int defineOffsetPrevIndexPage() {
            return 12;
        }

        @Override
        protected int defineOffsetNextIndexPage() {
            return 16;
        }

        @Override
        protected int defineOffsetChildTailIndexPage() {
            return 20;
        }

        @Override
        protected int defineSizeIndexDefinition() {
            return 12;
        }

        @Override
        protected int defineSizeColumnHeader() {
            return 25;
        }

        @Override
        protected int defineSizeRowLocation() {
            return 2;
        }

        @Override
        protected int defineSizeLongValueDef() {
            return 12;
        }

        @Override
        protected int defineMaxInlineLongValueSize() {
            return 64;
        }

        @Override
        protected int defineMaxLongValueRowSize() {
            return 4076;
        }

        @Override
        protected int defineMaxCompressedUnicodeSize() {
            return 1024;
        }

        @Override
        protected int defineSizeTdefHeader() {
            return 63;
        }

        @Override
        protected int defineSizeTdefTrailer() {
            return 2;
        }

        @Override
        protected int defineSizeColumnDefBlock() {
            return 25;
        }

        @Override
        protected int defineSizeIndexEntryMask() {
            return 453;
        }

        @Override
        protected int defineSkipBeforeIndexFlags() {
            return 4;
        }

        @Override
        protected int defineSkipAfterIndexFlags() {
            return 5;
        }

        @Override
        protected int defineSkipBeforeIndexSlot() {
            return 4;
        }

        @Override
        protected int defineSkipAfterIndexSlot() {
            return 4;
        }

        @Override
        protected int defineSkipBeforeIndex() {
            return 4;
        }

        @Override
        protected int defineSizeNameLength() {
            return 2;
        }

        @Override
        protected int defineSizeRowColumnCount() {
            return 2;
        }

        @Override
        protected int defineSizeRowVarColOffset() {
            return 2;
        }

        @Override
        protected int defineUsageMapTableByteLength() {
            return 64;
        }

        @Override
        protected int defineMaxColumnsPerTable() {
            return 255;
        }

        @Override
        protected int defineMaxIndexesPerTable() {
            return 32;
        }

        @Override
        protected int defineMaxTableNameLength() {
            return 64;
        }

        @Override
        protected int defineMaxColumnNameLength() {
            return 64;
        }

        @Override
        protected int defineMaxIndexNameLength() {
            return 64;
        }

        @Override
        protected boolean defineLegacyNumericIndexes() {
            return true;
        }

        @Override
        protected Charset defineCharset() {
            return Charset.forName("UTF-16LE");
        }

        @Override
        protected ColumnImpl.SortOrder defineDefaultSortOrder() {
            return ColumnImpl.GENERAL_LEGACY_SORT_ORDER;
        }

        @Override
        protected byte[] definePropMapType() {
            return PROPERTY_MAP_TYPES[0];
        }

        @Override
        protected Map<String, Database.FileFormat> getPossibleFileFormats() {
            return PossibleFileFormats.POSSIBLE_VERSION_4;
        }

        @Override
        public boolean isSupportedDataType(DataType type) {
            return type != DataType.COMPLEX_TYPE;
        }

        @Override
        public boolean isSupportedCalculatedDataType(DataType type) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jet3Format
    extends JetFormat {
        private Jet3Format() {
            super("VERSION_3");
        }

        @Override
        protected boolean defineReadOnly() {
            return true;
        }

        @Override
        protected boolean defineIndexesSupported() {
            return false;
        }

        @Override
        protected CodecType defineCodecType() {
            return CodecType.JET;
        }

        @Override
        protected int definePageSize() {
            return 2048;
        }

        @Override
        protected long defineMaxDatabaseSize() {
            return 0x40000000L;
        }

        @Override
        protected int defineMaxRowSize() {
            return 2012;
        }

        @Override
        protected int defineDataPageInitialFreeSpace() {
            return this.PAGE_SIZE - 14;
        }

        @Override
        protected int defineOffsetMaskedHeader() {
            return 24;
        }

        @Override
        protected byte[] defineHeaderMask() {
            return ByteUtil.copyOf(BASE_HEADER_MASK, BASE_HEADER_MASK.length - 2);
        }

        @Override
        protected int defineOffsetHeaderDate() {
            return -1;
        }

        @Override
        protected int defineOffsetPassword() {
            return 66;
        }

        @Override
        protected int defineSizePassword() {
            return 20;
        }

        @Override
        protected int defineOffsetSortOrder() {
            return 58;
        }

        @Override
        protected int defineSizeSortOrder() {
            return 2;
        }

        @Override
        protected int defineOffsetCodePage() {
            return 60;
        }

        @Override
        protected int defineOffsetEncodingKey() {
            return 62;
        }

        @Override
        protected int defineOffsetNextTableDefPage() {
            return 4;
        }

        @Override
        protected int defineOffsetNumRows() {
            return 12;
        }

        @Override
        protected int defineOffsetNextAutoNumber() {
            return 20;
        }

        @Override
        protected int defineOffsetNextComplexAutoNumber() {
            return -1;
        }

        @Override
        protected int defineOffsetTableType() {
            return 20;
        }

        @Override
        protected int defineOffsetMaxCols() {
            return 21;
        }

        @Override
        protected int defineOffsetNumVarCols() {
            return 23;
        }

        @Override
        protected int defineOffsetNumCols() {
            return 25;
        }

        @Override
        protected int defineOffsetNumIndexSlots() {
            return 27;
        }

        @Override
        protected int defineOffsetNumIndexes() {
            return 31;
        }

        @Override
        protected int defineOffsetOwnedPages() {
            return 35;
        }

        @Override
        protected int defineOffsetFreeSpacePages() {
            return 39;
        }

        @Override
        protected int defineOffsetIndexDefBlock() {
            return 43;
        }

        @Override
        protected int defineSizeIndexColumnBlock() {
            return 39;
        }

        @Override
        protected int defineSizeIndexInfoBlock() {
            return 20;
        }

        @Override
        protected int defineOffsetColumnType() {
            return 0;
        }

        @Override
        protected int defineOffsetColumnNumber() {
            return 1;
        }

        @Override
        protected int defineOffsetColumnPrecision() {
            return 11;
        }

        @Override
        protected int defineOffsetColumnScale() {
            return 12;
        }

        @Override
        protected int defineOffsetColumnSortOrder() {
            return 9;
        }

        @Override
        protected int defineOffsetColumnCodePage() {
            return 11;
        }

        @Override
        protected int defineOffsetColumnComplexId() {
            return -1;
        }

        @Override
        protected int defineOffsetColumnFlags() {
            return 13;
        }

        @Override
        protected int defineOffsetColumnExtFlags() {
            return -1;
        }

        @Override
        protected int defineOffsetColumnLength() {
            return 16;
        }

        @Override
        protected int defineOffsetColumnVariableTableIndex() {
            return 3;
        }

        @Override
        protected int defineOffsetColumnFixedDataOffset() {
            return 14;
        }

        @Override
        protected int defineOffsetColumnFixedDataRowOffset() {
            return 1;
        }

        @Override
        protected int defineOffsetTableDefLocation() {
            return 4;
        }

        @Override
        protected int defineOffsetRowStart() {
            return 10;
        }

        @Override
        protected int defineOffsetUsageMapStart() {
            return 5;
        }

        @Override
        protected int defineOffsetUsageMapPageData() {
            return 4;
        }

        @Override
        protected int defineOffsetReferenceMapPageNumbers() {
            return 1;
        }

        @Override
        protected int defineOffsetFreeSpace() {
            return 2;
        }

        @Override
        protected int defineOffsetNumRowsOnDataPage() {
            return 8;
        }

        @Override
        protected int defineMaxNumRowsOnDataPage() {
            return 255;
        }

        @Override
        protected int defineOffsetIndexCompressedByteCount() {
            return 20;
        }

        @Override
        protected int defineOffsetIndexEntryMask() {
            return 22;
        }

        @Override
        protected int defineOffsetPrevIndexPage() {
            return 8;
        }

        @Override
        protected int defineOffsetNextIndexPage() {
            return 12;
        }

        @Override
        protected int defineOffsetChildTailIndexPage() {
            return 16;
        }

        @Override
        protected int defineSizeIndexDefinition() {
            return 8;
        }

        @Override
        protected int defineSizeColumnHeader() {
            return 18;
        }

        @Override
        protected int defineSizeRowLocation() {
            return 2;
        }

        @Override
        protected int defineSizeLongValueDef() {
            return 12;
        }

        @Override
        protected int defineMaxInlineLongValueSize() {
            return 64;
        }

        @Override
        protected int defineMaxLongValueRowSize() {
            return 2032;
        }

        @Override
        protected int defineMaxCompressedUnicodeSize() {
            return 1024;
        }

        @Override
        protected int defineSizeTdefHeader() {
            return 63;
        }

        @Override
        protected int defineSizeTdefTrailer() {
            return 2;
        }

        @Override
        protected int defineSizeColumnDefBlock() {
            return 25;
        }

        @Override
        protected int defineSizeIndexEntryMask() {
            return 226;
        }

        @Override
        protected int defineSkipBeforeIndexFlags() {
            return 0;
        }

        @Override
        protected int defineSkipAfterIndexFlags() {
            return 0;
        }

        @Override
        protected int defineSkipBeforeIndexSlot() {
            return 0;
        }

        @Override
        protected int defineSkipAfterIndexSlot() {
            return 0;
        }

        @Override
        protected int defineSkipBeforeIndex() {
            return 0;
        }

        @Override
        protected int defineSizeNameLength() {
            return 1;
        }

        @Override
        protected int defineSizeRowColumnCount() {
            return 1;
        }

        @Override
        protected int defineSizeRowVarColOffset() {
            return 1;
        }

        @Override
        protected int defineUsageMapTableByteLength() {
            return 128;
        }

        @Override
        protected int defineMaxColumnsPerTable() {
            return 255;
        }

        @Override
        protected int defineMaxIndexesPerTable() {
            return 32;
        }

        @Override
        protected int defineMaxTableNameLength() {
            return 64;
        }

        @Override
        protected int defineMaxColumnNameLength() {
            return 64;
        }

        @Override
        protected int defineMaxIndexNameLength() {
            return 64;
        }

        @Override
        protected boolean defineLegacyNumericIndexes() {
            return true;
        }

        @Override
        protected Charset defineCharset() {
            return Charset.defaultCharset();
        }

        @Override
        protected ColumnImpl.SortOrder defineDefaultSortOrder() {
            return ColumnImpl.GENERAL_LEGACY_SORT_ORDER;
        }

        @Override
        protected byte[] definePropMapType() {
            return PROPERTY_MAP_TYPES[1];
        }

        @Override
        protected Map<String, Database.FileFormat> getPossibleFileFormats() {
            return PossibleFileFormats.POSSIBLE_VERSION_3;
        }

        @Override
        public boolean isSupportedDataType(DataType type) {
            return type != DataType.COMPLEX_TYPE;
        }

        @Override
        public boolean isSupportedCalculatedDataType(DataType type) {
            return false;
        }
    }

    private static final class PossibleFileFormats {
        private static final Map<String, Database.FileFormat> POSSIBLE_VERSION_3 = Collections.singletonMap(null, Database.FileFormat.V1997);
        private static final Map<String, Database.FileFormat> POSSIBLE_VERSION_4 = new HashMap<String, Database.FileFormat>();
        private static final Map<String, Database.FileFormat> POSSIBLE_VERSION_12 = Collections.singletonMap(null, Database.FileFormat.V2007);
        private static final Map<String, Database.FileFormat> POSSIBLE_VERSION_14 = Collections.singletonMap(null, Database.FileFormat.V2010);
        private static final Map<String, Database.FileFormat> POSSIBLE_VERSION_MSISAM = Collections.singletonMap(null, Database.FileFormat.MSISAM);

        private PossibleFileFormats() {
        }

        static {
            POSSIBLE_VERSION_4.put(JetFormat.ACCESS_VERSION_2000, Database.FileFormat.V2000);
            POSSIBLE_VERSION_4.put(JetFormat.ACCESS_VERSION_2003, Database.FileFormat.V2003);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CodecType {
        NONE,
        JET,
        MSISAM,
        OFFICE;

    }
}

