/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AIOSequentialFile;
import org.hornetq.core.journal.impl.AIOSequentialFileFactory;
import org.hornetq.core.journal.impl.NIOSequentialFile;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.journal.HornetQJournalLogger;

public class SyncSpeedTest {
    protected SequentialFileFactory fileFactory;
    public boolean AIO = true;

    public static void main(String[] args) {
        try {
            new SyncSpeedTest().testScaleAIO();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setupFactory() {
        this.fileFactory = this.AIO ? new AIOSequentialFileFactory(".", 0, 0, false, null) : new NIOSequentialFileFactory(".", false, 0, 0, false, null);
    }

    protected SequentialFile createSequentialFile(String fileName) {
        if (this.AIO) {
            return new AIOSequentialFile(this.fileFactory, 0, 0L, ".", fileName, 100000, null, null, Executors.newSingleThreadExecutor());
        }
        return new NIOSequentialFile(this.fileFactory, new File(fileName), 1000, null);
    }

    public void run2() throws Exception {
        this.setupFactory();
        int recordSize = 131072;
        while (true) {
            System.out.println("** record size is " + recordSize);
            int warmup = 500;
            int its = 500;
            int fileSize = (its + warmup) * recordSize;
            SequentialFile file = this.createSequentialFile("sync-speed-test.dat");
            if (file.exists()) {
                file.delete();
            }
            file.open();
            file.fill(0, fileSize, (byte)88);
            if (!this.AIO) {
                file.sync();
            }
            ByteBuffer bb1 = this.generateBuffer(recordSize, (byte)104);
            long start = 0L;
            for (int i = 0; i < its + warmup; ++i) {
                if (i == warmup) {
                    start = System.currentTimeMillis();
                }
                bb1.rewind();
                file.writeDirect(bb1, true);
            }
            long end = System.currentTimeMillis();
            double rate = 1000.0 * (double)its / (double)(end - start);
            double throughput = (double)recordSize * rate;
            System.out.println("Rate of " + rate + " syncs per sec");
            System.out.println("Throughput " + throughput + " bytes per sec");
            System.out.println("*************");
            recordSize *= 2;
        }
    }

    public void run() throws Exception {
        int recordSize = 256;
        while (true) {
            boolean created;
            System.out.println("** record size is " + recordSize);
            int warmup = 500;
            int its = 500;
            int fileSize = (its + warmup) * recordSize;
            File file = new File("sync-speed-test.dat");
            if (file.exists() && !file.delete()) {
                HornetQJournalLogger.LOGGER.errorDeletingFile(file);
            }
            if (!(created = file.createNewFile())) {
                throw new IOException("could not create file " + file);
            }
            RandomAccessFile rfile = new RandomAccessFile(file, "rw");
            FileChannel channel = rfile.getChannel();
            ByteBuffer bb = this.generateBuffer(fileSize, (byte)120);
            this.write(bb, channel, fileSize);
            channel.force(true);
            channel.position(0L);
            ByteBuffer bb1 = this.generateBuffer(recordSize, (byte)104);
            long start = 0L;
            for (int i = 0; i < its + warmup; ++i) {
                if (i == warmup) {
                    start = System.currentTimeMillis();
                }
                bb1.flip();
                channel.write(bb1);
                channel.force(false);
            }
            long end = System.currentTimeMillis();
            double rate = 1000.0 * (double)its / (double)(end - start);
            double throughput = (double)recordSize * rate;
            System.out.println("Rate of " + rate + " syncs per sec");
            System.out.println("Throughput " + throughput + " bytes per sec");
            recordSize *= 2;
        }
    }

    public void testScaleAIO() throws Exception {
        this.setupFactory();
        int recordSize = 1024;
        System.out.println("** record size is 1024");
        int its = 10;
        for (int numThreads = 1; numThreads <= 10; ++numThreads) {
            int fileSize = 10240 * numThreads;
            final SequentialFile file = this.createSequentialFile("sync-speed-test.dat");
            if (file.exists()) {
                file.delete();
            }
            file.open();
            file.fill(0, fileSize, (byte)88);
            if (!this.AIO) {
                file.sync();
            }
            final CountDownLatch latch = new CountDownLatch(10 * numThreads);
            class MyIOAsyncTask
            implements IOAsyncTask {
                MyIOAsyncTask() {
                }

                @Override
                public void done() {
                    latch.countDown();
                }

                @Override
                public void onError(int errorCode, String errorMessage) {
                }
            }
            final MyIOAsyncTask task = new MyIOAsyncTask();
            HashSet<Thread> threads = new HashSet<Thread>();
            for (int i = 0; i < numThreads; ++i) {
                class MyRunner
                implements Runnable {
                    private final ByteBuffer bb1;

                    MyRunner() {
                        this.bb1 = SyncSpeedTest.this.generateBuffer(1024, (byte)104);
                    }

                    @Override
                    public void run() {
                        for (int i = 0; i < 10; ++i) {
                            this.bb1.rewind();
                            file.writeDirect(this.bb1, true, task);
                        }
                    }
                }
                MyRunner runner = new MyRunner();
                Thread t = new Thread(runner);
                threads.add(t);
            }
            long start = System.currentTimeMillis();
            for (Thread t : threads) {
                HornetQJournalLogger.LOGGER.startingThread();
                t.start();
            }
            for (Thread t : threads) {
                t.join();
            }
            latch.await();
            long end = System.currentTimeMillis();
            double rate = 10000.0 * (double)numThreads / (double)(end - start);
            double throughput = 1024.0 * rate;
            System.out.println("For " + numThreads + " threads:");
            System.out.println("Rate of " + rate + " records per sec");
            System.out.println("Throughput " + throughput + " bytes per sec");
            System.out.println("*************");
        }
    }

    private void write(ByteBuffer buffer, FileChannel channel, int size) throws Exception {
        buffer.flip();
        channel.write(buffer);
    }

    private ByteBuffer generateBuffer(int size, byte ch) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size);
        for (int i = 0; i < size; ++i) {
            bb.put(ch);
        }
        return bb;
    }
}

