/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.googlecode.ehcache.annotations.key.AbstractDeepCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.CacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.HashCodeCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.ListCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.MessageDigestCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.ReflectionHelper;
import com.googlecode.ehcache.annotations.key.ReflectionHelperAware;
import com.googlecode.ehcache.annotations.key.StringCacheKeyGenerator;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpELCacheKeyGenerator
implements CacheKeyGenerator<Serializable>,
BeanFactoryAware,
InitializingBean,
ReflectionHelperAware {
    private static final Map<String, Class<?>> DEFAULT_KEY_GENERATORS;
    private final ExpressionParser expressionParser = new SpelExpressionParser();
    private final KeyGeneratorMethodResolver methodResolver = new KeyGeneratorMethodResolver();
    private final Object keyCallbackObject = new Object();
    private DefaultListableBeanFactory cacheKeyBeanFactory;
    private Map<String, CacheKeyGenerator<Serializable>> registeredKeyGenerators;
    private Map<String, MethodExecutor> keyGeneratorMethodExecutors;
    private Expression expression;
    private BeanFactory beanFactory;
    private ReflectionHelper reflectionHelper;

    public void setExpression(String expression) {
        this.expression = this.parseExpression(expression);
    }

    public void setKeyGenerators(Map<String, CacheKeyGenerator<Serializable>> keyGenerators) {
        this.registeredKeyGenerators = new LinkedHashMap<String, CacheKeyGenerator<Serializable>>(keyGenerators);
    }

    @Override
    public void setReflectionHelper(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.cacheKeyBeanFactory = new DefaultListableBeanFactory(this.beanFactory);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.registeredKeyGenerators == null) {
            this.registeredKeyGenerators = new LinkedHashMap<String, CacheKeyGenerator<Serializable>>();
        }
        this.registerDefaultKeyGenerators();
        this.createKeyGeneratorMethodExecutors();
    }

    protected final void registerDefaultKeyGenerators() {
        for (Map.Entry<String, Class<?>> defaultGeneratorEntry : DEFAULT_KEY_GENERATORS.entrySet()) {
            String name = defaultGeneratorEntry.getKey();
            Class<CacheKeyGenerator<Serializable>> keyGeneratorClass = defaultGeneratorEntry.getValue();
            if (!this.registeredKeyGenerators.containsKey(name)) {
                MutablePropertyValues properties = new MutablePropertyValues();
                CacheKeyGenerator<Serializable> keyGenerator = this.createKeyGenerator(name, keyGeneratorClass, properties);
                this.registeredKeyGenerators.put(name, keyGenerator);
            }
            String reflectionName = name + "R";
            if (!keyGeneratorClass.isAssignableFrom(AbstractDeepCacheKeyGenerator.class) || this.registeredKeyGenerators.containsKey(reflectionName)) continue;
            MutablePropertyValues properties = new MutablePropertyValues();
            properties.addPropertyValue("useReflection", (Object)true);
            CacheKeyGenerator<Serializable> keyGenerator = this.createKeyGenerator(reflectionName, keyGeneratorClass, properties);
            this.registeredKeyGenerators.put(reflectionName, keyGenerator);
        }
    }

    protected final void createKeyGeneratorMethodExecutors() {
        this.keyGeneratorMethodExecutors = new LinkedHashMap<String, MethodExecutor>(this.registeredKeyGenerators.size());
        for (Map.Entry<String, CacheKeyGenerator<Serializable>> keyGeneratorEntry : this.registeredKeyGenerators.entrySet()) {
            String name = keyGeneratorEntry.getKey();
            CacheKeyGenerator<Serializable> keyGenerator = keyGeneratorEntry.getValue();
            KeyGeneratorMethodExecutor keyGeneratorMethodExecutor = new KeyGeneratorMethodExecutor(keyGenerator);
            this.keyGeneratorMethodExecutors.put(name, keyGeneratorMethodExecutor);
        }
    }

    protected CacheKeyGenerator<Serializable> createKeyGenerator(String name, Class<CacheKeyGenerator<Serializable>> keyGeneratorClass, MutablePropertyValues properties) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(keyGeneratorClass);
        if (this.reflectionHelper != null && ReflectionHelperAware.class.isAssignableFrom(beanDefinition.getBeanClass())) {
            properties.addPropertyValue("reflectionHelper", (Object)this.reflectionHelper);
        }
        beanDefinition.setPropertyValues(properties);
        this.cacheKeyBeanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
        return (CacheKeyGenerator)this.cacheKeyBeanFactory.getBean(name, CacheKeyGenerator.class);
    }

    @Override
    public Serializable generateKey(MethodInvocation methodInvocation) {
        Object[] arguments = methodInvocation.getArguments();
        EvaluationContext evaluationContext = this.getEvaluationContext(methodInvocation, arguments);
        return (Serializable)this.expression.getValue(evaluationContext, Serializable.class);
    }

    @Override
    public Serializable generateKey(Object ... data) {
        EvaluationContext evaluationContext = this.getEvaluationContext(null, data);
        return (Serializable)this.expression.getValue(evaluationContext, Serializable.class);
    }

    protected Expression parseExpression(String expression) {
        return this.expressionParser.parseExpression(expression);
    }

    protected EvaluationContext getEvaluationContext(MethodInvocation methodInvocation, Object ... args) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
        evaluationContext.setVariable("invocation", (Object)methodInvocation);
        evaluationContext.setVariable("args", (Object)args);
        evaluationContext.setVariable("key", this.keyCallbackObject);
        evaluationContext.addMethodResolver((MethodResolver)this.methodResolver);
        return evaluationContext;
    }

    static {
        LinkedHashMap<String, Class> keyGenerators = new LinkedHashMap<String, Class>();
        keyGenerators.put("hash", HashCodeCacheKeyGenerator.class);
        keyGenerators.put("string", StringCacheKeyGenerator.class);
        keyGenerators.put("list", ListCacheKeyGenerator.class);
        keyGenerators.put("digest", MessageDigestCacheKeyGenerator.class);
        DEFAULT_KEY_GENERATORS = Collections.unmodifiableMap(keyGenerators);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyGeneratorMethodExecutor
    implements MethodExecutor {
        private final CacheKeyGenerator<Serializable> cacheKeyGenerator;

        private KeyGeneratorMethodExecutor(CacheKeyGenerator<Serializable> cacheKeyGenerator) {
            this.cacheKeyGenerator = cacheKeyGenerator;
        }

        public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
            return new TypedValue((Object)this.cacheKeyGenerator.generateKey(arguments));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyGeneratorMethodResolver
    implements MethodResolver {
        private KeyGeneratorMethodResolver() {
        }

        public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
            if (SpELCacheKeyGenerator.this.keyCallbackObject != targetObject) {
                return null;
            }
            return (MethodExecutor)SpELCacheKeyGenerator.this.keyGeneratorMethodExecutors.get(name);
        }
    }
}

