/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.googlecode.ehcache.annotations.key.AbstractDeepCacheKeyGenerator;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHashingCacheKeyGenerator<G, T extends Serializable>
extends AbstractDeepCacheKeyGenerator<G, T> {
    public AbstractHashingCacheKeyGenerator() {
    }

    public AbstractHashingCacheKeyGenerator(boolean includeMethod, boolean includeParameterTypes) {
        super(includeMethod, includeParameterTypes);
    }

    protected void appendClass(G generator, Class<?> e) {
        this.append(generator, e.getName());
    }

    protected void appendEnum(G generator, Enum<?> e) {
        if (e.getClass().isAnonymousClass()) {
            this.deepHashCode(generator, new Object[]{e.getClass().getEnclosingClass(), e.name()});
        } else {
            this.deepHashCode(generator, new Object[]{e.getClass(), e.name()});
        }
    }

    @Override
    protected final void append(G generator, Object e) {
        if (e instanceof Class) {
            this.appendClass(generator, (Class)e);
        } else if (e instanceof Enum) {
            this.appendEnum(generator, (Enum)e);
        } else {
            this.appendHash(generator, e);
        }
    }

    @Override
    protected boolean shouldReflect(Object element) {
        return !this.getReflectionHelper().implementsHashCode(element);
    }

    protected abstract void appendHash(G var1, Object var2);
}

