/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations;

import java.util.Arrays;

public class ParameterMask {
    public static final ParameterMask NO_MASK = new ParameterMask();
    private final boolean[] mask;
    private final int parameterCount;
    private final boolean shouldMask;

    public static ParameterMask create(boolean[] mask) {
        int parameterCount = mask.length;
        for (boolean b : mask) {
            if (b) continue;
            --parameterCount;
        }
        if (parameterCount == 0 || parameterCount == mask.length) {
            return NO_MASK;
        }
        return new ParameterMask(mask, parameterCount);
    }

    private ParameterMask() {
        this.mask = new boolean[0];
        this.parameterCount = 0;
        this.shouldMask = false;
    }

    private ParameterMask(boolean[] mask, int parameterCount) {
        this.mask = mask;
        this.parameterCount = parameterCount;
        this.shouldMask = true;
    }

    public boolean shouldMask() {
        return this.shouldMask;
    }

    public boolean[] getMask() {
        if (this.mask.length == 0) {
            return this.mask;
        }
        boolean[] maskCopy = new boolean[this.mask.length];
        System.arraycopy(this.mask, 0, maskCopy, 0, this.mask.length);
        return maskCopy;
    }

    public Object[] maskParameters(Object[] parameters) {
        if (!this.shouldMask) {
            return parameters;
        }
        int maskedIndex = 0;
        Object[] maskedParameters = new Object[this.parameterCount];
        for (int index = 0; index < parameters.length; ++index) {
            if (!this.mask[index]) continue;
            maskedParameters[maskedIndex++] = parameters[index];
        }
        return maskedParameters;
    }

    public void unmaskParameters(Object[] originalParameters, Object[] maskedParameters) {
        if (!this.shouldMask || originalParameters == maskedParameters) {
            return;
        }
        int maskedIndex = 0;
        for (int index = 0; index < originalParameters.length; ++index) {
            if (!this.mask[index]) continue;
            originalParameters[index] = maskedParameters[maskedIndex++];
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mask);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterMask other = (ParameterMask)obj;
        return Arrays.equals(this.mask, other.mask);
    }

    public String toString() {
        return "ParameterMask [mask=" + Arrays.toString(this.mask) + "]";
    }
}

