/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.RuleSet;
import org.apache.commons.digester3.Rules;
import org.apache.commons.digester3.RulesBase;
import org.apache.commons.digester3.StackAction;
import org.apache.commons.digester3.Substitutor;
import org.apache.commons.digester3.binder.DefaultRulesBinder;
import org.apache.commons.digester3.binder.DigesterLoadingException;
import org.apache.commons.digester3.binder.ErrorMessage;
import org.apache.commons.digester3.binder.RulesModule;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DigesterLoader {
    private static final String HEADING = "Digester creation errors:%n%n";
    private final DefaultRulesBinder rulesBinder = new DefaultRulesBinder();
    private final Map<String, URL> entityValidator = new HashMap<String, URL>();
    private final SAXParserFactory factory = SAXParserFactory.newInstance();
    private final Iterable<RulesModule> rulesModules;
    private boolean useContextClassLoader = true;
    private ClassLoader classLoader;
    private Substitutor substitutor;
    private EntityResolver entityResolver;
    private StackAction stackAction;

    public static DigesterLoader newLoader(RulesModule ... rulesModules) {
        if (rulesModules == null || rulesModules.length == 0) {
            throw new DigesterLoadingException("At least one RulesModule has to be specified");
        }
        return DigesterLoader.newLoader(Arrays.asList(rulesModules));
    }

    public static DigesterLoader newLoader(Iterable<RulesModule> rulesModules) {
        if (rulesModules == null) {
            throw new DigesterLoadingException("RulesModule has to be specified");
        }
        return new DigesterLoader(rulesModules);
    }

    private DigesterLoader(Iterable<RulesModule> rulesModules) {
        this.rulesModules = rulesModules;
    }

    public DigesterLoader setUseContextClassLoader(boolean useContextClassLoader) {
        this.useContextClassLoader = useContextClassLoader;
        return this;
    }

    public DigesterLoader setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public DigesterLoader setSubstitutor(Substitutor substitutor) {
        this.substitutor = substitutor;
        return this;
    }

    public DigesterLoader setNamespaceAware(boolean namespaceAware) {
        this.factory.setNamespaceAware(namespaceAware);
        return this;
    }

    public boolean isNamespaceAware() {
        return this.factory.isNamespaceAware();
    }

    public DigesterLoader setXIncludeAware(boolean xIncludeAware) {
        this.factory.setXIncludeAware(xIncludeAware);
        return this;
    }

    public boolean isXIncludeAware() {
        return this.factory.isXIncludeAware();
    }

    public DigesterLoader setValidating(boolean validating) {
        this.factory.setValidating(validating);
        return this;
    }

    public boolean isValidating() {
        return this.factory.isValidating();
    }

    public DigesterLoader setSchema(Schema schema) {
        this.factory.setSchema(schema);
        return this;
    }

    public DigesterLoader register(String publicId, URL entityURL) {
        this.entityValidator.put(publicId, entityURL);
        return this;
    }

    public DigesterLoader register(String publicId, String entityURL) {
        try {
            return this.register(publicId, new URL(entityURL));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL '" + entityURL + "' : " + e.getMessage());
        }
    }

    public Map<String, URL> getRegistrations() {
        return Collections.unmodifiableMap(this.entityValidator);
    }

    public DigesterLoader setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        return this;
    }

    public DigesterLoader setStackAction(StackAction stackAction) {
        this.stackAction = stackAction;
        return this;
    }

    public Digester newDigester() {
        return this.newDigester(new RulesBase());
    }

    public Digester newDigester(Rules rules) {
        try {
            return this.newDigester(this.factory.newSAXParser(), rules);
        }
        catch (ParserConfigurationException e) {
            throw new DigesterLoadingException("SAX Parser misconfigured", e);
        }
        catch (SAXException e) {
            throw new DigesterLoadingException("An error occurred while initializing the SAX Parser", e);
        }
    }

    public Digester newDigester(SAXParser parser) {
        return this.newDigester(parser, (Rules)new RulesBase());
    }

    public Digester newDigester(SAXParser parser, Rules rules) {
        if (parser == null) {
            throw new DigesterLoadingException("SAXParser must be not null");
        }
        try {
            return this.newDigester(parser.getXMLReader(), rules);
        }
        catch (SAXException e) {
            throw new DigesterLoadingException("An error occurred while creating the XML Reader", e);
        }
    }

    public Digester newDigester(XMLReader reader) {
        return this.newDigester(reader, (Rules)new RulesBase());
    }

    public Digester newDigester(XMLReader reader, Rules rules) {
        if (reader == null) {
            throw new DigesterLoadingException("XMLReader must be not null");
        }
        if (rules == null) {
            throw new DigesterLoadingException("Impossible to create a new Digester with null Rules");
        }
        Digester digester = new Digester(reader);
        digester.setRules(rules);
        digester.setSubstitutor(this.substitutor);
        digester.registerAll(this.entityValidator);
        digester.setEntityResolver(this.entityResolver);
        digester.setStackAction(this.stackAction);
        digester.setNamespaceAware(this.isNamespaceAware());
        this.addRules(digester);
        return digester;
    }

    public void addRules(Digester digester) {
        RuleSet ruleSet = this.createRuleSet();
        ruleSet.addRuleInstances(digester);
    }

    public RuleSet createRuleSet() {
        ClassLoader contextClassLoader;
        ClassLoader classLoader = this.classLoader != null ? this.classLoader : (contextClassLoader = this.useContextClassLoader ? Thread.currentThread().getContextClassLoader() : this.getClass().getClassLoader());
        if (!contextClassLoader.equals(this.rulesBinder.getContextClassLoader())) {
            this.rulesBinder.initialize(contextClassLoader);
            for (RulesModule rulesModule : this.rulesModules) {
                rulesModule.configure(this.rulesBinder);
            }
        }
        if (this.rulesBinder.hasError()) {
            Formatter fmt = new Formatter().format(HEADING, new Object[0]);
            int index = 1;
            for (ErrorMessage errorMessage : this.rulesBinder.getErrors()) {
                fmt.format("%s) %s%n", index++, errorMessage.getMessage());
                Throwable cause = errorMessage.getCause();
                if (cause != null) {
                    StringWriter writer = new StringWriter();
                    cause.printStackTrace(new PrintWriter(writer));
                    fmt.format("Caused by: %s", writer.getBuffer());
                }
                fmt.format("%n", new Object[0]);
            }
            if (this.rulesBinder.errorsSize() == 1) {
                fmt.format("1 error", new Object[0]);
            } else {
                fmt.format("%s errors", this.rulesBinder.errorsSize());
            }
            throw new DigesterLoadingException(fmt.toString());
        }
        return this.rulesBinder.getFromBinderRuleSet();
    }
}

