/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDefaultParagraphStyle;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDefaultRunStyle;
import ai2.org.apache.poi.xwpf.usermodel.XWPFLatentStyles;
import ai2.org.apache.poi.xwpf.usermodel.XWPFStyle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLanguage;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrDefault;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPrDefault;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.StylesDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFStyles
extends POIXMLDocumentPart {
    private CTStyles ctStyles;
    private List<XWPFStyle> listStyle = new ArrayList<XWPFStyle>();
    private XWPFLatentStyles latentStyles;
    private XWPFDefaultRunStyle defaultRunStyle;
    private XWPFDefaultParagraphStyle defaultParaStyle;

    public XWPFStyles(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, OpenXML4JException {
        super(packagePart, packageRelationship);
    }

    public XWPFStyles() {
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            InputStream inputStream = this.getPackagePart().getInputStream();
            StylesDocument stylesDocument = StylesDocument.Factory.parse((InputStream)inputStream);
            this.setStyles(stylesDocument.getStyles());
            this.latentStyles = new XWPFLatentStyles(this.ctStyles.getLatentStyles(), this);
        }
        catch (XmlException xmlException) {
            throw new POIXMLException("Unable to read styles", xmlException);
        }
    }

    @Override
    protected void commit() throws IOException {
        if (this.ctStyles == null) {
            throw new IllegalStateException("Unable to write out styles that were never read in!");
        }
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTStyles.type.getName().getNamespaceURI(), "styles"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        hashMap.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.ctStyles.save(outputStream, xmlOptions);
        outputStream.close();
    }

    protected void ensureDocDefaults() {
        CTDocDefaults cTDocDefaults;
        if (!this.ctStyles.isSetDocDefaults()) {
            this.ctStyles.addNewDocDefaults();
        }
        if (!(cTDocDefaults = this.ctStyles.getDocDefaults()).isSetPPrDefault()) {
            cTDocDefaults.addNewPPrDefault();
        }
        if (!cTDocDefaults.isSetRPrDefault()) {
            cTDocDefaults.addNewRPrDefault();
        }
        CTPPrDefault cTPPrDefault = cTDocDefaults.getPPrDefault();
        CTRPrDefault cTRPrDefault = cTDocDefaults.getRPrDefault();
        if (!cTPPrDefault.isSetPPr()) {
            cTPPrDefault.addNewPPr();
        }
        if (!cTRPrDefault.isSetRPr()) {
            cTRPrDefault.addNewRPr();
        }
        this.defaultRunStyle = new XWPFDefaultRunStyle(cTRPrDefault.getRPr());
        this.defaultParaStyle = new XWPFDefaultParagraphStyle(cTPPrDefault.getPPr());
    }

    public void setStyles(CTStyles cTStyles) {
        this.ctStyles = cTStyles;
        for (CTStyle cTStyle : this.ctStyles.getStyleArray()) {
            this.listStyle.add(new XWPFStyle(cTStyle, this));
        }
        if (this.ctStyles.isSetDocDefaults()) {
            CTDocDefaults cTDocDefaults = this.ctStyles.getDocDefaults();
            if (cTDocDefaults.isSetRPrDefault() && cTDocDefaults.getRPrDefault().isSetRPr()) {
                this.defaultRunStyle = new XWPFDefaultRunStyle(cTDocDefaults.getRPrDefault().getRPr());
            }
            if (cTDocDefaults.isSetPPrDefault() && cTDocDefaults.getPPrDefault().isSetPPr()) {
                this.defaultParaStyle = new XWPFDefaultParagraphStyle(cTDocDefaults.getPPrDefault().getPPr());
            }
        }
    }

    public boolean styleExist(String string) {
        for (XWPFStyle xWPFStyle : this.listStyle) {
            if (!xWPFStyle.getStyleId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void addStyle(XWPFStyle xWPFStyle) {
        this.listStyle.add(xWPFStyle);
        this.ctStyles.addNewStyle();
        int n = this.ctStyles.sizeOfStyleArray() - 1;
        this.ctStyles.setStyleArray(n, xWPFStyle.getCTStyle());
    }

    public XWPFStyle getStyle(String string) {
        for (XWPFStyle xWPFStyle : this.listStyle) {
            if (!xWPFStyle.getStyleId().equals(string)) continue;
            return xWPFStyle;
        }
        return null;
    }

    public int getNumberOfStyles() {
        return this.listStyle.size();
    }

    public List<XWPFStyle> getUsedStyleList(XWPFStyle xWPFStyle) {
        ArrayList<XWPFStyle> arrayList = new ArrayList<XWPFStyle>();
        arrayList.add(xWPFStyle);
        return this.getUsedStyleList(xWPFStyle, arrayList);
    }

    private List<XWPFStyle> getUsedStyleList(XWPFStyle xWPFStyle, List<XWPFStyle> list) {
        String string;
        XWPFStyle xWPFStyle2;
        String string2;
        XWPFStyle xWPFStyle3;
        String string3 = xWPFStyle.getBasisStyleID();
        XWPFStyle xWPFStyle4 = this.getStyle(string3);
        if (xWPFStyle4 != null && !list.contains(xWPFStyle4)) {
            list.add(xWPFStyle4);
            this.getUsedStyleList(xWPFStyle4, list);
        }
        if ((xWPFStyle3 = this.getStyle(string2 = xWPFStyle.getLinkStyleID())) != null && !list.contains(xWPFStyle3)) {
            list.add(xWPFStyle3);
            this.getUsedStyleList(xWPFStyle3, list);
        }
        if ((xWPFStyle2 = this.getStyle(string = xWPFStyle.getNextStyleID())) != null && !list.contains(xWPFStyle2)) {
            list.add(xWPFStyle3);
            this.getUsedStyleList(xWPFStyle3, list);
        }
        return list;
    }

    protected CTLanguage getCTLanguage() {
        this.ensureDocDefaults();
        CTLanguage cTLanguage = null;
        cTLanguage = this.defaultRunStyle.getRPr().isSetLang() ? this.defaultRunStyle.getRPr().getLang() : this.defaultRunStyle.getRPr().addNewLang();
        return cTLanguage;
    }

    public void setSpellingLanguage(String string) {
        CTLanguage cTLanguage = this.getCTLanguage();
        cTLanguage.setVal((Object)string);
        cTLanguage.setBidi((Object)string);
    }

    public void setEastAsia(String string) {
        CTLanguage cTLanguage = this.getCTLanguage();
        cTLanguage.setEastAsia((Object)string);
    }

    public void setDefaultFonts(CTFonts cTFonts) {
        this.ensureDocDefaults();
        CTRPr cTRPr = this.defaultRunStyle.getRPr();
        cTRPr.setRFonts(cTFonts);
    }

    public XWPFStyle getStyleWithSameName(XWPFStyle xWPFStyle) {
        for (XWPFStyle xWPFStyle2 : this.listStyle) {
            if (!xWPFStyle2.hasSameName(xWPFStyle)) continue;
            return xWPFStyle2;
        }
        return null;
    }

    public XWPFDefaultRunStyle getDefaultRunStyle() {
        this.ensureDocDefaults();
        return this.defaultRunStyle;
    }

    public XWPFDefaultParagraphStyle getDefaultParagraphStyle() {
        this.ensureDocDefaults();
        return this.defaultParaStyle;
    }

    public XWPFLatentStyles getLatentStyles() {
        return this.latentStyles;
    }
}

