/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.wp.usermodel.CharacterRun;
import ai2.org.apache.poi.xwpf.usermodel.BreakClear;
import ai2.org.apache.poi.xwpf.usermodel.BreakType;
import ai2.org.apache.poi.xwpf.usermodel.IRunBody;
import ai2.org.apache.poi.xwpf.usermodel.IRunElement;
import ai2.org.apache.poi.xwpf.usermodel.ISDTContents;
import ai2.org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import ai2.org.apache.poi.xwpf.usermodel.VerticalAlign;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import ai2.org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFPicture;
import ai2.org.apache.poi.xwpf.usermodel.XWPFPictureData;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.XmlToken;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualPictureProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPictureNonVisual;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTEmpty;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFFCheckBox;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdnRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPTab;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSignedHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSignedTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrClear;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalAlignRun;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFRun
implements ISDTContents,
IRunElement,
CharacterRun {
    private CTR run;
    private String pictureText;
    private IRunBody parent;
    private List<XWPFPicture> pictures;

    public XWPFRun(CTR cTR, IRunBody iRunBody) {
        this.run = cTR;
        this.parent = iRunBody;
        for (CTDrawing cTDrawing : cTR.getDrawingArray()) {
            for (CTAnchor cTAnchor : cTDrawing.getAnchorArray()) {
                if (cTAnchor.getDocPr() == null) continue;
                this.getDocument().getDrawingIdManager().reserve(cTAnchor.getDocPr().getId());
            }
            for (CTAnchor cTAnchor : cTDrawing.getInlineArray()) {
                if (cTAnchor.getDocPr() == null) continue;
                this.getDocument().getDrawingIdManager().reserve(cTAnchor.getDocPr().getId());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(cTR.getPictArray()));
        arrayList.addAll(Arrays.asList(cTR.getDrawingArray()));
        for (XmlObject xmlObject : arrayList) {
            XmlObject[] xmlObjectArray = xmlObject.selectPath("declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' .//w:t");
            for (CTAnchor cTAnchor : xmlObjectArray) {
                NodeList nodeList = cTAnchor.getDomNode().getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (!(nodeList.item(i) instanceof Text)) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(nodeList.item(i).getNodeValue());
                }
            }
        }
        this.pictureText = stringBuilder.toString();
        this.pictures = new ArrayList<XWPFPicture>();
        for (XmlObject xmlObject : arrayList) {
            for (CTPicture cTPicture : this.getCTPictures(xmlObject)) {
                XWPFPicture xWPFPicture = new XWPFPicture(cTPicture, this);
                this.pictures.add(xWPFPicture);
            }
        }
    }

    public XWPFRun(CTR cTR, XWPFParagraph xWPFParagraph) {
        this(cTR, (IRunBody)xWPFParagraph);
    }

    static void preserveSpaces(XmlString xmlString) {
        String string = xmlString.getStringValue();
        if (string != null && (string.startsWith(" ") || string.endsWith(" "))) {
            XmlCursor xmlCursor = xmlString.newCursor();
            xmlCursor.toNextToken();
            xmlCursor.insertAttributeWithValue(new QName("http://www.w3.org/XML/1998/namespace", "space"), "preserve");
            xmlCursor.dispose();
        }
    }

    private List<CTPicture> getCTPictures(XmlObject xmlObject) {
        XmlObject[] xmlObjectArray;
        ArrayList<CTPicture> arrayList = new ArrayList<CTPicture>();
        for (XmlObject xmlObject2 : xmlObjectArray = xmlObject.selectPath("declare namespace pic='" + CTPicture.type.getName().getNamespaceURI() + "' .//pic:pic")) {
            if (xmlObject2 instanceof XmlAnyTypeImpl) {
                try {
                    xmlObject2 = CTPicture.Factory.parse((String)xmlObject2.toString());
                }
                catch (XmlException xmlException) {
                    throw new POIXMLException(xmlException);
                }
            }
            if (!(xmlObject2 instanceof CTPicture)) continue;
            arrayList.add((CTPicture)xmlObject2);
        }
        return arrayList;
    }

    @Internal
    public CTR getCTR() {
        return this.run;
    }

    public IRunBody getParent() {
        return this.parent;
    }

    public XWPFParagraph getParagraph() {
        if (this.parent instanceof XWPFParagraph) {
            return (XWPFParagraph)this.parent;
        }
        return null;
    }

    public XWPFDocument getDocument() {
        if (this.parent != null) {
            return this.parent.getDocument();
        }
        return null;
    }

    private boolean isCTOnOff(CTOnOff cTOnOff) {
        if (!cTOnOff.isSetVal()) {
            return true;
        }
        if (cTOnOff.getVal() == STOnOff.ON) {
            return true;
        }
        return cTOnOff.getVal() == STOnOff.TRUE;
    }

    @Override
    public boolean isBold() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetB()) {
            return false;
        }
        return this.isCTOnOff(cTRPr.getB());
    }

    @Override
    public void setBold(boolean bl) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff cTOnOff = cTRPr.isSetB() ? cTRPr.getB() : cTRPr.addNewB();
        cTOnOff.setVal(bl ? STOnOff.TRUE : STOnOff.FALSE);
    }

    public String getColor() {
        CTRPr cTRPr;
        String string = null;
        if (this.run.isSetRPr() && (cTRPr = this.run.getRPr()).isSetColor()) {
            CTColor cTColor = cTRPr.getColor();
            string = cTColor.xgetVal().getStringValue();
        }
        return string;
    }

    public void setColor(String string) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTColor cTColor = cTRPr.isSetColor() ? cTRPr.getColor() : cTRPr.addNewColor();
        cTColor.setVal((Object)string);
    }

    public String getText(int n) {
        return this.run.sizeOfTArray() == 0 ? null : this.run.getTArray(n).getStringValue();
    }

    public String getPictureText() {
        return this.pictureText;
    }

    public void setText(String string) {
        this.setText(string, this.run.sizeOfTArray());
    }

    public void setText(String string, int n) {
        if (n > this.run.sizeOfTArray()) {
            throw new ArrayIndexOutOfBoundsException("Value too large for the parameter position in XWPFRun.setText(String value,int pos)");
        }
        CTText cTText = n < this.run.sizeOfTArray() && n >= 0 ? this.run.getTArray(n) : this.run.addNewT();
        cTText.setStringValue(string);
        XWPFRun.preserveSpaces((XmlString)cTText);
    }

    @Override
    public boolean isItalic() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetI()) {
            return false;
        }
        return this.isCTOnOff(cTRPr.getI());
    }

    @Override
    public void setItalic(boolean bl) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff cTOnOff = cTRPr.isSetI() ? cTRPr.getI() : cTRPr.addNewI();
        cTOnOff.setVal(bl ? STOnOff.TRUE : STOnOff.FALSE);
    }

    public UnderlinePatterns getUnderline() {
        CTRPr cTRPr = this.run.getRPr();
        return cTRPr != null && cTRPr.isSetU() && cTRPr.getU().getVal() != null ? UnderlinePatterns.valueOf(cTRPr.getU().getVal().intValue()) : UnderlinePatterns.NONE;
    }

    public void setUnderline(UnderlinePatterns underlinePatterns) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTUnderline cTUnderline = cTRPr.getU() == null ? cTRPr.addNewU() : cTRPr.getU();
        cTUnderline.setVal(STUnderline.Enum.forInt((int)underlinePatterns.getValue()));
    }

    @Override
    public boolean isStrikeThrough() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetStrike()) {
            return false;
        }
        return this.isCTOnOff(cTRPr.getStrike());
    }

    @Override
    public void setStrikeThrough(boolean bl) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff cTOnOff = cTRPr.isSetStrike() ? cTRPr.getStrike() : cTRPr.addNewStrike();
        cTOnOff.setVal(bl ? STOnOff.TRUE : STOnOff.FALSE);
    }

    @Deprecated
    public boolean isStrike() {
        return this.isStrikeThrough();
    }

    @Deprecated
    public void setStrike(boolean bl) {
        this.setStrikeThrough(bl);
    }

    @Override
    public boolean isDoubleStrikeThrough() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetDstrike()) {
            return false;
        }
        return this.isCTOnOff(cTRPr.getDstrike());
    }

    @Override
    public void setDoubleStrikethrough(boolean bl) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff cTOnOff = cTRPr.isSetDstrike() ? cTRPr.getDstrike() : cTRPr.addNewDstrike();
        cTOnOff.setVal(bl ? STOnOff.TRUE : STOnOff.FALSE);
    }

    @Override
    public boolean isSmallCaps() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetSmallCaps()) {
            return false;
        }
        return this.isCTOnOff(cTRPr.getSmallCaps());
    }

    @Override
    public void setSmallCaps(boolean bl) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff cTOnOff = cTRPr.isSetSmallCaps() ? cTRPr.getSmallCaps() : cTRPr.addNewSmallCaps();
        cTOnOff.setVal(bl ? STOnOff.TRUE : STOnOff.FALSE);
    }

    @Override
    public boolean isCapitalized() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetCaps()) {
            return false;
        }
        return this.isCTOnOff(cTRPr.getCaps());
    }

    @Override
    public void setCapitalized(boolean bl) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff cTOnOff = cTRPr.isSetCaps() ? cTRPr.getCaps() : cTRPr.addNewCaps();
        cTOnOff.setVal(bl ? STOnOff.TRUE : STOnOff.FALSE);
    }

    @Override
    public boolean isShadowed() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetShadow()) {
            return false;
        }
        return this.isCTOnOff(cTRPr.getShadow());
    }

    @Override
    public void setShadow(boolean bl) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff cTOnOff = cTRPr.isSetShadow() ? cTRPr.getShadow() : cTRPr.addNewShadow();
        cTOnOff.setVal(bl ? STOnOff.TRUE : STOnOff.FALSE);
    }

    @Override
    public boolean isImprinted() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetImprint()) {
            return false;
        }
        return this.isCTOnOff(cTRPr.getImprint());
    }

    @Override
    public void setImprinted(boolean bl) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff cTOnOff = cTRPr.isSetImprint() ? cTRPr.getImprint() : cTRPr.addNewImprint();
        cTOnOff.setVal(bl ? STOnOff.TRUE : STOnOff.FALSE);
    }

    @Override
    public boolean isEmbossed() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetEmboss()) {
            return false;
        }
        return this.isCTOnOff(cTRPr.getEmboss());
    }

    @Override
    public void setEmbossed(boolean bl) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff cTOnOff = cTRPr.isSetEmboss() ? cTRPr.getEmboss() : cTRPr.addNewEmboss();
        cTOnOff.setVal(bl ? STOnOff.TRUE : STOnOff.FALSE);
    }

    public VerticalAlign getSubscript() {
        CTRPr cTRPr = this.run.getRPr();
        return cTRPr != null && cTRPr.isSetVertAlign() ? VerticalAlign.valueOf(cTRPr.getVertAlign().getVal().intValue()) : VerticalAlign.BASELINE;
    }

    public void setSubscript(VerticalAlign verticalAlign) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTVerticalAlignRun cTVerticalAlignRun = cTRPr.isSetVertAlign() ? cTRPr.getVertAlign() : cTRPr.addNewVertAlign();
        cTVerticalAlignRun.setVal(STVerticalAlignRun.Enum.forInt((int)verticalAlign.getValue()));
    }

    @Override
    public int getKerning() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetKern()) {
            return 0;
        }
        return cTRPr.getKern().getVal().intValue();
    }

    @Override
    public void setKerning(int n) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTHpsMeasure cTHpsMeasure = cTRPr.isSetKern() ? cTRPr.getKern() : cTRPr.addNewKern();
        cTHpsMeasure.setVal(BigInteger.valueOf(n));
    }

    @Override
    public int getCharacterSpacing() {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetSpacing()) {
            return 0;
        }
        return cTRPr.getSpacing().getVal().intValue();
    }

    @Override
    public void setCharacterSpacing(int n) {
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTSignedTwipsMeasure cTSignedTwipsMeasure = cTRPr.isSetSpacing() ? cTRPr.getSpacing() : cTRPr.addNewSpacing();
        cTSignedTwipsMeasure.setVal(BigInteger.valueOf(n));
    }

    public String getFontFamily() {
        return this.getFontFamily(null);
    }

    public void setFontFamily(String string) {
        this.setFontFamily(string, null);
    }

    @Override
    public String getFontName() {
        return this.getFontFamily();
    }

    public String getFontFamily(FontCharRange fontCharRange) {
        CTRPr cTRPr = this.run.getRPr();
        if (cTRPr == null || !cTRPr.isSetRFonts()) {
            return null;
        }
        CTFonts cTFonts = cTRPr.getRFonts();
        switch (fontCharRange == null ? FontCharRange.ascii : fontCharRange) {
            default: {
                return cTFonts.getAscii();
            }
            case cs: {
                return cTFonts.getCs();
            }
            case eastAsia: {
                return cTFonts.getEastAsia();
            }
            case hAnsi: 
        }
        return cTFonts.getHAnsi();
    }

    public void setFontFamily(String string, FontCharRange fontCharRange) {
        CTFonts cTFonts;
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTFonts cTFonts2 = cTFonts = cTRPr.isSetRFonts() ? cTRPr.getRFonts() : cTRPr.addNewRFonts();
        if (fontCharRange == null) {
            cTFonts.setAscii(string);
            if (!cTFonts.isSetHAnsi()) {
                cTFonts.setHAnsi(string);
            }
            if (!cTFonts.isSetCs()) {
                cTFonts.setCs(string);
            }
            if (!cTFonts.isSetEastAsia()) {
                cTFonts.setEastAsia(string);
            }
        } else {
            switch (fontCharRange) {
                case ascii: {
                    cTFonts.setAscii(string);
                    break;
                }
                case cs: {
                    cTFonts.setCs(string);
                    break;
                }
                case eastAsia: {
                    cTFonts.setEastAsia(string);
                    break;
                }
                case hAnsi: {
                    cTFonts.setHAnsi(string);
                }
            }
        }
    }

    @Override
    public int getFontSize() {
        CTRPr cTRPr = this.run.getRPr();
        return cTRPr != null && cTRPr.isSetSz() ? cTRPr.getSz().getVal().divide(new BigInteger("2")).intValue() : -1;
    }

    @Override
    public void setFontSize(int n) {
        BigInteger bigInteger = new BigInteger("" + n);
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTHpsMeasure cTHpsMeasure = cTRPr.isSetSz() ? cTRPr.getSz() : cTRPr.addNewSz();
        cTHpsMeasure.setVal(bigInteger.multiply(new BigInteger("2")));
    }

    public int getTextPosition() {
        CTRPr cTRPr = this.run.getRPr();
        return cTRPr != null && cTRPr.isSetPosition() ? cTRPr.getPosition().getVal().intValue() : -1;
    }

    public void setTextPosition(int n) {
        BigInteger bigInteger = new BigInteger("" + n);
        CTRPr cTRPr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTSignedHpsMeasure cTSignedHpsMeasure = cTRPr.isSetPosition() ? cTRPr.getPosition() : cTRPr.addNewPosition();
        cTSignedHpsMeasure.setVal(bigInteger);
    }

    public void removeBreak() {
    }

    public void addBreak() {
        this.run.addNewBr();
    }

    public void addBreak(BreakType breakType) {
        CTBr cTBr = this.run.addNewBr();
        cTBr.setType(STBrType.Enum.forInt((int)breakType.getValue()));
    }

    public void addBreak(BreakClear breakClear) {
        CTBr cTBr = this.run.addNewBr();
        cTBr.setType(STBrType.Enum.forInt((int)BreakType.TEXT_WRAPPING.getValue()));
        cTBr.setClear(STBrClear.Enum.forInt((int)breakClear.getValue()));
    }

    public void addTab() {
        this.run.addNewTab();
    }

    public void removeTab() {
    }

    public void addCarriageReturn() {
        this.run.addNewCr();
    }

    public void removeCarriageReturn() {
    }

    public XWPFPicture addPicture(InputStream inputStream, int n, String string, int n2, int n3) throws InvalidFormatException, IOException {
        XWPFPictureData xWPFPictureData;
        POIXMLDocumentPart pOIXMLDocumentPart;
        if (this.parent.getPart() instanceof XWPFHeaderFooter) {
            pOIXMLDocumentPart = (XWPFHeaderFooter)this.parent.getPart();
            String string2 = ((XWPFHeaderFooter)pOIXMLDocumentPart).addPictureData(inputStream, n);
            xWPFPictureData = (XWPFPictureData)pOIXMLDocumentPart.getRelationById(string2);
        } else {
            pOIXMLDocumentPart = this.parent.getDocument();
            String string3 = ((XWPFDocument)pOIXMLDocumentPart).addPictureData(inputStream, n);
            xWPFPictureData = (XWPFPictureData)pOIXMLDocumentPart.getRelationById(string3);
        }
        try {
            pOIXMLDocumentPart = this.run.addNewDrawing();
            CTInline cTInline = pOIXMLDocumentPart.addNewInline();
            String string4 = "<a:graphic xmlns:a=\"" + CTGraphicalObject.type.getName().getNamespaceURI() + "\">" + "<a:graphicData uri=\"" + CTPicture.type.getName().getNamespaceURI() + "\">" + "<pic:pic xmlns:pic=\"" + CTPicture.type.getName().getNamespaceURI() + "\" />" + "</a:graphicData>" + "</a:graphic>";
            cTInline.set((XmlObject)XmlToken.Factory.parse((String)string4));
            cTInline.setDistT(0L);
            cTInline.setDistR(0L);
            cTInline.setDistB(0L);
            cTInline.setDistL(0L);
            CTNonVisualDrawingProps cTNonVisualDrawingProps = cTInline.addNewDocPr();
            long l = this.getParent().getDocument().getDrawingIdManager().reserveNew();
            cTNonVisualDrawingProps.setId(l);
            cTNonVisualDrawingProps.setName("Drawing " + l);
            cTNonVisualDrawingProps.setDescr(string);
            CTPositiveSize2D cTPositiveSize2D = cTInline.addNewExtent();
            cTPositiveSize2D.setCx((long)n2);
            cTPositiveSize2D.setCy((long)n3);
            CTGraphicalObject cTGraphicalObject = cTInline.getGraphic();
            CTGraphicalObjectData cTGraphicalObjectData = cTGraphicalObject.getGraphicData();
            CTPicture cTPicture = this.getCTPictures((XmlObject)cTGraphicalObjectData).get(0);
            CTPictureNonVisual cTPictureNonVisual = cTPicture.addNewNvPicPr();
            CTNonVisualDrawingProps cTNonVisualDrawingProps2 = cTPictureNonVisual.addNewCNvPr();
            cTNonVisualDrawingProps2.setId(0L);
            cTNonVisualDrawingProps2.setName("Picture " + l);
            cTNonVisualDrawingProps2.setDescr(string);
            CTNonVisualPictureProperties cTNonVisualPictureProperties = cTPictureNonVisual.addNewCNvPicPr();
            cTNonVisualPictureProperties.addNewPicLocks().setNoChangeAspect(true);
            CTBlipFillProperties cTBlipFillProperties = cTPicture.addNewBlipFill();
            CTBlip cTBlip = cTBlipFillProperties.addNewBlip();
            cTBlip.setEmbed(xWPFPictureData.getPackageRelationship().getId());
            cTBlipFillProperties.addNewStretch().addNewFillRect();
            CTShapeProperties cTShapeProperties = cTPicture.addNewSpPr();
            CTTransform2D cTTransform2D = cTShapeProperties.addNewXfrm();
            CTPoint2D cTPoint2D = cTTransform2D.addNewOff();
            cTPoint2D.setX(0L);
            cTPoint2D.setY(0L);
            CTPositiveSize2D cTPositiveSize2D2 = cTTransform2D.addNewExt();
            cTPositiveSize2D2.setCx((long)n2);
            cTPositiveSize2D2.setCy((long)n3);
            CTPresetGeometry2D cTPresetGeometry2D = cTShapeProperties.addNewPrstGeom();
            cTPresetGeometry2D.setPrst(STShapeType.RECT);
            cTPresetGeometry2D.addNewAvLst();
            XWPFPicture xWPFPicture = new XWPFPicture(cTPicture, this);
            this.pictures.add(xWPFPicture);
            return xWPFPicture;
        }
        catch (XmlException xmlException) {
            throw new IllegalStateException(xmlException);
        }
    }

    public List<XWPFPicture> getEmbeddedPictures() {
        return this.pictures;
    }

    public String toString() {
        return this.text();
    }

    @Override
    public String text() {
        StringBuffer stringBuffer = new StringBuffer();
        XmlCursor xmlCursor = this.run.newCursor();
        xmlCursor.selectPath("./*");
        while (xmlCursor.toNextSelection()) {
            String string;
            XmlObject xmlObject = xmlCursor.getObject();
            if (xmlObject instanceof CTText && !"w:instrText".equals(string = xmlObject.getDomNode().getNodeName())) {
                stringBuffer.append(((CTText)xmlObject).getStringValue());
            }
            if (xmlObject instanceof CTFldChar && (string = (CTFldChar)xmlObject).getFldCharType() == STFldCharType.BEGIN && string.getFfData() != null) {
                for (CTFFCheckBox cTFFCheckBox : string.getFfData().getCheckBoxList()) {
                    if (cTFFCheckBox.getDefault().getVal() == STOnOff.X_1) {
                        stringBuffer.append("|X|");
                        continue;
                    }
                    stringBuffer.append("|_|");
                }
            }
            if (xmlObject instanceof CTPTab) {
                stringBuffer.append("\t");
            }
            if (xmlObject instanceof CTBr) {
                stringBuffer.append("\n");
            }
            if (xmlObject instanceof CTEmpty) {
                string = xmlObject.getDomNode().getNodeName();
                if ("w:tab".equals(string) || "tab".equals(string)) {
                    stringBuffer.append("\t");
                }
                if ("w:br".equals(string) || "br".equals(string)) {
                    stringBuffer.append("\n");
                }
                if ("w:cr".equals(string) || "cr".equals(string)) {
                    stringBuffer.append("\n");
                }
            }
            if (!(xmlObject instanceof CTFtnEdnRef)) continue;
            string = (CTFtnEdnRef)xmlObject;
            String string2 = string.getDomNode().getLocalName().equals("footnoteReference") ? "[footnoteRef:" + string.getId().intValue() + "]" : "[endnoteRef:" + string.getId().intValue() + "]";
            stringBuffer.append(string2);
        }
        xmlCursor.dispose();
        if (this.pictureText != null && this.pictureText.length() > 0) {
            stringBuffer.append("\n").append(this.pictureText);
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontCharRange {
        ascii,
        cs,
        eastAsia,
        hAnsi;

    }
}

