/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import ai2.org.apache.poi.xwpf.usermodel.XWPFNum;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumbering;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.NumberingDocument;

public class XWPFNumbering
extends POIXMLDocumentPart {
    protected List<XWPFAbstractNum> abstractNums = new ArrayList<XWPFAbstractNum>();
    protected List<XWPFNum> nums = new ArrayList<XWPFNum>();
    boolean isNew;
    private CTNumbering ctNumbering;

    public XWPFNumbering(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, OpenXML4JException {
        super(packagePart, packageRelationship);
        this.isNew = true;
    }

    public XWPFNumbering() {
        this.abstractNums = new ArrayList<XWPFAbstractNum>();
        this.nums = new ArrayList<XWPFNum>();
        this.isNew = true;
    }

    protected void onDocumentRead() throws IOException {
        NumberingDocument numberingDocument = null;
        InputStream inputStream = this.getPackagePart().getInputStream();
        try {
            numberingDocument = NumberingDocument.Factory.parse((InputStream)inputStream);
            this.ctNumbering = numberingDocument.getNumbering();
            for (CTNum cTNum : this.ctNumbering.getNumArray()) {
                this.nums.add(new XWPFNum(cTNum, this));
            }
            for (CTNum cTNum : this.ctNumbering.getAbstractNumArray()) {
                this.abstractNums.add(new XWPFAbstractNum((CTAbstractNum)cTNum, this));
            }
            this.isNew = false;
        }
        catch (XmlException xmlException) {
            throw new POIXMLException();
        }
    }

    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTNumbering.type.getName().getNamespaceURI(), "numbering"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://schemas.openxmlformats.org/markup-compatibility/2006", "ve");
        hashMap.put("urn:schemas-microsoft-com:office:office", "o");
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/math", "m");
        hashMap.put("urn:schemas-microsoft-com:vml", "v");
        hashMap.put("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
        hashMap.put("urn:schemas-microsoft-com:office:word", "w10");
        hashMap.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        hashMap.put("http://schemas.microsoft.com/office/word/2006/wordml", "wne");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.ctNumbering.save(outputStream, xmlOptions);
        outputStream.close();
    }

    public void setNumbering(CTNumbering cTNumbering) {
        this.ctNumbering = cTNumbering;
    }

    public boolean numExist(BigInteger bigInteger) {
        for (XWPFNum xWPFNum : this.nums) {
            if (!xWPFNum.getCTNum().getNumId().equals(bigInteger)) continue;
            return true;
        }
        return false;
    }

    public BigInteger addNum(XWPFNum xWPFNum) {
        this.ctNumbering.addNewNum();
        int n = this.ctNumbering.sizeOfNumArray() - 1;
        this.ctNumbering.setNumArray(n, xWPFNum.getCTNum());
        this.nums.add(xWPFNum);
        return xWPFNum.getCTNum().getNumId();
    }

    public BigInteger addNum(BigInteger bigInteger) {
        CTNum cTNum = this.ctNumbering.addNewNum();
        cTNum.addNewAbstractNumId();
        cTNum.getAbstractNumId().setVal(bigInteger);
        cTNum.setNumId(BigInteger.valueOf(this.nums.size() + 1));
        XWPFNum xWPFNum = new XWPFNum(cTNum, this);
        this.nums.add(xWPFNum);
        return cTNum.getNumId();
    }

    public void addNum(BigInteger bigInteger, BigInteger bigInteger2) {
        CTNum cTNum = this.ctNumbering.addNewNum();
        cTNum.addNewAbstractNumId();
        cTNum.getAbstractNumId().setVal(bigInteger);
        cTNum.setNumId(bigInteger2);
        XWPFNum xWPFNum = new XWPFNum(cTNum, this);
        this.nums.add(xWPFNum);
    }

    public XWPFNum getNum(BigInteger bigInteger) {
        for (XWPFNum xWPFNum : this.nums) {
            if (!xWPFNum.getCTNum().getNumId().equals(bigInteger)) continue;
            return xWPFNum;
        }
        return null;
    }

    public XWPFAbstractNum getAbstractNum(BigInteger bigInteger) {
        for (XWPFAbstractNum xWPFAbstractNum : this.abstractNums) {
            if (!xWPFAbstractNum.getAbstractNum().getAbstractNumId().equals(bigInteger)) continue;
            return xWPFAbstractNum;
        }
        return null;
    }

    public BigInteger getIdOfAbstractNum(XWPFAbstractNum xWPFAbstractNum) {
        CTAbstractNum cTAbstractNum = (CTAbstractNum)xWPFAbstractNum.getCTAbstractNum().copy();
        XWPFAbstractNum xWPFAbstractNum2 = new XWPFAbstractNum(cTAbstractNum, this);
        for (int i = 0; i < this.abstractNums.size(); ++i) {
            xWPFAbstractNum2.getCTAbstractNum().setAbstractNumId(BigInteger.valueOf(i));
            xWPFAbstractNum2.setNumbering(this);
            if (!xWPFAbstractNum2.getCTAbstractNum().valueEquals((XmlObject)this.abstractNums.get(i).getCTAbstractNum())) continue;
            return xWPFAbstractNum2.getCTAbstractNum().getAbstractNumId();
        }
        return null;
    }

    public BigInteger addAbstractNum(XWPFAbstractNum xWPFAbstractNum) {
        int n = this.abstractNums.size();
        if (xWPFAbstractNum.getAbstractNum() != null) {
            this.ctNumbering.addNewAbstractNum().set((XmlObject)xWPFAbstractNum.getAbstractNum());
        } else {
            this.ctNumbering.addNewAbstractNum();
            xWPFAbstractNum.getAbstractNum().setAbstractNumId(BigInteger.valueOf(n));
            this.ctNumbering.setAbstractNumArray(n, xWPFAbstractNum.getAbstractNum());
        }
        this.abstractNums.add(xWPFAbstractNum);
        return xWPFAbstractNum.getCTAbstractNum().getAbstractNumId();
    }

    public boolean removeAbstractNum(BigInteger bigInteger) {
        if (bigInteger.byteValue() < this.abstractNums.size()) {
            this.ctNumbering.removeAbstractNum((int)bigInteger.byteValue());
            this.abstractNums.remove(bigInteger.byteValue());
            return true;
        }
        return false;
    }

    public BigInteger getAbstractNumID(BigInteger bigInteger) {
        XWPFNum xWPFNum = this.getNum(bigInteger);
        if (xWPFNum == null) {
            return null;
        }
        if (xWPFNum.getCTNum() == null) {
            return null;
        }
        if (xWPFNum.getCTNum().getAbstractNumId() == null) {
            return null;
        }
        return xWPFNum.getCTNum().getAbstractNumId().getVal();
    }
}

