/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.xwpf.usermodel.BodyElementType;
import ai2.org.apache.poi.xwpf.usermodel.BodyType;
import ai2.org.apache.poi.xwpf.usermodel.IBody;
import ai2.org.apache.poi.xwpf.usermodel.ISDTContent;
import ai2.org.apache.poi.xwpf.usermodel.ISDTContents;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;

public abstract class AbstractXWPFSDT
implements ISDTContents {
    private final String title;
    private final String tag;
    private final IBody part;

    public AbstractXWPFSDT(CTSdtPr cTSdtPr, IBody iBody) {
        CTString[] cTStringArray = cTSdtPr.getAliasArray();
        this.title = cTStringArray != null && cTStringArray.length > 0 ? cTStringArray[0].getVal() : "";
        CTString[] cTStringArray2 = cTSdtPr.getTagArray();
        this.tag = cTStringArray2 != null && cTStringArray2.length > 0 ? cTStringArray2[0].getVal() : "";
        this.part = iBody;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTag() {
        return this.tag;
    }

    public abstract ISDTContent getContent();

    public IBody getBody() {
        return null;
    }

    public POIXMLDocumentPart getPart() {
        return this.part.getPart();
    }

    public BodyType getPartType() {
        return BodyType.CONTENTCONTROL;
    }

    public BodyElementType getElementType() {
        return BodyElementType.CONTENTCONTROL;
    }

    public XWPFDocument getDocument() {
        return this.part.getXWPFDocument();
    }
}

