/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.model;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFactory;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFooter;
import ai2.org.apache.poi.xwpf.usermodel.XWPFHeader;
import ai2.org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFRelation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPicture;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FtrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;
import schemasMicrosoftComOfficeOffice.CTLock;
import schemasMicrosoftComOfficeOffice.STConnectType;
import schemasMicrosoftComVml.CTFormulas;
import schemasMicrosoftComVml.CTGroup;
import schemasMicrosoftComVml.CTH;
import schemasMicrosoftComVml.CTHandles;
import schemasMicrosoftComVml.CTPath;
import schemasMicrosoftComVml.CTShape;
import schemasMicrosoftComVml.CTShapetype;
import schemasMicrosoftComVml.CTTextPath;
import schemasMicrosoftComVml.STExt;
import schemasMicrosoftComVml.STTrueFalse;

public class XWPFHeaderFooterPolicy {
    public static final STHdrFtr.Enum DEFAULT = STHdrFtr.DEFAULT;
    public static final STHdrFtr.Enum EVEN = STHdrFtr.EVEN;
    public static final STHdrFtr.Enum FIRST = STHdrFtr.FIRST;
    private XWPFDocument doc;
    private XWPFHeader firstPageHeader;
    private XWPFFooter firstPageFooter;
    private XWPFHeader evenPageHeader;
    private XWPFFooter evenPageFooter;
    private XWPFHeader defaultHeader;
    private XWPFFooter defaultFooter;

    public XWPFHeaderFooterPolicy(XWPFDocument xWPFDocument) {
        this(xWPFDocument, xWPFDocument.getDocument().getBody().getSectPr());
    }

    public XWPFHeaderFooterPolicy(XWPFDocument xWPFDocument, CTSectPr cTSectPr) {
        STHdrFtr.Enum enum_;
        XWPFHeaderFooter xWPFHeaderFooter;
        POIXMLDocumentPart pOIXMLDocumentPart;
        CTHdrFtrRef cTHdrFtrRef;
        int n;
        this.doc = xWPFDocument;
        for (n = 0; n < cTSectPr.sizeOfHeaderReferenceArray(); ++n) {
            cTHdrFtrRef = cTSectPr.getHeaderReferenceArray(n);
            pOIXMLDocumentPart = xWPFDocument.getRelationById(cTHdrFtrRef.getId());
            xWPFHeaderFooter = null;
            if (pOIXMLDocumentPart != null && pOIXMLDocumentPart instanceof XWPFHeader) {
                xWPFHeaderFooter = (XWPFHeader)pOIXMLDocumentPart;
            }
            enum_ = cTHdrFtrRef.getType();
            this.assignHeader((XWPFHeader)xWPFHeaderFooter, enum_);
        }
        for (n = 0; n < cTSectPr.sizeOfFooterReferenceArray(); ++n) {
            cTHdrFtrRef = cTSectPr.getFooterReferenceArray(n);
            pOIXMLDocumentPart = xWPFDocument.getRelationById(cTHdrFtrRef.getId());
            xWPFHeaderFooter = null;
            if (pOIXMLDocumentPart != null && pOIXMLDocumentPart instanceof XWPFFooter) {
                xWPFHeaderFooter = (XWPFFooter)pOIXMLDocumentPart;
            }
            enum_ = cTHdrFtrRef.getType();
            this.assignFooter((XWPFFooter)xWPFHeaderFooter, enum_);
        }
    }

    private void assignFooter(XWPFFooter xWPFFooter, STHdrFtr.Enum enum_) {
        if (enum_ == STHdrFtr.FIRST) {
            this.firstPageFooter = xWPFFooter;
        } else if (enum_ == STHdrFtr.EVEN) {
            this.evenPageFooter = xWPFFooter;
        } else {
            this.defaultFooter = xWPFFooter;
        }
    }

    private void assignHeader(XWPFHeader xWPFHeader, STHdrFtr.Enum enum_) {
        if (enum_ == STHdrFtr.FIRST) {
            this.firstPageHeader = xWPFHeader;
        } else if (enum_ == STHdrFtr.EVEN) {
            this.evenPageHeader = xWPFHeader;
        } else {
            this.defaultHeader = xWPFHeader;
        }
    }

    public XWPFHeader createHeader(STHdrFtr.Enum enum_) throws IOException {
        return this.createHeader(enum_, null);
    }

    public XWPFHeader createHeader(STHdrFtr.Enum enum_, XWPFParagraph[] xWPFParagraphArray) throws IOException {
        XWPFRelation xWPFRelation = XWPFRelation.HEADER;
        String string = "Header";
        int n = this.getRelationIndex(xWPFRelation);
        HdrDocument hdrDocument = HdrDocument.Factory.newInstance();
        XWPFHeader xWPFHeader = (XWPFHeader)this.doc.createRelationship(xWPFRelation, XWPFFactory.getInstance(), n);
        xWPFHeader.setXWPFDocument(this.doc);
        CTHdrFtr cTHdrFtr = this.buildHdr(enum_, string, xWPFHeader, xWPFParagraphArray);
        xWPFHeader.setHeaderFooter(cTHdrFtr);
        OutputStream outputStream = xWPFHeader.getPackagePart().getOutputStream();
        hdrDocument.setHdr(cTHdrFtr);
        XmlOptions xmlOptions = this.commit(xWPFHeader);
        this.assignHeader(xWPFHeader, enum_);
        hdrDocument.save(outputStream, xmlOptions);
        outputStream.close();
        return xWPFHeader;
    }

    public XWPFFooter createFooter(STHdrFtr.Enum enum_) throws IOException {
        return this.createFooter(enum_, null);
    }

    public XWPFFooter createFooter(STHdrFtr.Enum enum_, XWPFParagraph[] xWPFParagraphArray) throws IOException {
        XWPFRelation xWPFRelation = XWPFRelation.FOOTER;
        String string = "Footer";
        int n = this.getRelationIndex(xWPFRelation);
        FtrDocument ftrDocument = FtrDocument.Factory.newInstance();
        XWPFFooter xWPFFooter = (XWPFFooter)this.doc.createRelationship(xWPFRelation, XWPFFactory.getInstance(), n);
        xWPFFooter.setXWPFDocument(this.doc);
        CTHdrFtr cTHdrFtr = this.buildFtr(enum_, string, xWPFFooter, xWPFParagraphArray);
        xWPFFooter.setHeaderFooter(cTHdrFtr);
        OutputStream outputStream = xWPFFooter.getPackagePart().getOutputStream();
        ftrDocument.setFtr(cTHdrFtr);
        XmlOptions xmlOptions = this.commit(xWPFFooter);
        this.assignFooter(xWPFFooter, enum_);
        ftrDocument.save(outputStream, xmlOptions);
        outputStream.close();
        return xWPFFooter;
    }

    private int getRelationIndex(XWPFRelation xWPFRelation) {
        List<POIXMLDocumentPart> list = this.doc.getRelations();
        int n = 1;
        for (POIXMLDocumentPart pOIXMLDocumentPart : list) {
            if (!pOIXMLDocumentPart.getPackageRelationship().getRelationshipType().equals(xWPFRelation.getRelation())) continue;
            ++n;
        }
        return n;
    }

    private CTHdrFtr buildFtr(STHdrFtr.Enum enum_, String string, XWPFHeaderFooter xWPFHeaderFooter, XWPFParagraph[] xWPFParagraphArray) {
        CTHdrFtr cTHdrFtr = this.buildHdrFtr(string, xWPFParagraphArray, xWPFHeaderFooter);
        this.setFooterReference(enum_, xWPFHeaderFooter);
        return cTHdrFtr;
    }

    private CTHdrFtr buildHdr(STHdrFtr.Enum enum_, String string, XWPFHeaderFooter xWPFHeaderFooter, XWPFParagraph[] xWPFParagraphArray) {
        CTHdrFtr cTHdrFtr = this.buildHdrFtr(string, xWPFParagraphArray, xWPFHeaderFooter);
        this.setHeaderReference(enum_, xWPFHeaderFooter);
        return cTHdrFtr;
    }

    private CTHdrFtr buildHdrFtr(String string, XWPFParagraph[] xWPFParagraphArray) {
        CTHdrFtr cTHdrFtr = CTHdrFtr.Factory.newInstance();
        if (xWPFParagraphArray != null) {
            for (int i = 0; i < xWPFParagraphArray.length; ++i) {
                CTP cTP = cTHdrFtr.addNewP();
                cTHdrFtr.setPArray(i, xWPFParagraphArray[i].getCTP());
            }
        } else {
            CTP cTP = cTHdrFtr.addNewP();
            byte[] byArray = this.doc.getDocument().getBody().getPArray(0).getRsidR();
            byte[] byArray2 = this.doc.getDocument().getBody().getPArray(0).getRsidRDefault();
            cTP.setRsidP(byArray);
            cTP.setRsidRDefault(byArray2);
            CTPPr cTPPr = cTP.addNewPPr();
            cTPPr.addNewPStyle().setVal(string);
        }
        return cTHdrFtr;
    }

    private CTHdrFtr buildHdrFtr(String string, XWPFParagraph[] xWPFParagraphArray, XWPFHeaderFooter xWPFHeaderFooter) {
        CTHdrFtr cTHdrFtr = xWPFHeaderFooter._getHdrFtr();
        if (xWPFParagraphArray != null) {
            for (int i = 0; i < xWPFParagraphArray.length; ++i) {
                CTP cTP = cTHdrFtr.addNewP();
                cTHdrFtr.setPArray(i, xWPFParagraphArray[i].getCTP());
            }
        } else {
            CTPPr cTPPr;
            CTP cTP = cTHdrFtr.addNewP();
            CTBody cTBody = this.doc.getDocument().getBody();
            if (cTBody.sizeOfPArray() > 0 && (cTPPr = cTBody.getPArray(0)).isSetRsidR()) {
                byte[] byArray = cTPPr.getRsidR();
                byte[] byArray2 = cTPPr.getRsidRDefault();
                cTP.setRsidP(byArray);
                cTP.setRsidRDefault(byArray2);
            }
            cTPPr = cTP.addNewPPr();
            cTPPr.addNewPStyle().setVal(string);
        }
        return cTHdrFtr;
    }

    private void setFooterReference(STHdrFtr.Enum enum_, XWPFHeaderFooter xWPFHeaderFooter) {
        CTHdrFtrRef cTHdrFtrRef = this.doc.getDocument().getBody().getSectPr().addNewFooterReference();
        cTHdrFtrRef.setType(enum_);
        cTHdrFtrRef.setId(xWPFHeaderFooter.getPackageRelationship().getId());
    }

    private void setHeaderReference(STHdrFtr.Enum enum_, XWPFHeaderFooter xWPFHeaderFooter) {
        CTHdrFtrRef cTHdrFtrRef = this.doc.getDocument().getBody().getSectPr().addNewHeaderReference();
        cTHdrFtrRef.setType(enum_);
        cTHdrFtrRef.setId(xWPFHeaderFooter.getPackageRelationship().getId());
    }

    private XmlOptions commit(XWPFHeaderFooter xWPFHeaderFooter) {
        XmlOptions xmlOptions = new XmlOptions(POIXMLDocumentPart.DEFAULT_XML_OPTIONS);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/math", "m");
        hashMap.put("urn:schemas-microsoft-com:office:office", "o");
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        hashMap.put("urn:schemas-microsoft-com:vml", "v");
        hashMap.put("http://schemas.openxmlformats.org/markup-compatibility/2006", "ve");
        hashMap.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        hashMap.put("urn:schemas-microsoft-com:office:word", "w10");
        hashMap.put("http://schemas.microsoft.com/office/word/2006/wordml", "wne");
        hashMap.put("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        return xmlOptions;
    }

    public XWPFHeader getFirstPageHeader() {
        return this.firstPageHeader;
    }

    public XWPFFooter getFirstPageFooter() {
        return this.firstPageFooter;
    }

    public XWPFHeader getOddPageHeader() {
        return this.defaultHeader;
    }

    public XWPFFooter getOddPageFooter() {
        return this.defaultFooter;
    }

    public XWPFHeader getEvenPageHeader() {
        return this.evenPageHeader;
    }

    public XWPFFooter getEvenPageFooter() {
        return this.evenPageFooter;
    }

    public XWPFHeader getDefaultHeader() {
        return this.defaultHeader;
    }

    public XWPFFooter getDefaultFooter() {
        return this.defaultFooter;
    }

    public XWPFHeader getHeader(int n) {
        if (n == 1 && this.firstPageHeader != null) {
            return this.firstPageHeader;
        }
        if (n % 2 == 0 && this.evenPageHeader != null) {
            return this.evenPageHeader;
        }
        return this.defaultHeader;
    }

    public XWPFFooter getFooter(int n) {
        if (n == 1 && this.firstPageFooter != null) {
            return this.firstPageFooter;
        }
        if (n % 2 == 0 && this.evenPageFooter != null) {
            return this.evenPageFooter;
        }
        return this.defaultFooter;
    }

    public void createWatermark(String string) {
        XWPFParagraph[] xWPFParagraphArray = new XWPFParagraph[1];
        try {
            xWPFParagraphArray[0] = this.getWatermarkParagraph(string, 1);
            this.createHeader(DEFAULT, xWPFParagraphArray);
            xWPFParagraphArray[0] = this.getWatermarkParagraph(string, 2);
            this.createHeader(FIRST, xWPFParagraphArray);
            xWPFParagraphArray[0] = this.getWatermarkParagraph(string, 3);
            this.createHeader(EVEN, xWPFParagraphArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private XWPFParagraph getWatermarkParagraph(String string, int n) {
        CTP cTP = CTP.Factory.newInstance();
        byte[] byArray = this.doc.getDocument().getBody().getPArray(0).getRsidR();
        byte[] byArray2 = this.doc.getDocument().getBody().getPArray(0).getRsidRDefault();
        cTP.setRsidP(byArray);
        cTP.setRsidRDefault(byArray2);
        CTPPr cTPPr = cTP.addNewPPr();
        cTPPr.addNewPStyle().setVal("Header");
        CTR cTR = cTP.addNewR();
        CTRPr cTRPr = cTR.addNewRPr();
        cTRPr.addNewNoProof();
        CTPicture cTPicture = cTR.addNewPict();
        CTGroup cTGroup = CTGroup.Factory.newInstance();
        CTShapetype cTShapetype = cTGroup.addNewShapetype();
        cTShapetype.setId("_x0000_t136");
        cTShapetype.setCoordsize("1600,21600");
        cTShapetype.setSpt(136.0f);
        cTShapetype.setAdj("10800");
        cTShapetype.setPath2("m@7,0l@8,0m@5,21600l@6,21600e");
        CTFormulas cTFormulas = cTShapetype.addNewFormulas();
        cTFormulas.addNewF().setEqn("sum #0 0 10800");
        cTFormulas.addNewF().setEqn("prod #0 2 1");
        cTFormulas.addNewF().setEqn("sum 21600 0 @1");
        cTFormulas.addNewF().setEqn("sum 0 0 @2");
        cTFormulas.addNewF().setEqn("sum 21600 0 @3");
        cTFormulas.addNewF().setEqn("if @0 @3 0");
        cTFormulas.addNewF().setEqn("if @0 21600 @1");
        cTFormulas.addNewF().setEqn("if @0 0 @2");
        cTFormulas.addNewF().setEqn("if @0 @4 21600");
        cTFormulas.addNewF().setEqn("mid @5 @6");
        cTFormulas.addNewF().setEqn("mid @8 @5");
        cTFormulas.addNewF().setEqn("mid @7 @8");
        cTFormulas.addNewF().setEqn("mid @6 @7");
        cTFormulas.addNewF().setEqn("sum @6 0 @5");
        CTPath cTPath = cTShapetype.addNewPath();
        cTPath.setTextpathok(STTrueFalse.T);
        cTPath.setConnecttype(STConnectType.CUSTOM);
        cTPath.setConnectlocs("@9,0;@10,10800;@11,21600;@12,10800");
        cTPath.setConnectangles("270,180,90,0");
        CTTextPath cTTextPath = cTShapetype.addNewTextpath();
        cTTextPath.setOn(STTrueFalse.T);
        cTTextPath.setFitshape(STTrueFalse.T);
        CTHandles cTHandles = cTShapetype.addNewHandles();
        CTH cTH = cTHandles.addNewH();
        cTH.setPosition("#0,bottomRight");
        cTH.setXrange("6629,14971");
        CTLock cTLock = cTShapetype.addNewLock();
        cTLock.setExt(STExt.EDIT);
        CTShape cTShape = cTGroup.addNewShape();
        cTShape.setId("PowerPlusWaterMarkObject" + n);
        cTShape.setSpid("_x0000_s102" + (4 + n));
        cTShape.setType("#_x0000_t136");
        cTShape.setStyle("position:absolute;margin-left:0;margin-top:0;width:415pt;height:207.5pt;z-index:-251654144;mso-wrap-edited:f;mso-position-horizontal:center;mso-position-horizontal-relative:margin;mso-position-vertical:center;mso-position-vertical-relative:margin");
        cTShape.setWrapcoords("616 5068 390 16297 39 16921 -39 17155 7265 17545 7186 17467 -39 17467 18904 17467 10507 17467 8710 17545 18904 17077 18787 16843 18358 16297 18279 12554 19178 12476 20701 11774 20779 11228 21131 10059 21248 8811 21248 7563 20975 6316 20935 5380 19490 5146 14022 5068 2616 5068");
        cTShape.setFillcolor("black");
        cTShape.setStroked(STTrueFalse.FALSE);
        CTTextPath cTTextPath2 = cTShape.addNewTextpath();
        cTTextPath2.setStyle("font-family:&quot;Cambria&quot;;font-size:1pt");
        cTTextPath2.setString(string);
        cTPicture.set((XmlObject)cTGroup);
        return new XWPFParagraph(cTP, this.doc);
    }
}

