/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.model;

import ai2.org.apache.poi.xwpf.model.XWPFParagraphDecorator;
import ai2.org.apache.poi.xwpf.usermodel.XWPFComment;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;

public class XWPFCommentsDecorator
extends XWPFParagraphDecorator {
    private StringBuffer commentText = new StringBuffer();

    public XWPFCommentsDecorator(XWPFParagraphDecorator xWPFParagraphDecorator) {
        this(xWPFParagraphDecorator.paragraph, xWPFParagraphDecorator);
    }

    public XWPFCommentsDecorator(XWPFParagraph xWPFParagraph, XWPFParagraphDecorator xWPFParagraphDecorator) {
        super(xWPFParagraph, xWPFParagraphDecorator);
        for (CTMarkupRange cTMarkupRange : xWPFParagraph.getCTP().getCommentRangeStartArray()) {
            XWPFComment xWPFComment = xWPFParagraph.getDocument().getCommentByID(cTMarkupRange.getId().toString());
            if (xWPFComment == null) continue;
            this.commentText.append("\tComment by " + xWPFComment.getAuthor() + ": " + xWPFComment.getText());
        }
    }

    public String getCommentText() {
        return this.commentText.toString();
    }

    public String getText() {
        return super.getText() + this.commentText;
    }
}

