/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class EvilUnclosedBRFixingInputStream
extends InputStream {
    private InputStream source;
    private byte[] spare;
    private static byte[] detect = new byte[]{60, 98, 114, 62};

    public EvilUnclosedBRFixingInputStream(InputStream inputStream) {
        this.source = inputStream;
    }

    public int read() throws IOException {
        return this.source.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.readFromSpare(byArray, n, n2);
        int n4 = this.source.read(byArray, n + n3, n2 - n3);
        int n5 = n4 == -1 || n4 == 0 ? n3 : n3 + n4;
        if (n5 > 0) {
            n5 = this.fixUp(byArray, n, n5);
        }
        return n5;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private int readFromSpare(byte[] byArray, int n, int n2) {
        if (this.spare == null) {
            return 0;
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("Asked to read 0 bytes");
        }
        if (this.spare.length <= n2) {
            System.arraycopy(this.spare, 0, byArray, n, this.spare.length);
            int n3 = this.spare.length;
            this.spare = null;
            return n3;
        }
        byte[] byArray2 = new byte[this.spare.length - n2];
        System.arraycopy(this.spare, 0, byArray, n, n2);
        System.arraycopy(this.spare, n2, byArray2, 0, byArray2.length);
        this.spare = byArray2;
        return n2;
    }

    private void addToSpare(byte[] byArray, int n, int n2, boolean bl) {
        if (this.spare == null) {
            this.spare = new byte[n2];
            System.arraycopy(byArray, n, this.spare, 0, n2);
        } else {
            byte[] byArray2 = new byte[this.spare.length + n2];
            if (bl) {
                System.arraycopy(this.spare, 0, byArray2, 0, this.spare.length);
                System.arraycopy(byArray, n, byArray2, this.spare.length, n2);
            } else {
                System.arraycopy(byArray, n, byArray2, 0, n2);
                System.arraycopy(this.spare, 0, byArray2, n2, this.spare.length);
            }
            this.spare = byArray2;
        }
    }

    private int fixUp(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        for (int i = 0; i < detect.length - 1; ++i) {
            n5 = n + n2 - 1 - i;
            if (n5 < 0) continue;
            n4 = 1;
            for (n3 = 0; n3 <= i && n4 != 0; ++n3) {
                if (byArray[n5 + n3] == detect[n3]) continue;
                n4 = 0;
            }
            if (n4 == 0) continue;
            this.addToSpare(byArray, n5, i + 1, true);
            --n2;
            n2 -= i;
            break;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n5 = n; n5 <= n + n2 - detect.length; ++n5) {
            n4 = 1;
            for (n3 = 0; n3 < detect.length && n4 != 0; ++n3) {
                if (byArray[n5 + n3] == detect[n3]) continue;
                n4 = 0;
            }
            if (n4 == 0) continue;
            arrayList.add(n5);
        }
        if (arrayList.size() == 0) {
            return n2;
        }
        n5 = n + n2 + arrayList.size();
        n4 = n5 - byArray.length;
        if (n4 > 0) {
            n3 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n6 = (Integer)iterator.next();
                if (n6 > n + n2 - detect.length - n4 - n3) {
                    n4 = n5 - n6 - 1 - n3;
                    break;
                }
                ++n3;
            }
            this.addToSpare(byArray, n + n2 - n4, n4, false);
            n2 -= n4;
        }
        for (n3 = arrayList.size() - 1; n3 >= 0; --n3) {
            int n7 = (Integer)arrayList.get(n3);
            if (n7 >= n2 + n || n7 > n2 - 3) continue;
            byte[] byArray2 = new byte[n2 - n7 - 3];
            System.arraycopy(byArray, n7 + 3, byArray2, 0, byArray2.length);
            byArray[n7 + 3] = 47;
            System.arraycopy(byArray2, 0, byArray, n7 + 4, byArray2.length);
            ++n2;
        }
        return n2;
    }
}

