/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.helpers;

import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.xssf.model.SingleXmlCells;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSingleXmlCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXmlCellPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXmlPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STXmlDataType;

public class XSSFSingleXmlCell {
    private CTSingleXmlCell singleXmlCell;
    private SingleXmlCells parent;

    public XSSFSingleXmlCell(CTSingleXmlCell cTSingleXmlCell, SingleXmlCells singleXmlCells) {
        this.singleXmlCell = cTSingleXmlCell;
        this.parent = singleXmlCells;
    }

    public XSSFCell getReferencedCell() {
        XSSFCell xSSFCell = null;
        CellReference cellReference = new CellReference(this.singleXmlCell.getR());
        XSSFRow xSSFRow = this.parent.getXSSFSheet().getRow(cellReference.getRow());
        if (xSSFRow == null) {
            xSSFRow = this.parent.getXSSFSheet().createRow(cellReference.getRow());
        }
        if ((xSSFCell = xSSFRow.getCell(cellReference.getCol())) == null) {
            xSSFCell = xSSFRow.createCell(cellReference.getCol());
        }
        return xSSFCell;
    }

    public String getXpath() {
        CTXmlCellPr cTXmlCellPr = this.singleXmlCell.getXmlCellPr();
        CTXmlPr cTXmlPr = cTXmlCellPr.getXmlPr();
        String string = cTXmlPr.getXpath();
        return string;
    }

    public long getMapId() {
        return this.singleXmlCell.getXmlCellPr().getXmlPr().getMapId();
    }

    public STXmlDataType.Enum getXmlDataType() {
        CTXmlCellPr cTXmlCellPr = this.singleXmlCell.getXmlCellPr();
        CTXmlPr cTXmlPr = cTXmlCellPr.getXmlPr();
        return cTXmlPr.getXmlDataType();
    }
}

