/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.helpers;

import ai2.org.apache.poi.ss.formula.FormulaParseException;
import ai2.org.apache.poi.ss.formula.FormulaParser;
import ai2.org.apache.poi.ss.formula.FormulaRenderer;
import ai2.org.apache.poi.ss.formula.FormulaShifter;
import ai2.org.apache.poi.ss.formula.ptg.AreaErrPtg;
import ai2.org.apache.poi.ss.formula.ptg.AreaPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.usermodel.Sheet;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import ai2.org.apache.poi.xssf.usermodel.XSSFName;
import ai2.org.apache.poi.xssf.usermodel.XSSFRow;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSSFRowShifter {
    private static POILogger logger = POILogFactory.getLogger(XSSFRowShifter.class);
    private final XSSFSheet sheet;

    public XSSFRowShifter(XSSFSheet xSSFSheet) {
        this.sheet = xSSFSheet;
    }

    public List<CellRangeAddress> shiftMerged(int n, int n2, int n3) {
        ArrayList<CellRangeAddress> arrayList = new ArrayList<CellRangeAddress>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n4 = this.sheet.getNumMergedRegions();
        for (int i = 0; i < n4; ++i) {
            boolean bl;
            CellRangeAddress cellRangeAddress = this.sheet.getMergedRegion(i);
            boolean bl2 = cellRangeAddress.getFirstRow() >= n || cellRangeAddress.getLastRow() >= n;
            boolean bl3 = bl = cellRangeAddress.getFirstRow() <= n2 || cellRangeAddress.getLastRow() <= n2;
            if (!bl2 || !bl || XSSFRowShifter.containsCell(cellRangeAddress, n - 1, 0) || XSSFRowShifter.containsCell(cellRangeAddress, n2 + 1, 0)) continue;
            cellRangeAddress.setFirstRow(cellRangeAddress.getFirstRow() + n3);
            cellRangeAddress.setLastRow(cellRangeAddress.getLastRow() + n3);
            arrayList.add(cellRangeAddress);
            hashSet.add(i);
        }
        if (!hashSet.isEmpty()) {
            this.sheet.removeMergedRegions(hashSet);
        }
        for (CellRangeAddress cellRangeAddress : arrayList) {
            this.sheet.addMergedRegion(cellRangeAddress);
        }
        return arrayList;
    }

    private static boolean containsCell(CellRangeAddress cellRangeAddress, int n, int n2) {
        return cellRangeAddress.getFirstRow() <= n && cellRangeAddress.getLastRow() >= n && cellRangeAddress.getFirstColumn() <= n2 && cellRangeAddress.getLastColumn() >= n2;
    }

    public void updateNamedRanges(FormulaShifter formulaShifter) {
        XSSFWorkbook xSSFWorkbook = this.sheet.getWorkbook();
        XSSFEvaluationWorkbook xSSFEvaluationWorkbook = XSSFEvaluationWorkbook.create(xSSFWorkbook);
        for (int i = 0; i < xSSFWorkbook.getNumberOfNames(); ++i) {
            int n;
            XSSFName xSSFName = xSSFWorkbook.getNameAt(i);
            String string = xSSFName.getRefersToFormula();
            Ptg[] ptgArray = FormulaParser.parse(string, xSSFEvaluationWorkbook, 4, n = xSSFName.getSheetIndex());
            if (!formulaShifter.adjustFormula(ptgArray, n)) continue;
            String string2 = FormulaRenderer.toFormulaString(xSSFEvaluationWorkbook, ptgArray);
            xSSFName.setRefersToFormula(string2);
        }
    }

    public void updateFormulas(FormulaShifter formulaShifter) {
        this.updateSheetFormulas(this.sheet, formulaShifter);
        XSSFWorkbook xSSFWorkbook = this.sheet.getWorkbook();
        for (Sheet sheet : xSSFWorkbook) {
            if (this.sheet == sheet) continue;
            this.updateSheetFormulas(sheet, formulaShifter);
        }
    }

    private void updateSheetFormulas(Sheet sheet, FormulaShifter formulaShifter) {
        for (Row row : sheet) {
            XSSFRow xSSFRow = (XSSFRow)row;
            this.updateRowFormulas(xSSFRow, formulaShifter);
        }
    }

    private void updateRowFormulas(XSSFRow xSSFRow, FormulaShifter formulaShifter) {
        for (Cell cell : xSSFRow) {
            String string;
            String string2;
            XSSFCell xSSFCell = (XSSFCell)cell;
            CTCell cTCell = xSSFCell.getCTCell();
            if (!cTCell.isSetF()) continue;
            CTCellFormula cTCellFormula = cTCell.getF();
            String string3 = cTCellFormula.getStringValue();
            if (string3.length() > 0 && (string2 = XSSFRowShifter.shiftFormula(xSSFRow, string3, formulaShifter)) != null) {
                cTCellFormula.setStringValue(string2);
                if (cTCellFormula.getT() == STCellFormulaType.SHARED) {
                    int n = (int)cTCellFormula.getSi();
                    CTCellFormula cTCellFormula2 = xSSFRow.getSheet().getSharedFormula(n);
                    cTCellFormula2.setStringValue(string2);
                }
            }
            if (!cTCellFormula.isSetRef() || (string = XSSFRowShifter.shiftFormula(xSSFRow, string2 = cTCellFormula.getRef(), formulaShifter)) == null) continue;
            cTCellFormula.setRef(string);
        }
    }

    private static String shiftFormula(XSSFRow xSSFRow, String string, FormulaShifter formulaShifter) {
        XSSFSheet xSSFSheet = xSSFRow.getSheet();
        XSSFWorkbook xSSFWorkbook = xSSFSheet.getWorkbook();
        int n = xSSFWorkbook.getSheetIndex(xSSFSheet);
        XSSFEvaluationWorkbook xSSFEvaluationWorkbook = XSSFEvaluationWorkbook.create(xSSFWorkbook);
        try {
            Ptg[] ptgArray = FormulaParser.parse(string, xSSFEvaluationWorkbook, 0, n);
            String string2 = null;
            if (formulaShifter.adjustFormula(ptgArray, n)) {
                string2 = FormulaRenderer.toFormulaString(xSSFEvaluationWorkbook, ptgArray);
            }
            return string2;
        }
        catch (FormulaParseException formulaParseException) {
            logger.log(5, "Error shifting formula on row ", xSSFRow.getRowNum(), formulaParseException);
            return string;
        }
    }

    public void updateConditionalFormatting(FormulaShifter formulaShifter) {
        XSSFWorkbook xSSFWorkbook = this.sheet.getWorkbook();
        int n = xSSFWorkbook.getSheetIndex(this.sheet);
        XSSFEvaluationWorkbook xSSFEvaluationWorkbook = XSSFEvaluationWorkbook.create(xSSFWorkbook);
        CTWorksheet cTWorksheet = this.sheet.getCTWorksheet();
        CTConditionalFormatting[] cTConditionalFormattingArray = cTWorksheet.getConditionalFormattingArray();
        for (int i = cTConditionalFormattingArray.length - 1; i >= 0; --i) {
            Object object;
            Object object2;
            Object object32;
            CTConditionalFormatting cTConditionalFormatting = cTConditionalFormattingArray[i];
            ArrayList<CellRangeAddress> arrayList = new ArrayList<CellRangeAddress>();
            for (Object object32 : cTConditionalFormatting.getSqref()) {
                for (String[] stringArray : object2 = object32.toString().split(" ")) {
                    arrayList.add(CellRangeAddress.valueOf((String)stringArray));
                }
            }
            boolean bl = false;
            object32 = new ArrayList();
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (CellRangeAddress)object2.next();
                CellRangeAddress cellRangeAddress = XSSFRowShifter.shiftRange(formulaShifter, (CellRangeAddress)object, n);
                if (cellRangeAddress == null) {
                    bl = true;
                    continue;
                }
                object32.add(cellRangeAddress);
                if (cellRangeAddress == object) continue;
                bl = true;
            }
            if (bl) {
                int n2 = object32.size();
                if (n2 == 0) {
                    cTWorksheet.removeConditionalFormatting(i);
                    continue;
                }
                object = new ArrayList();
                Iterator iterator = object32.iterator();
                while (iterator.hasNext()) {
                    CellRangeAddress cellRangeAddress = (CellRangeAddress)iterator.next();
                    object.add(cellRangeAddress.formatAsString());
                }
                cTConditionalFormatting.setSqref((List)object);
            }
            for (CTCfRule cTCfRule : cTConditionalFormatting.getCfRuleArray()) {
                String[] stringArray;
                stringArray = cTCfRule.getFormulaArray();
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = stringArray[j];
                    Ptg[] ptgArray = FormulaParser.parse(string, xSSFEvaluationWorkbook, 0, n);
                    if (!formulaShifter.adjustFormula(ptgArray, n)) continue;
                    String string2 = FormulaRenderer.toFormulaString(xSSFEvaluationWorkbook, ptgArray);
                    cTCfRule.setFormulaArray(j, string2);
                }
            }
        }
    }

    private static CellRangeAddress shiftRange(FormulaShifter formulaShifter, CellRangeAddress cellRangeAddress, int n) {
        AreaPtg areaPtg = new AreaPtg(cellRangeAddress.getFirstRow(), cellRangeAddress.getLastRow(), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn(), false, false, false, false);
        Ptg[] ptgArray = new Ptg[]{areaPtg};
        if (!formulaShifter.adjustFormula(ptgArray, n)) {
            return cellRangeAddress;
        }
        Ptg ptg = ptgArray[0];
        if (ptg instanceof AreaPtg) {
            AreaPtg areaPtg2 = (AreaPtg)ptg;
            return new CellRangeAddress(areaPtg2.getFirstRow(), areaPtg2.getLastRow(), areaPtg2.getFirstColumn(), areaPtg2.getLastColumn());
        }
        if (ptg instanceof AreaErrPtg) {
            return null;
        }
        throw new IllegalStateException("Unexpected shifted ptg class (" + ptg.getClass().getName() + ")");
    }
}

