/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.helpers;

import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.xssf.util.CTColComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeSet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class ColumnHelper {
    private CTWorksheet worksheet;
    private CTCols newCols;

    public ColumnHelper(CTWorksheet cTWorksheet) {
        this.worksheet = cTWorksheet;
        this.cleanColumns();
    }

    public void cleanColumns() {
        this.newCols = CTCols.Factory.newInstance();
        CTCols cTCols = CTCols.Factory.newInstance();
        CTCols[] cTColsArray = this.worksheet.getColsArray();
        assert (cTColsArray != null);
        for (CTCols cTCols2 : cTColsArray) {
            for (CTCol cTCol : cTCols2.getColArray()) {
                this.cloneCol(cTCols, cTCol);
            }
        }
        ColumnHelper.sortColumns(cTCols);
        CTCols[] cTColsArray2 = cTCols.getColArray();
        this.sweepCleanColumns(this.newCols, (CTCol[])cTColsArray2, null);
        int n = cTColsArray.length;
        for (int i = n - 1; i >= 0; --i) {
            this.worksheet.removeCols(i);
        }
        this.worksheet.addNewCols();
        this.worksheet.setColsArray(0, this.newCols);
    }

    private void sweepCleanColumns(CTCols cTCols, CTCol[] cTColArray, CTCol cTCol) {
        ArrayList<CTCol> arrayList = new ArrayList<CTCol>(Arrays.asList(cTColArray));
        TreeSet<CTCol> treeSet = new TreeSet<CTCol>(CTColComparator.BY_MAX);
        ListIterator listIterator = arrayList.listIterator();
        CTCol cTCol2 = null;
        long l = 0L;
        long l2 = 0L;
        while (listIterator.hasNext()) {
            Object object;
            long l3;
            CTCol cTCol3 = (CTCol)listIterator.next();
            long l4 = cTCol3.getMin();
            long l5 = cTCol3.getMax();
            long l6 = l3 = l5 > l2 ? l5 : l2;
            if (listIterator.hasNext()) {
                l3 = ((CTCol)listIterator.next()).getMin();
                listIterator.previous();
            }
            Iterator<CTCol> iterator = treeSet.iterator();
            while (iterator.hasNext() && l4 > (object = iterator.next()).getMax()) {
                iterator.remove();
            }
            if (!treeSet.isEmpty() && l < l4) {
                this.insertCol(cTCols, l, l4 - 1L, treeSet.toArray(new CTCol[treeSet.size()]), true, cTCol2);
            }
            treeSet.add(cTCol3);
            if (l5 > l2) {
                l2 = l5;
            }
            if (cTCol3.equals(cTCol)) {
                cTCol2 = cTCol;
            }
            while (l4 <= l3 && !treeSet.isEmpty()) {
                CTCol cTCol4;
                object = new HashSet();
                CTCol cTCol5 = treeSet.first();
                long l7 = cTCol5.getMax();
                object.add(cTCol5);
                while ((cTCol4 = treeSet.higher(cTCol5)) != null && cTCol4.getMax() == l7) {
                    cTCol5 = cTCol4;
                    object.add(cTCol5);
                    if (l5 > l2) {
                        l2 = l5;
                    }
                    if (!cTCol3.equals(cTCol)) continue;
                    cTCol2 = cTCol;
                }
                if (l7 < l3 || !listIterator.hasNext()) {
                    this.insertCol(cTCols, l4, l7, treeSet.toArray(new CTCol[treeSet.size()]), true, cTCol2);
                    if (listIterator.hasNext()) {
                        if (l3 > l7) {
                            treeSet.removeAll((Collection<?>)object);
                            if (object.contains(cTCol)) {
                                cTCol2 = null;
                            }
                        }
                    } else {
                        treeSet.removeAll((Collection<?>)object);
                        if (object.contains(cTCol)) {
                            cTCol2 = null;
                        }
                    }
                    l = l4 = l7 + 1L;
                    continue;
                }
                l = l4;
                l4 = l3 + 1L;
            }
        }
        ColumnHelper.sortColumns(cTCols);
    }

    public static void sortColumns(CTCols cTCols) {
        CTCol[] cTColArray = cTCols.getColArray();
        Arrays.sort(cTColArray, CTColComparator.BY_MIN_MAX);
        cTCols.setColArray(cTColArray);
    }

    public CTCol cloneCol(CTCols cTCols, CTCol cTCol) {
        CTCol cTCol2 = cTCols.addNewCol();
        cTCol2.setMin(cTCol.getMin());
        cTCol2.setMax(cTCol.getMax());
        this.setColumnAttributes(cTCol, cTCol2);
        return cTCol2;
    }

    public CTCol getColumn(long l, boolean bl) {
        return this.getColumn1Based(l + 1L, bl);
    }

    public CTCol getColumn1Based(long l, boolean bl) {
        CTCol[] cTColArray;
        CTCols cTCols = this.worksheet.getColsArray(0);
        for (CTCol cTCol : cTColArray = cTCols.getColArray()) {
            long l2 = cTCol.getMin();
            long l3 = cTCol.getMax();
            if (l2 > l || l3 < l) continue;
            if (bl) {
                if (l2 < l) {
                    this.insertCol(cTCols, l2, l - 1L, new CTCol[]{cTCol});
                }
                if (l3 > l) {
                    this.insertCol(cTCols, l + 1L, l3, new CTCol[]{cTCol});
                }
                cTCol.setMin(l);
                cTCol.setMax(l);
            }
            return cTCol;
        }
        return null;
    }

    public CTCols addCleanColIntoCols(CTCols cTCols, CTCol cTCol) {
        CTCols cTCols2 = CTCols.Factory.newInstance();
        for (CTCol cTCol2 : cTCols.getColArray()) {
            this.cloneCol(cTCols2, cTCol2);
        }
        this.cloneCol(cTCols2, cTCol);
        ColumnHelper.sortColumns(cTCols2);
        CTCol[] cTColArray = cTCols2.getColArray();
        CTCols cTCols3 = CTCols.Factory.newInstance();
        this.sweepCleanColumns(cTCols3, cTColArray, cTCol);
        cTColArray = cTCols3.getColArray();
        cTCols.setColArray(cTColArray);
        return cTCols3;
    }

    private CTCol insertCol(CTCols cTCols, long l, long l2, CTCol[] cTColArray) {
        return this.insertCol(cTCols, l, l2, cTColArray, false, null);
    }

    private CTCol insertCol(CTCols cTCols, long l, long l2, CTCol[] cTColArray, boolean bl, CTCol cTCol) {
        if (bl || !this.columnExists(cTCols, l, l2)) {
            CTCol cTCol2 = cTCols.insertNewCol(0);
            cTCol2.setMin(l);
            cTCol2.setMax(l2);
            for (CTCol cTCol3 : cTColArray) {
                this.setColumnAttributes(cTCol3, cTCol2);
            }
            if (cTCol != null) {
                this.setColumnAttributes(cTCol, cTCol2);
            }
            return cTCol2;
        }
        return null;
    }

    public boolean columnExists(CTCols cTCols, long l) {
        return this.columnExists1Based(cTCols, l + 1L);
    }

    private boolean columnExists1Based(CTCols cTCols, long l) {
        for (CTCol cTCol : cTCols.getColArray()) {
            if (cTCol.getMin() != l) continue;
            return true;
        }
        return false;
    }

    public void setColumnAttributes(CTCol cTCol, CTCol cTCol2) {
        if (cTCol.isSetBestFit()) {
            cTCol2.setBestFit(cTCol.getBestFit());
        }
        if (cTCol.isSetCustomWidth()) {
            cTCol2.setCustomWidth(cTCol.getCustomWidth());
        }
        if (cTCol.isSetHidden()) {
            cTCol2.setHidden(cTCol.getHidden());
        }
        if (cTCol.isSetStyle()) {
            cTCol2.setStyle(cTCol.getStyle());
        }
        if (cTCol.isSetWidth()) {
            cTCol2.setWidth(cTCol.getWidth());
        }
        if (cTCol.isSetCollapsed()) {
            cTCol2.setCollapsed(cTCol.getCollapsed());
        }
        if (cTCol.isSetPhonetic()) {
            cTCol2.setPhonetic(cTCol.getPhonetic());
        }
        if (cTCol.isSetOutlineLevel()) {
            cTCol2.setOutlineLevel(cTCol.getOutlineLevel());
        }
        cTCol2.setCollapsed(cTCol.isSetCollapsed());
    }

    public void setColBestFit(long l, boolean bl) {
        CTCol cTCol = this.getOrCreateColumn1Based(l + 1L, false);
        cTCol.setBestFit(bl);
    }

    public void setCustomWidth(long l, boolean bl) {
        CTCol cTCol = this.getOrCreateColumn1Based(l + 1L, true);
        cTCol.setCustomWidth(bl);
    }

    public void setColWidth(long l, double d) {
        CTCol cTCol = this.getOrCreateColumn1Based(l + 1L, true);
        cTCol.setWidth(d);
    }

    public void setColHidden(long l, boolean bl) {
        CTCol cTCol = this.getOrCreateColumn1Based(l + 1L, true);
        cTCol.setHidden(bl);
    }

    protected CTCol getOrCreateColumn1Based(long l, boolean bl) {
        CTCol cTCol = this.getColumn1Based(l, bl);
        if (cTCol == null) {
            cTCol = this.worksheet.getColsArray(0).addNewCol();
            cTCol.setMin(l);
            cTCol.setMax(l);
        }
        return cTCol;
    }

    public void setColDefaultStyle(long l, CellStyle cellStyle) {
        this.setColDefaultStyle(l, cellStyle.getIndex());
    }

    public void setColDefaultStyle(long l, int n) {
        CTCol cTCol = this.getOrCreateColumn1Based(l + 1L, true);
        cTCol.setStyle((long)n);
    }

    public int getColDefaultStyle(long l) {
        if (this.getColumn(l, false) != null) {
            return (int)this.getColumn(l, false).getStyle();
        }
        return -1;
    }

    private boolean columnExists(CTCols cTCols, long l, long l2) {
        for (CTCol cTCol : cTCols.getColArray()) {
            if (cTCol.getMin() != l || cTCol.getMax() != l2) continue;
            return true;
        }
        return false;
    }

    public int getIndexOfColumn(CTCols cTCols, CTCol cTCol) {
        int n = 0;
        for (CTCol cTCol2 : cTCols.getColArray()) {
            if (cTCol2.getMin() == cTCol.getMin() && cTCol2.getMax() == cTCol.getMax()) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

