/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.charts;

import ai2.org.apache.poi.ss.usermodel.charts.LayoutMode;
import ai2.org.apache.poi.ss.usermodel.charts.LayoutTarget;
import ai2.org.apache.poi.ss.usermodel.charts.ManualLayout;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.usermodel.XSSFChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLayout;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLayoutMode;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLayoutTarget;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTManualLayout;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.STLayoutMode;
import org.openxmlformats.schemas.drawingml.x2006.chart.STLayoutTarget;

public final class XSSFManualLayout
implements ManualLayout {
    private CTManualLayout layout;
    private static final LayoutMode defaultLayoutMode = LayoutMode.EDGE;
    private static final LayoutTarget defaultLayoutTarget = LayoutTarget.INNER;

    public XSSFManualLayout(CTLayout cTLayout) {
        this.initLayout(cTLayout);
    }

    public XSSFManualLayout(XSSFChart xSSFChart) {
        CTPlotArea cTPlotArea = xSSFChart.getCTChart().getPlotArea();
        CTLayout cTLayout = cTPlotArea.isSetLayout() ? cTPlotArea.getLayout() : cTPlotArea.addNewLayout();
        this.initLayout(cTLayout);
    }

    @Internal
    public CTManualLayout getCTManualLayout() {
        return this.layout;
    }

    public void setWidthRatio(double d) {
        if (!this.layout.isSetW()) {
            this.layout.addNewW();
        }
        this.layout.getW().setVal(d);
    }

    public double getWidthRatio() {
        if (!this.layout.isSetW()) {
            return 0.0;
        }
        return this.layout.getW().getVal();
    }

    public void setHeightRatio(double d) {
        if (!this.layout.isSetH()) {
            this.layout.addNewH();
        }
        this.layout.getH().setVal(d);
    }

    public double getHeightRatio() {
        if (!this.layout.isSetH()) {
            return 0.0;
        }
        return this.layout.getH().getVal();
    }

    public LayoutTarget getTarget() {
        if (!this.layout.isSetLayoutTarget()) {
            return defaultLayoutTarget;
        }
        return this.toLayoutTarget(this.layout.getLayoutTarget());
    }

    public void setTarget(LayoutTarget layoutTarget) {
        if (!this.layout.isSetLayoutTarget()) {
            this.layout.addNewLayoutTarget();
        }
        this.layout.getLayoutTarget().setVal(this.fromLayoutTarget(layoutTarget));
    }

    public LayoutMode getXMode() {
        if (!this.layout.isSetXMode()) {
            return defaultLayoutMode;
        }
        return this.toLayoutMode(this.layout.getXMode());
    }

    public void setXMode(LayoutMode layoutMode) {
        if (!this.layout.isSetXMode()) {
            this.layout.addNewXMode();
        }
        this.layout.getXMode().setVal(this.fromLayoutMode(layoutMode));
    }

    public LayoutMode getYMode() {
        if (!this.layout.isSetYMode()) {
            return defaultLayoutMode;
        }
        return this.toLayoutMode(this.layout.getYMode());
    }

    public void setYMode(LayoutMode layoutMode) {
        if (!this.layout.isSetYMode()) {
            this.layout.addNewYMode();
        }
        this.layout.getYMode().setVal(this.fromLayoutMode(layoutMode));
    }

    public double getX() {
        if (!this.layout.isSetX()) {
            return 0.0;
        }
        return this.layout.getX().getVal();
    }

    public void setX(double d) {
        if (!this.layout.isSetX()) {
            this.layout.addNewX();
        }
        this.layout.getX().setVal(d);
    }

    public double getY() {
        if (!this.layout.isSetY()) {
            return 0.0;
        }
        return this.layout.getY().getVal();
    }

    public void setY(double d) {
        if (!this.layout.isSetY()) {
            this.layout.addNewY();
        }
        this.layout.getY().setVal(d);
    }

    public LayoutMode getWidthMode() {
        if (!this.layout.isSetWMode()) {
            return defaultLayoutMode;
        }
        return this.toLayoutMode(this.layout.getWMode());
    }

    public void setWidthMode(LayoutMode layoutMode) {
        if (!this.layout.isSetWMode()) {
            this.layout.addNewWMode();
        }
        this.layout.getWMode().setVal(this.fromLayoutMode(layoutMode));
    }

    public LayoutMode getHeightMode() {
        if (!this.layout.isSetHMode()) {
            return defaultLayoutMode;
        }
        return this.toLayoutMode(this.layout.getHMode());
    }

    public void setHeightMode(LayoutMode layoutMode) {
        if (!this.layout.isSetHMode()) {
            this.layout.addNewHMode();
        }
        this.layout.getHMode().setVal(this.fromLayoutMode(layoutMode));
    }

    private void initLayout(CTLayout cTLayout) {
        this.layout = cTLayout.isSetManualLayout() ? cTLayout.getManualLayout() : cTLayout.addNewManualLayout();
    }

    private STLayoutMode.Enum fromLayoutMode(LayoutMode layoutMode) {
        switch (layoutMode) {
            case EDGE: {
                return STLayoutMode.EDGE;
            }
            case FACTOR: {
                return STLayoutMode.FACTOR;
            }
        }
        throw new IllegalArgumentException();
    }

    private LayoutMode toLayoutMode(CTLayoutMode cTLayoutMode) {
        switch (cTLayoutMode.getVal().intValue()) {
            case 1: {
                return LayoutMode.EDGE;
            }
            case 2: {
                return LayoutMode.FACTOR;
            }
        }
        throw new IllegalArgumentException();
    }

    private STLayoutTarget.Enum fromLayoutTarget(LayoutTarget layoutTarget) {
        switch (layoutTarget) {
            case INNER: {
                return STLayoutTarget.INNER;
            }
            case OUTER: {
                return STLayoutTarget.OUTER;
            }
        }
        throw new IllegalArgumentException();
    }

    private LayoutTarget toLayoutTarget(CTLayoutTarget cTLayoutTarget) {
        switch (cTLayoutTarget.getVal().intValue()) {
            case 1: {
                return LayoutTarget.INNER;
            }
            case 2: {
                return LayoutTarget.OUTER;
            }
        }
        throw new IllegalArgumentException();
    }
}

