/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.charts;

import ai2.org.apache.poi.ss.usermodel.Chart;
import ai2.org.apache.poi.ss.usermodel.charts.ChartAxis;
import ai2.org.apache.poi.ss.usermodel.charts.ChartDataSource;
import ai2.org.apache.poi.ss.usermodel.charts.LineChartData;
import ai2.org.apache.poi.ss.usermodel.charts.LineChartSeries;
import ai2.org.apache.poi.xssf.usermodel.XSSFChart;
import ai2.org.apache.poi.xssf.usermodel.charts.AbstractXSSFChartSeries;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFChartUtil;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.STMarkerStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFLineChartData
implements LineChartData {
    private List<Series> series = new ArrayList<Series>();

    @Override
    public LineChartSeries addSeries(ChartDataSource<?> chartDataSource, ChartDataSource<? extends Number> chartDataSource2) {
        if (!chartDataSource2.isNumeric()) {
            throw new IllegalArgumentException("Value data source must be numeric.");
        }
        int n = this.series.size();
        Series series = new Series(n, n, chartDataSource, chartDataSource2);
        this.series.add(series);
        return series;
    }

    @Override
    public List<? extends LineChartSeries> getSeries() {
        return this.series;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... chartAxisArray) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        XSSFChart xSSFChart = (XSSFChart)chart;
        CTPlotArea cTPlotArea = xSSFChart.getCTChart().getPlotArea();
        CTLineChart cTLineChart = cTPlotArea.addNewLineChart();
        cTLineChart.addNewVaryColors().setVal(false);
        for (Series series : this.series) {
            series.addToChart(cTLineChart);
        }
        for (ChartAxis chartAxis : chartAxisArray) {
            cTLineChart.addNewAxId().setVal(chartAxis.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Series
    extends AbstractXSSFChartSeries
    implements LineChartSeries {
        private int id;
        private int order;
        private ChartDataSource<?> categories;
        private ChartDataSource<? extends Number> values;

        protected Series(int n, int n2, ChartDataSource<?> chartDataSource, ChartDataSource<? extends Number> chartDataSource2) {
            this.id = n;
            this.order = n2;
            this.categories = chartDataSource;
            this.values = chartDataSource2;
        }

        @Override
        public ChartDataSource<?> getCategoryAxisData() {
            return this.categories;
        }

        @Override
        public ChartDataSource<? extends Number> getValues() {
            return this.values;
        }

        protected void addToChart(CTLineChart cTLineChart) {
            CTLineSer cTLineSer = cTLineChart.addNewSer();
            cTLineSer.addNewIdx().setVal((long)this.id);
            cTLineSer.addNewOrder().setVal((long)this.order);
            cTLineSer.addNewMarker().addNewSymbol().setVal(STMarkerStyle.NONE);
            CTAxDataSource cTAxDataSource = cTLineSer.addNewCat();
            XSSFChartUtil.buildAxDataSource(cTAxDataSource, this.categories);
            CTNumDataSource cTNumDataSource = cTLineSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(cTNumDataSource, this.values);
            if (this.isTitleSet()) {
                cTLineSer.setTx(this.getCTSerTx());
            }
        }
    }
}

