/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.charts;

import ai2.org.apache.poi.ss.usermodel.charts.AxisCrosses;
import ai2.org.apache.poi.ss.usermodel.charts.AxisOrientation;
import ai2.org.apache.poi.ss.usermodel.charts.AxisPosition;
import ai2.org.apache.poi.ss.usermodel.charts.AxisTickMark;
import ai2.org.apache.poi.ss.usermodel.charts.ChartAxis;
import ai2.org.apache.poi.xssf.usermodel.XSSFChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCrosses;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLogBase;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumFmt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTOrientation;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScaling;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTickMark;
import org.openxmlformats.schemas.drawingml.x2006.chart.STAxPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.STCrosses;
import org.openxmlformats.schemas.drawingml.x2006.chart.STOrientation;
import org.openxmlformats.schemas.drawingml.x2006.chart.STTickMark;

public abstract class XSSFChartAxis
implements ChartAxis {
    protected XSSFChart chart;
    private static final double MIN_LOG_BASE = 2.0;
    private static final double MAX_LOG_BASE = 1000.0;

    protected XSSFChartAxis(XSSFChart xSSFChart) {
        this.chart = xSSFChart;
    }

    public AxisPosition getPosition() {
        return XSSFChartAxis.toAxisPosition(this.getCTAxPos());
    }

    public void setPosition(AxisPosition axisPosition) {
        this.getCTAxPos().setVal(XSSFChartAxis.fromAxisPosition(axisPosition));
    }

    public void setNumberFormat(String string) {
        this.getCTNumFmt().setFormatCode(string);
        this.getCTNumFmt().setSourceLinked(true);
    }

    public String getNumberFormat() {
        return this.getCTNumFmt().getFormatCode();
    }

    public boolean isSetLogBase() {
        return this.getCTScaling().isSetLogBase();
    }

    public void setLogBase(double d) {
        if (d < 2.0 || 1000.0 < d) {
            throw new IllegalArgumentException("Axis log base must be between 2 and 1000 (inclusive), got: " + d);
        }
        CTScaling cTScaling = this.getCTScaling();
        if (cTScaling.isSetLogBase()) {
            cTScaling.getLogBase().setVal(d);
        } else {
            cTScaling.addNewLogBase().setVal(d);
        }
    }

    public double getLogBase() {
        CTLogBase cTLogBase = this.getCTScaling().getLogBase();
        if (cTLogBase != null) {
            return cTLogBase.getVal();
        }
        return 0.0;
    }

    public boolean isSetMinimum() {
        return this.getCTScaling().isSetMin();
    }

    public void setMinimum(double d) {
        CTScaling cTScaling = this.getCTScaling();
        if (cTScaling.isSetMin()) {
            cTScaling.getMin().setVal(d);
        } else {
            cTScaling.addNewMin().setVal(d);
        }
    }

    public double getMinimum() {
        CTScaling cTScaling = this.getCTScaling();
        if (cTScaling.isSetMin()) {
            return cTScaling.getMin().getVal();
        }
        return 0.0;
    }

    public boolean isSetMaximum() {
        return this.getCTScaling().isSetMax();
    }

    public void setMaximum(double d) {
        CTScaling cTScaling = this.getCTScaling();
        if (cTScaling.isSetMax()) {
            cTScaling.getMax().setVal(d);
        } else {
            cTScaling.addNewMax().setVal(d);
        }
    }

    public double getMaximum() {
        CTScaling cTScaling = this.getCTScaling();
        if (cTScaling.isSetMax()) {
            return cTScaling.getMax().getVal();
        }
        return 0.0;
    }

    public AxisOrientation getOrientation() {
        return XSSFChartAxis.toAxisOrientation(this.getCTScaling().getOrientation());
    }

    public void setOrientation(AxisOrientation axisOrientation) {
        CTScaling cTScaling = this.getCTScaling();
        STOrientation.Enum enum_ = XSSFChartAxis.fromAxisOrientation(axisOrientation);
        if (cTScaling.isSetOrientation()) {
            cTScaling.getOrientation().setVal(enum_);
        } else {
            this.getCTScaling().addNewOrientation().setVal(enum_);
        }
    }

    public AxisCrosses getCrosses() {
        return XSSFChartAxis.toAxisCrosses(this.getCTCrosses());
    }

    public void setCrosses(AxisCrosses axisCrosses) {
        this.getCTCrosses().setVal(XSSFChartAxis.fromAxisCrosses(axisCrosses));
    }

    public boolean isVisible() {
        return !this.getDelete().getVal();
    }

    public void setVisible(boolean bl) {
        this.getDelete().setVal(!bl);
    }

    public AxisTickMark getMajorTickMark() {
        return XSSFChartAxis.toAxisTickMark(this.getMajorCTTickMark());
    }

    public void setMajorTickMark(AxisTickMark axisTickMark) {
        this.getMajorCTTickMark().setVal(XSSFChartAxis.fromAxisTickMark(axisTickMark));
    }

    public AxisTickMark getMinorTickMark() {
        return XSSFChartAxis.toAxisTickMark(this.getMinorCTTickMark());
    }

    public void setMinorTickMark(AxisTickMark axisTickMark) {
        this.getMinorCTTickMark().setVal(XSSFChartAxis.fromAxisTickMark(axisTickMark));
    }

    protected abstract CTAxPos getCTAxPos();

    protected abstract CTNumFmt getCTNumFmt();

    protected abstract CTScaling getCTScaling();

    protected abstract CTCrosses getCTCrosses();

    protected abstract CTBoolean getDelete();

    protected abstract CTTickMark getMajorCTTickMark();

    protected abstract CTTickMark getMinorCTTickMark();

    private static STOrientation.Enum fromAxisOrientation(AxisOrientation axisOrientation) {
        switch (axisOrientation) {
            case MIN_MAX: {
                return STOrientation.MIN_MAX;
            }
            case MAX_MIN: {
                return STOrientation.MAX_MIN;
            }
        }
        throw new IllegalArgumentException();
    }

    private static AxisOrientation toAxisOrientation(CTOrientation cTOrientation) {
        switch (cTOrientation.getVal().intValue()) {
            case 2: {
                return AxisOrientation.MIN_MAX;
            }
            case 1: {
                return AxisOrientation.MAX_MIN;
            }
        }
        throw new IllegalArgumentException();
    }

    private static STCrosses.Enum fromAxisCrosses(AxisCrosses axisCrosses) {
        switch (axisCrosses) {
            case AUTO_ZERO: {
                return STCrosses.AUTO_ZERO;
            }
            case MIN: {
                return STCrosses.MIN;
            }
            case MAX: {
                return STCrosses.MAX;
            }
        }
        throw new IllegalArgumentException();
    }

    private static AxisCrosses toAxisCrosses(CTCrosses cTCrosses) {
        switch (cTCrosses.getVal().intValue()) {
            case 1: {
                return AxisCrosses.AUTO_ZERO;
            }
            case 2: {
                return AxisCrosses.MAX;
            }
            case 3: {
                return AxisCrosses.MIN;
            }
        }
        throw new IllegalArgumentException();
    }

    private static STAxPos.Enum fromAxisPosition(AxisPosition axisPosition) {
        switch (axisPosition) {
            case BOTTOM: {
                return STAxPos.B;
            }
            case LEFT: {
                return STAxPos.L;
            }
            case RIGHT: {
                return STAxPos.R;
            }
            case TOP: {
                return STAxPos.T;
            }
        }
        throw new IllegalArgumentException();
    }

    private static AxisPosition toAxisPosition(CTAxPos cTAxPos) {
        switch (cTAxPos.getVal().intValue()) {
            case 1: {
                return AxisPosition.BOTTOM;
            }
            case 2: {
                return AxisPosition.LEFT;
            }
            case 3: {
                return AxisPosition.RIGHT;
            }
            case 4: {
                return AxisPosition.TOP;
            }
        }
        return AxisPosition.BOTTOM;
    }

    private static STTickMark.Enum fromAxisTickMark(AxisTickMark axisTickMark) {
        switch (axisTickMark) {
            case NONE: {
                return STTickMark.NONE;
            }
            case IN: {
                return STTickMark.IN;
            }
            case OUT: {
                return STTickMark.OUT;
            }
            case CROSS: {
                return STTickMark.CROSS;
            }
        }
        throw new IllegalArgumentException("Unknown AxisTickMark: " + (Object)((Object)axisTickMark));
    }

    private static AxisTickMark toAxisTickMark(CTTickMark cTTickMark) {
        switch (cTTickMark.getVal().intValue()) {
            case 3: {
                return AxisTickMark.NONE;
            }
            case 2: {
                return AxisTickMark.IN;
            }
            case 4: {
                return AxisTickMark.OUT;
            }
            case 1: {
                return AxisTickMark.CROSS;
            }
        }
        return AxisTickMark.CROSS;
    }
}

