/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.charts;

import ai2.org.apache.poi.ss.usermodel.charts.ChartSeries;
import ai2.org.apache.poi.ss.usermodel.charts.TitleType;
import ai2.org.apache.poi.ss.util.CellReference;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;

public abstract class AbstractXSSFChartSeries
implements ChartSeries {
    private String titleValue;
    private CellReference titleRef;
    private TitleType titleType;

    public void setTitle(CellReference cellReference) {
        this.titleType = TitleType.CELL_REFERENCE;
        this.titleRef = cellReference;
    }

    public void setTitle(String string) {
        this.titleType = TitleType.STRING;
        this.titleValue = string;
    }

    public CellReference getTitleCellReference() {
        if (TitleType.CELL_REFERENCE.equals((Object)this.titleType)) {
            return this.titleRef;
        }
        throw new IllegalStateException("Title type is not CellReference.");
    }

    public String getTitleString() {
        if (TitleType.STRING.equals((Object)this.titleType)) {
            return this.titleValue;
        }
        throw new IllegalStateException("Title type is not String.");
    }

    public TitleType getTitleType() {
        return this.titleType;
    }

    protected boolean isTitleSet() {
        return this.titleType != null;
    }

    protected CTSerTx getCTSerTx() {
        CTSerTx cTSerTx = CTSerTx.Factory.newInstance();
        switch (this.titleType) {
            case CELL_REFERENCE: {
                cTSerTx.addNewStrRef().setF(this.titleRef.formatAsString());
                return cTSerTx;
            }
            case STRING: {
                cTSerTx.setV(this.titleValue);
                return cTSerTx;
            }
        }
        throw new IllegalStateException("Unkown title type: " + (Object)((Object)this.titleType));
    }
}

