/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocument;
import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.POIXMLProperties;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackageAccess;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.ss.formula.SheetNameFormatter;
import ai2.org.apache.poi.ss.formula.udf.IndexedUDFFinder;
import ai2.org.apache.poi.ss.formula.udf.UDFFinder;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.usermodel.Sheet;
import ai2.org.apache.poi.ss.usermodel.Workbook;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.ss.util.WorkbookUtil;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.PackageHelper;
import ai2.org.apache.poi.xssf.XLSBUnsupportedException;
import ai2.org.apache.poi.xssf.model.CalculationChain;
import ai2.org.apache.poi.xssf.model.ExternalLinksTable;
import ai2.org.apache.poi.xssf.model.MapInfo;
import ai2.org.apache.poi.xssf.model.SharedStringsTable;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.model.ThemesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import ai2.org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataFormat;
import ai2.org.apache.poi.xssf.usermodel.XSSFDialogsheet;
import ai2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFFactory;
import ai2.org.apache.poi.xssf.usermodel.XSSFFont;
import ai2.org.apache.poi.xssf.usermodel.XSSFMap;
import ai2.org.apache.poi.xssf.usermodel.XSSFName;
import ai2.org.apache.poi.xssf.usermodel.XSSFPictureData;
import ai2.org.apache.poi.xssf.usermodel.XSSFPivotTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbookType;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFFormulaUtils;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFPaswordHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBookView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBookViews;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCalcPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDefinedName;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDefinedNames;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDialogsheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalReference;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotCache;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotCaches;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheets;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbookPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbookProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCalcMode;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STSheetState;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorkbookDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFWorkbook
extends POIXMLDocument
implements Workbook {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    public static final float DEFAULT_CHARACTER_WIDTH = 7.0017f;
    private static final int MAX_SENSITIVE_SHEET_NAME_LEN = 31;
    public static final int PICTURE_TYPE_GIF = 8;
    public static final int PICTURE_TYPE_TIFF = 9;
    public static final int PICTURE_TYPE_EPS = 10;
    public static final int PICTURE_TYPE_BMP = 11;
    public static final int PICTURE_TYPE_WPG = 12;
    private CTWorkbook workbook;
    private List<XSSFSheet> sheets;
    private List<XSSFName> namedRanges;
    private SharedStringsTable sharedStringSource;
    private StylesTable stylesSource;
    private IndexedUDFFinder _udfFinder = new IndexedUDFFinder(UDFFinder.DEFAULT);
    private CalculationChain calcChain;
    private List<ExternalLinksTable> externalLinks;
    private MapInfo mapInfo;
    private XSSFDataFormat formatter;
    private Row.MissingCellPolicy _missingCellPolicy = Row.RETURN_NULL_AND_BLANK;
    private List<XSSFPictureData> pictures;
    private static POILogger logger = POILogFactory.getLogger(XSSFWorkbook.class);
    private XSSFCreationHelper _creationHelper;
    private List<XSSFPivotTable> pivotTables;
    private List<CTPivotCache> pivotCaches;

    public XSSFWorkbook() {
        this(XSSFWorkbookType.XLSX);
    }

    public XSSFWorkbook(XSSFWorkbookType xSSFWorkbookType) {
        super(XSSFWorkbook.newPackage(xSSFWorkbookType));
        this.onWorkbookCreate();
    }

    public XSSFWorkbook(OPCPackage oPCPackage) throws IOException {
        super(oPCPackage);
        this.beforeDocumentRead();
        this.load(XSSFFactory.getInstance());
        if (!this.workbook.isSetBookViews()) {
            CTBookViews cTBookViews = this.workbook.addNewBookViews();
            CTBookView cTBookView = cTBookViews.addNewWorkbookView();
            cTBookView.setActiveTab(0L);
        }
    }

    public XSSFWorkbook(InputStream inputStream) throws IOException {
        super(PackageHelper.open(inputStream));
        this.beforeDocumentRead();
        this.load(XSSFFactory.getInstance());
        if (!this.workbook.isSetBookViews()) {
            CTBookViews cTBookViews = this.workbook.addNewBookViews();
            CTBookView cTBookView = cTBookViews.addNewWorkbookView();
            cTBookView.setActiveTab(0L);
        }
    }

    public XSSFWorkbook(File file) throws IOException, InvalidFormatException {
        this(OPCPackage.open(file));
    }

    public XSSFWorkbook(String string) throws IOException {
        this(XSSFWorkbook.openPackage(string));
    }

    protected void beforeDocumentRead() {
        if (this.getCorePart().getContentType().equals(XSSFRelation.XLSB_BINARY_WORKBOOK.getContentType())) {
            throw new XLSBUnsupportedException();
        }
        this.pivotTables = new ArrayList<XSSFPivotTable>();
        this.pivotCaches = new ArrayList<CTPivotCache>();
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            boolean bl;
            WorkbookDocument workbookDocument = WorkbookDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
            this.workbook = workbookDocument.getWorkbook();
            ThemesTable themesTable = null;
            HashMap<String, XSSFSheet> hashMap = new HashMap<String, XSSFSheet>();
            HashMap<String, ExternalLinksTable> hashMap2 = new HashMap<String, ExternalLinksTable>();
            for (POIXMLDocumentPart cTSheetArray : this.getRelations()) {
                if (cTSheetArray instanceof SharedStringsTable) {
                    this.sharedStringSource = (SharedStringsTable)cTSheetArray;
                    continue;
                }
                if (cTSheetArray instanceof StylesTable) {
                    this.stylesSource = (StylesTable)cTSheetArray;
                    continue;
                }
                if (cTSheetArray instanceof ThemesTable) {
                    themesTable = (ThemesTable)cTSheetArray;
                    continue;
                }
                if (cTSheetArray instanceof CalculationChain) {
                    this.calcChain = (CalculationChain)cTSheetArray;
                    continue;
                }
                if (cTSheetArray instanceof MapInfo) {
                    this.mapInfo = (MapInfo)cTSheetArray;
                    continue;
                }
                if (cTSheetArray instanceof XSSFSheet) {
                    hashMap.put(cTSheetArray.getPackageRelationship().getId(), (XSSFSheet)cTSheetArray);
                    continue;
                }
                if (!(cTSheetArray instanceof ExternalLinksTable)) continue;
                hashMap2.put(cTSheetArray.getPackageRelationship().getId(), (ExternalLinksTable)cTSheetArray);
            }
            boolean bl2 = bl = this.getPackage().getPackageAccess() == PackageAccess.READ;
            if (this.stylesSource == null) {
                this.stylesSource = bl ? new StylesTable() : (StylesTable)this.createRelationship(XSSFRelation.STYLES, XSSFFactory.getInstance());
            }
            this.stylesSource.setWorkbook(this);
            this.stylesSource.setTheme(themesTable);
            if (this.sharedStringSource == null) {
                this.sharedStringSource = bl ? new SharedStringsTable() : (SharedStringsTable)this.createRelationship(XSSFRelation.SHARED_STRINGS, XSSFFactory.getInstance());
            }
            this.sheets = new ArrayList<XSSFSheet>(hashMap.size());
            for (CTSheet cTSheet : this.workbook.getSheets().getSheetArray()) {
                this.parseSheet(hashMap, cTSheet);
            }
            this.externalLinks = new ArrayList<ExternalLinksTable>(hashMap2.size());
            if (this.workbook.isSetExternalReferences()) {
                for (CTExternalReference cTExternalReference : this.workbook.getExternalReferences().getExternalReferenceArray()) {
                    ExternalLinksTable externalLinksTable = (ExternalLinksTable)hashMap2.get(cTExternalReference.getId());
                    if (externalLinksTable == null) {
                        logger.log(5, new Object[]{"ExternalLinksTable with r:id " + cTExternalReference.getId() + " was defined, but didn't exist in package, skipping"});
                        continue;
                    }
                    this.externalLinks.add(externalLinksTable);
                }
            }
            this.reprocessNamedRanges();
        }
        catch (XmlException xmlException) {
            throw new POIXMLException(xmlException);
        }
    }

    public void parseSheet(Map<String, XSSFSheet> map, CTSheet cTSheet) {
        XSSFSheet xSSFSheet = map.get(cTSheet.getId());
        if (xSSFSheet == null) {
            logger.log(5, new Object[]{"Sheet with name " + cTSheet.getName() + " and r:id " + cTSheet.getId() + " was defined, but didn't exist in package, skipping"});
            return;
        }
        xSSFSheet.sheet = cTSheet;
        xSSFSheet.onDocumentRead();
        this.sheets.add(xSSFSheet);
    }

    private void onWorkbookCreate() {
        this.workbook = CTWorkbook.Factory.newInstance();
        CTWorkbookPr cTWorkbookPr = this.workbook.addNewWorkbookPr();
        cTWorkbookPr.setDate1904(false);
        CTBookViews cTBookViews = this.workbook.addNewBookViews();
        CTBookView cTBookView = cTBookViews.addNewWorkbookView();
        cTBookView.setActiveTab(0L);
        this.workbook.addNewSheets();
        POIXMLProperties.ExtendedProperties extendedProperties = this.getProperties().getExtendedProperties();
        extendedProperties.getUnderlyingProperties().setApplication("Apache POI");
        this.sharedStringSource = (SharedStringsTable)this.createRelationship(XSSFRelation.SHARED_STRINGS, XSSFFactory.getInstance());
        this.stylesSource = (StylesTable)this.createRelationship(XSSFRelation.STYLES, XSSFFactory.getInstance());
        this.stylesSource.setWorkbook(this);
        this.namedRanges = new ArrayList<XSSFName>();
        this.sheets = new ArrayList<XSSFSheet>();
        this.pivotTables = new ArrayList<XSSFPivotTable>();
    }

    protected static OPCPackage newPackage(XSSFWorkbookType xSSFWorkbookType) {
        try {
            OPCPackage oPCPackage = OPCPackage.create(new ByteArrayOutputStream());
            PackagePartName packagePartName = PackagingURIHelper.createPartName(XSSFRelation.WORKBOOK.getDefaultFileName());
            oPCPackage.addRelationship(packagePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            oPCPackage.createPart(packagePartName, xSSFWorkbookType.getContentType());
            oPCPackage.getPackageProperties().setCreatorProperty("Apache POI");
            return oPCPackage;
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }

    @Internal
    public CTWorkbook getCTWorkbook() {
        return this.workbook;
    }

    @Override
    public int addPicture(byte[] byArray, int n) {
        int n2 = this.getAllPictures().size() + 1;
        XSSFPictureData xSSFPictureData = (XSSFPictureData)this.createRelationship(XSSFPictureData.RELATIONS[n], XSSFFactory.getInstance(), n2, true);
        try {
            OutputStream outputStream = xSSFPictureData.getPackagePart().getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new POIXMLException(iOException);
        }
        this.pictures.add(xSSFPictureData);
        return n2 - 1;
    }

    public int addPicture(InputStream inputStream, int n) throws IOException {
        int n2 = this.getAllPictures().size() + 1;
        XSSFPictureData xSSFPictureData = (XSSFPictureData)this.createRelationship(XSSFPictureData.RELATIONS[n], XSSFFactory.getInstance(), n2, true);
        OutputStream outputStream = xSSFPictureData.getPackagePart().getOutputStream();
        IOUtils.copy(inputStream, outputStream);
        outputStream.close();
        this.pictures.add(xSSFPictureData);
        return n2 - 1;
    }

    @Override
    public XSSFSheet cloneSheet(int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        this.validateSheetIndex(n);
        XSSFSheet xSSFSheet = this.sheets.get(n);
        String string = xSSFSheet.getSheetName();
        String string2 = this.getUniqueSheetName(string);
        XSSFSheet xSSFSheet2 = this.createSheet(string2);
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            xSSFSheet.write(byteArrayOutputStream);
            xSSFSheet2.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            throw new POIXMLException("Failed to clone sheet", iOException);
        }
        byteArrayOutputStream = xSSFSheet2.getCTWorksheet();
        if (byteArrayOutputStream.isSetLegacyDrawing()) {
            logger.log(5, new Object[]{"Cloning sheets with comments is not yet supported."});
            byteArrayOutputStream.unsetLegacyDrawing();
        }
        if (byteArrayOutputStream.isSetPageSetup()) {
            logger.log(5, new Object[]{"Cloning sheets with page setup is not yet supported."});
            byteArrayOutputStream.unsetPageSetup();
        }
        xSSFSheet2.setSelected(false);
        List<POIXMLDocumentPart> list = xSSFSheet.getRelations();
        XSSFDrawing xSSFDrawing = null;
        for (POIXMLDocumentPart object2 : list) {
            if (object2 instanceof XSSFDrawing) {
                xSSFDrawing = (XSSFDrawing)object2;
                continue;
            }
            PackageRelationship packageRelationship = object2.getPackageRelationship();
            xSSFSheet2.getPackagePart().addRelationship(packageRelationship.getTargetURI(), packageRelationship.getTargetMode(), packageRelationship.getRelationshipType());
            xSSFSheet2.addRelation(packageRelationship.getId(), object2);
        }
        if (xSSFDrawing != null) {
            if (byteArrayOutputStream.isSetDrawing()) {
                byteArrayOutputStream.unsetDrawing();
            }
            Object object3 = xSSFSheet2.createDrawingPatriarch();
            ((XSSFDrawing)object3).getCTDrawing().set((XmlObject)xSSFDrawing.getCTDrawing());
            object3 = xSSFSheet2.createDrawingPatriarch();
            List<POIXMLDocumentPart> list2 = xSSFSheet.createDrawingPatriarch().getRelations();
            for (POIXMLDocumentPart pOIXMLDocumentPart : list2) {
                PackageRelationship packageRelationship = pOIXMLDocumentPart.getPackageRelationship();
                ((POIXMLDocumentPart)object3).addRelation(packageRelationship.getId(), pOIXMLDocumentPart);
                ((POIXMLDocumentPart)object3).getPackagePart().addRelationship(packageRelationship.getTargetURI(), packageRelationship.getTargetMode(), packageRelationship.getRelationshipType(), packageRelationship.getId());
            }
        }
        return xSSFSheet2;
    }

    private String getUniqueSheetName(String string) {
        String string2;
        String string3;
        int n = 2;
        String string4 = string;
        int n2 = string.lastIndexOf(40);
        if (n2 > 0 && string.endsWith(")")) {
            string3 = string.substring(n2 + 1, string.length() - ")".length());
            try {
                n = Integer.parseInt(string3.trim());
                string4 = string.substring(0, n2).trim();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        do {
            int n3 = ++n;
            ++n;
            string3 = Integer.toString(n3);
        } while (this.getSheetIndex(string2 = string4.length() + string3.length() + 2 < 31 ? string4 + " (" + string3 + ")" : string4.substring(0, 31 - string3.length() - 2) + "(" + string3 + ")") != -1);
        return string2;
    }

    @Override
    public XSSFCellStyle createCellStyle() {
        return this.stylesSource.createCellStyle();
    }

    @Override
    public XSSFDataFormat createDataFormat() {
        if (this.formatter == null) {
            this.formatter = new XSSFDataFormat(this.stylesSource);
        }
        return this.formatter;
    }

    @Override
    public XSSFFont createFont() {
        XSSFFont xSSFFont = new XSSFFont();
        xSSFFont.registerTo(this.stylesSource);
        return xSSFFont;
    }

    @Override
    public XSSFName createName() {
        CTDefinedName cTDefinedName = CTDefinedName.Factory.newInstance();
        cTDefinedName.setName("");
        XSSFName xSSFName = new XSSFName(cTDefinedName, this);
        this.namedRanges.add(xSSFName);
        return xSSFName;
    }

    @Override
    public XSSFSheet createSheet() {
        String string = "Sheet" + this.sheets.size();
        int n = 0;
        while (this.getSheet(string) != null) {
            string = "Sheet" + n;
            ++n;
        }
        return this.createSheet(string);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public XSSFSheet createSheet(String var1_1) {
        if (var1_1 == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        if (this.containsSheet(var1_1, this.sheets.size())) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        if (var1_1.length() > 31) {
            var1_1 = var1_1.substring(0, 31);
        }
        WorkbookUtil.validateSheetName(var1_1);
        var2_2 = this.addSheet(var1_1);
        var3_3 = 1;
        block0: while (true) lbl-1000:
        // 3 sources

        {
            for (Object var5_5 : this.sheets) {
                var3_3 = (int)Math.max(var5_5.sheet.getSheetId() + 1L, (long)var3_3);
            }
            var4_4 = XSSFRelation.WORKSHEET.getFileName(var3_3);
            for (POIXMLDocumentPart var6_6 : this.getRelations()) {
                if (var6_6.getPackagePart() == null || !var4_4.equals(var6_6.getPackagePart().getPartName().getName())) continue;
                ++var3_3;
                continue block0;
                ** continue;
            }
            break;
        }
        var4_4 = (XSSFSheet)this.createRelationship(XSSFRelation.WORKSHEET, XSSFFactory.getInstance(), var3_3);
        var4_4.sheet = var2_2;
        var2_2.setId(var4_4.getPackageRelationship().getId());
        var2_2.setSheetId((long)var3_3);
        if (this.sheets.size() == 0) {
            var4_4.setSelected(true);
        }
        this.sheets.add((XSSFSheet)var4_4);
        return var4_4;
    }

    protected XSSFDialogsheet createDialogsheet(String string, CTDialogsheet cTDialogsheet) {
        XSSFSheet xSSFSheet = this.createSheet(string);
        return new XSSFDialogsheet(xSSFSheet);
    }

    private CTSheet addSheet(String string) {
        CTSheet cTSheet = this.workbook.getSheets().addNewSheet();
        cTSheet.setName(string);
        return cTSheet;
    }

    @Override
    public XSSFFont findFont(short s, short s2, short s3, String string, boolean bl, boolean bl2, short s4, byte by) {
        return this.stylesSource.findFont(s, s2, s3, string, bl, bl2, s4, by);
    }

    @Override
    public int getActiveSheetIndex() {
        return (int)this.workbook.getBookViews().getWorkbookViewArray(0).getActiveTab();
    }

    public List<XSSFPictureData> getAllPictures() {
        if (this.pictures == null) {
            List<PackagePart> list = this.getPackage().getPartsByName(Pattern.compile("/xl/media/.*?"));
            this.pictures = new ArrayList<XSSFPictureData>(list.size());
            for (PackagePart packagePart : list) {
                this.pictures.add(new XSSFPictureData(packagePart, null));
            }
        }
        return this.pictures;
    }

    @Override
    public XSSFCellStyle getCellStyleAt(short s) {
        return this.getCellStyleAt(s & 0xFFFF);
    }

    public XSSFCellStyle getCellStyleAt(int n) {
        return this.stylesSource.getStyleAt(n);
    }

    @Override
    public XSSFFont getFontAt(short s) {
        return this.stylesSource.getFontAt(s);
    }

    @Override
    public XSSFName getName(String string) {
        int n = this.getNameIndex(string);
        if (n < 0) {
            return null;
        }
        return this.namedRanges.get(n);
    }

    @Override
    public XSSFName getNameAt(int n) {
        int n2 = this.namedRanges.size();
        if (n2 < 1) {
            throw new IllegalStateException("There are no defined names in this workbook");
        }
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Specified name index " + n + " is outside the allowable range (0.." + (n2 - 1) + ").");
        }
        return this.namedRanges.get(n);
    }

    @Override
    public int getNameIndex(String string) {
        int n = 0;
        for (XSSFName xSSFName : this.namedRanges) {
            if (xSSFName.getNameName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public short getNumCellStyles() {
        return (short)this.stylesSource.getNumCellStyles();
    }

    @Override
    public short getNumberOfFonts() {
        return (short)this.stylesSource.getFonts().size();
    }

    @Override
    public int getNumberOfNames() {
        return this.namedRanges.size();
    }

    @Override
    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    @Override
    public String getPrintArea(int n) {
        XSSFName xSSFName = this.getBuiltInName("_xlnm.Print_Area", n);
        if (xSSFName == null) {
            return null;
        }
        return xSSFName.getRefersToFormula();
    }

    @Override
    public XSSFSheet getSheet(String string) {
        for (XSSFSheet xSSFSheet : this.sheets) {
            if (!string.equalsIgnoreCase(xSSFSheet.getSheetName())) continue;
            return xSSFSheet;
        }
        return null;
    }

    @Override
    public XSSFSheet getSheetAt(int n) {
        this.validateSheetIndex(n);
        return this.sheets.get(n);
    }

    @Override
    public int getSheetIndex(String string) {
        for (int i = 0; i < this.sheets.size(); ++i) {
            XSSFSheet xSSFSheet = this.sheets.get(i);
            if (!string.equalsIgnoreCase(xSSFSheet.getSheetName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        int n = 0;
        for (XSSFSheet xSSFSheet : this.sheets) {
            if (xSSFSheet == sheet) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public String getSheetName(int n) {
        this.validateSheetIndex(n);
        return this.sheets.get(n).getSheetName();
    }

    @Override
    public Iterator<Sheet> sheetIterator() {
        return new SheetIterator<Sheet>();
    }

    @Override
    public Iterator<Sheet> iterator() {
        return this.sheetIterator();
    }

    @Deprecated
    public Iterator<XSSFSheet> xssfSheetIterator() {
        return new SheetIterator<XSSFSheet>();
    }

    public boolean isMacroEnabled() {
        return this.getPackagePart().getContentType().equals(XSSFRelation.MACROS_WORKBOOK.getContentType());
    }

    @Override
    public void removeName(int n) {
        this.namedRanges.remove(n);
    }

    @Override
    public void removeName(String string) {
        for (int i = 0; i < this.namedRanges.size(); ++i) {
            XSSFName xSSFName = this.namedRanges.get(i);
            if (!xSSFName.getNameName().equalsIgnoreCase(string)) continue;
            this.removeName(i);
            return;
        }
        throw new IllegalArgumentException("Named range was not found: " + string);
    }

    void removeName(XSSFName xSSFName) {
        if (!this.namedRanges.remove(xSSFName)) {
            throw new IllegalArgumentException("Name was not found: " + xSSFName);
        }
    }

    @Override
    public void removePrintArea(int n) {
        int n2 = 0;
        for (XSSFName xSSFName : this.namedRanges) {
            if (xSSFName.getNameName().equals("_xlnm.Print_Area") && xSSFName.getSheetIndex() == n) {
                this.namedRanges.remove(n2);
                break;
            }
            ++n2;
        }
    }

    @Override
    public void removeSheetAt(int n) {
        int n2;
        this.validateSheetIndex(n);
        this.onSheetDelete(n);
        XSSFSheet xSSFSheet = this.getSheetAt(n);
        this.removeRelation(xSSFSheet);
        this.sheets.remove(n);
        if (this.sheets.size() == 0) {
            return;
        }
        int n3 = n;
        if (n3 >= this.sheets.size()) {
            n3 = this.sheets.size() - 1;
        }
        if ((n2 = this.getActiveSheetIndex()) == n) {
            this.setActiveSheet(n3);
        } else if (n2 > n) {
            this.setActiveSheet(n2 - 1);
        }
    }

    private void onSheetDelete(int n) {
        this.workbook.getSheets().removeSheet(n);
        if (this.calcChain != null) {
            this.removeRelation(this.calcChain);
            this.calcChain = null;
        }
        Iterator<XSSFName> iterator = this.namedRanges.iterator();
        while (iterator.hasNext()) {
            XSSFName xSSFName = iterator.next();
            CTDefinedName cTDefinedName = xSSFName.getCTName();
            if (!cTDefinedName.isSetLocalSheetId()) continue;
            if (cTDefinedName.getLocalSheetId() == (long)n) {
                iterator.remove();
                continue;
            }
            if (cTDefinedName.getLocalSheetId() <= (long)n) continue;
            cTDefinedName.setLocalSheetId(cTDefinedName.getLocalSheetId() - 1L);
        }
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this._missingCellPolicy;
    }

    @Override
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        this._missingCellPolicy = missingCellPolicy;
    }

    @Override
    public void setActiveSheet(int n) {
        this.validateSheetIndex(n);
        for (CTBookView cTBookView : this.workbook.getBookViews().getWorkbookViewArray()) {
            cTBookView.setActiveTab((long)n);
        }
    }

    private void validateSheetIndex(int n) {
        int n2 = this.sheets.size() - 1;
        if (n < 0 || n > n2) {
            String string = "(0.." + n2 + ")";
            if (n2 == -1) {
                string = "(no sheets)";
            }
            throw new IllegalArgumentException("Sheet index (" + n + ") is out of range " + string);
        }
    }

    @Override
    public int getFirstVisibleTab() {
        CTBookViews cTBookViews = this.workbook.getBookViews();
        CTBookView cTBookView = cTBookViews.getWorkbookViewArray(0);
        return (short)cTBookView.getFirstSheet();
    }

    @Override
    public void setFirstVisibleTab(int n) {
        CTBookViews cTBookViews = this.workbook.getBookViews();
        CTBookView cTBookView = cTBookViews.getWorkbookViewArray(0);
        cTBookView.setFirstSheet((long)n);
    }

    @Override
    public void setPrintArea(int n, String string) {
        XSSFName xSSFName = this.getBuiltInName("_xlnm.Print_Area", n);
        if (xSSFName == null) {
            xSSFName = this.createBuiltInName("_xlnm.Print_Area", n);
        }
        String[] stringArray = COMMA_PATTERN.split(string);
        StringBuffer stringBuffer = new StringBuffer(32);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            SheetNameFormatter.appendFormat(stringBuffer, this.getSheetName(n));
            stringBuffer.append("!");
            stringBuffer.append(stringArray[i]);
        }
        xSSFName.setRefersToFormula(stringBuffer.toString());
    }

    @Override
    public void setPrintArea(int n, int n2, int n3, int n4, int n5) {
        String string = XSSFWorkbook.getReferencePrintArea(this.getSheetName(n), n2, n3, n4, n5);
        this.setPrintArea(n, string);
    }

    @Override
    @Deprecated
    public void setRepeatingRowsAndColumns(int n, int n2, int n3, int n4, int n5) {
        XSSFSheet xSSFSheet = this.getSheetAt(n);
        CellRangeAddress cellRangeAddress = null;
        CellRangeAddress cellRangeAddress2 = null;
        if (n4 != -1) {
            cellRangeAddress = new CellRangeAddress(n4, n5, -1, -1);
        }
        if (n2 != -1) {
            cellRangeAddress2 = new CellRangeAddress(-1, -1, n2, n3);
        }
        xSSFSheet.setRepeatingRows(cellRangeAddress);
        xSSFSheet.setRepeatingColumns(cellRangeAddress2);
    }

    private static String getReferencePrintArea(String string, int n, int n2, int n3, int n4) {
        CellReference cellReference = new CellReference(string, n3, n, true, true);
        CellReference cellReference2 = new CellReference(string, n4, n2, true, true);
        return "$" + cellReference.getCellRefParts()[2] + "$" + cellReference.getCellRefParts()[1] + ":$" + cellReference2.getCellRefParts()[2] + "$" + cellReference2.getCellRefParts()[1];
    }

    XSSFName getBuiltInName(String string, int n) {
        for (XSSFName xSSFName : this.namedRanges) {
            if (!xSSFName.getNameName().equalsIgnoreCase(string) || xSSFName.getSheetIndex() != n) continue;
            return xSSFName;
        }
        return null;
    }

    XSSFName createBuiltInName(String string, int n) {
        this.validateSheetIndex(n);
        CTDefinedNames cTDefinedNames = this.workbook.getDefinedNames() == null ? this.workbook.addNewDefinedNames() : this.workbook.getDefinedNames();
        CTDefinedName cTDefinedName = cTDefinedNames.addNewDefinedName();
        cTDefinedName.setName(string);
        cTDefinedName.setLocalSheetId((long)n);
        XSSFName xSSFName = new XSSFName(cTDefinedName, this);
        for (XSSFName xSSFName2 : this.namedRanges) {
            if (!xSSFName2.equals(xSSFName)) continue;
            throw new POIXMLException("Builtin (" + string + ") already exists for sheet (" + n + ")");
        }
        this.namedRanges.add(xSSFName);
        return xSSFName;
    }

    @Override
    public void setSelectedTab(int n) {
        for (int i = 0; i < this.sheets.size(); ++i) {
            XSSFSheet xSSFSheet = this.sheets.get(i);
            xSSFSheet.setSelected(i == n);
        }
    }

    @Override
    public void setSheetName(int n, String string) {
        this.validateSheetIndex(n);
        String string2 = this.getSheetName(n);
        if (string != null && string.length() > 31) {
            string = string.substring(0, 31);
        }
        WorkbookUtil.validateSheetName(string);
        assert (string != null);
        if (string.equals(string2)) {
            return;
        }
        if (this.containsSheet(string, n)) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        XSSFFormulaUtils xSSFFormulaUtils = new XSSFFormulaUtils(this);
        xSSFFormulaUtils.updateSheetName(n, string2, string);
        this.workbook.getSheets().getSheetArray(n).setName(string);
    }

    @Override
    public void setSheetOrder(String string, int n) {
        int n2;
        int n3 = this.getSheetIndex(string);
        this.sheets.add(n, this.sheets.remove(n3));
        CTSheets cTSheets = this.workbook.getSheets();
        XmlObject xmlObject = cTSheets.getSheetArray(n3).copy();
        this.workbook.getSheets().removeSheet(n3);
        CTSheet cTSheet = cTSheets.insertNewSheet(n);
        cTSheet.set(xmlObject);
        CTSheet[] cTSheetArray = cTSheets.getSheetArray();
        for (n2 = 0; n2 < cTSheetArray.length; ++n2) {
            this.sheets.get((int)n2).sheet = cTSheetArray[n2];
        }
        n2 = this.getActiveSheetIndex();
        if (n2 == n3) {
            this.setActiveSheet(n);
        } else if (!(n2 < n3 && n2 < n || n2 > n3 && n2 > n)) {
            if (n > n3) {
                this.setActiveSheet(n2 - 1);
            } else {
                this.setActiveSheet(n2 + 1);
            }
        }
    }

    private void saveNamedRanges() {
        if (this.namedRanges.size() > 0) {
            CTDefinedNames cTDefinedNames = CTDefinedNames.Factory.newInstance();
            CTDefinedName[] cTDefinedNameArray = new CTDefinedName[this.namedRanges.size()];
            int n = 0;
            for (XSSFName xSSFName : this.namedRanges) {
                cTDefinedNameArray[n] = xSSFName.getCTName();
                ++n;
            }
            cTDefinedNames.setDefinedNameArray(cTDefinedNameArray);
            if (this.workbook.isSetDefinedNames()) {
                this.workbook.unsetDefinedNames();
            }
            this.workbook.setDefinedNames(cTDefinedNames);
            this.reprocessNamedRanges();
        } else if (this.workbook.isSetDefinedNames()) {
            this.workbook.unsetDefinedNames();
        }
    }

    private void reprocessNamedRanges() {
        this.namedRanges = new ArrayList<XSSFName>();
        if (this.workbook.isSetDefinedNames()) {
            for (CTDefinedName cTDefinedName : this.workbook.getDefinedNames().getDefinedNameArray()) {
                this.namedRanges.add(new XSSFName(cTDefinedName, this));
            }
        }
    }

    private void saveCalculationChain() {
        int n;
        if (this.calcChain != null && (n = this.calcChain.getCTCalcChain().sizeOfCArray()) == 0) {
            this.removeRelation(this.calcChain);
            this.calcChain = null;
        }
    }

    @Override
    protected void commit() throws IOException {
        this.saveNamedRanges();
        this.saveCalculationChain();
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTWorkbook.type.getName().getNamespaceURI(), "workbook"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.workbook.save(outputStream, xmlOptions);
        outputStream.close();
    }

    @Internal
    public SharedStringsTable getSharedStringSource() {
        return this.sharedStringSource;
    }

    public StylesTable getStylesSource() {
        return this.stylesSource;
    }

    public ThemesTable getTheme() {
        if (this.stylesSource == null) {
            return null;
        }
        return this.stylesSource.getTheme();
    }

    @Override
    public XSSFCreationHelper getCreationHelper() {
        if (this._creationHelper == null) {
            this._creationHelper = new XSSFCreationHelper(this);
        }
        return this._creationHelper;
    }

    private boolean containsSheet(String string, int n) {
        CTSheet[] cTSheetArray = this.workbook.getSheets().getSheetArray();
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        for (int i = 0; i < cTSheetArray.length; ++i) {
            String string2 = cTSheetArray[i].getName();
            if (string2.length() > 31) {
                string2 = string2.substring(0, 31);
            }
            if (n == i || !string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    @Internal
    public boolean isDate1904() {
        CTWorkbookPr cTWorkbookPr = this.workbook.getWorkbookPr();
        return cTWorkbookPr != null && cTWorkbookPr.getDate1904();
    }

    @Override
    public List<PackagePart> getAllEmbedds() throws OpenXML4JException {
        LinkedList<PackagePart> linkedList = new LinkedList<PackagePart>();
        for (XSSFSheet xSSFSheet : this.sheets) {
            for (PackageRelationship packageRelationship : xSSFSheet.getPackagePart().getRelationshipsByType(XSSFRelation.OLEEMBEDDINGS.getRelation())) {
                linkedList.add(xSSFSheet.getPackagePart().getRelatedPart(packageRelationship));
            }
            for (PackageRelationship packageRelationship : xSSFSheet.getPackagePart().getRelationshipsByType(XSSFRelation.PACKEMBEDDINGS.getRelation())) {
                linkedList.add(xSSFSheet.getPackagePart().getRelatedPart(packageRelationship));
            }
        }
        return linkedList;
    }

    @Override
    public boolean isHidden() {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void setHidden(boolean bl) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public boolean isSheetHidden(int n) {
        this.validateSheetIndex(n);
        CTSheet cTSheet = this.sheets.get((int)n).sheet;
        return cTSheet.getState() == STSheetState.HIDDEN;
    }

    @Override
    public boolean isSheetVeryHidden(int n) {
        this.validateSheetIndex(n);
        CTSheet cTSheet = this.sheets.get((int)n).sheet;
        return cTSheet.getState() == STSheetState.VERY_HIDDEN;
    }

    @Override
    public void setSheetHidden(int n, boolean bl) {
        this.setSheetHidden(n, bl ? 1 : 0);
    }

    @Override
    public void setSheetHidden(int n, int n2) {
        this.validateSheetIndex(n);
        WorkbookUtil.validateSheetState(n2);
        CTSheet cTSheet = this.sheets.get((int)n).sheet;
        cTSheet.setState(STSheetState.Enum.forInt((int)(n2 + 1)));
    }

    protected void onDeleteFormula(XSSFCell xSSFCell) {
        if (this.calcChain != null) {
            int n = (int)xSSFCell.getSheet().sheet.getSheetId();
            this.calcChain.removeItem(n, xSSFCell.getReference());
        }
    }

    @Internal
    public CalculationChain getCalculationChain() {
        return this.calcChain;
    }

    @Internal
    public List<ExternalLinksTable> getExternalLinksTable() {
        return this.externalLinks;
    }

    public Collection<XSSFMap> getCustomXMLMappings() {
        return this.mapInfo == null ? new ArrayList() : this.mapInfo.getAllXSSFMaps();
    }

    @Internal
    public MapInfo getMapInfo() {
        return this.mapInfo;
    }

    @Override
    public int linkExternalWorkbook(String string, Workbook workbook) {
        throw new RuntimeException("Not Implemented - see bug #57184");
    }

    public boolean isStructureLocked() {
        return this.workbookProtectionPresent() && this.workbook.getWorkbookProtection().getLockStructure();
    }

    public boolean isWindowsLocked() {
        return this.workbookProtectionPresent() && this.workbook.getWorkbookProtection().getLockWindows();
    }

    public boolean isRevisionLocked() {
        return this.workbookProtectionPresent() && this.workbook.getWorkbookProtection().getLockRevision();
    }

    public void lockStructure() {
        this.safeGetWorkbookProtection().setLockStructure(true);
    }

    public void unLockStructure() {
        this.safeGetWorkbookProtection().setLockStructure(false);
    }

    public void lockWindows() {
        this.safeGetWorkbookProtection().setLockWindows(true);
    }

    public void unLockWindows() {
        this.safeGetWorkbookProtection().setLockWindows(false);
    }

    public void lockRevision() {
        this.safeGetWorkbookProtection().setLockRevision(true);
    }

    public void unLockRevision() {
        this.safeGetWorkbookProtection().setLockRevision(false);
    }

    public void setWorkbookPassword(String string, HashAlgorithm hashAlgorithm) {
        if (string == null && !this.workbookProtectionPresent()) {
            return;
        }
        XSSFPaswordHelper.setPassword((XmlObject)this.safeGetWorkbookProtection(), string, hashAlgorithm, "workbook");
    }

    public boolean validateWorkbookPassword(String string) {
        if (!this.workbookProtectionPresent()) {
            return string == null;
        }
        return XSSFPaswordHelper.validatePassword((XmlObject)this.safeGetWorkbookProtection(), string, "workbook");
    }

    public void setRevisionsPassword(String string, HashAlgorithm hashAlgorithm) {
        if (string == null && !this.workbookProtectionPresent()) {
            return;
        }
        XSSFPaswordHelper.setPassword((XmlObject)this.safeGetWorkbookProtection(), string, hashAlgorithm, "revisions");
    }

    public boolean validateRevisionsPassword(String string) {
        if (!this.workbookProtectionPresent()) {
            return string == null;
        }
        return XSSFPaswordHelper.validatePassword((XmlObject)this.safeGetWorkbookProtection(), string, "revisions");
    }

    public void unLock() {
        if (this.workbookProtectionPresent()) {
            this.workbook.unsetWorkbookProtection();
        }
    }

    private boolean workbookProtectionPresent() {
        return this.workbook.isSetWorkbookProtection();
    }

    private CTWorkbookProtection safeGetWorkbookProtection() {
        if (!this.workbookProtectionPresent()) {
            return this.workbook.addNewWorkbookProtection();
        }
        return this.workbook.getWorkbookProtection();
    }

    UDFFinder getUDFFinder() {
        return this._udfFinder;
    }

    @Override
    public void addToolPack(UDFFinder uDFFinder) {
        this._udfFinder.add(uDFFinder);
    }

    @Override
    public void setForceFormulaRecalculation(boolean bl) {
        CTWorkbook cTWorkbook = this.getCTWorkbook();
        CTCalcPr cTCalcPr = cTWorkbook.isSetCalcPr() ? cTWorkbook.getCalcPr() : cTWorkbook.addNewCalcPr();
        cTCalcPr.setCalcId(0L);
        if (bl && cTCalcPr.getCalcMode() == STCalcMode.MANUAL) {
            cTCalcPr.setCalcMode(STCalcMode.AUTO);
        }
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        CTWorkbook cTWorkbook = this.getCTWorkbook();
        CTCalcPr cTCalcPr = cTWorkbook.getCalcPr();
        return cTCalcPr != null && cTCalcPr.getCalcId() != 0L;
    }

    protected CTPivotCache addPivotCache(String string) {
        CTWorkbook cTWorkbook = this.getCTWorkbook();
        CTPivotCaches cTPivotCaches = cTWorkbook.isSetPivotCaches() ? cTWorkbook.getPivotCaches() : cTWorkbook.addNewPivotCaches();
        CTPivotCache cTPivotCache = cTPivotCaches.addNewPivotCache();
        int n = this.getPivotTables().size() + 1;
        cTPivotCache.setCacheId((long)n);
        cTPivotCache.setId(string);
        if (this.pivotCaches == null) {
            this.pivotCaches = new ArrayList<CTPivotCache>();
        }
        this.pivotCaches.add(cTPivotCache);
        return cTPivotCache;
    }

    public List<XSSFPivotTable> getPivotTables() {
        return this.pivotTables;
    }

    protected void setPivotTables(List<XSSFPivotTable> list) {
        this.pivotTables = list;
    }

    public XSSFWorkbookType getWorkbookType() {
        return this.isMacroEnabled() ? XSSFWorkbookType.XLSM : XSSFWorkbookType.XLSX;
    }

    public void setWorkbookType(XSSFWorkbookType xSSFWorkbookType) {
        try {
            this.getPackagePart().setContentType(xSSFWorkbookType.getContentType());
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new POIXMLException(invalidFormatException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVBAProject(InputStream inputStream) throws IOException {
        OutputStream outputStream;
        PackagePartName packagePartName;
        if (!this.isMacroEnabled()) {
            this.setWorkbookType(XSSFWorkbookType.XLSM);
        }
        try {
            packagePartName = PackagingURIHelper.createPartName(XSSFRelation.VBA_MACROS.getDefaultFileName());
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new POIXMLException(invalidFormatException);
        }
        OPCPackage oPCPackage = this.getPackage();
        if (!oPCPackage.containPart(packagePartName)) {
            POIXMLDocumentPart pOIXMLDocumentPart = this.createRelationship(XSSFRelation.VBA_MACROS, XSSFFactory.getInstance());
            outputStream = pOIXMLDocumentPart.getPackagePart().getOutputStream();
        } else {
            PackagePart packagePart = oPCPackage.getPart(packagePartName);
            outputStream = packagePart.getOutputStream();
        }
        try {
            IOUtils.copy(inputStream, outputStream);
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
    }

    public void setVBAProject(XSSFWorkbook xSSFWorkbook) throws IOException, InvalidFormatException {
        if (!xSSFWorkbook.isMacroEnabled()) {
            return;
        }
        InputStream inputStream = XSSFRelation.VBA_MACROS.getContents(xSSFWorkbook.getCorePart());
        if (inputStream != null) {
            this.setVBAProject(inputStream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SheetIterator<T extends Sheet>
    implements Iterator<T> {
        private final Iterator<T> it;

        public SheetIterator() {
            this.it = XSSFWorkbook.this.sheets.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() throws NoSuchElementException {
            return (T)((Sheet)this.it.next());
        }

        @Override
        public void remove() throws IllegalStateException {
            throw new UnsupportedOperationException("remove method not supported on XSSFWorkbook.iterator(). Use Sheet.removeSheetAt(int) instead.");
        }
    }
}

