/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xssf.util.EvilUnclosedBRFixingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Node;
import schemasMicrosoftComOfficeExcel.CTClientData;
import schemasMicrosoftComOfficeExcel.STObjectType;
import schemasMicrosoftComOfficeOffice.CTIdMap;
import schemasMicrosoftComOfficeOffice.CTShapeLayout;
import schemasMicrosoftComOfficeOffice.STConnectType;
import schemasMicrosoftComOfficeOffice.STInsetMode;
import schemasMicrosoftComVml.CTPath;
import schemasMicrosoftComVml.CTShadow;
import schemasMicrosoftComVml.CTShape;
import schemasMicrosoftComVml.CTShapetype;
import schemasMicrosoftComVml.STExt;
import schemasMicrosoftComVml.STStrokeJoinStyle;
import schemasMicrosoftComVml.STTrueFalse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSSFVMLDrawing
extends POIXMLDocumentPart {
    private static final QName QNAME_SHAPE_LAYOUT = new QName("urn:schemas-microsoft-com:office:office", "shapelayout");
    private static final QName QNAME_SHAPE_TYPE = new QName("urn:schemas-microsoft-com:vml", "shapetype");
    private static final QName QNAME_SHAPE = new QName("urn:schemas-microsoft-com:vml", "shape");
    private static final String COMMENT_SHAPE_TYPE_ID = "_x0000_t202";
    private static final Pattern ptrn_shapeId = Pattern.compile("_x0000_s(\\d+)");
    private List<QName> _qnames = new ArrayList<QName>();
    private List<XmlObject> _items = new ArrayList<XmlObject>();
    private String _shapeTypeId;
    private int _shapeId = 1024;

    protected XSSFVMLDrawing() {
        this.newDrawing();
    }

    protected XSSFVMLDrawing(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, XmlException {
        super(packagePart, packageRelationship);
        this.read(this.getPackagePart().getInputStream());
    }

    protected void read(InputStream inputStream) throws IOException, XmlException {
        XmlObject xmlObject = XmlObject.Factory.parse((InputStream)new EvilUnclosedBRFixingInputStream(inputStream));
        this._qnames = new ArrayList<QName>();
        this._items = new ArrayList<XmlObject>();
        for (XmlObject xmlObject2 : xmlObject.selectPath("$this/xml/*")) {
            CTShapetype cTShapetype;
            Node node = xmlObject2.getDomNode();
            QName qName = new QName(node.getNamespaceURI(), node.getLocalName());
            if (qName.equals(QNAME_SHAPE_LAYOUT)) {
                this._items.add((XmlObject)CTShapeLayout.Factory.parse((String)xmlObject2.xmlText()));
            } else if (qName.equals(QNAME_SHAPE_TYPE)) {
                cTShapetype = CTShapetype.Factory.parse((String)xmlObject2.xmlText());
                this._items.add((XmlObject)cTShapetype);
                this._shapeTypeId = cTShapetype.getId();
            } else if (qName.equals(QNAME_SHAPE)) {
                Matcher matcher;
                cTShapetype = CTShape.Factory.parse((String)xmlObject2.xmlText());
                String string = cTShapetype.getId();
                if (string != null && (matcher = ptrn_shapeId.matcher(string)).find()) {
                    this._shapeId = Math.max(this._shapeId, Integer.parseInt(matcher.group(1)));
                }
                this._items.add((XmlObject)cTShapetype);
            } else {
                this._items.add(XmlObject.Factory.parse((String)xmlObject2.xmlText()));
            }
            this._qnames.add(qName);
        }
    }

    protected List<XmlObject> getItems() {
        return this._items;
    }

    protected void write(OutputStream outputStream) throws IOException {
        Object object;
        XmlObject xmlObject = XmlObject.Factory.newInstance();
        XmlCursor xmlCursor = xmlObject.newCursor();
        xmlCursor.toNextToken();
        xmlCursor.beginElement("xml");
        for (int i = 0; i < this._items.size(); ++i) {
            object = this._items.get(i).newCursor();
            xmlCursor.beginElement(this._qnames.get(i));
            while (object.toNextToken() == XmlCursor.TokenType.ATTR) {
                Node node = object.getDomNode();
                xmlCursor.insertAttributeWithValue(node.getLocalName(), node.getNamespaceURI(), node.getNodeValue());
            }
            object.toStartDoc();
            object.copyXmlContents(xmlCursor);
            xmlCursor.toNextToken();
            object.dispose();
        }
        xmlCursor.dispose();
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSavePrettyPrint();
        object = new HashMap();
        ((HashMap)object).put("urn:schemas-microsoft-com:vml", "v");
        ((HashMap)object).put("urn:schemas-microsoft-com:office:office", "o");
        ((HashMap)object).put("urn:schemas-microsoft-com:office:excel", "x");
        xmlOptions.setSaveSuggestedPrefixes((Map)object);
        xmlObject.save(outputStream, xmlOptions);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.write(outputStream);
        outputStream.close();
    }

    private void newDrawing() {
        CTShapeLayout cTShapeLayout = CTShapeLayout.Factory.newInstance();
        cTShapeLayout.setExt(STExt.EDIT);
        CTIdMap cTIdMap = cTShapeLayout.addNewIdmap();
        cTIdMap.setExt(STExt.EDIT);
        cTIdMap.setData("1");
        this._items.add((XmlObject)cTShapeLayout);
        this._qnames.add(QNAME_SHAPE_LAYOUT);
        CTShapetype cTShapetype = CTShapetype.Factory.newInstance();
        this._shapeTypeId = COMMENT_SHAPE_TYPE_ID;
        cTShapetype.setId(this._shapeTypeId);
        cTShapetype.setCoordsize("21600,21600");
        cTShapetype.setSpt(202.0f);
        cTShapetype.setPath2("m,l,21600r21600,l21600,xe");
        cTShapetype.addNewStroke().setJoinstyle(STStrokeJoinStyle.MITER);
        CTPath cTPath = cTShapetype.addNewPath();
        cTPath.setGradientshapeok(STTrueFalse.T);
        cTPath.setConnecttype(STConnectType.RECT);
        this._items.add((XmlObject)cTShapetype);
        this._qnames.add(QNAME_SHAPE_TYPE);
    }

    protected CTShape newCommentShape() {
        CTShape cTShape = CTShape.Factory.newInstance();
        cTShape.setId("_x0000_s" + ++this._shapeId);
        cTShape.setType("#" + this._shapeTypeId);
        cTShape.setStyle("position:absolute; visibility:hidden");
        cTShape.setFillcolor("#ffffe1");
        cTShape.setInsetmode(STInsetMode.AUTO);
        cTShape.addNewFill().setColor("#ffffe1");
        CTShadow cTShadow = cTShape.addNewShadow();
        cTShadow.setOn(STTrueFalse.T);
        cTShadow.setColor("black");
        cTShadow.setObscured(STTrueFalse.T);
        cTShape.addNewPath().setConnecttype(STConnectType.NONE);
        cTShape.addNewTextbox().setStyle("mso-direction-alt:auto");
        CTClientData cTClientData = cTShape.addNewClientData();
        cTClientData.setObjectType(STObjectType.NOTE);
        cTClientData.addNewMoveWithCells();
        cTClientData.addNewSizeWithCells();
        cTClientData.addNewAnchor().setStringValue("1, 15, 0, 2, 3, 15, 3, 16");
        cTClientData.addNewAutoFill().setStringValue("False");
        cTClientData.addNewRow().setBigIntegerValue(new BigInteger("0"));
        cTClientData.addNewColumn().setBigIntegerValue(new BigInteger("0"));
        this._items.add((XmlObject)cTShape);
        this._qnames.add(QNAME_SHAPE);
        return cTShape;
    }

    protected CTShape findCommentShape(int n, int n2) {
        for (XmlObject xmlObject : this._items) {
            CTClientData cTClientData;
            CTShape cTShape;
            if (!(xmlObject instanceof CTShape) || (cTShape = (CTShape)xmlObject).sizeOfClientDataArray() <= 0 || (cTClientData = cTShape.getClientDataArray(0)).getObjectType() != STObjectType.NOTE) continue;
            int n3 = cTClientData.getRowArray(0).intValue();
            int n4 = cTClientData.getColumnArray(0).intValue();
            if (n3 != n || n4 != n2) continue;
            return cTShape;
        }
        return null;
    }

    protected boolean removeCommentShape(int n, int n2) {
        CTShape cTShape = this.findCommentShape(n, n2);
        return cTShape != null && this._items.remove(cTShape);
    }
}

