/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.xssf.usermodel.TextCap;
import ai2.org.apache.poi.xssf.usermodel.XSSFTextParagraph;
import java.awt.Color;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNormalAutofit;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextStrikeType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextUnderlineType;

public class XSSFTextRun {
    private final CTRegularTextRun _r;
    private final XSSFTextParagraph _p;

    XSSFTextRun(CTRegularTextRun cTRegularTextRun, XSSFTextParagraph xSSFTextParagraph) {
        this._r = cTRegularTextRun;
        this._p = xSSFTextParagraph;
    }

    XSSFTextParagraph getParentParagraph() {
        return this._p;
    }

    public String getText() {
        return this._r.getT();
    }

    public void setText(String string) {
        this._r.setT(string);
    }

    public CTRegularTextRun getXmlObject() {
        return this._r;
    }

    public void setFontColor(Color color) {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        CTSolidColorFillProperties cTSolidColorFillProperties = cTTextCharacterProperties.isSetSolidFill() ? cTTextCharacterProperties.getSolidFill() : cTTextCharacterProperties.addNewSolidFill();
        CTSRgbColor cTSRgbColor = cTSolidColorFillProperties.isSetSrgbClr() ? cTSolidColorFillProperties.getSrgbClr() : cTSolidColorFillProperties.addNewSrgbClr();
        cTSRgbColor.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
        if (cTSolidColorFillProperties.isSetHslClr()) {
            cTSolidColorFillProperties.unsetHslClr();
        }
        if (cTSolidColorFillProperties.isSetPrstClr()) {
            cTSolidColorFillProperties.unsetPrstClr();
        }
        if (cTSolidColorFillProperties.isSetSchemeClr()) {
            cTSolidColorFillProperties.unsetSchemeClr();
        }
        if (cTSolidColorFillProperties.isSetScrgbClr()) {
            cTSolidColorFillProperties.unsetScrgbClr();
        }
        if (cTSolidColorFillProperties.isSetSysClr()) {
            cTSolidColorFillProperties.unsetSysClr();
        }
    }

    public Color getFontColor() {
        CTSolidColorFillProperties cTSolidColorFillProperties;
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (cTTextCharacterProperties.isSetSolidFill() && (cTSolidColorFillProperties = cTTextCharacterProperties.getSolidFill()).isSetSrgbClr()) {
            CTSRgbColor cTSRgbColor = cTSolidColorFillProperties.getSrgbClr();
            byte[] byArray = cTSRgbColor.getVal();
            return new Color(0xFF & byArray[0], 0xFF & byArray[1], 0xFF & byArray[2]);
        }
        return new Color(0, 0, 0);
    }

    public void setFontSize(double d) {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (d == -1.0) {
            if (cTTextCharacterProperties.isSetSz()) {
                cTTextCharacterProperties.unsetSz();
            }
        } else {
            if (d < 1.0) {
                throw new IllegalArgumentException("Minimum font size is 1pt but was " + d);
            }
            cTTextCharacterProperties.setSz((int)(100.0 * d));
        }
    }

    public double getFontSize() {
        CTTextCharacterProperties cTTextCharacterProperties;
        double d = 1.0;
        double d2 = 11.0;
        CTTextNormalAutofit cTTextNormalAutofit = this.getParentParagraph().getParentShape().getTxBody().getBodyPr().getNormAutofit();
        if (cTTextNormalAutofit != null) {
            d = (double)cTTextNormalAutofit.getFontScale() / 100000.0;
        }
        if ((cTTextCharacterProperties = this.getRPr()).isSetSz()) {
            d2 = (double)cTTextCharacterProperties.getSz() * 0.01;
        }
        return d2 * d;
    }

    public double getCharacterSpacing() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (cTTextCharacterProperties.isSetSpc()) {
            return (double)cTTextCharacterProperties.getSpc() * 0.01;
        }
        return 0.0;
    }

    public void setCharacterSpacing(double d) {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (d == 0.0) {
            if (cTTextCharacterProperties.isSetSpc()) {
                cTTextCharacterProperties.unsetSpc();
            }
        } else {
            cTTextCharacterProperties.setSpc((int)(100.0 * d));
        }
    }

    public void setFont(String string) {
        this.setFontFamily(string, (byte)-1, (byte)-1, false);
    }

    public void setFontFamily(String string, byte by, byte by2, boolean bl) {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (string == null) {
            if (cTTextCharacterProperties.isSetLatin()) {
                cTTextCharacterProperties.unsetLatin();
            }
            if (cTTextCharacterProperties.isSetCs()) {
                cTTextCharacterProperties.unsetCs();
            }
            if (cTTextCharacterProperties.isSetSym()) {
                cTTextCharacterProperties.unsetSym();
            }
        } else if (bl) {
            CTTextFont cTTextFont = cTTextCharacterProperties.isSetSym() ? cTTextCharacterProperties.getSym() : cTTextCharacterProperties.addNewSym();
            cTTextFont.setTypeface(string);
        } else {
            CTTextFont cTTextFont = cTTextCharacterProperties.isSetLatin() ? cTTextCharacterProperties.getLatin() : cTTextCharacterProperties.addNewLatin();
            cTTextFont.setTypeface(string);
            if (by != -1) {
                cTTextFont.setCharset(by);
            }
            if (by2 != -1) {
                cTTextFont.setPitchFamily(by2);
            }
        }
    }

    public String getFontFamily() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        CTTextFont cTTextFont = cTTextCharacterProperties.getLatin();
        if (cTTextFont != null) {
            return cTTextFont.getTypeface();
        }
        return "Calibri";
    }

    public byte getPitchAndFamily() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        CTTextFont cTTextFont = cTTextCharacterProperties.getLatin();
        if (cTTextFont != null) {
            return cTTextFont.getPitchFamily();
        }
        return 0;
    }

    public void setStrikethrough(boolean bl) {
        this.getRPr().setStrike(bl ? STTextStrikeType.SNG_STRIKE : STTextStrikeType.NO_STRIKE);
    }

    public boolean isStrikethrough() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (cTTextCharacterProperties.isSetStrike()) {
            return cTTextCharacterProperties.getStrike() != STTextStrikeType.NO_STRIKE;
        }
        return false;
    }

    public boolean isSuperscript() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (cTTextCharacterProperties.isSetBaseline()) {
            return cTTextCharacterProperties.getBaseline() > 0;
        }
        return false;
    }

    public void setBaselineOffset(double d) {
        this.getRPr().setBaseline((int)d * 1000);
    }

    public void setSuperscript(boolean bl) {
        this.setBaselineOffset(bl ? 30.0 : 0.0);
    }

    public void setSubscript(boolean bl) {
        this.setBaselineOffset(bl ? -25.0 : 0.0);
    }

    public boolean isSubscript() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (cTTextCharacterProperties.isSetBaseline()) {
            return cTTextCharacterProperties.getBaseline() < 0;
        }
        return false;
    }

    public TextCap getTextCap() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (cTTextCharacterProperties.isSetCap()) {
            return TextCap.values()[cTTextCharacterProperties.getCap().intValue() - 1];
        }
        return TextCap.NONE;
    }

    public void setBold(boolean bl) {
        this.getRPr().setB(bl);
    }

    public boolean isBold() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (cTTextCharacterProperties.isSetB()) {
            return cTTextCharacterProperties.getB();
        }
        return false;
    }

    public void setItalic(boolean bl) {
        this.getRPr().setI(bl);
    }

    public boolean isItalic() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (cTTextCharacterProperties.isSetI()) {
            return cTTextCharacterProperties.getI();
        }
        return false;
    }

    public void setUnderline(boolean bl) {
        this.getRPr().setU(bl ? STTextUnderlineType.SNG : STTextUnderlineType.NONE);
    }

    public boolean isUnderline() {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (cTTextCharacterProperties.isSetU()) {
            return cTTextCharacterProperties.getU() != STTextUnderlineType.NONE;
        }
        return false;
    }

    protected CTTextCharacterProperties getRPr() {
        return this._r.isSetRPr() ? this._r.getRPr() : this._r.addNewRPr();
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getText();
    }
}

