/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xssf.model.ParagraphPropertyFetcher;
import ai2.org.apache.poi.xssf.usermodel.ListAutoNumber;
import ai2.org.apache.poi.xssf.usermodel.TextAlign;
import ai2.org.apache.poi.xssf.usermodel.TextFontAlign;
import ai2.org.apache.poi.xssf.usermodel.XSSFLineBreak;
import ai2.org.apache.poi.xssf.usermodel.XSSFTextRun;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextAutonumberBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePercent;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePoint;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextField;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextLineBreak;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNormalAutofit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacing;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStopList;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAlignType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAutonumberScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextFontAlignType;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFTextParagraph
implements Iterable<XSSFTextRun> {
    private final CTTextParagraph _p;
    private final CTShape _shape;
    private final List<XSSFTextRun> _runs;

    XSSFTextParagraph(CTTextParagraph cTTextParagraph, CTShape cTShape) {
        this._p = cTTextParagraph;
        this._shape = cTShape;
        this._runs = new ArrayList<XSSFTextRun>();
        for (XmlObject xmlObject : this._p.selectPath("*")) {
            CTRegularTextRun cTRegularTextRun;
            CTRegularTextRun cTRegularTextRun2;
            if (xmlObject instanceof CTRegularTextRun) {
                cTRegularTextRun2 = (CTRegularTextRun)xmlObject;
                this._runs.add(new XSSFTextRun(cTRegularTextRun2, this));
                continue;
            }
            if (xmlObject instanceof CTTextLineBreak) {
                cTRegularTextRun2 = (CTTextLineBreak)xmlObject;
                cTRegularTextRun = CTRegularTextRun.Factory.newInstance();
                cTRegularTextRun.setRPr(cTRegularTextRun2.getRPr());
                cTRegularTextRun.setT("\n");
                this._runs.add(new XSSFTextRun(cTRegularTextRun, this));
                continue;
            }
            if (!(xmlObject instanceof CTTextField)) continue;
            cTRegularTextRun2 = (CTTextField)xmlObject;
            cTRegularTextRun = CTRegularTextRun.Factory.newInstance();
            cTRegularTextRun.setRPr(cTRegularTextRun2.getRPr());
            cTRegularTextRun.setT(cTRegularTextRun2.getT());
            this._runs.add(new XSSFTextRun(cTRegularTextRun, this));
        }
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (XSSFTextRun xSSFTextRun : this._runs) {
            stringBuilder.append(xSSFTextRun.getText());
        }
        return stringBuilder.toString();
    }

    @Internal
    public CTTextParagraph getXmlObject() {
        return this._p;
    }

    @Internal
    public CTShape getParentShape() {
        return this._shape;
    }

    public List<XSSFTextRun> getTextRuns() {
        return this._runs;
    }

    @Override
    public Iterator<XSSFTextRun> iterator() {
        return this._runs.iterator();
    }

    public XSSFTextRun addNewTextRun() {
        CTRegularTextRun cTRegularTextRun = this._p.addNewR();
        CTTextCharacterProperties cTTextCharacterProperties = cTRegularTextRun.addNewRPr();
        cTTextCharacterProperties.setLang("en-US");
        XSSFTextRun xSSFTextRun = new XSSFTextRun(cTRegularTextRun, this);
        this._runs.add(xSSFTextRun);
        return xSSFTextRun;
    }

    public XSSFTextRun addLineBreak() {
        CTRegularTextRun cTRegularTextRun;
        CTTextLineBreak cTTextLineBreak = this._p.addNewBr();
        CTTextCharacterProperties cTTextCharacterProperties = cTTextLineBreak.addNewRPr();
        if (this._runs.size() > 0) {
            cTRegularTextRun = this._runs.get(this._runs.size() - 1).getRPr();
            cTTextCharacterProperties.set((XmlObject)cTRegularTextRun);
        }
        cTRegularTextRun = CTRegularTextRun.Factory.newInstance();
        cTRegularTextRun.setRPr(cTTextCharacterProperties);
        cTRegularTextRun.setT("\n");
        XSSFLineBreak xSSFLineBreak = new XSSFLineBreak(cTRegularTextRun, this, cTTextCharacterProperties);
        this._runs.add(xSSFLineBreak);
        return xSSFLineBreak;
    }

    public TextAlign getTextAlign() {
        ParagraphPropertyFetcher<TextAlign> paragraphPropertyFetcher = new ParagraphPropertyFetcher<TextAlign>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetAlgn()) {
                    TextAlign textAlign = TextAlign.values()[cTTextParagraphProperties.getAlgn().intValue() - 1];
                    this.setValue(textAlign);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? TextAlign.LEFT : (TextAlign)((Object)paragraphPropertyFetcher.getValue());
    }

    public void setTextAlign(TextAlign textAlign) {
        CTTextParagraphProperties cTTextParagraphProperties;
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (textAlign == null) {
            if (cTTextParagraphProperties.isSetAlgn()) {
                cTTextParagraphProperties.unsetAlgn();
            }
        } else {
            cTTextParagraphProperties.setAlgn(STTextAlignType.Enum.forInt((int)(textAlign.ordinal() + 1)));
        }
    }

    public TextFontAlign getTextFontAlign() {
        ParagraphPropertyFetcher<TextFontAlign> paragraphPropertyFetcher = new ParagraphPropertyFetcher<TextFontAlign>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetFontAlgn()) {
                    TextFontAlign textFontAlign = TextFontAlign.values()[cTTextParagraphProperties.getFontAlgn().intValue() - 1];
                    this.setValue(textFontAlign);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? TextFontAlign.BASELINE : (TextFontAlign)((Object)paragraphPropertyFetcher.getValue());
    }

    public void setTextFontAlign(TextFontAlign textFontAlign) {
        CTTextParagraphProperties cTTextParagraphProperties;
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (textFontAlign == null) {
            if (cTTextParagraphProperties.isSetFontAlgn()) {
                cTTextParagraphProperties.unsetFontAlgn();
            }
        } else {
            cTTextParagraphProperties.setFontAlgn(STTextFontAlignType.Enum.forInt((int)(textFontAlign.ordinal() + 1)));
        }
    }

    public String getBulletFont() {
        ParagraphPropertyFetcher<String> paragraphPropertyFetcher = new ParagraphPropertyFetcher<String>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuFont()) {
                    this.setValue(cTTextParagraphProperties.getBuFont().getTypeface());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (String)paragraphPropertyFetcher.getValue();
    }

    public void setBulletFont(String string) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextFont cTTextFont = cTTextParagraphProperties.isSetBuFont() ? cTTextParagraphProperties.getBuFont() : cTTextParagraphProperties.addNewBuFont();
        cTTextFont.setTypeface(string);
    }

    public String getBulletCharacter() {
        ParagraphPropertyFetcher<String> paragraphPropertyFetcher = new ParagraphPropertyFetcher<String>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuChar()) {
                    this.setValue(cTTextParagraphProperties.getBuChar().getChar());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (String)paragraphPropertyFetcher.getValue();
    }

    public void setBulletCharacter(String string) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextCharBullet cTTextCharBullet = cTTextParagraphProperties.isSetBuChar() ? cTTextParagraphProperties.getBuChar() : cTTextParagraphProperties.addNewBuChar();
        cTTextCharBullet.setChar(string);
    }

    public Color getBulletFontColor() {
        ParagraphPropertyFetcher<Color> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Color>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuClr() && cTTextParagraphProperties.getBuClr().isSetSrgbClr()) {
                    CTSRgbColor cTSRgbColor = cTTextParagraphProperties.getBuClr().getSrgbClr();
                    byte[] byArray = cTSRgbColor.getVal();
                    this.setValue(new Color(0xFF & byArray[0], 0xFF & byArray[1], 0xFF & byArray[2]));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (Color)paragraphPropertyFetcher.getValue();
    }

    public void setBulletFontColor(Color color) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTColor cTColor = cTTextParagraphProperties.isSetBuClr() ? cTTextParagraphProperties.getBuClr() : cTTextParagraphProperties.addNewBuClr();
        CTSRgbColor cTSRgbColor = cTColor.isSetSrgbClr() ? cTColor.getSrgbClr() : cTColor.addNewSrgbClr();
        cTSRgbColor.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    public double getBulletFontSize() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuSzPct()) {
                    this.setValue((double)cTTextParagraphProperties.getBuSzPct().getVal() * 0.001);
                    return true;
                }
                if (cTTextParagraphProperties.isSetBuSzPts()) {
                    this.setValue((double)(-cTTextParagraphProperties.getBuSzPts().getVal()) * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? 100.0 : (Double)paragraphPropertyFetcher.getValue();
    }

    public void setBulletFontSize(double d) {
        CTTextParagraphProperties cTTextParagraphProperties;
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (d >= 0.0) {
            CTTextBulletSizePercent cTTextBulletSizePercent = cTTextParagraphProperties.isSetBuSzPct() ? cTTextParagraphProperties.getBuSzPct() : cTTextParagraphProperties.addNewBuSzPct();
            cTTextBulletSizePercent.setVal((int)(d * 1000.0));
            if (cTTextParagraphProperties.isSetBuSzPts()) {
                cTTextParagraphProperties.unsetBuSzPts();
            }
        } else {
            CTTextBulletSizePoint cTTextBulletSizePoint = cTTextParagraphProperties.isSetBuSzPts() ? cTTextParagraphProperties.getBuSzPts() : cTTextParagraphProperties.addNewBuSzPts();
            cTTextBulletSizePoint.setVal((int)(-d * 100.0));
            if (cTTextParagraphProperties.isSetBuSzPct()) {
                cTTextParagraphProperties.unsetBuSzPct();
            }
        }
    }

    public void setIndent(double d) {
        CTTextParagraphProperties cTTextParagraphProperties;
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (d == -1.0) {
            if (cTTextParagraphProperties.isSetIndent()) {
                cTTextParagraphProperties.unsetIndent();
            }
        } else {
            cTTextParagraphProperties.setIndent(Units.toEMU(d));
        }
    }

    public double getIndent() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetIndent()) {
                    this.setValue(Units.toPoints(cTTextParagraphProperties.getIndent()));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? 0.0 : (Double)paragraphPropertyFetcher.getValue();
    }

    public void setLeftMargin(double d) {
        CTTextParagraphProperties cTTextParagraphProperties;
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (d == -1.0) {
            if (cTTextParagraphProperties.isSetMarL()) {
                cTTextParagraphProperties.unsetMarL();
            }
        } else {
            cTTextParagraphProperties.setMarL(Units.toEMU(d));
        }
    }

    public double getLeftMargin() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetMarL()) {
                    double d = Units.toPoints(cTTextParagraphProperties.getMarL());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? 0.0 : (Double)paragraphPropertyFetcher.getValue();
    }

    public void setRightMargin(double d) {
        CTTextParagraphProperties cTTextParagraphProperties;
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (d == -1.0) {
            if (cTTextParagraphProperties.isSetMarR()) {
                cTTextParagraphProperties.unsetMarR();
            }
        } else {
            cTTextParagraphProperties.setMarR(Units.toEMU(d));
        }
    }

    public double getRightMargin() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetMarR()) {
                    double d = Units.toPoints(cTTextParagraphProperties.getMarR());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? 0.0 : (Double)paragraphPropertyFetcher.getValue();
    }

    public double getDefaultTabSize() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetDefTabSz()) {
                    double d = Units.toPoints(cTTextParagraphProperties.getDefTabSz());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? 0.0 : (Double)paragraphPropertyFetcher.getValue();
    }

    public double getTabStop(final int n) {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                CTTextTabStopList cTTextTabStopList;
                if (cTTextParagraphProperties.isSetTabLst() && n < (cTTextTabStopList = cTTextParagraphProperties.getTabLst()).sizeOfTabArray()) {
                    CTTextTabStop cTTextTabStop = cTTextTabStopList.getTabArray(n);
                    double d = Units.toPoints(cTTextTabStop.getPos());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? 0.0 : (Double)paragraphPropertyFetcher.getValue();
    }

    public void addTabStop(double d) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextTabStopList cTTextTabStopList = cTTextParagraphProperties.isSetTabLst() ? cTTextParagraphProperties.getTabLst() : cTTextParagraphProperties.addNewTabLst();
        cTTextTabStopList.addNewTab().setPos(Units.toEMU(d));
    }

    public void setLineSpacing(double d) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing cTTextSpacing = CTTextSpacing.Factory.newInstance();
        if (d >= 0.0) {
            cTTextSpacing.addNewSpcPct().setVal((int)(d * 1000.0));
        } else {
            cTTextSpacing.addNewSpcPts().setVal((int)(-d * 100.0));
        }
        cTTextParagraphProperties.setLnSpc(cTTextSpacing);
    }

    public double getLineSpacing() {
        CTTextNormalAutofit cTTextNormalAutofit;
        double d;
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetLnSpc()) {
                    CTTextSpacing cTTextSpacing = cTTextParagraphProperties.getLnSpc();
                    if (cTTextSpacing.isSetSpcPct()) {
                        this.setValue((double)cTTextSpacing.getSpcPct().getVal() * 0.001);
                    } else if (cTTextSpacing.isSetSpcPts()) {
                        this.setValue((double)(-cTTextSpacing.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        double d2 = d = paragraphPropertyFetcher.getValue() == null ? 100.0 : (Double)paragraphPropertyFetcher.getValue();
        if (d > 0.0 && (cTTextNormalAutofit = this._shape.getTxBody().getBodyPr().getNormAutofit()) != null) {
            double d3 = 1.0 - (double)cTTextNormalAutofit.getLnSpcReduction() / 100000.0;
            d *= d3;
        }
        return d;
    }

    public void setSpaceBefore(double d) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing cTTextSpacing = CTTextSpacing.Factory.newInstance();
        if (d >= 0.0) {
            cTTextSpacing.addNewSpcPct().setVal((int)(d * 1000.0));
        } else {
            cTTextSpacing.addNewSpcPts().setVal((int)(-d * 100.0));
        }
        cTTextParagraphProperties.setSpcBef(cTTextSpacing);
    }

    public double getSpaceBefore() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetSpcBef()) {
                    CTTextSpacing cTTextSpacing = cTTextParagraphProperties.getSpcBef();
                    if (cTTextSpacing.isSetSpcPct()) {
                        this.setValue((double)cTTextSpacing.getSpcPct().getVal() * 0.001);
                    } else if (cTTextSpacing.isSetSpcPts()) {
                        this.setValue((double)(-cTTextSpacing.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        double d = paragraphPropertyFetcher.getValue() == null ? 0.0 : (Double)paragraphPropertyFetcher.getValue();
        return d;
    }

    public void setSpaceAfter(double d) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing cTTextSpacing = CTTextSpacing.Factory.newInstance();
        if (d >= 0.0) {
            cTTextSpacing.addNewSpcPct().setVal((int)(d * 1000.0));
        } else {
            cTTextSpacing.addNewSpcPts().setVal((int)(-d * 100.0));
        }
        cTTextParagraphProperties.setSpcAft(cTTextSpacing);
    }

    public double getSpaceAfter() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetSpcAft()) {
                    CTTextSpacing cTTextSpacing = cTTextParagraphProperties.getSpcAft();
                    if (cTTextSpacing.isSetSpcPct()) {
                        this.setValue((double)cTTextSpacing.getSpcPct().getVal() * 0.001);
                    } else if (cTTextSpacing.isSetSpcPts()) {
                        this.setValue((double)(-cTTextSpacing.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? 0.0 : (Double)paragraphPropertyFetcher.getValue();
    }

    public void setLevel(int n) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        cTTextParagraphProperties.setLvl(n);
    }

    public int getLevel() {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.getPPr();
        if (cTTextParagraphProperties == null) {
            return 0;
        }
        return cTTextParagraphProperties.getLvl();
    }

    public boolean isBullet() {
        ParagraphPropertyFetcher<Boolean> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Boolean>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuNone()) {
                    this.setValue(false);
                    return true;
                }
                if (cTTextParagraphProperties.isSetBuFont() && (cTTextParagraphProperties.isSetBuChar() || cTTextParagraphProperties.isSetBuAutoNum())) {
                    this.setValue(true);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? false : (Boolean)paragraphPropertyFetcher.getValue();
    }

    public void setBullet(boolean bl) {
        CTTextParagraphProperties cTTextParagraphProperties;
        if (this.isBullet() == bl) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (!bl) {
            cTTextParagraphProperties.addNewBuNone();
            if (cTTextParagraphProperties.isSetBuAutoNum()) {
                cTTextParagraphProperties.unsetBuAutoNum();
            }
            if (cTTextParagraphProperties.isSetBuBlip()) {
                cTTextParagraphProperties.unsetBuBlip();
            }
            if (cTTextParagraphProperties.isSetBuChar()) {
                cTTextParagraphProperties.unsetBuChar();
            }
            if (cTTextParagraphProperties.isSetBuClr()) {
                cTTextParagraphProperties.unsetBuClr();
            }
            if (cTTextParagraphProperties.isSetBuClrTx()) {
                cTTextParagraphProperties.unsetBuClrTx();
            }
            if (cTTextParagraphProperties.isSetBuFont()) {
                cTTextParagraphProperties.unsetBuFont();
            }
            if (cTTextParagraphProperties.isSetBuFontTx()) {
                cTTextParagraphProperties.unsetBuFontTx();
            }
            if (cTTextParagraphProperties.isSetBuSzPct()) {
                cTTextParagraphProperties.unsetBuSzPct();
            }
            if (cTTextParagraphProperties.isSetBuSzPts()) {
                cTTextParagraphProperties.unsetBuSzPts();
            }
            if (cTTextParagraphProperties.isSetBuSzTx()) {
                cTTextParagraphProperties.unsetBuSzTx();
            }
        } else {
            if (cTTextParagraphProperties.isSetBuNone()) {
                cTTextParagraphProperties.unsetBuNone();
            }
            if (!cTTextParagraphProperties.isSetBuFont()) {
                cTTextParagraphProperties.addNewBuFont().setTypeface("Arial");
            }
            if (!cTTextParagraphProperties.isSetBuAutoNum()) {
                cTTextParagraphProperties.addNewBuChar().setChar("\u2022");
            }
        }
    }

    public void setBullet(ListAutoNumber listAutoNumber, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Start Number must be greater or equal that 1");
        }
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextAutonumberBullet cTTextAutonumberBullet = cTTextParagraphProperties.isSetBuAutoNum() ? cTTextParagraphProperties.getBuAutoNum() : cTTextParagraphProperties.addNewBuAutoNum();
        cTTextAutonumberBullet.setType(STTextAutonumberScheme.Enum.forInt((int)(listAutoNumber.ordinal() + 1)));
        cTTextAutonumberBullet.setStartAt(n);
        if (!cTTextParagraphProperties.isSetBuFont()) {
            cTTextParagraphProperties.addNewBuFont().setTypeface("Arial");
        }
        if (cTTextParagraphProperties.isSetBuNone()) {
            cTTextParagraphProperties.unsetBuNone();
        }
        if (cTTextParagraphProperties.isSetBuBlip()) {
            cTTextParagraphProperties.unsetBuBlip();
        }
        if (cTTextParagraphProperties.isSetBuChar()) {
            cTTextParagraphProperties.unsetBuChar();
        }
    }

    public void setBullet(ListAutoNumber listAutoNumber) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextAutonumberBullet cTTextAutonumberBullet = cTTextParagraphProperties.isSetBuAutoNum() ? cTTextParagraphProperties.getBuAutoNum() : cTTextParagraphProperties.addNewBuAutoNum();
        cTTextAutonumberBullet.setType(STTextAutonumberScheme.Enum.forInt((int)(listAutoNumber.ordinal() + 1)));
        if (!cTTextParagraphProperties.isSetBuFont()) {
            cTTextParagraphProperties.addNewBuFont().setTypeface("Arial");
        }
        if (cTTextParagraphProperties.isSetBuNone()) {
            cTTextParagraphProperties.unsetBuNone();
        }
        if (cTTextParagraphProperties.isSetBuBlip()) {
            cTTextParagraphProperties.unsetBuBlip();
        }
        if (cTTextParagraphProperties.isSetBuChar()) {
            cTTextParagraphProperties.unsetBuChar();
        }
    }

    public boolean isBulletAutoNumber() {
        ParagraphPropertyFetcher<Boolean> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Boolean>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuAutoNum()) {
                    this.setValue(true);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? false : (Boolean)paragraphPropertyFetcher.getValue();
    }

    public int getBulletAutoNumberStart() {
        ParagraphPropertyFetcher<Integer> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Integer>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuAutoNum() && cTTextParagraphProperties.getBuAutoNum().isSetStartAt()) {
                    this.setValue(cTTextParagraphProperties.getBuAutoNum().getStartAt());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? 0 : (Integer)paragraphPropertyFetcher.getValue();
    }

    public ListAutoNumber getBulletAutoNumberScheme() {
        ParagraphPropertyFetcher<ListAutoNumber> paragraphPropertyFetcher = new ParagraphPropertyFetcher<ListAutoNumber>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuAutoNum()) {
                    this.setValue(ListAutoNumber.values()[cTTextParagraphProperties.getBuAutoNum().getType().intValue() - 1]);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? ListAutoNumber.ARABIC_PLAIN : (ListAutoNumber)((Object)paragraphPropertyFetcher.getValue());
    }

    private boolean fetchParagraphProperty(ParagraphPropertyFetcher paragraphPropertyFetcher) {
        boolean bl = false;
        if (this._p.isSetPPr()) {
            bl = paragraphPropertyFetcher.fetch(this._p.getPPr());
        }
        if (!bl) {
            bl = paragraphPropertyFetcher.fetch(this._shape);
        }
        return bl;
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getText();
    }
}

