/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFRow;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.TableDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFTable
extends POIXMLDocumentPart {
    private CTTable ctTable;
    private List<XSSFXmlColumnPr> xmlColumnPr;
    private CellReference startCellReference;
    private CellReference endCellReference;
    private String commonXPath;

    public XSSFTable() {
        this.ctTable = CTTable.Factory.newInstance();
    }

    public XSSFTable(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            TableDocument tableDocument = TableDocument.Factory.parse((InputStream)inputStream);
            this.ctTable = tableDocument.getTable();
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage());
        }
    }

    public XSSFSheet getXSSFSheet() {
        return (XSSFSheet)this.getParent();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.updateHeaders();
        TableDocument tableDocument = TableDocument.Factory.newInstance();
        tableDocument.setTable(this.ctTable);
        tableDocument.save(outputStream, DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.writeTo(outputStream);
        outputStream.close();
    }

    public CTTable getCTTable() {
        return this.ctTable;
    }

    public boolean mapsTo(long l) {
        boolean bl = false;
        List<XSSFXmlColumnPr> list = this.getXmlColumnPrs();
        for (XSSFXmlColumnPr xSSFXmlColumnPr : list) {
            if (xSSFXmlColumnPr.getMapId() != l) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getCommonXpath() {
        if (this.commonXPath == null) {
            String[] stringArray = new String[]{};
            block0: for (CTTableColumn cTTableColumn : this.ctTable.getTableColumns().getTableColumnArray()) {
                if (cTTableColumn.getXmlColumnPr() == null) continue;
                String string = cTTableColumn.getXmlColumnPr().getXpath();
                String[] stringArray2 = string.split("/");
                if (stringArray.length == 0) {
                    stringArray = stringArray2;
                    continue;
                }
                int n = stringArray.length > stringArray2.length ? stringArray2.length : stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (stringArray[i].equals(stringArray2[i])) continue;
                    List<String> list = Arrays.asList(stringArray).subList(0, i);
                    String[] stringArray3 = new String[]{};
                    stringArray = list.toArray(stringArray3);
                    continue block0;
                }
            }
            this.commonXPath = "";
            for (int i = 1; i < stringArray.length; ++i) {
                this.commonXPath = this.commonXPath + "/" + stringArray[i];
            }
        }
        return this.commonXPath;
    }

    public List<XSSFXmlColumnPr> getXmlColumnPrs() {
        if (this.xmlColumnPr == null) {
            this.xmlColumnPr = new ArrayList<XSSFXmlColumnPr>();
            for (CTTableColumn cTTableColumn : this.ctTable.getTableColumns().getTableColumnArray()) {
                if (cTTableColumn.getXmlColumnPr() == null) continue;
                XSSFXmlColumnPr xSSFXmlColumnPr = new XSSFXmlColumnPr(this, cTTableColumn, cTTableColumn.getXmlColumnPr());
                this.xmlColumnPr.add(xSSFXmlColumnPr);
            }
        }
        return this.xmlColumnPr;
    }

    public String getName() {
        return this.ctTable.getName();
    }

    public void setName(String string) {
        if (string == null) {
            this.ctTable.unsetName();
            return;
        }
        this.ctTable.setName(string);
    }

    public String getDisplayName() {
        return this.ctTable.getDisplayName();
    }

    public void setDisplayName(String string) {
        this.ctTable.setDisplayName(string);
    }

    public long getNumerOfMappedColumns() {
        return this.ctTable.getTableColumns().getCount();
    }

    public CellReference getStartCellReference() {
        String string;
        if (this.startCellReference == null && (string = this.ctTable.getRef()) != null) {
            String[] stringArray = string.split(":");
            String string2 = stringArray[0];
            this.startCellReference = new CellReference(string2);
        }
        return this.startCellReference;
    }

    public CellReference getEndCellReference() {
        if (this.endCellReference == null) {
            String string = this.ctTable.getRef();
            String[] stringArray = string.split(":");
            String string2 = stringArray[1];
            this.endCellReference = new CellReference(string2);
        }
        return this.endCellReference;
    }

    public int getRowCount() {
        CellReference cellReference = this.getStartCellReference();
        CellReference cellReference2 = this.getEndCellReference();
        int n = -1;
        if (cellReference != null && cellReference2 != null) {
            n = cellReference2.getRow() - cellReference.getRow();
        }
        return n;
    }

    public void updateHeaders() {
        XSSFSheet xSSFSheet = (XSSFSheet)this.getParent();
        CellReference cellReference = this.getStartCellReference();
        if (cellReference == null) {
            return;
        }
        int n = cellReference.getRow();
        int n2 = cellReference.getCol();
        XSSFRow xSSFRow = xSSFSheet.getRow(n);
        if (xSSFRow != null && xSSFRow.getCTRow().validate()) {
            int n3 = n2;
            for (CTTableColumn cTTableColumn : this.getCTTable().getTableColumns().getTableColumnArray()) {
                XSSFCell xSSFCell = xSSFRow.getCell(n3);
                if (xSSFCell != null) {
                    cTTableColumn.setName(xSSFCell.getStringCellValue());
                }
                ++n3;
            }
        }
    }
}

