/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.hssf.util.HSSFColor;
import ai2.org.apache.poi.ss.usermodel.VerticalAlignment;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xssf.usermodel.ListAutoNumber;
import ai2.org.apache.poi.xssf.usermodel.TextAutofit;
import ai2.org.apache.poi.xssf.usermodel.TextDirection;
import ai2.org.apache.poi.xssf.usermodel.TextHorizontalOverflow;
import ai2.org.apache.poi.xssf.usermodel.TextVerticalOverflow;
import ai2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import ai2.org.apache.poi.xssf.usermodel.XSSFShape;
import ai2.org.apache.poi.xssf.usermodel.XSSFTextParagraph;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAlignType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextHorzOverflowType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextUnderlineType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextVertOverflowType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextVerticalType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextWrappingType;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShape;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShapeNonVisual;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRElt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRPrElt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STUnderlineValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFSimpleShape
extends XSSFShape
implements Iterable<XSSFTextParagraph> {
    private final List<XSSFTextParagraph> _paragraphs;
    private static CTShape prototype = null;
    private CTShape ctShape;
    private static String[] _romanChars = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static int[] _romanAlphaValues = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};

    protected XSSFSimpleShape(XSSFDrawing xSSFDrawing, CTShape cTShape) {
        this.drawing = xSSFDrawing;
        this.ctShape = cTShape;
        this._paragraphs = new ArrayList<XSSFTextParagraph>();
        CTTextBody cTTextBody = cTShape.getTxBody();
        if (cTTextBody != null) {
            for (int i = 0; i < cTTextBody.sizeOfPArray(); ++i) {
                this._paragraphs.add(new XSSFTextParagraph(cTTextBody.getPArray(i), cTShape));
            }
        }
    }

    protected static CTShape prototype() {
        if (prototype == null) {
            CTShape cTShape = CTShape.Factory.newInstance();
            CTShapeNonVisual cTShapeNonVisual = cTShape.addNewNvSpPr();
            CTNonVisualDrawingProps cTNonVisualDrawingProps = cTShapeNonVisual.addNewCNvPr();
            cTNonVisualDrawingProps.setId(1L);
            cTNonVisualDrawingProps.setName("Shape 1");
            cTShapeNonVisual.addNewCNvSpPr();
            CTShapeProperties cTShapeProperties = cTShape.addNewSpPr();
            CTTransform2D cTTransform2D = cTShapeProperties.addNewXfrm();
            CTPositiveSize2D cTPositiveSize2D = cTTransform2D.addNewExt();
            cTPositiveSize2D.setCx(0L);
            cTPositiveSize2D.setCy(0L);
            CTPoint2D cTPoint2D = cTTransform2D.addNewOff();
            cTPoint2D.setX(0L);
            cTPoint2D.setY(0L);
            CTPresetGeometry2D cTPresetGeometry2D = cTShapeProperties.addNewPrstGeom();
            cTPresetGeometry2D.setPrst(STShapeType.RECT);
            cTPresetGeometry2D.addNewAvLst();
            CTTextBody cTTextBody = cTShape.addNewTxBody();
            CTTextBodyProperties cTTextBodyProperties = cTTextBody.addNewBodyPr();
            cTTextBodyProperties.setAnchor(STTextAnchoringType.T);
            cTTextBodyProperties.setRtlCol(false);
            CTTextParagraph cTTextParagraph = cTTextBody.addNewP();
            cTTextParagraph.addNewPPr().setAlgn(STTextAlignType.L);
            CTTextCharacterProperties cTTextCharacterProperties = cTTextParagraph.addNewEndParaRPr();
            cTTextCharacterProperties.setLang("en-US");
            cTTextCharacterProperties.setSz(1100);
            CTSolidColorFillProperties cTSolidColorFillProperties = cTTextCharacterProperties.addNewSolidFill();
            cTSolidColorFillProperties.addNewSrgbClr().setVal(new byte[]{0, 0, 0});
            cTTextBody.addNewLstStyle();
            prototype = cTShape;
        }
        return prototype;
    }

    @Internal
    public CTShape getCTShape() {
        return this.ctShape;
    }

    @Override
    public Iterator<XSSFTextParagraph> iterator() {
        return this._paragraphs.iterator();
    }

    public String getText() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(9);
        XSSFTextParagraph xSSFTextParagraph = null;
        for (n = 0; n < 9; ++n) {
            arrayList.add(0);
        }
        for (n = 0; n < this._paragraphs.size(); ++n) {
            int n2;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            if ((xSSFTextParagraph = this._paragraphs.get(n)).isBullet() && xSSFTextParagraph.getText().length() > 0) {
                n2 = Math.min(xSSFTextParagraph.getLevel(), 8);
                if (xSSFTextParagraph.isBulletAutoNumber()) {
                    n = this.processAutoNumGroup(n, n2, arrayList, stringBuilder);
                    continue;
                }
                for (int i = 0; i < n2; ++i) {
                    stringBuilder.append('\t');
                }
                String string = xSSFTextParagraph.getBulletCharacter();
                stringBuilder.append(string.length() > 0 ? string + " " : "- ");
                stringBuilder.append(xSSFTextParagraph.getText());
                continue;
            }
            stringBuilder.append(xSSFTextParagraph.getText());
            for (n2 = 0; n2 < 9; ++n2) {
                arrayList.set(n2, 0);
            }
        }
        return stringBuilder.toString();
    }

    private int processAutoNumGroup(int n, int n2, List<Integer> list, StringBuilder stringBuilder) {
        int n3;
        XSSFTextParagraph xSSFTextParagraph = null;
        XSSFTextParagraph xSSFTextParagraph2 = null;
        xSSFTextParagraph = this._paragraphs.get(n);
        int n4 = xSSFTextParagraph.getBulletAutoNumberStart();
        ListAutoNumber listAutoNumber = xSSFTextParagraph.getBulletAutoNumberScheme();
        if (list.get(n2) == 0) {
            list.set(n2, n4 == 0 ? 1 : n4);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            stringBuilder.append('\t');
        }
        if (xSSFTextParagraph.getText().length() > 0) {
            stringBuilder.append(this.getBulletPrefix(listAutoNumber, list.get(n2)));
            stringBuilder.append(xSSFTextParagraph.getText());
        }
        while (true) {
            XSSFTextParagraph xSSFTextParagraph3 = xSSFTextParagraph2 = n + 1 == this._paragraphs.size() ? null : this._paragraphs.get(n + 1);
            if (xSSFTextParagraph2 == null || !xSSFTextParagraph2.isBullet() || !xSSFTextParagraph.isBulletAutoNumber()) break;
            if (xSSFTextParagraph2.getLevel() > n2) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                n = this.processAutoNumGroup(n + 1, xSSFTextParagraph2.getLevel(), list, stringBuilder);
                continue;
            }
            if (xSSFTextParagraph2.getLevel() < n2) break;
            ListAutoNumber listAutoNumber2 = xSSFTextParagraph2.getBulletAutoNumberScheme();
            int n5 = xSSFTextParagraph2.getBulletAutoNumberStart();
            if (listAutoNumber2 != listAutoNumber || n5 != n4) break;
            ++n;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuilder.append('\t');
            }
            if (xSSFTextParagraph2.getText().length() <= 0) continue;
            list.set(n2, list.get(n2) + 1);
            stringBuilder.append(this.getBulletPrefix(listAutoNumber2, list.get(n2)));
            stringBuilder.append(xSSFTextParagraph2.getText());
        }
        list.set(n2, 0);
        return n;
    }

    private String getBulletPrefix(ListAutoNumber listAutoNumber, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (listAutoNumber) {
            case ALPHA_LC_PARENT_BOTH: 
            case ALPHA_LC_PARENT_R: {
                if (listAutoNumber == ListAutoNumber.ALPHA_LC_PARENT_BOTH) {
                    stringBuilder.append('(');
                }
                stringBuilder.append(this.valueToAlpha(n).toLowerCase(Locale.ROOT));
                stringBuilder.append(')');
                break;
            }
            case ALPHA_UC_PARENT_BOTH: 
            case ALPHA_UC_PARENT_R: {
                if (listAutoNumber == ListAutoNumber.ALPHA_UC_PARENT_BOTH) {
                    stringBuilder.append('(');
                }
                stringBuilder.append(this.valueToAlpha(n));
                stringBuilder.append(')');
                break;
            }
            case ALPHA_LC_PERIOD: {
                stringBuilder.append(this.valueToAlpha(n).toLowerCase(Locale.ROOT));
                stringBuilder.append('.');
                break;
            }
            case ALPHA_UC_PERIOD: {
                stringBuilder.append(this.valueToAlpha(n));
                stringBuilder.append('.');
                break;
            }
            case ARABIC_PARENT_BOTH: 
            case ARABIC_PARENT_R: {
                if (listAutoNumber == ListAutoNumber.ARABIC_PARENT_BOTH) {
                    stringBuilder.append('(');
                }
                stringBuilder.append(n);
                stringBuilder.append(')');
                break;
            }
            case ARABIC_PERIOD: {
                stringBuilder.append(n);
                stringBuilder.append('.');
                break;
            }
            case ARABIC_PLAIN: {
                stringBuilder.append(n);
                break;
            }
            case ROMAN_LC_PARENT_BOTH: 
            case ROMAN_LC_PARENT_R: {
                if (listAutoNumber == ListAutoNumber.ROMAN_LC_PARENT_BOTH) {
                    stringBuilder.append('(');
                }
                stringBuilder.append(this.valueToRoman(n).toLowerCase(Locale.ROOT));
                stringBuilder.append(')');
                break;
            }
            case ROMAN_UC_PARENT_BOTH: 
            case ROMAN_UC_PARENT_R: {
                if (listAutoNumber == ListAutoNumber.ROMAN_UC_PARENT_BOTH) {
                    stringBuilder.append('(');
                }
                stringBuilder.append(this.valueToRoman(n));
                stringBuilder.append(')');
                break;
            }
            case ROMAN_LC_PERIOD: {
                stringBuilder.append(this.valueToRoman(n).toLowerCase(Locale.ROOT));
                stringBuilder.append('.');
                break;
            }
            case ROMAN_UC_PERIOD: {
                stringBuilder.append(this.valueToRoman(n));
                stringBuilder.append('.');
                break;
            }
            default: {
                stringBuilder.append('\u2022');
            }
        }
        stringBuilder.append(" ");
        return stringBuilder.toString();
    }

    private String valueToAlpha(int n) {
        String string = "";
        while (n > 0) {
            int n2 = (n - 1) % 26;
            string = (char)(65 + n2) + string;
            n = (n - n2) / 26;
        }
        return string;
    }

    private String valueToRoman(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; n > 0 && i < _romanChars.length; ++i) {
            while (_romanAlphaValues[i] <= n) {
                stringBuilder.append(_romanChars[i]);
                n -= _romanAlphaValues[i];
            }
        }
        return stringBuilder.toString();
    }

    public void clearText() {
        this._paragraphs.clear();
        CTTextBody cTTextBody = this.ctShape.getTxBody();
        cTTextBody.setPArray(null);
    }

    public void setText(String string) {
        this.clearText();
        this.addNewTextParagraph().addNewTextRun().setText(string);
    }

    public void setText(XSSFRichTextString xSSFRichTextString) {
        XSSFWorkbook xSSFWorkbook = (XSSFWorkbook)this.getDrawing().getParent().getParent();
        xSSFRichTextString.setStylesTableReference(xSSFWorkbook.getStylesSource());
        CTTextParagraph cTTextParagraph = CTTextParagraph.Factory.newInstance();
        if (xSSFRichTextString.numFormattingRuns() == 0) {
            CTRegularTextRun cTRegularTextRun = cTTextParagraph.addNewR();
            CTTextCharacterProperties cTTextCharacterProperties = cTRegularTextRun.addNewRPr();
            cTTextCharacterProperties.setLang("en-US");
            cTTextCharacterProperties.setSz(1100);
            cTRegularTextRun.setT(xSSFRichTextString.getString());
        } else {
            for (int i = 0; i < xSSFRichTextString.getCTRst().sizeOfRArray(); ++i) {
                CTRElt cTRElt = xSSFRichTextString.getCTRst().getRArray(i);
                CTRPrElt cTRPrElt = cTRElt.getRPr();
                if (cTRPrElt == null) {
                    cTRPrElt = cTRElt.addNewRPr();
                }
                CTRegularTextRun cTRegularTextRun = cTTextParagraph.addNewR();
                CTTextCharacterProperties cTTextCharacterProperties = cTRegularTextRun.addNewRPr();
                cTTextCharacterProperties.setLang("en-US");
                XSSFSimpleShape.applyAttributes(cTRPrElt, cTTextCharacterProperties);
                cTRegularTextRun.setT(cTRElt.getT());
            }
        }
        this.clearText();
        this.ctShape.getTxBody().setPArray(new CTTextParagraph[]{cTTextParagraph});
        this._paragraphs.add(new XSSFTextParagraph(this.ctShape.getTxBody().getPArray(0), this.ctShape));
    }

    public List<XSSFTextParagraph> getTextParagraphs() {
        return this._paragraphs;
    }

    public XSSFTextParagraph addNewTextParagraph() {
        CTTextBody cTTextBody = this.ctShape.getTxBody();
        CTTextParagraph cTTextParagraph = cTTextBody.addNewP();
        XSSFTextParagraph xSSFTextParagraph = new XSSFTextParagraph(cTTextParagraph, this.ctShape);
        this._paragraphs.add(xSSFTextParagraph);
        return xSSFTextParagraph;
    }

    public XSSFTextParagraph addNewTextParagraph(String string) {
        XSSFTextParagraph xSSFTextParagraph = this.addNewTextParagraph();
        xSSFTextParagraph.addNewTextRun().setText(string);
        return xSSFTextParagraph;
    }

    public XSSFTextParagraph addNewTextParagraph(XSSFRichTextString xSSFRichTextString) {
        Object object;
        CTTextBody cTTextBody = this.ctShape.getTxBody();
        CTTextParagraph cTTextParagraph = cTTextBody.addNewP();
        if (xSSFRichTextString.numFormattingRuns() == 0) {
            object = cTTextParagraph.addNewR();
            CTTextCharacterProperties cTTextCharacterProperties = object.addNewRPr();
            cTTextCharacterProperties.setLang("en-US");
            cTTextCharacterProperties.setSz(1100);
            object.setT(xSSFRichTextString.getString());
        } else {
            for (int i = 0; i < xSSFRichTextString.getCTRst().sizeOfRArray(); ++i) {
                CTRElt cTRElt = xSSFRichTextString.getCTRst().getRArray(i);
                CTRPrElt cTRPrElt = cTRElt.getRPr();
                if (cTRPrElt == null) {
                    cTRPrElt = cTRElt.addNewRPr();
                }
                CTRegularTextRun cTRegularTextRun = cTTextParagraph.addNewR();
                CTTextCharacterProperties cTTextCharacterProperties = cTRegularTextRun.addNewRPr();
                cTTextCharacterProperties.setLang("en-US");
                XSSFSimpleShape.applyAttributes(cTRPrElt, cTTextCharacterProperties);
                cTRegularTextRun.setT(cTRElt.getT());
            }
        }
        object = new XSSFTextParagraph(cTTextParagraph, this.ctShape);
        this._paragraphs.add((XSSFTextParagraph)object);
        return object;
    }

    public void setTextHorizontalOverflow(TextHorizontalOverflow textHorizontalOverflow) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (textHorizontalOverflow == null) {
                if (cTTextBodyProperties.isSetHorzOverflow()) {
                    cTTextBodyProperties.unsetHorzOverflow();
                }
            } else {
                cTTextBodyProperties.setHorzOverflow(STTextHorzOverflowType.Enum.forInt((int)(textHorizontalOverflow.ordinal() + 1)));
            }
        }
    }

    public TextHorizontalOverflow getTextHorizontalOverflow() {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null && cTTextBodyProperties.isSetHorzOverflow()) {
            return TextHorizontalOverflow.values()[cTTextBodyProperties.getHorzOverflow().intValue() - 1];
        }
        return TextHorizontalOverflow.OVERFLOW;
    }

    public void setTextVerticalOverflow(TextVerticalOverflow textVerticalOverflow) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (textVerticalOverflow == null) {
                if (cTTextBodyProperties.isSetVertOverflow()) {
                    cTTextBodyProperties.unsetVertOverflow();
                }
            } else {
                cTTextBodyProperties.setVertOverflow(STTextVertOverflowType.Enum.forInt((int)(textVerticalOverflow.ordinal() + 1)));
            }
        }
    }

    public TextVerticalOverflow getTextVerticalOverflow() {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null && cTTextBodyProperties.isSetVertOverflow()) {
            return TextVerticalOverflow.values()[cTTextBodyProperties.getVertOverflow().intValue() - 1];
        }
        return TextVerticalOverflow.OVERFLOW;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (verticalAlignment == null) {
                if (cTTextBodyProperties.isSetAnchor()) {
                    cTTextBodyProperties.unsetAnchor();
                }
            } else {
                cTTextBodyProperties.setAnchor(STTextAnchoringType.Enum.forInt((int)(verticalAlignment.ordinal() + 1)));
            }
        }
    }

    public VerticalAlignment getVerticalAlignment() {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null && cTTextBodyProperties.isSetAnchor()) {
            return VerticalAlignment.values()[cTTextBodyProperties.getAnchor().intValue() - 1];
        }
        return VerticalAlignment.TOP;
    }

    public void setTextDirection(TextDirection textDirection) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (textDirection == null) {
                if (cTTextBodyProperties.isSetVert()) {
                    cTTextBodyProperties.unsetVert();
                }
            } else {
                cTTextBodyProperties.setVert(STTextVerticalType.Enum.forInt((int)(textDirection.ordinal() + 1)));
            }
        }
    }

    public TextDirection getTextDirection() {
        STTextVerticalType.Enum enum_;
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null && (enum_ = cTTextBodyProperties.getVert()) != null) {
            return TextDirection.values()[enum_.intValue() - 1];
        }
        return TextDirection.HORIZONTAL;
    }

    public double getBottomInset() {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null && cTTextBodyProperties.isSetBIns()) {
            return Units.toPoints(cTTextBodyProperties.getBIns());
        }
        return 3.6;
    }

    public double getLeftInset() {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null && cTTextBodyProperties.isSetLIns()) {
            return Units.toPoints(cTTextBodyProperties.getLIns());
        }
        return 3.6;
    }

    public double getRightInset() {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null && cTTextBodyProperties.isSetRIns()) {
            return Units.toPoints(cTTextBodyProperties.getRIns());
        }
        return 3.6;
    }

    public double getTopInset() {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null && cTTextBodyProperties.isSetTIns()) {
            return Units.toPoints(cTTextBodyProperties.getTIns());
        }
        return 3.6;
    }

    public void setBottomInset(double d) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (d == -1.0) {
                if (cTTextBodyProperties.isSetBIns()) {
                    cTTextBodyProperties.unsetBIns();
                }
            } else {
                cTTextBodyProperties.setBIns(Units.toEMU(d));
            }
        }
    }

    public void setLeftInset(double d) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (d == -1.0) {
                if (cTTextBodyProperties.isSetLIns()) {
                    cTTextBodyProperties.unsetLIns();
                }
            } else {
                cTTextBodyProperties.setLIns(Units.toEMU(d));
            }
        }
    }

    public void setRightInset(double d) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (d == -1.0) {
                if (cTTextBodyProperties.isSetRIns()) {
                    cTTextBodyProperties.unsetRIns();
                }
            } else {
                cTTextBodyProperties.setRIns(Units.toEMU(d));
            }
        }
    }

    public void setTopInset(double d) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (d == -1.0) {
                if (cTTextBodyProperties.isSetTIns()) {
                    cTTextBodyProperties.unsetTIns();
                }
            } else {
                cTTextBodyProperties.setTIns(Units.toEMU(d));
            }
        }
    }

    public boolean getWordWrap() {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null && cTTextBodyProperties.isSetWrap()) {
            return cTTextBodyProperties.getWrap() == STTextWrappingType.SQUARE;
        }
        return true;
    }

    public void setWordWrap(boolean bl) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            cTTextBodyProperties.setWrap(bl ? STTextWrappingType.SQUARE : STTextWrappingType.NONE);
        }
    }

    public void setTextAutofit(TextAutofit textAutofit) {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (cTTextBodyProperties.isSetSpAutoFit()) {
                cTTextBodyProperties.unsetSpAutoFit();
            }
            if (cTTextBodyProperties.isSetNoAutofit()) {
                cTTextBodyProperties.unsetNoAutofit();
            }
            if (cTTextBodyProperties.isSetNormAutofit()) {
                cTTextBodyProperties.unsetNormAutofit();
            }
            switch (textAutofit) {
                case NONE: {
                    cTTextBodyProperties.addNewNoAutofit();
                    break;
                }
                case NORMAL: {
                    cTTextBodyProperties.addNewNormAutofit();
                    break;
                }
                case SHAPE: {
                    cTTextBodyProperties.addNewSpAutoFit();
                }
            }
        }
    }

    public TextAutofit getTextAutofit() {
        CTTextBodyProperties cTTextBodyProperties = this.ctShape.getTxBody().getBodyPr();
        if (cTTextBodyProperties != null) {
            if (cTTextBodyProperties.isSetNoAutofit()) {
                return TextAutofit.NONE;
            }
            if (cTTextBodyProperties.isSetNormAutofit()) {
                return TextAutofit.NORMAL;
            }
            if (cTTextBodyProperties.isSetSpAutoFit()) {
                return TextAutofit.SHAPE;
            }
        }
        return TextAutofit.NORMAL;
    }

    public int getShapeType() {
        return this.ctShape.getSpPr().getPrstGeom().getPrst().intValue();
    }

    public void setShapeType(int n) {
        this.ctShape.getSpPr().getPrstGeom().setPrst(STShapeType.Enum.forInt((int)n));
    }

    @Override
    protected CTShapeProperties getShapeProperties() {
        return this.ctShape.getSpPr();
    }

    private static void applyAttributes(CTRPrElt cTRPrElt, CTTextCharacterProperties cTTextCharacterProperties) {
        STUnderlineValues.Enum enum_;
        if (cTRPrElt.sizeOfBArray() > 0) {
            cTTextCharacterProperties.setB(cTRPrElt.getBArray(0).getVal());
        }
        if (cTRPrElt.sizeOfUArray() > 0) {
            enum_ = cTRPrElt.getUArray(0).getVal();
            if (enum_ == STUnderlineValues.SINGLE) {
                cTTextCharacterProperties.setU(STTextUnderlineType.SNG);
            } else if (enum_ == STUnderlineValues.DOUBLE) {
                cTTextCharacterProperties.setU(STTextUnderlineType.DBL);
            } else if (enum_ == STUnderlineValues.NONE) {
                cTTextCharacterProperties.setU(STTextUnderlineType.NONE);
            }
        }
        if (cTRPrElt.sizeOfIArray() > 0) {
            cTTextCharacterProperties.setI(cTRPrElt.getIArray(0).getVal());
        }
        if (cTRPrElt.sizeOfRFontArray() > 0) {
            enum_ = cTTextCharacterProperties.isSetLatin() ? cTTextCharacterProperties.getLatin() : cTTextCharacterProperties.addNewLatin();
            enum_.setTypeface(cTRPrElt.getRFontArray(0).getVal());
        }
        if (cTRPrElt.sizeOfSzArray() > 0) {
            int n = (int)(cTRPrElt.getSzArray(0).getVal() * 100.0);
            cTTextCharacterProperties.setSz(n);
        }
        if (cTRPrElt.sizeOfColorArray() > 0) {
            HSSFColor hSSFColor;
            CTSolidColorFillProperties cTSolidColorFillProperties = cTTextCharacterProperties.isSetSolidFill() ? cTTextCharacterProperties.getSolidFill() : cTTextCharacterProperties.addNewSolidFill();
            CTColor cTColor = cTRPrElt.getColorArray(0);
            if (cTColor.isSetRgb()) {
                CTSRgbColor cTSRgbColor = cTSolidColorFillProperties.isSetSrgbClr() ? cTSolidColorFillProperties.getSrgbClr() : cTSolidColorFillProperties.addNewSrgbClr();
                cTSRgbColor.setVal(cTColor.getRgb());
            } else if (cTColor.isSetIndexed() && (hSSFColor = HSSFColor.getIndexHash().get((int)cTColor.getIndexed())) != null) {
                byte[] byArray = new byte[]{(byte)hSSFColor.getTriplet()[0], (byte)hSSFColor.getTriplet()[1], (byte)hSSFColor.getTriplet()[2]};
                CTSRgbColor cTSRgbColor = cTSolidColorFillProperties.isSetSrgbClr() ? cTSolidColorFillProperties.getSrgbClr() : cTSolidColorFillProperties.addNewSrgbClr();
                cTSRgbColor.setVal(byArray);
            }
        }
    }
}

