/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.hssf.record.cf.CellRangeUtil;
import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormatting;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import ai2.org.apache.poi.ss.usermodel.ExtendedColor;
import ai2.org.apache.poi.ss.usermodel.IconMultiStateFormatting;
import ai2.org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import ai2.org.apache.poi.xssf.usermodel.XSSFConditionalFormatting;
import ai2.org.apache.poi.xssf.usermodel.XSSFConditionalFormattingRule;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STConditionalFormattingOperator;

public class XSSFSheetConditionalFormatting
implements SheetConditionalFormatting {
    protected static final String CF_EXT_2009_NS_X14 = "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main";
    private final XSSFSheet _sheet;

    XSSFSheetConditionalFormatting(XSSFSheet xSSFSheet) {
        this._sheet = xSSFSheet;
    }

    public XSSFConditionalFormattingRule createConditionalFormattingRule(byte by, String string, String string2) {
        STConditionalFormattingOperator.Enum enum_;
        XSSFConditionalFormattingRule xSSFConditionalFormattingRule = new XSSFConditionalFormattingRule(this._sheet);
        CTCfRule cTCfRule = xSSFConditionalFormattingRule.getCTCfRule();
        cTCfRule.addFormula(string);
        if (string2 != null) {
            cTCfRule.addFormula(string2);
        }
        cTCfRule.setType(STCfType.CELL_IS);
        switch (by) {
            case 1: {
                enum_ = STConditionalFormattingOperator.BETWEEN;
                break;
            }
            case 2: {
                enum_ = STConditionalFormattingOperator.NOT_BETWEEN;
                break;
            }
            case 6: {
                enum_ = STConditionalFormattingOperator.LESS_THAN;
                break;
            }
            case 8: {
                enum_ = STConditionalFormattingOperator.LESS_THAN_OR_EQUAL;
                break;
            }
            case 5: {
                enum_ = STConditionalFormattingOperator.GREATER_THAN;
                break;
            }
            case 7: {
                enum_ = STConditionalFormattingOperator.GREATER_THAN_OR_EQUAL;
                break;
            }
            case 3: {
                enum_ = STConditionalFormattingOperator.EQUAL;
                break;
            }
            case 4: {
                enum_ = STConditionalFormattingOperator.NOT_EQUAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown comparison operator: " + by);
            }
        }
        cTCfRule.setOperator(enum_);
        return xSSFConditionalFormattingRule;
    }

    public XSSFConditionalFormattingRule createConditionalFormattingRule(byte by, String string) {
        return this.createConditionalFormattingRule(by, string, null);
    }

    public XSSFConditionalFormattingRule createConditionalFormattingRule(String string) {
        XSSFConditionalFormattingRule xSSFConditionalFormattingRule = new XSSFConditionalFormattingRule(this._sheet);
        CTCfRule cTCfRule = xSSFConditionalFormattingRule.getCTCfRule();
        cTCfRule.addFormula(string);
        cTCfRule.setType(STCfType.EXPRESSION);
        return xSSFConditionalFormattingRule;
    }

    public XSSFConditionalFormattingRule createConditionalFormattingRule(XSSFColor xSSFColor) {
        XSSFConditionalFormattingRule xSSFConditionalFormattingRule = new XSSFConditionalFormattingRule(this._sheet);
        xSSFConditionalFormattingRule.createDataBarFormatting(xSSFColor);
        return xSSFConditionalFormattingRule;
    }

    public XSSFConditionalFormattingRule createConditionalFormattingRule(ExtendedColor extendedColor) {
        return this.createConditionalFormattingRule((XSSFColor)extendedColor);
    }

    public XSSFConditionalFormattingRule createConditionalFormattingRule(IconMultiStateFormatting.IconSet iconSet) {
        XSSFConditionalFormattingRule xSSFConditionalFormattingRule = new XSSFConditionalFormattingRule(this._sheet);
        xSSFConditionalFormattingRule.createMultiStateFormatting(iconSet);
        return xSSFConditionalFormattingRule;
    }

    public XSSFConditionalFormattingRule createConditionalFormattingColorScaleRule() {
        XSSFConditionalFormattingRule xSSFConditionalFormattingRule = new XSSFConditionalFormattingRule(this._sheet);
        xSSFConditionalFormattingRule.createColorScaleFormatting();
        return xSSFConditionalFormattingRule;
    }

    /*
     * WARNING - void declaration
     */
    public int addConditionalFormatting(CellRangeAddress[] cellRangeAddressArray, ConditionalFormattingRule[] conditionalFormattingRuleArray) {
        if (cellRangeAddressArray == null) {
            throw new IllegalArgumentException("regions must not be null");
        }
        for (CellRangeAddress cellRangeAddressArray2 : cellRangeAddressArray) {
            cellRangeAddressArray2.validate(SpreadsheetVersion.EXCEL2007);
        }
        if (conditionalFormattingRuleArray == null) {
            throw new IllegalArgumentException("cfRules must not be null");
        }
        if (conditionalFormattingRuleArray.length == 0) {
            throw new IllegalArgumentException("cfRules must not be empty");
        }
        if (conditionalFormattingRuleArray.length > 3) {
            throw new IllegalArgumentException("Number of rules must not exceed 3");
        }
        CellRangeAddress[] cellRangeAddressArray3 = CellRangeUtil.mergeCellRanges(cellRangeAddressArray);
        CTConditionalFormatting cTConditionalFormatting = this._sheet.getCTWorksheet().addNewConditionalFormatting();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CellRangeAddress cellRangeAddress : cellRangeAddressArray3) {
            arrayList.add(cellRangeAddress.formatAsString());
        }
        cTConditionalFormatting.setSqref(arrayList);
        boolean bl = true;
        for (CTConditionalFormatting cTConditionalFormatting2 : this._sheet.getCTWorksheet().getConditionalFormattingArray()) {
            var6_11 += cTConditionalFormatting2.sizeOfCfRuleArray();
        }
        for (ConditionalFormattingRule conditionalFormattingRule : conditionalFormattingRuleArray) {
            void var6_12;
            XSSFConditionalFormattingRule xSSFConditionalFormattingRule = (XSSFConditionalFormattingRule)conditionalFormattingRule;
            xSSFConditionalFormattingRule.getCTCfRule().setPriority((int)(++var6_12));
            cTConditionalFormatting.addNewCfRule().set((XmlObject)xSSFConditionalFormattingRule.getCTCfRule());
        }
        return this._sheet.getCTWorksheet().sizeOfConditionalFormattingArray() - 1;
    }

    public int addConditionalFormatting(CellRangeAddress[] cellRangeAddressArray, ConditionalFormattingRule conditionalFormattingRule) {
        XSSFConditionalFormattingRule[] xSSFConditionalFormattingRuleArray;
        if (conditionalFormattingRule == null) {
            xSSFConditionalFormattingRuleArray = null;
        } else {
            XSSFConditionalFormattingRule[] xSSFConditionalFormattingRuleArray2 = new XSSFConditionalFormattingRule[1];
            xSSFConditionalFormattingRuleArray = xSSFConditionalFormattingRuleArray2;
            xSSFConditionalFormattingRuleArray2[0] = (XSSFConditionalFormattingRule)conditionalFormattingRule;
        }
        return this.addConditionalFormatting(cellRangeAddressArray, xSSFConditionalFormattingRuleArray);
    }

    public int addConditionalFormatting(CellRangeAddress[] cellRangeAddressArray, ConditionalFormattingRule conditionalFormattingRule, ConditionalFormattingRule conditionalFormattingRule2) {
        XSSFConditionalFormattingRule[] xSSFConditionalFormattingRuleArray;
        if (conditionalFormattingRule == null) {
            xSSFConditionalFormattingRuleArray = null;
        } else {
            XSSFConditionalFormattingRule[] xSSFConditionalFormattingRuleArray2 = new XSSFConditionalFormattingRule[2];
            xSSFConditionalFormattingRuleArray2[0] = (XSSFConditionalFormattingRule)conditionalFormattingRule;
            xSSFConditionalFormattingRuleArray = xSSFConditionalFormattingRuleArray2;
            xSSFConditionalFormattingRuleArray2[1] = (XSSFConditionalFormattingRule)conditionalFormattingRule2;
        }
        return this.addConditionalFormatting(cellRangeAddressArray, xSSFConditionalFormattingRuleArray);
    }

    public int addConditionalFormatting(ConditionalFormatting conditionalFormatting) {
        XSSFConditionalFormatting xSSFConditionalFormatting = (XSSFConditionalFormatting)conditionalFormatting;
        CTWorksheet cTWorksheet = this._sheet.getCTWorksheet();
        cTWorksheet.addNewConditionalFormatting().set(xSSFConditionalFormatting.getCTConditionalFormatting().copy());
        return cTWorksheet.sizeOfConditionalFormattingArray() - 1;
    }

    public XSSFConditionalFormatting getConditionalFormattingAt(int n) {
        this.checkIndex(n);
        CTConditionalFormatting cTConditionalFormatting = this._sheet.getCTWorksheet().getConditionalFormattingArray(n);
        return new XSSFConditionalFormatting(this._sheet, cTConditionalFormatting);
    }

    public int getNumConditionalFormattings() {
        return this._sheet.getCTWorksheet().sizeOfConditionalFormattingArray();
    }

    public void removeConditionalFormatting(int n) {
        this.checkIndex(n);
        this._sheet.getCTWorksheet().removeConditionalFormatting(n);
    }

    private void checkIndex(int n) {
        int n2 = this.getNumConditionalFormattings();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Specified CF index " + n + " is outside the allowable range (0.." + (n2 - 1) + ")");
        }
    }
}

