/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.hssf.util.PaneInformation;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.PartAlreadyExistsException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.FormulaShifter;
import ai2.org.apache.poi.ss.formula.SheetNameFormatter;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.CellRange;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.usermodel.DataValidation;
import ai2.org.apache.poi.ss.usermodel.DataValidationHelper;
import ai2.org.apache.poi.ss.usermodel.Footer;
import ai2.org.apache.poi.ss.usermodel.Header;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.usermodel.Sheet;
import ai2.org.apache.poi.ss.util.AreaReference;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellRangeAddressList;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.ss.util.SSCellRange;
import ai2.org.apache.poi.ss.util.SheetUtil;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xssf.model.CommentsTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFAutoFilter;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import ai2.org.apache.poi.xssf.usermodel.XSSFComment;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataValidation;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import ai2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFEvenFooter;
import ai2.org.apache.poi.xssf.usermodel.XSSFEvenHeader;
import ai2.org.apache.poi.xssf.usermodel.XSSFFactory;
import ai2.org.apache.poi.xssf.usermodel.XSSFFirstFooter;
import ai2.org.apache.poi.xssf.usermodel.XSSFFirstHeader;
import ai2.org.apache.poi.xssf.usermodel.XSSFHyperlink;
import ai2.org.apache.poi.xssf.usermodel.XSSFName;
import ai2.org.apache.poi.xssf.usermodel.XSSFOddFooter;
import ai2.org.apache.poi.xssf.usermodel.XSSFOddHeader;
import ai2.org.apache.poi.xssf.usermodel.XSSFPivotCache;
import ai2.org.apache.poi.xssf.usermodel.XSSFPivotCacheDefinition;
import ai2.org.apache.poi.xssf.usermodel.XSSFPivotCacheRecords;
import ai2.org.apache.poi.xssf.usermodel.XSSFPivotTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import ai2.org.apache.poi.xssf.usermodel.XSSFRow;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheetConditionalFormatting;
import ai2.org.apache.poi.xssf.usermodel.XSSFTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFVMLDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ai2.org.apache.poi.xssf.usermodel.helpers.ColumnHelper;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFPaswordHelper;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFRowShifter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCalcPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidations;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHeaderFooter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTLegacyDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCells;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOutlinePr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageMargins;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageSetUpPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPrintOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSelection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetCalcPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetViews;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTablePart;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableParts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCalcMode;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPaneState;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorksheetDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFSheet
extends POIXMLDocumentPart
implements Sheet {
    private static final POILogger logger = POILogFactory.getLogger(XSSFSheet.class);
    protected CTSheet sheet;
    protected CTWorksheet worksheet;
    private SortedMap<Integer, XSSFRow> _rows;
    private List<XSSFHyperlink> hyperlinks;
    private ColumnHelper columnHelper;
    private CommentsTable sheetComments;
    private Map<Integer, CTCellFormula> sharedFormulas;
    private SortedMap<String, XSSFTable> tables;
    private List<CellRangeAddress> arrayFormulas;
    private XSSFDataValidationHelper dataValidationHelper = new XSSFDataValidationHelper(this);

    protected XSSFSheet() {
        this.onDocumentCreate();
    }

    protected XSSFSheet(PackagePart packagePart, PackageRelationship packageRelationship) {
        super(packagePart, packageRelationship);
    }

    @Override
    public XSSFWorkbook getWorkbook() {
        return (XSSFWorkbook)this.getParent();
    }

    @Override
    protected void onDocumentRead() {
        try {
            this.read(this.getPackagePart().getInputStream());
        }
        catch (IOException iOException) {
            throw new POIXMLException(iOException);
        }
    }

    protected void read(InputStream inputStream) throws IOException {
        try {
            this.worksheet = WorksheetDocument.Factory.parse((InputStream)inputStream).getWorksheet();
        }
        catch (XmlException xmlException) {
            throw new POIXMLException(xmlException);
        }
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
            if (pOIXMLDocumentPart instanceof CommentsTable) {
                this.sheetComments = (CommentsTable)pOIXMLDocumentPart;
            }
            if (pOIXMLDocumentPart instanceof XSSFTable) {
                this.tables.put(pOIXMLDocumentPart.getPackageRelationship().getId(), (XSSFTable)pOIXMLDocumentPart);
            }
            if (!(pOIXMLDocumentPart instanceof XSSFPivotTable)) continue;
            this.getWorkbook().getPivotTables().add((XSSFPivotTable)pOIXMLDocumentPart);
        }
        this.initHyperlinks();
    }

    @Override
    protected void onDocumentCreate() {
        this.worksheet = XSSFSheet.newSheet();
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
    }

    private void initRows(CTWorksheet cTWorksheet) {
        this._rows = new TreeMap<Integer, XSSFRow>();
        this.tables = new TreeMap<String, XSSFTable>();
        this.sharedFormulas = new HashMap<Integer, CTCellFormula>();
        this.arrayFormulas = new ArrayList<CellRangeAddress>();
        for (CTRow cTRow : cTWorksheet.getSheetData().getRowArray()) {
            XSSFRow xSSFRow = new XSSFRow(cTRow, this);
            this._rows.put(xSSFRow.getRowNum(), xSSFRow);
        }
    }

    private void initHyperlinks() {
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
        if (!this.worksheet.isSetHyperlinks()) {
            return;
        }
        try {
            PackageRelationshipCollection packageRelationshipCollection = this.getPackagePart().getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation());
            for (CTHyperlink cTHyperlink : this.worksheet.getHyperlinks().getHyperlinkArray()) {
                PackageRelationship packageRelationship = null;
                if (cTHyperlink.getId() != null) {
                    packageRelationship = packageRelationshipCollection.getRelationshipByID(cTHyperlink.getId());
                }
                this.hyperlinks.add(new XSSFHyperlink(cTHyperlink, packageRelationship));
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new POIXMLException(invalidFormatException);
        }
    }

    private static CTWorksheet newSheet() {
        CTWorksheet cTWorksheet = CTWorksheet.Factory.newInstance();
        CTSheetFormatPr cTSheetFormatPr = cTWorksheet.addNewSheetFormatPr();
        cTSheetFormatPr.setDefaultRowHeight(15.0);
        CTSheetView cTSheetView = cTWorksheet.addNewSheetViews().addNewSheetView();
        cTSheetView.setWorkbookViewId(0L);
        cTWorksheet.addNewDimension().setRef("A1");
        cTWorksheet.addNewSheetData();
        CTPageMargins cTPageMargins = cTWorksheet.addNewPageMargins();
        cTPageMargins.setBottom(0.75);
        cTPageMargins.setFooter(0.3);
        cTPageMargins.setHeader(0.3);
        cTPageMargins.setLeft(0.7);
        cTPageMargins.setRight(0.7);
        cTPageMargins.setTop(0.75);
        return cTWorksheet;
    }

    @Internal
    public CTWorksheet getCTWorksheet() {
        return this.worksheet;
    }

    public ColumnHelper getColumnHelper() {
        return this.columnHelper;
    }

    @Override
    public String getSheetName() {
        return this.sheet.getName();
    }

    @Override
    public int addMergedRegion(CellRangeAddress cellRangeAddress) {
        cellRangeAddress.validate(SpreadsheetVersion.EXCEL2007);
        this.validateArrayFormulas(cellRangeAddress);
        CTMergeCells cTMergeCells = this.worksheet.isSetMergeCells() ? this.worksheet.getMergeCells() : this.worksheet.addNewMergeCells();
        CTMergeCell cTMergeCell = cTMergeCells.addNewMergeCell();
        cTMergeCell.setRef(cellRangeAddress.formatAsString());
        return 1;
    }

    private void validateArrayFormulas(CellRangeAddress cellRangeAddress) {
        int n = cellRangeAddress.getFirstRow();
        int n2 = cellRangeAddress.getFirstColumn();
        int n3 = cellRangeAddress.getLastRow();
        int n4 = cellRangeAddress.getLastColumn();
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                CellRangeAddress cellRangeAddress2;
                XSSFCell xSSFCell;
                XSSFRow xSSFRow = this.getRow(i);
                if (xSSFRow == null || (xSSFCell = xSSFRow.getCell(j)) == null || !xSSFCell.isPartOfArrayFormulaGroup() || (cellRangeAddress2 = xSSFCell.getArrayFormulaRange()).getNumberOfCells() <= 1 || !cellRangeAddress2.isInRange(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn()) && !cellRangeAddress2.isInRange(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn())) continue;
                String string = "The range " + cellRangeAddress.formatAsString() + " intersects with a multi-cell array formula. " + "You cannot merge cells of an array.";
                throw new IllegalStateException(string);
            }
        }
    }

    @Override
    public void autoSizeColumn(int n) {
        this.autoSizeColumn(n, false);
    }

    @Override
    public void autoSizeColumn(int n, boolean bl) {
        double d = SheetUtil.getColumnWidth(this, n, bl);
        if (d != -1.0) {
            int n2 = 65280;
            if ((d *= 256.0) > (double)n2) {
                d = n2;
            }
            this.setColumnWidth(n, (int)d);
            this.columnHelper.setColBestFit(n, true);
        }
    }

    public XSSFDrawing getDrawingPatriarch() {
        CTDrawing cTDrawing = this.getCTDrawing();
        if (cTDrawing != null) {
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof XSSFDrawing)) continue;
                XSSFDrawing xSSFDrawing = (XSSFDrawing)pOIXMLDocumentPart;
                String string = xSSFDrawing.getPackageRelationship().getId();
                if (!string.equals(cTDrawing.getId())) break;
                return xSSFDrawing;
            }
            logger.log(7, new Object[]{"Can't find drawing with id=" + cTDrawing.getId() + " in the list of the sheet's relationships"});
        }
        return null;
    }

    @Override
    public XSSFDrawing createDrawingPatriarch() {
        CTDrawing cTDrawing = this.getCTDrawing();
        if (cTDrawing != null) {
            return this.getDrawingPatriarch();
        }
        int n = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.DRAWINGS.getContentType()).size() + 1;
        XSSFDrawing xSSFDrawing = (XSSFDrawing)this.createRelationship(XSSFRelation.DRAWINGS, XSSFFactory.getInstance(), n);
        String string = xSSFDrawing.getPackageRelationship().getId();
        cTDrawing = this.worksheet.addNewDrawing();
        cTDrawing.setId(string);
        return xSSFDrawing;
    }

    protected XSSFVMLDrawing getVMLDrawing(boolean bl) {
        XSSFVMLDrawing xSSFVMLDrawing = null;
        CTLegacyDrawing cTLegacyDrawing = this.getCTLegacyDrawing();
        if (cTLegacyDrawing == null) {
            if (bl) {
                int n = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.VML_DRAWINGS.getContentType()).size() + 1;
                xSSFVMLDrawing = (XSSFVMLDrawing)this.createRelationship(XSSFRelation.VML_DRAWINGS, XSSFFactory.getInstance(), n);
                String string = xSSFVMLDrawing.getPackageRelationship().getId();
                cTLegacyDrawing = this.worksheet.addNewLegacyDrawing();
                cTLegacyDrawing.setId(string);
            }
        } else {
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof XSSFVMLDrawing)) continue;
                XSSFVMLDrawing xSSFVMLDrawing2 = (XSSFVMLDrawing)pOIXMLDocumentPart;
                String string = xSSFVMLDrawing2.getPackageRelationship().getId();
                if (!string.equals(cTLegacyDrawing.getId())) break;
                xSSFVMLDrawing = xSSFVMLDrawing2;
                break;
            }
            if (xSSFVMLDrawing == null) {
                logger.log(7, new Object[]{"Can't find VML drawing with id=" + cTLegacyDrawing.getId() + " in the list of the sheet's relationships"});
            }
        }
        return xSSFVMLDrawing;
    }

    protected CTDrawing getCTDrawing() {
        return this.worksheet.getDrawing();
    }

    protected CTLegacyDrawing getCTLegacyDrawing() {
        return this.worksheet.getLegacyDrawing();
    }

    @Override
    public void createFreezePane(int n, int n2) {
        this.createFreezePane(n, n2, n, n2);
    }

    @Override
    public void createFreezePane(int n, int n2, int n3, int n4) {
        CTSheetView cTSheetView = this.getDefaultSheetView();
        if (n == 0 && n2 == 0) {
            if (cTSheetView.isSetPane()) {
                cTSheetView.unsetPane();
            }
            cTSheetView.setSelectionArray(null);
            return;
        }
        if (!cTSheetView.isSetPane()) {
            cTSheetView.addNewPane();
        }
        CTPane cTPane = cTSheetView.getPane();
        if (n > 0) {
            cTPane.setXSplit((double)n);
        } else if (cTPane.isSetXSplit()) {
            cTPane.unsetXSplit();
        }
        if (n2 > 0) {
            cTPane.setYSplit((double)n2);
        } else if (cTPane.isSetYSplit()) {
            cTPane.unsetYSplit();
        }
        cTPane.setState(STPaneState.FROZEN);
        if (n2 == 0) {
            cTPane.setTopLeftCell(new CellReference(0, n3).formatAsString());
            cTPane.setActivePane(STPane.TOP_RIGHT);
        } else if (n == 0) {
            cTPane.setTopLeftCell(new CellReference(n4, 0).formatAsString());
            cTPane.setActivePane(STPane.BOTTOM_LEFT);
        } else {
            cTPane.setTopLeftCell(new CellReference(n4, n3).formatAsString());
            cTPane.setActivePane(STPane.BOTTOM_RIGHT);
        }
        cTSheetView.setSelectionArray(null);
        CTSelection cTSelection = cTSheetView.addNewSelection();
        cTSelection.setPane(cTPane.getActivePane());
    }

    @Deprecated
    public XSSFComment createComment() {
        return this.createDrawingPatriarch().createCellComment(new XSSFClientAnchor());
    }

    @Override
    public XSSFRow createRow(int n) {
        CTRow cTRow;
        XSSFRow xSSFRow = (XSSFRow)this._rows.get(n);
        if (xSSFRow != null) {
            while (xSSFRow.getFirstCellNum() != -1) {
                xSSFRow.removeCell(xSSFRow.getCell(xSSFRow.getFirstCellNum()));
            }
            cTRow = xSSFRow.getCTRow();
            cTRow.set((XmlObject)CTRow.Factory.newInstance());
        } else if (this._rows.isEmpty() || n > this._rows.lastKey()) {
            cTRow = this.worksheet.getSheetData().addNewRow();
        } else {
            int n2 = this._rows.headMap(n).size();
            cTRow = this.worksheet.getSheetData().insertNewRow(n2);
        }
        XSSFRow xSSFRow2 = new XSSFRow(cTRow, this);
        xSSFRow2.setRowNum(n);
        this._rows.put(n, xSSFRow2);
        return xSSFRow2;
    }

    @Override
    public void createSplitPane(int n, int n2, int n3, int n4, int n5) {
        this.createFreezePane(n, n2, n3, n4);
        this.getPane().setState(STPaneState.SPLIT);
        this.getPane().setActivePane(STPane.Enum.forInt((int)n5));
    }

    @Override
    public XSSFComment getCellComment(int n, int n2) {
        if (this.sheetComments == null) {
            return null;
        }
        String string = new CellReference(n, n2).formatAsString();
        CTComment cTComment = this.sheetComments.getCTComment(string);
        if (cTComment == null) {
            return null;
        }
        XSSFVMLDrawing xSSFVMLDrawing = this.getVMLDrawing(false);
        return new XSSFComment(this.sheetComments, cTComment, xSSFVMLDrawing == null ? null : xSSFVMLDrawing.findCommentShape(n, n2));
    }

    public XSSFHyperlink getHyperlink(int n, int n2) {
        String string = new CellReference(n, n2).formatAsString();
        for (XSSFHyperlink xSSFHyperlink : this.hyperlinks) {
            if (!xSSFHyperlink.getCellRef().equals(string)) continue;
            return xSSFHyperlink;
        }
        return null;
    }

    private int[] getBreaks(CTPageBreak cTPageBreak) {
        CTBreak[] cTBreakArray = cTPageBreak.getBrkArray();
        int[] nArray = new int[cTBreakArray.length];
        for (int i = 0; i < cTBreakArray.length; ++i) {
            nArray[i] = (int)cTBreakArray[i].getId() - 1;
        }
        return nArray;
    }

    private void removeBreak(int n, CTPageBreak cTPageBreak) {
        int n2 = n + 1;
        CTBreak[] cTBreakArray = cTPageBreak.getBrkArray();
        for (int i = 0; i < cTBreakArray.length; ++i) {
            if (cTBreakArray[i].getId() != (long)n2) continue;
            cTPageBreak.removeBrk(i);
        }
    }

    @Override
    public int[] getColumnBreaks() {
        return this.worksheet.isSetColBreaks() ? this.getBreaks(this.worksheet.getColBreaks()) : new int[]{};
    }

    @Override
    public int getColumnWidth(int n) {
        CTCol cTCol = this.columnHelper.getColumn(n, false);
        double d = cTCol == null || !cTCol.isSetWidth() ? (double)this.getDefaultColumnWidth() : cTCol.getWidth();
        return (int)(d * 256.0);
    }

    @Override
    public float getColumnWidthInPixels(int n) {
        float f = this.getColumnWidth(n);
        return (float)((double)f / 256.0 * (double)7.0017f);
    }

    @Override
    public int getDefaultColumnWidth() {
        CTSheetFormatPr cTSheetFormatPr = this.worksheet.getSheetFormatPr();
        return cTSheetFormatPr == null ? 8 : (int)cTSheetFormatPr.getBaseColWidth();
    }

    @Override
    public short getDefaultRowHeight() {
        return (short)(this.getDefaultRowHeightInPoints() * 20.0f);
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        CTSheetFormatPr cTSheetFormatPr = this.worksheet.getSheetFormatPr();
        return (float)(cTSheetFormatPr == null ? 0.0 : cTSheetFormatPr.getDefaultRowHeight());
    }

    private CTSheetFormatPr getSheetTypeSheetFormatPr() {
        return this.worksheet.isSetSheetFormatPr() ? this.worksheet.getSheetFormatPr() : this.worksheet.addNewSheetFormatPr();
    }

    @Override
    public CellStyle getColumnStyle(int n) {
        int n2 = this.columnHelper.getColDefaultStyle(n);
        return this.getWorkbook().getCellStyleAt((short)(n2 == -1 ? 0 : n2));
    }

    @Override
    public void setRightToLeft(boolean bl) {
        CTSheetView cTSheetView = this.getDefaultSheetView();
        cTSheetView.setRightToLeft(bl);
    }

    @Override
    public boolean isRightToLeft() {
        CTSheetView cTSheetView = this.getDefaultSheetView();
        return cTSheetView != null && cTSheetView.getRightToLeft();
    }

    @Override
    public boolean getDisplayGuts() {
        CTSheetPr cTSheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr cTOutlinePr = cTSheetPr.getOutlinePr() == null ? CTOutlinePr.Factory.newInstance() : cTSheetPr.getOutlinePr();
        return cTOutlinePr.getShowOutlineSymbols();
    }

    @Override
    public void setDisplayGuts(boolean bl) {
        CTSheetPr cTSheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr cTOutlinePr = cTSheetPr.getOutlinePr() == null ? cTSheetPr.addNewOutlinePr() : cTSheetPr.getOutlinePr();
        cTOutlinePr.setShowOutlineSymbols(bl);
    }

    @Override
    public boolean isDisplayZeros() {
        CTSheetView cTSheetView = this.getDefaultSheetView();
        return cTSheetView == null || cTSheetView.getShowZeros();
    }

    @Override
    public void setDisplayZeros(boolean bl) {
        CTSheetView cTSheetView = this.getSheetTypeSheetView();
        cTSheetView.setShowZeros(bl);
    }

    @Override
    public int getFirstRowNum() {
        return this._rows.isEmpty() ? 0 : this._rows.firstKey();
    }

    @Override
    public boolean getFitToPage() {
        CTSheetPr cTSheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr cTPageSetUpPr = cTSheetPr == null || !cTSheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : cTSheetPr.getPageSetUpPr();
        return cTPageSetUpPr.getFitToPage();
    }

    private CTSheetPr getSheetTypeSheetPr() {
        if (this.worksheet.getSheetPr() == null) {
            this.worksheet.setSheetPr(CTSheetPr.Factory.newInstance());
        }
        return this.worksheet.getSheetPr();
    }

    private CTHeaderFooter getSheetTypeHeaderFooter() {
        if (this.worksheet.getHeaderFooter() == null) {
            this.worksheet.setHeaderFooter(CTHeaderFooter.Factory.newInstance());
        }
        return this.worksheet.getHeaderFooter();
    }

    @Override
    public Footer getFooter() {
        return this.getOddFooter();
    }

    @Override
    public Header getHeader() {
        return this.getOddHeader();
    }

    public Footer getOddFooter() {
        return new XSSFOddFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getEvenFooter() {
        return new XSSFEvenFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getFirstFooter() {
        return new XSSFFirstFooter(this.getSheetTypeHeaderFooter());
    }

    public Header getOddHeader() {
        return new XSSFOddHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getEvenHeader() {
        return new XSSFEvenHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getFirstHeader() {
        return new XSSFFirstHeader(this.getSheetTypeHeaderFooter());
    }

    @Override
    public boolean getHorizontallyCenter() {
        CTPrintOptions cTPrintOptions = this.worksheet.getPrintOptions();
        return cTPrintOptions != null && cTPrintOptions.getHorizontalCentered();
    }

    @Override
    public int getLastRowNum() {
        return this._rows.isEmpty() ? 0 : this._rows.lastKey();
    }

    @Override
    public short getLeftCol() {
        String string = this.worksheet.getSheetViews().getSheetViewArray(0).getTopLeftCell();
        if (string == null) {
            return 0;
        }
        CellReference cellReference = new CellReference(string);
        return cellReference.getCol();
    }

    @Override
    public double getMargin(short s) {
        if (!this.worksheet.isSetPageMargins()) {
            return 0.0;
        }
        CTPageMargins cTPageMargins = this.worksheet.getPageMargins();
        switch (s) {
            case 0: {
                return cTPageMargins.getLeft();
            }
            case 1: {
                return cTPageMargins.getRight();
            }
            case 2: {
                return cTPageMargins.getTop();
            }
            case 3: {
                return cTPageMargins.getBottom();
            }
            case 4: {
                return cTPageMargins.getHeader();
            }
            case 5: {
                return cTPageMargins.getFooter();
            }
        }
        throw new IllegalArgumentException("Unknown margin constant:  " + s);
    }

    @Override
    public void setMargin(short s, double d) {
        CTPageMargins cTPageMargins = this.worksheet.isSetPageMargins() ? this.worksheet.getPageMargins() : this.worksheet.addNewPageMargins();
        switch (s) {
            case 0: {
                cTPageMargins.setLeft(d);
                break;
            }
            case 1: {
                cTPageMargins.setRight(d);
                break;
            }
            case 2: {
                cTPageMargins.setTop(d);
                break;
            }
            case 3: {
                cTPageMargins.setBottom(d);
                break;
            }
            case 4: {
                cTPageMargins.setHeader(d);
                break;
            }
            case 5: {
                cTPageMargins.setFooter(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown margin constant:  " + s);
            }
        }
    }

    @Override
    public CellRangeAddress getMergedRegion(int n) {
        CTMergeCells cTMergeCells = this.worksheet.getMergeCells();
        if (cTMergeCells == null) {
            throw new IllegalStateException("This worksheet does not contain merged regions");
        }
        CTMergeCell cTMergeCell = cTMergeCells.getMergeCellArray(n);
        String string = cTMergeCell.getRef();
        return CellRangeAddress.valueOf(string);
    }

    @Override
    public List<CellRangeAddress> getMergedRegions() {
        CTMergeCells cTMergeCells = this.worksheet.getMergeCells();
        if (cTMergeCells == null) {
            throw new IllegalStateException("This worksheet does not contain merged regions");
        }
        ArrayList<CellRangeAddress> arrayList = new ArrayList<CellRangeAddress>();
        for (CTMergeCell cTMergeCell : cTMergeCells.getMergeCellArray()) {
            String string = cTMergeCell.getRef();
            arrayList.add(CellRangeAddress.valueOf(string));
        }
        return arrayList;
    }

    @Override
    public int getNumMergedRegions() {
        CTMergeCells cTMergeCells = this.worksheet.getMergeCells();
        return cTMergeCells == null ? 0 : cTMergeCells.sizeOfMergeCellArray();
    }

    public int getNumHyperlinks() {
        return this.hyperlinks.size();
    }

    @Override
    public PaneInformation getPaneInformation() {
        CTPane cTPane = this.getDefaultSheetView().getPane();
        if (cTPane == null) {
            return null;
        }
        CellReference cellReference = cTPane.isSetTopLeftCell() ? new CellReference(cTPane.getTopLeftCell()) : null;
        return new PaneInformation((short)cTPane.getXSplit(), (short)cTPane.getYSplit(), (short)(cellReference == null ? 0 : cellReference.getRow()), cellReference == null ? (short)0 : cellReference.getCol(), (byte)(cTPane.getActivePane().intValue() - 1), cTPane.getState() == STPaneState.FROZEN);
    }

    @Override
    public int getPhysicalNumberOfRows() {
        return this._rows.size();
    }

    @Override
    public XSSFPrintSetup getPrintSetup() {
        return new XSSFPrintSetup(this.worksheet);
    }

    @Override
    public boolean getProtect() {
        return this.isSheetLocked();
    }

    @Override
    public void protectSheet(String string) {
        if (string != null) {
            CTSheetProtection cTSheetProtection = this.safeGetProtectionField();
            this.setSheetPassword(string, null);
            cTSheetProtection.setSheet(true);
            cTSheetProtection.setScenarios(true);
            cTSheetProtection.setObjects(true);
        } else {
            this.worksheet.unsetSheetProtection();
        }
    }

    public void setSheetPassword(String string, HashAlgorithm hashAlgorithm) {
        if (string == null && !this.isSheetProtectionEnabled()) {
            return;
        }
        XSSFPaswordHelper.setPassword((XmlObject)this.safeGetProtectionField(), string, hashAlgorithm, null);
    }

    public boolean validateSheetPassword(String string) {
        if (!this.isSheetProtectionEnabled()) {
            return string == null;
        }
        return XSSFPaswordHelper.validatePassword((XmlObject)this.safeGetProtectionField(), string, null);
    }

    @Override
    public XSSFRow getRow(int n) {
        return (XSSFRow)this._rows.get(n);
    }

    @Override
    public int[] getRowBreaks() {
        return this.worksheet.isSetRowBreaks() ? this.getBreaks(this.worksheet.getRowBreaks()) : new int[]{};
    }

    @Override
    public boolean getRowSumsBelow() {
        CTSheetPr cTSheetPr = this.worksheet.getSheetPr();
        CTOutlinePr cTOutlinePr = cTSheetPr != null && cTSheetPr.isSetOutlinePr() ? cTSheetPr.getOutlinePr() : null;
        return cTOutlinePr == null || cTOutlinePr.getSummaryBelow();
    }

    @Override
    public void setRowSumsBelow(boolean bl) {
        this.ensureOutlinePr().setSummaryBelow(bl);
    }

    @Override
    public boolean getRowSumsRight() {
        CTSheetPr cTSheetPr = this.worksheet.getSheetPr();
        CTOutlinePr cTOutlinePr = cTSheetPr != null && cTSheetPr.isSetOutlinePr() ? cTSheetPr.getOutlinePr() : CTOutlinePr.Factory.newInstance();
        return cTOutlinePr.getSummaryRight();
    }

    @Override
    public void setRowSumsRight(boolean bl) {
        this.ensureOutlinePr().setSummaryRight(bl);
    }

    private CTOutlinePr ensureOutlinePr() {
        CTSheetPr cTSheetPr = this.worksheet.isSetSheetPr() ? this.worksheet.getSheetPr() : this.worksheet.addNewSheetPr();
        return cTSheetPr.isSetOutlinePr() ? cTSheetPr.getOutlinePr() : cTSheetPr.addNewOutlinePr();
    }

    @Override
    public boolean getScenarioProtect() {
        return this.worksheet.isSetSheetProtection() && this.worksheet.getSheetProtection().getScenarios();
    }

    @Override
    public short getTopRow() {
        String string = this.getSheetTypeSheetView().getTopLeftCell();
        if (string == null) {
            return 0;
        }
        CellReference cellReference = new CellReference(string);
        return (short)cellReference.getRow();
    }

    @Override
    public boolean getVerticallyCenter() {
        CTPrintOptions cTPrintOptions = this.worksheet.getPrintOptions();
        return cTPrintOptions != null && cTPrintOptions.getVerticalCentered();
    }

    @Override
    public void groupColumn(int n, int n2) {
        this.groupColumn1Based(n + 1, n2 + 1);
    }

    private void groupColumn1Based(int n, int n2) {
        CTCols cTCols = this.worksheet.getColsArray(0);
        CTCol cTCol = CTCol.Factory.newInstance();
        CTCol cTCol2 = this.columnHelper.getColumn1Based(n2, false);
        if (cTCol2 != null) {
            cTCol2 = (CTCol)cTCol2.copy();
        }
        cTCol.setMin((long)n);
        cTCol.setMax((long)n2);
        this.columnHelper.addCleanColIntoCols(cTCols, cTCol);
        CTCol cTCol3 = this.columnHelper.getColumn1Based(n2, false);
        if (cTCol2 != null && cTCol3 != null) {
            this.columnHelper.setColumnAttributes(cTCol2, cTCol3);
        }
        for (int i = n; i <= n2; ++i) {
            CTCol cTCol4 = this.columnHelper.getColumn1Based(i, false);
            short s = cTCol4.getOutlineLevel();
            cTCol4.setOutlineLevel((short)(s + 1));
            i = (int)cTCol4.getMax();
        }
        this.worksheet.setColsArray(0, cTCols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    private void setColWidthAttribute(CTCols cTCols) {
        for (CTCol cTCol : cTCols.getColArray()) {
            if (cTCol.isSetWidth()) continue;
            cTCol.setWidth((double)this.getDefaultColumnWidth());
            cTCol.setCustomWidth(false);
        }
    }

    @Override
    public void groupRow(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            XSSFRow xSSFRow = this.getRow(i);
            if (xSSFRow == null) {
                xSSFRow = this.createRow(i);
            }
            CTRow cTRow = xSSFRow.getCTRow();
            short s = cTRow.getOutlineLevel();
            cTRow.setOutlineLevel((short)(s + 1));
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private short getMaxOutlineLevelRows() {
        int n = 0;
        for (XSSFRow xSSFRow : this._rows.values()) {
            n = Math.max(n, xSSFRow.getCTRow().getOutlineLevel());
        }
        return (short)n;
    }

    private short getMaxOutlineLevelCols() {
        CTCols cTCols = this.worksheet.getColsArray(0);
        int n = 0;
        for (CTCol cTCol : cTCols.getColArray()) {
            n = Math.max(n, cTCol.getOutlineLevel());
        }
        return (short)n;
    }

    @Override
    public boolean isColumnBroken(int n) {
        for (int n2 : this.getColumnBreaks()) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColumnHidden(int n) {
        CTCol cTCol = this.columnHelper.getColumn(n, false);
        return cTCol != null && cTCol.getHidden();
    }

    @Override
    public boolean isDisplayFormulas() {
        return this.getSheetTypeSheetView().getShowFormulas();
    }

    @Override
    public boolean isDisplayGridlines() {
        return this.getSheetTypeSheetView().getShowGridLines();
    }

    @Override
    public void setDisplayGridlines(boolean bl) {
        this.getSheetTypeSheetView().setShowGridLines(bl);
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        return this.getSheetTypeSheetView().getShowRowColHeaders();
    }

    @Override
    public void setDisplayRowColHeadings(boolean bl) {
        this.getSheetTypeSheetView().setShowRowColHeaders(bl);
    }

    @Override
    public boolean isPrintGridlines() {
        CTPrintOptions cTPrintOptions = this.worksheet.getPrintOptions();
        return cTPrintOptions != null && cTPrintOptions.getGridLines();
    }

    @Override
    public void setPrintGridlines(boolean bl) {
        CTPrintOptions cTPrintOptions = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        cTPrintOptions.setGridLines(bl);
    }

    @Override
    public boolean isRowBroken(int n) {
        for (int n2 : this.getRowBreaks()) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private void setBreak(int n, CTPageBreak cTPageBreak, int n2) {
        CTBreak cTBreak = cTPageBreak.addNewBrk();
        cTBreak.setId((long)(n + 1));
        cTBreak.setMan(true);
        cTBreak.setMax((long)n2);
        int n3 = cTPageBreak.sizeOfBrkArray();
        cTPageBreak.setCount((long)n3);
        cTPageBreak.setManualBreakCount((long)n3);
    }

    @Override
    public void setRowBreak(int n) {
        if (!this.isRowBroken(n)) {
            CTPageBreak cTPageBreak = this.worksheet.isSetRowBreaks() ? this.worksheet.getRowBreaks() : this.worksheet.addNewRowBreaks();
            this.setBreak(n, cTPageBreak, SpreadsheetVersion.EXCEL2007.getLastColumnIndex());
        }
    }

    @Override
    public void removeColumnBreak(int n) {
        if (this.worksheet.isSetColBreaks()) {
            this.removeBreak(n, this.worksheet.getColBreaks());
        }
    }

    @Override
    public void removeMergedRegion(int n) {
        if (!this.worksheet.isSetMergeCells()) {
            return;
        }
        CTMergeCells cTMergeCells = this.worksheet.getMergeCells();
        int n2 = cTMergeCells.sizeOfMergeCellArray();
        assert (0 <= n && n < n2);
        if (n2 > 1) {
            cTMergeCells.removeMergeCell(n);
        } else {
            this.worksheet.unsetMergeCells();
        }
    }

    public void removeMergedRegions(Set<Integer> set) {
        if (!this.worksheet.isSetMergeCells()) {
            return;
        }
        CTMergeCells cTMergeCells = this.worksheet.getMergeCells();
        ArrayList<CTMergeCell> arrayList = new ArrayList<CTMergeCell>(cTMergeCells.sizeOfMergeCellArray());
        int n = 0;
        for (CTMergeCell cTMergeCell : cTMergeCells.getMergeCellArray()) {
            if (set.contains(n++)) continue;
            arrayList.add(cTMergeCell);
        }
        if (arrayList.isEmpty()) {
            this.worksheet.unsetMergeCells();
        } else {
            CTMergeCell[] cTMergeCellArray = new CTMergeCell[arrayList.size()];
            cTMergeCells.setMergeCellArray(arrayList.toArray(cTMergeCellArray));
        }
    }

    @Override
    public void removeRow(Row row) {
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        ArrayList<XSSFCell> arrayList = new ArrayList<XSSFCell>();
        for (Cell cell : row) {
            arrayList.add((XSSFCell)cell);
        }
        for (XSSFCell xSSFCell : arrayList) {
            row.removeCell(xSSFCell);
        }
        int n = this._rows.headMap(row.getRowNum()).size();
        this._rows.remove(row.getRowNum());
        this.worksheet.getSheetData().removeRow(n);
    }

    @Override
    public void removeRowBreak(int n) {
        if (this.worksheet.isSetRowBreaks()) {
            this.removeBreak(n, this.worksheet.getRowBreaks());
        }
    }

    @Override
    public void setForceFormulaRecalculation(boolean bl) {
        CTCalcPr cTCalcPr = this.getWorkbook().getCTWorkbook().getCalcPr();
        if (this.worksheet.isSetSheetCalcPr()) {
            CTSheetCalcPr cTSheetCalcPr = this.worksheet.getSheetCalcPr();
            cTSheetCalcPr.setFullCalcOnLoad(bl);
        } else if (bl) {
            CTSheetCalcPr cTSheetCalcPr = this.worksheet.addNewSheetCalcPr();
            cTSheetCalcPr.setFullCalcOnLoad(bl);
        }
        if (bl && cTCalcPr != null && cTCalcPr.getCalcMode() == STCalcMode.MANUAL) {
            cTCalcPr.setCalcMode(STCalcMode.AUTO);
        }
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        if (this.worksheet.isSetSheetCalcPr()) {
            CTSheetCalcPr cTSheetCalcPr = this.worksheet.getSheetCalcPr();
            return cTSheetCalcPr.getFullCalcOnLoad();
        }
        return false;
    }

    @Override
    public Iterator<Row> rowIterator() {
        return this._rows.values().iterator();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    @Override
    public boolean getAutobreaks() {
        CTSheetPr cTSheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr cTPageSetUpPr = cTSheetPr == null || !cTSheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : cTSheetPr.getPageSetUpPr();
        return cTPageSetUpPr.getAutoPageBreaks();
    }

    @Override
    public void setAutobreaks(boolean bl) {
        CTSheetPr cTSheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr cTPageSetUpPr = cTSheetPr.isSetPageSetUpPr() ? cTSheetPr.getPageSetUpPr() : cTSheetPr.addNewPageSetUpPr();
        cTPageSetUpPr.setAutoPageBreaks(bl);
    }

    @Override
    public void setColumnBreak(int n) {
        if (!this.isColumnBroken(n)) {
            CTPageBreak cTPageBreak = this.worksheet.isSetColBreaks() ? this.worksheet.getColBreaks() : this.worksheet.addNewColBreaks();
            this.setBreak(n, cTPageBreak, SpreadsheetVersion.EXCEL2007.getLastRowIndex());
        }
    }

    @Override
    public void setColumnGroupCollapsed(int n, boolean bl) {
        if (bl) {
            this.collapseColumn(n);
        } else {
            this.expandColumn(n);
        }
    }

    private void collapseColumn(int n) {
        CTCol cTCol;
        CTCols cTCols = this.worksheet.getColsArray(0);
        int n2 = this.columnHelper.getIndexOfColumn(cTCols, cTCol = this.columnHelper.getColumn(n, false));
        if (n2 == -1) {
            return;
        }
        int n3 = this.findStartOfColumnOutlineGroup(n2);
        CTCol cTCol2 = cTCols.getColArray(n3);
        int n4 = this.setGroupHidden(n3, cTCol2.getOutlineLevel(), true);
        this.setColumn(n4 + 1, 0, null, null, Boolean.TRUE);
    }

    private void setColumn(int n, Integer n2, Integer n3, Boolean bl, Boolean bl2) {
        boolean bl3;
        CTCols cTCols = this.worksheet.getColsArray(0);
        CTCol cTCol = null;
        for (CTCol cTCol2 : cTCols.getColArray()) {
            long l = cTCol2.getMin();
            long l2 = cTCol2.getMax();
            if (l >= (long)n && l2 <= (long)n) {
                cTCol = cTCol2;
                break;
            }
            if (l > (long)n) break;
        }
        if (cTCol == null) {
            CTCol cTCol3 = CTCol.Factory.newInstance();
            cTCol3.setMin((long)n);
            cTCol3.setMax((long)n);
            this.unsetCollapsed(bl2, cTCol3);
            this.columnHelper.addCleanColIntoCols(cTCols, cTCol3);
            return;
        }
        boolean bl4 = n2 != null && cTCol.getStyle() != (long)n2.intValue();
        int n4 = n3 != null && cTCol.getOutlineLevel() != n3.intValue() ? 1 : 0;
        int n5 = bl != null && cTCol.getHidden() != bl.booleanValue() ? 1 : 0;
        boolean bl5 = bl2 != null && cTCol.getCollapsed() != bl2.booleanValue();
        boolean bl6 = bl3 = n4 != 0 || n5 != 0 || bl5 || bl4;
        if (!bl3) {
            return;
        }
        long l = cTCol.getMin();
        long l3 = cTCol.getMax();
        if (l == (long)n && l3 == (long)n) {
            this.unsetCollapsed(bl2, cTCol);
            return;
        }
        if (l == (long)n || l3 == (long)n) {
            if (l == (long)n) {
                cTCol.setMin((long)(n + 1));
            } else {
                cTCol.setMax((long)(n - 1));
            }
            CTCol cTCol4 = this.columnHelper.cloneCol(cTCols, cTCol);
            cTCol4.setMin((long)n);
            this.unsetCollapsed(bl2, cTCol4);
            this.columnHelper.addCleanColIntoCols(cTCols, cTCol4);
        } else {
            CTCol cTCol5 = this.columnHelper.cloneCol(cTCols, cTCol);
            CTCol cTCol6 = this.columnHelper.cloneCol(cTCols, cTCol);
            int n6 = (int)l3;
            cTCol.setMax((long)(n - 1));
            cTCol5.setMin((long)n);
            cTCol5.setMax((long)n);
            this.unsetCollapsed(bl2, cTCol5);
            this.columnHelper.addCleanColIntoCols(cTCols, cTCol5);
            cTCol6.setMin((long)(n + 1));
            cTCol6.setMax((long)n6);
            this.columnHelper.addCleanColIntoCols(cTCols, cTCol6);
        }
    }

    private void unsetCollapsed(boolean bl, CTCol cTCol) {
        if (bl) {
            cTCol.setCollapsed(bl);
        } else {
            cTCol.unsetCollapsed();
        }
    }

    private int setGroupHidden(int n, int n2, boolean bl) {
        int n3;
        CTCols cTCols = this.worksheet.getColsArray(0);
        CTCol[] cTColArray = cTCols.getColArray();
        CTCol cTCol = cTColArray[n3];
        for (n3 = n; n3 < cTColArray.length; ++n3) {
            cTCol.setHidden(bl);
            if (n3 + 1 >= cTColArray.length) continue;
            CTCol cTCol2 = cTColArray[n3 + 1];
            if (!this.isAdjacentBefore(cTCol, cTCol2) || cTCol2.getOutlineLevel() < n2) break;
            cTCol = cTCol2;
        }
        return (int)cTCol.getMax();
    }

    private boolean isAdjacentBefore(CTCol cTCol, CTCol cTCol2) {
        return cTCol.getMax() == cTCol2.getMin() - 1L;
    }

    private int findStartOfColumnOutlineGroup(int n) {
        CTCol cTCol;
        int n2;
        CTCols cTCols = this.worksheet.getColsArray(0);
        CTCol[] cTColArray = cTCols.getColArray();
        CTCol cTCol2 = cTColArray[n];
        short s = cTCol2.getOutlineLevel();
        for (n2 = n; n2 != 0 && this.isAdjacentBefore(cTCol = cTColArray[n2 - 1], cTCol2) && cTCol.getOutlineLevel() >= s; --n2) {
            cTCol2 = cTCol;
        }
        return n2;
    }

    private int findEndOfColumnOutlineGroup(int n) {
        CTCol cTCol;
        int n2;
        CTCols cTCols = this.worksheet.getColsArray(0);
        CTCol[] cTColArray = cTCols.getColArray();
        CTCol cTCol2 = cTColArray[n];
        short s = cTCol2.getOutlineLevel();
        int n3 = cTColArray.length - 1;
        for (n2 = n; n2 < n3 && this.isAdjacentBefore(cTCol2, cTCol = cTColArray[n2 + 1]) && cTCol.getOutlineLevel() >= s; ++n2) {
            cTCol2 = cTCol;
        }
        return n2;
    }

    private void expandColumn(int n) {
        CTCols cTCols = this.worksheet.getColsArray(0);
        CTCol cTCol = this.columnHelper.getColumn(n, false);
        int n2 = this.columnHelper.getIndexOfColumn(cTCols, cTCol);
        int n3 = this.findColInfoIdx((int)cTCol.getMax(), n2);
        if (n3 == -1) {
            return;
        }
        if (!this.isColumnGroupCollapsed(n3)) {
            return;
        }
        int n4 = this.findStartOfColumnOutlineGroup(n3);
        int n5 = this.findEndOfColumnOutlineGroup(n3);
        CTCol[] cTColArray = cTCols.getColArray();
        CTCol cTCol2 = cTColArray[n5];
        if (!this.isColumnGroupHiddenByParent(n3)) {
            short s = cTCol2.getOutlineLevel();
            boolean bl = false;
            for (int i = n4; i <= n5; ++i) {
                CTCol cTCol3 = cTColArray[i];
                if (s == cTCol3.getOutlineLevel()) {
                    cTCol3.unsetHidden();
                    if (!bl) continue;
                    bl = false;
                    cTCol3.setCollapsed(true);
                    continue;
                }
                bl = true;
            }
        }
        this.setColumn((int)cTCol2.getMax() + 1, null, null, Boolean.FALSE, Boolean.FALSE);
    }

    private boolean isColumnGroupHiddenByParent(int n) {
        CTCol cTCol;
        CTCol cTCol2;
        CTCol[] cTColArray;
        CTCols cTCols = this.worksheet.getColsArray(0);
        short s = 0;
        boolean bl = false;
        int n2 = this.findEndOfColumnOutlineGroup(n);
        if (n2 < (cTColArray = cTCols.getColArray()).length && this.isAdjacentBefore(cTColArray[n2], cTCol2 = cTColArray[n2 + 1])) {
            s = cTCol2.getOutlineLevel();
            bl = cTCol2.getHidden();
        }
        short s2 = 0;
        boolean bl2 = false;
        int n3 = this.findStartOfColumnOutlineGroup(n);
        if (n3 > 0 && this.isAdjacentBefore(cTCol = cTColArray[n3 - 1], cTColArray[n3])) {
            s2 = cTCol.getOutlineLevel();
            bl2 = cTCol.getHidden();
        }
        if (s > s2) {
            return bl;
        }
        return bl2;
    }

    private int findColInfoIdx(int n, int n2) {
        CTCols cTCols = this.worksheet.getColsArray(0);
        if (n < 0) {
            throw new IllegalArgumentException("column parameter out of range: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("fromIdx parameter out of range: " + n2);
        }
        CTCol[] cTColArray = cTCols.getColArray();
        for (int i = n2; i < cTColArray.length; ++i) {
            CTCol cTCol = cTColArray[i];
            if (this.containsColumn(cTCol, n)) {
                return i;
            }
            if (cTCol.getMin() > (long)n2) break;
        }
        return -1;
    }

    private boolean containsColumn(CTCol cTCol, int n) {
        return cTCol.getMin() <= (long)n && (long)n <= cTCol.getMax();
    }

    private boolean isColumnGroupCollapsed(int n) {
        CTCols cTCols = this.worksheet.getColsArray(0);
        CTCol[] cTColArray = cTCols.getColArray();
        int n2 = this.findEndOfColumnOutlineGroup(n);
        int n3 = n2 + 1;
        if (n3 >= cTColArray.length) {
            return false;
        }
        CTCol cTCol = cTColArray[n2];
        CTCol cTCol2 = cTColArray[n3];
        if (!this.isAdjacentBefore(cTCol, cTCol2)) {
            return false;
        }
        return cTCol2.getCollapsed();
    }

    @Override
    public void setColumnHidden(int n, boolean bl) {
        this.columnHelper.setColHidden(n, bl);
    }

    @Override
    public void setColumnWidth(int n, int n2) {
        if (n2 > 65280) {
            throw new IllegalArgumentException("The maximum column width for an individual cell is 255 characters.");
        }
        this.columnHelper.setColWidth(n, (double)n2 / 256.0);
        this.columnHelper.setCustomWidth(n, true);
    }

    @Override
    public void setDefaultColumnStyle(int n, CellStyle cellStyle) {
        this.columnHelper.setColDefaultStyle((long)n, cellStyle);
    }

    @Override
    public void setDefaultColumnWidth(int n) {
        this.getSheetTypeSheetFormatPr().setBaseColWidth((long)n);
    }

    @Override
    public void setDefaultRowHeight(short s) {
        this.setDefaultRowHeightInPoints((float)s / 20.0f);
    }

    @Override
    public void setDefaultRowHeightInPoints(float f) {
        CTSheetFormatPr cTSheetFormatPr = this.getSheetTypeSheetFormatPr();
        cTSheetFormatPr.setDefaultRowHeight((double)f);
        cTSheetFormatPr.setCustomHeight(true);
    }

    @Override
    public void setDisplayFormulas(boolean bl) {
        this.getSheetTypeSheetView().setShowFormulas(bl);
    }

    private CTSheetView getSheetTypeSheetView() {
        if (this.getDefaultSheetView() == null) {
            this.getSheetTypeSheetViews().setSheetViewArray(0, CTSheetView.Factory.newInstance());
        }
        return this.getDefaultSheetView();
    }

    @Override
    public void setFitToPage(boolean bl) {
        this.getSheetTypePageSetUpPr().setFitToPage(bl);
    }

    @Override
    public void setHorizontallyCenter(boolean bl) {
        CTPrintOptions cTPrintOptions = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        cTPrintOptions.setHorizontalCentered(bl);
    }

    @Override
    public void setVerticallyCenter(boolean bl) {
        CTPrintOptions cTPrintOptions = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        cTPrintOptions.setVerticalCentered(bl);
    }

    @Override
    public void setRowGroupCollapsed(int n, boolean bl) {
        if (bl) {
            this.collapseRow(n);
        } else {
            this.expandRow(n);
        }
    }

    private void collapseRow(int n) {
        XSSFRow xSSFRow = this.getRow(n);
        if (xSSFRow != null) {
            int n2 = this.findStartOfRowOutlineGroup(n);
            int n3 = this.writeHidden(xSSFRow, n2, true);
            if (this.getRow(n3) != null) {
                this.getRow(n3).getCTRow().setCollapsed(true);
            } else {
                XSSFRow xSSFRow2 = this.createRow(n3);
                xSSFRow2.getCTRow().setCollapsed(true);
            }
        }
    }

    private int findStartOfRowOutlineGroup(int n) {
        short s = this.getRow(n).getCTRow().getOutlineLevel();
        int n2 = n;
        while (this.getRow(n2) != null) {
            if (this.getRow(n2).getCTRow().getOutlineLevel() < s) {
                return n2 + 1;
            }
            --n2;
        }
        return n2;
    }

    private int writeHidden(XSSFRow xSSFRow, int n, boolean bl) {
        short s = xSSFRow.getCTRow().getOutlineLevel();
        Iterator<Row> iterator = this.rowIterator();
        while (iterator.hasNext()) {
            xSSFRow = (XSSFRow)iterator.next();
            if (xSSFRow.getRowNum() < n || xSSFRow.getCTRow().getOutlineLevel() < s) continue;
            xSSFRow.getCTRow().setHidden(bl);
            ++n;
        }
        return n;
    }

    private void expandRow(int n) {
        CTRow cTRow;
        if (n == -1) {
            return;
        }
        XSSFRow xSSFRow = this.getRow(n);
        if (!xSSFRow.getCTRow().isSetHidden()) {
            return;
        }
        int n2 = this.findStartOfRowOutlineGroup(n);
        int n3 = this.findEndOfRowOutlineGroup(n);
        short s = xSSFRow.getCTRow().getOutlineLevel();
        if (!this.isRowGroupHiddenByParent(n)) {
            for (int i = n2; i < n3; ++i) {
                if (s == this.getRow(i).getCTRow().getOutlineLevel()) {
                    this.getRow(i).getCTRow().unsetHidden();
                    continue;
                }
                if (this.isRowGroupCollapsed(i)) continue;
                this.getRow(i).getCTRow().unsetHidden();
            }
        }
        if ((cTRow = this.getRow(n3).getCTRow()).getCollapsed()) {
            cTRow.unsetCollapsed();
        }
    }

    public int findEndOfRowOutlineGroup(int n) {
        int n2;
        short s = this.getRow(n).getCTRow().getOutlineLevel();
        for (n2 = n; n2 < this.getLastRowNum() && this.getRow(n2) != null && this.getRow(n2).getCTRow().getOutlineLevel() >= s; ++n2) {
        }
        return n2;
    }

    private boolean isRowGroupHiddenByParent(int n) {
        boolean bl;
        short s;
        boolean bl2;
        short s2;
        int n2 = this.findEndOfRowOutlineGroup(n);
        if (this.getRow(n2) == null) {
            s2 = 0;
            bl2 = false;
        } else {
            s2 = this.getRow(n2).getCTRow().getOutlineLevel();
            bl2 = this.getRow(n2).getCTRow().getHidden();
        }
        int n3 = this.findStartOfRowOutlineGroup(n);
        if (n3 < 0 || this.getRow(n3) == null) {
            s = 0;
            bl = false;
        } else {
            s = this.getRow(n3).getCTRow().getOutlineLevel();
            bl = this.getRow(n3).getCTRow().getHidden();
        }
        if (s2 > s) {
            return bl2;
        }
        return bl;
    }

    private boolean isRowGroupCollapsed(int n) {
        int n2 = this.findEndOfRowOutlineGroup(n) + 1;
        if (this.getRow(n2) == null) {
            return false;
        }
        return this.getRow(n2).getCTRow().getCollapsed();
    }

    @Override
    public void setZoom(int n, int n2) {
        int n3 = 100 * n / n2;
        this.setZoom(n3);
    }

    public void setZoom(int n) {
        if (n < 10 || n > 400) {
            throw new IllegalArgumentException("Valid scale values range from 10 to 400");
        }
        this.getSheetTypeSheetView().setZoomScale((long)n);
    }

    @Override
    public void shiftRows(int n, int n2, int n3) {
        this.shiftRows(n, n2, n3, false, false);
    }

    @Override
    public void shiftRows(int n, int n2, final int n3, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        int n4;
        Object object3;
        XSSFVMLDrawing xSSFVMLDrawing = this.getVMLDrawing(false);
        Object object4 = this.rowIterator();
        while (object4.hasNext()) {
            object3 = (XSSFRow)object4.next();
            int n5 = ((XSSFRow)object3).getRowNum();
            if (!this.shouldRemoveRow(n, n2, n3, n5)) continue;
            n4 = this._rows.headMap(((XSSFRow)object3).getRowNum()).size();
            this.worksheet.getSheetData().removeRow(n4);
            object4.remove();
            if (this.sheetComments == null) continue;
            CTCommentList cTCommentList = this.sheetComments.getCTComments().getCommentList();
            for (CTCommentList cTCommentList2 : cTCommentList.getCommentArray()) {
                String string = cTCommentList2.getRef();
                object2 = new CellReference(string);
                if (((CellReference)object2).getRow() != n5) continue;
                this.sheetComments.removeComment(string);
                xSSFVMLDrawing.removeCommentShape(((CellReference)object2).getRow(), ((CellReference)object2).getCol());
            }
        }
        object4 = new TreeMap(new Comparator<XSSFComment>(){

            @Override
            public int compare(XSSFComment xSSFComment, XSSFComment xSSFComment2) {
                int n;
                int n2 = xSSFComment.getRow();
                if (n2 == (n = xSSFComment2.getRow())) {
                    return xSSFComment.hashCode() - xSSFComment2.hashCode();
                }
                if (n3 > 0) {
                    return n2 < n ? 1 : -1;
                }
                return n2 > n ? 1 : -1;
            }
        });
        object3 = this.rowIterator();
        while (object3.hasNext()) {
            int n6;
            XSSFRow xSSFRow = (XSSFRow)object3.next();
            n4 = xSSFRow.getRowNum();
            if (this.sheetComments != null && (n6 = this.shiftedRowNum(n, n2, n3, n4)) != n4) {
                object = this.sheetComments.getCTComments().getCommentList();
                for (CTComment cTComment : object.getCommentArray()) {
                    object2 = cTComment.getRef();
                    CellReference cellReference = new CellReference((String)object2);
                    if (cellReference.getRow() != n4) continue;
                    XSSFComment xSSFComment = new XSSFComment(this.sheetComments, cTComment, xSSFVMLDrawing == null ? null : xSSFVMLDrawing.findCommentShape(n4, cellReference.getCol()));
                    object4.put(xSSFComment, n6);
                }
            }
            if (n4 < n || n4 > n2) continue;
            if (!bl) {
                xSSFRow.setHeight((short)-1);
            }
            xSSFRow.shift(n3);
        }
        for (Map.Entry entry : object4.entrySet()) {
            ((XSSFComment)entry.getKey()).setRow((Integer)entry.getValue());
        }
        object3 = new XSSFRowShifter(this);
        int n7 = this.getWorkbook().getSheetIndex(this);
        String string = this.getWorkbook().getSheetName(n7);
        FormulaShifter formulaShifter = FormulaShifter.createForRowShift(n7, string, n, n2, n3);
        ((XSSFRowShifter)object3).updateNamedRanges(formulaShifter);
        ((XSSFRowShifter)object3).updateFormulas(formulaShifter);
        ((XSSFRowShifter)object3).shiftMerged(n, n2, n3);
        ((XSSFRowShifter)object3).updateConditionalFormatting(formulaShifter);
        object = new TreeMap();
        for (XSSFRow xSSFRow : this._rows.values()) {
            object.put(xSSFRow.getRowNum(), xSSFRow);
        }
        this._rows = object;
    }

    private int shiftedRowNum(int n, int n2, int n3, int n4) {
        if (n4 < n && (n3 > 0 || n - n4 > n3)) {
            return n4;
        }
        if (n4 > n2 && (n3 < 0 || n4 - n2 > n3)) {
            return n4;
        }
        if (n4 < n) {
            return n4 + (n2 - n);
        }
        if (n4 > n2) {
            return n4 - (n2 - n);
        }
        return n4 + n3;
    }

    @Override
    public void showInPane(int n, int n2) {
        CellReference cellReference = new CellReference(n, n2);
        String string = cellReference.formatAsString();
        this.getPane().setTopLeftCell(string);
    }

    @Override
    @Deprecated
    public void showInPane(short s, short s2) {
        this.showInPane((int)s, (int)s2);
    }

    @Override
    public void ungroupColumn(int n, int n2) {
        CTCols cTCols = this.worksheet.getColsArray(0);
        for (int i = n; i <= n2; ++i) {
            CTCol cTCol = this.columnHelper.getColumn(i, false);
            if (cTCol == null) continue;
            short s = cTCol.getOutlineLevel();
            cTCol.setOutlineLevel((short)(s - 1));
            i = (int)cTCol.getMax();
            if (cTCol.getOutlineLevel() > 0) continue;
            int n3 = this.columnHelper.getIndexOfColumn(cTCols, cTCol);
            this.worksheet.getColsArray(0).removeCol(n3);
        }
        this.worksheet.setColsArray(0, cTCols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    @Override
    public void ungroupRow(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            XSSFRow xSSFRow = this.getRow(i);
            if (xSSFRow == null) continue;
            CTRow cTRow = xSSFRow.getCTRow();
            short s = cTRow.getOutlineLevel();
            cTRow.setOutlineLevel((short)(s - 1));
            if (s != 1 || xSSFRow.getFirstCellNum() != -1) continue;
            this.removeRow(xSSFRow);
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private void setSheetFormatPrOutlineLevelRow() {
        short s = this.getMaxOutlineLevelRows();
        this.getSheetTypeSheetFormatPr().setOutlineLevelRow(s);
    }

    private void setSheetFormatPrOutlineLevelCol() {
        short s = this.getMaxOutlineLevelCols();
        this.getSheetTypeSheetFormatPr().setOutlineLevelCol(s);
    }

    private CTSheetViews getSheetTypeSheetViews() {
        if (this.worksheet.getSheetViews() == null) {
            this.worksheet.setSheetViews(CTSheetViews.Factory.newInstance());
            this.worksheet.getSheetViews().addNewSheetView();
        }
        return this.worksheet.getSheetViews();
    }

    @Override
    public boolean isSelected() {
        CTSheetView cTSheetView = this.getDefaultSheetView();
        return cTSheetView != null && cTSheetView.getTabSelected();
    }

    @Override
    public void setSelected(boolean bl) {
        CTSheetViews cTSheetViews = this.getSheetTypeSheetViews();
        for (CTSheetView cTSheetView : cTSheetViews.getSheetViewArray()) {
            cTSheetView.setTabSelected(bl);
        }
    }

    @Deprecated
    public static void setCellComment(String string, XSSFComment xSSFComment) {
        CellReference cellReference = new CellReference(string);
        xSSFComment.setRow(cellReference.getRow());
        xSSFComment.setColumn(cellReference.getCol());
    }

    @Internal
    public void addHyperlink(XSSFHyperlink xSSFHyperlink) {
        this.hyperlinks.add(xSSFHyperlink);
    }

    @Internal
    public void removeHyperlink(int n, int n2) {
        String string = new CellReference(n, n2).formatAsString();
        Iterator<XSSFHyperlink> iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            XSSFHyperlink xSSFHyperlink = iterator.next();
            if (!xSSFHyperlink.getCellRef().equals(string)) continue;
            iterator.remove();
            return;
        }
    }

    public String getActiveCell() {
        return this.getSheetTypeSelection().getActiveCell();
    }

    public void setActiveCell(String string) {
        CTSelection cTSelection = this.getSheetTypeSelection();
        cTSelection.setActiveCell(string);
        cTSelection.setSqref(Arrays.asList(string));
    }

    public boolean hasComments() {
        return this.sheetComments != null && this.sheetComments.getNumberOfComments() > 0;
    }

    protected int getNumberOfComments() {
        return this.sheetComments == null ? 0 : this.sheetComments.getNumberOfComments();
    }

    private CTSelection getSheetTypeSelection() {
        if (this.getSheetTypeSheetView().sizeOfSelectionArray() == 0) {
            this.getSheetTypeSheetView().insertNewSelection(0);
        }
        return this.getSheetTypeSheetView().getSelectionArray(0);
    }

    private CTSheetView getDefaultSheetView() {
        int n;
        CTSheetViews cTSheetViews = this.getSheetTypeSheetViews();
        int n2 = n = cTSheetViews == null ? 0 : cTSheetViews.sizeOfSheetViewArray();
        if (n == 0) {
            return null;
        }
        return cTSheetViews.getSheetViewArray(n - 1);
    }

    protected CommentsTable getCommentsTable(boolean bl) {
        if (this.sheetComments == null && bl) {
            try {
                this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), (int)this.sheet.getSheetId());
            }
            catch (PartAlreadyExistsException partAlreadyExistsException) {
                this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), -1);
            }
        }
        return this.sheetComments;
    }

    private CTPageSetUpPr getSheetTypePageSetUpPr() {
        CTSheetPr cTSheetPr = this.getSheetTypeSheetPr();
        return cTSheetPr.isSetPageSetUpPr() ? cTSheetPr.getPageSetUpPr() : cTSheetPr.addNewPageSetUpPr();
    }

    private boolean shouldRemoveRow(int n, int n2, int n3, int n4) {
        if (n4 >= n + n3 && n4 <= n2 + n3) {
            if (n3 > 0 && n4 > n2) {
                return true;
            }
            if (n3 < 0 && n4 < n) {
                return true;
            }
        }
        return false;
    }

    private CTPane getPane() {
        if (this.getDefaultSheetView().getPane() == null) {
            this.getDefaultSheetView().addNewPane();
        }
        return this.getDefaultSheetView().getPane();
    }

    @Internal
    public CTCellFormula getSharedFormula(int n) {
        return this.sharedFormulas.get(n);
    }

    void onReadCell(XSSFCell xSSFCell) {
        CTCell cTCell = xSSFCell.getCTCell();
        CTCellFormula cTCellFormula = cTCell.getF();
        if (cTCellFormula != null && cTCellFormula.getT() == STCellFormulaType.SHARED && cTCellFormula.isSetRef() && cTCellFormula.getStringValue() != null) {
            CTCellFormula cTCellFormula2 = (CTCellFormula)cTCellFormula.copy();
            CellRangeAddress cellRangeAddress = CellRangeAddress.valueOf(cTCellFormula2.getRef());
            CellReference cellReference = new CellReference(xSSFCell);
            if (cellReference.getCol() > cellRangeAddress.getFirstColumn() || cellReference.getRow() > cellRangeAddress.getFirstRow()) {
                String string = new CellRangeAddress(Math.max(cellReference.getRow(), cellRangeAddress.getFirstRow()), cellRangeAddress.getLastRow(), Math.max(cellReference.getCol(), cellRangeAddress.getFirstColumn()), cellRangeAddress.getLastColumn()).formatAsString();
                cTCellFormula2.setRef(string);
            }
            this.sharedFormulas.put((int)cTCellFormula.getSi(), cTCellFormula2);
        }
        if (cTCellFormula != null && cTCellFormula.getT() == STCellFormulaType.ARRAY && cTCellFormula.getRef() != null) {
            this.arrayFormulas.add(CellRangeAddress.valueOf(cTCellFormula.getRef()));
        }
    }

    @Override
    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.write(outputStream);
        outputStream.close();
    }

    protected void write(OutputStream outputStream) throws IOException {
        Object object;
        boolean bl = false;
        if (this.worksheet.sizeOfColsArray() == 1) {
            object = this.worksheet.getColsArray(0);
            if (object.sizeOfColArray() == 0) {
                bl = true;
                this.worksheet.setColsArray(null);
            } else {
                this.setColWidthAttribute((CTCols)object);
            }
        }
        if (this.hyperlinks.size() > 0) {
            if (this.worksheet.getHyperlinks() == null) {
                this.worksheet.addNewHyperlinks();
            }
            object = new CTHyperlink[this.hyperlinks.size()];
            for (int i = 0; i < ((Object)object).length; ++i) {
                XSSFHyperlink xSSFHyperlink = this.hyperlinks.get(i);
                xSSFHyperlink.generateRelationIfNeeded(this.getPackagePart());
                object[i] = xSSFHyperlink.getCTHyperlink();
            }
            this.worksheet.getHyperlinks().setHyperlinkArray((CTHyperlink[])object);
        }
        for (XSSFRow xSSFRow : this._rows.values()) {
            xSSFRow.onDocumentWrite();
        }
        object = new XmlOptions(DEFAULT_XML_OPTIONS);
        object.setSaveSyntheticDocumentElement(new QName(CTWorksheet.type.getName().getNamespaceURI(), "worksheet"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        object.setSaveSuggestedPrefixes(hashMap);
        this.worksheet.save(outputStream, (XmlOptions)object);
        if (bl) {
            this.worksheet.addNewCols();
        }
    }

    public boolean isAutoFilterLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getAutoFilter();
    }

    public boolean isDeleteColumnsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getDeleteColumns();
    }

    public boolean isDeleteRowsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getDeleteRows();
    }

    public boolean isFormatCellsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getFormatCells();
    }

    public boolean isFormatColumnsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getFormatColumns();
    }

    public boolean isFormatRowsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getFormatRows();
    }

    public boolean isInsertColumnsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getInsertColumns();
    }

    public boolean isInsertHyperlinksLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getInsertHyperlinks();
    }

    public boolean isInsertRowsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getInsertRows();
    }

    public boolean isPivotTablesLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getPivotTables();
    }

    public boolean isSortLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getSort();
    }

    public boolean isObjectsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getObjects();
    }

    public boolean isScenariosLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getScenarios();
    }

    public boolean isSelectLockedCellsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getSelectLockedCells();
    }

    public boolean isSelectUnlockedCellsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getSelectUnlockedCells();
    }

    public boolean isSheetLocked() {
        return this.worksheet.isSetSheetProtection() && this.safeGetProtectionField().getSheet();
    }

    public void enableLocking() {
        this.safeGetProtectionField().setSheet(true);
    }

    public void disableLocking() {
        this.safeGetProtectionField().setSheet(false);
    }

    public void lockAutoFilter() {
        this.lockAutoFilter(true);
    }

    public void lockAutoFilter(boolean bl) {
        this.safeGetProtectionField().setAutoFilter(bl);
    }

    public void lockDeleteColumns() {
        this.lockDeleteColumns(true);
    }

    public void lockDeleteColumns(boolean bl) {
        this.safeGetProtectionField().setDeleteColumns(bl);
    }

    public void lockDeleteRows() {
        this.lockDeleteRows(true);
    }

    public void lockDeleteRows(boolean bl) {
        this.safeGetProtectionField().setDeleteRows(bl);
    }

    public void lockFormatCells() {
        this.lockFormatCells(true);
    }

    public void lockFormatCells(boolean bl) {
        this.safeGetProtectionField().setFormatCells(bl);
    }

    public void lockFormatColumns() {
        this.lockFormatColumns(true);
    }

    public void lockFormatColumns(boolean bl) {
        this.safeGetProtectionField().setFormatColumns(bl);
    }

    public void lockFormatRows() {
        this.lockFormatRows(true);
    }

    public void lockFormatRows(boolean bl) {
        this.safeGetProtectionField().setFormatRows(bl);
    }

    public void lockInsertColumns() {
        this.lockInsertColumns(true);
    }

    public void lockInsertColumns(boolean bl) {
        this.safeGetProtectionField().setInsertColumns(bl);
    }

    public void lockInsertHyperlinks() {
        this.lockInsertHyperlinks(true);
    }

    public void lockInsertHyperlinks(boolean bl) {
        this.safeGetProtectionField().setInsertHyperlinks(bl);
    }

    public void lockInsertRows() {
        this.lockInsertRows(true);
    }

    public void lockInsertRows(boolean bl) {
        this.safeGetProtectionField().setInsertRows(bl);
    }

    public void lockPivotTables() {
        this.lockPivotTables(true);
    }

    public void lockPivotTables(boolean bl) {
        this.safeGetProtectionField().setPivotTables(bl);
    }

    public void lockSort() {
        this.lockSort(true);
    }

    public void lockSort(boolean bl) {
        this.safeGetProtectionField().setSort(bl);
    }

    public void lockObjects() {
        this.lockObjects(true);
    }

    public void lockObjects(boolean bl) {
        this.safeGetProtectionField().setObjects(bl);
    }

    public void lockScenarios() {
        this.lockScenarios(true);
    }

    public void lockScenarios(boolean bl) {
        this.safeGetProtectionField().setScenarios(bl);
    }

    public void lockSelectLockedCells() {
        this.lockSelectLockedCells(true);
    }

    public void lockSelectLockedCells(boolean bl) {
        this.safeGetProtectionField().setSelectLockedCells(bl);
    }

    public void lockSelectUnlockedCells() {
        this.lockSelectUnlockedCells(true);
    }

    public void lockSelectUnlockedCells(boolean bl) {
        this.safeGetProtectionField().setSelectUnlockedCells(bl);
    }

    private CTSheetProtection safeGetProtectionField() {
        if (!this.isSheetProtectionEnabled()) {
            return this.worksheet.addNewSheetProtection();
        }
        return this.worksheet.getSheetProtection();
    }

    boolean isSheetProtectionEnabled() {
        return this.worksheet.isSetSheetProtection();
    }

    boolean isCellInArrayFormulaContext(XSSFCell xSSFCell) {
        for (CellRangeAddress cellRangeAddress : this.arrayFormulas) {
            if (!cellRangeAddress.isInRange(xSSFCell.getRowIndex(), xSSFCell.getColumnIndex())) continue;
            return true;
        }
        return false;
    }

    XSSFCell getFirstCellInArrayFormula(XSSFCell xSSFCell) {
        for (CellRangeAddress cellRangeAddress : this.arrayFormulas) {
            if (!cellRangeAddress.isInRange(xSSFCell.getRowIndex(), xSSFCell.getColumnIndex())) continue;
            return this.getRow(cellRangeAddress.getFirstRow()).getCell(cellRangeAddress.getFirstColumn());
        }
        return null;
    }

    private CellRange<XSSFCell> getCellRange(CellRangeAddress cellRangeAddress) {
        int n = cellRangeAddress.getFirstRow();
        int n2 = cellRangeAddress.getFirstColumn();
        int n3 = cellRangeAddress.getLastRow();
        int n4 = cellRangeAddress.getLastColumn();
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        ArrayList<XSSFCell> arrayList = new ArrayList<XSSFCell>(n5 * n6);
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                XSSFCell xSSFCell;
                XSSFRow xSSFRow = this.getRow(i);
                if (xSSFRow == null) {
                    xSSFRow = this.createRow(i);
                }
                if ((xSSFCell = xSSFRow.getCell(j)) == null) {
                    xSSFCell = xSSFRow.createCell(j);
                }
                arrayList.add(xSSFCell);
            }
        }
        return SSCellRange.create(n, n2, n5, n6, arrayList, XSSFCell.class);
    }

    public CellRange<XSSFCell> setArrayFormula(String string, CellRangeAddress cellRangeAddress) {
        CellRange<XSSFCell> cellRange = this.getCellRange(cellRangeAddress);
        XSSFCell xSSFCell = cellRange.getTopLeftCell();
        xSSFCell.setCellArrayFormula(string, cellRangeAddress);
        this.arrayFormulas.add(cellRangeAddress);
        return cellRange;
    }

    public CellRange<XSSFCell> removeArrayFormula(Cell cell) {
        if (cell.getSheet() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this sheet.");
        }
        for (CellRangeAddress cellRangeAddress : this.arrayFormulas) {
            if (!cellRangeAddress.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            this.arrayFormulas.remove(cellRangeAddress);
            CellRange<XSSFCell> cellRange = this.getCellRange(cellRangeAddress);
            for (XSSFCell xSSFCell : cellRange) {
                xSSFCell.setCellType(3);
            }
            return cellRange;
        }
        String string = ((XSSFCell)cell).getCTCell().getR();
        throw new IllegalArgumentException("Cell " + (String)string + " is not part of an array formula.");
    }

    @Override
    public DataValidationHelper getDataValidationHelper() {
        return this.dataValidationHelper;
    }

    public List<XSSFDataValidation> getDataValidations() {
        ArrayList<XSSFDataValidation> arrayList = new ArrayList<XSSFDataValidation>();
        CTDataValidations cTDataValidations = this.worksheet.getDataValidations();
        if (cTDataValidations != null && cTDataValidations.getCount() > 0L) {
            for (CTDataValidation cTDataValidation : cTDataValidations.getDataValidationArray()) {
                CellRangeAddressList cellRangeAddressList = new CellRangeAddressList();
                List list = cTDataValidation.getSqref();
                for (String string : list) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(" ")) {
                        String[] stringArray2 = string2.split(":");
                        CellReference cellReference = new CellReference(stringArray2[0]);
                        CellReference cellReference2 = stringArray2.length > 1 ? new CellReference(stringArray2[1]) : cellReference;
                        CellRangeAddress cellRangeAddress = new CellRangeAddress(cellReference.getRow(), cellReference2.getRow(), cellReference.getCol(), cellReference2.getCol());
                        cellRangeAddressList.addCellRangeAddress(cellRangeAddress);
                    }
                }
                XSSFDataValidation xSSFDataValidation = new XSSFDataValidation(cellRangeAddressList, cTDataValidation);
                arrayList.add(xSSFDataValidation);
            }
        }
        return arrayList;
    }

    @Override
    public void addValidationData(DataValidation dataValidation) {
        XSSFDataValidation xSSFDataValidation = (XSSFDataValidation)dataValidation;
        CTDataValidations cTDataValidations = this.worksheet.getDataValidations();
        if (cTDataValidations == null) {
            cTDataValidations = this.worksheet.addNewDataValidations();
        }
        int n = cTDataValidations.sizeOfDataValidationArray();
        CTDataValidation cTDataValidation = cTDataValidations.addNewDataValidation();
        cTDataValidation.set((XmlObject)xSSFDataValidation.getCtDdataValidation());
        cTDataValidations.setCount((long)(n + 1));
    }

    @Override
    public XSSFAutoFilter setAutoFilter(CellRangeAddress cellRangeAddress) {
        CTAutoFilter cTAutoFilter = this.worksheet.getAutoFilter();
        if (cTAutoFilter == null) {
            cTAutoFilter = this.worksheet.addNewAutoFilter();
        }
        CellRangeAddress cellRangeAddress2 = new CellRangeAddress(cellRangeAddress.getFirstRow(), cellRangeAddress.getLastRow(), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn());
        String string = cellRangeAddress2.formatAsString();
        cTAutoFilter.setRef(string);
        XSSFWorkbook xSSFWorkbook = this.getWorkbook();
        int n = this.getWorkbook().getSheetIndex(this);
        XSSFName xSSFName = xSSFWorkbook.getBuiltInName("_xlnm._FilterDatabase", n);
        if (xSSFName == null) {
            xSSFName = xSSFWorkbook.createBuiltInName("_xlnm._FilterDatabase", n);
        }
        xSSFName.getCTName().setHidden(true);
        CellReference cellReference = new CellReference(this.getSheetName(), cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn(), true, true);
        CellReference cellReference2 = new CellReference(null, cellRangeAddress.getLastRow(), cellRangeAddress.getLastColumn(), true, true);
        String string2 = cellReference.formatAsString() + ":" + cellReference2.formatAsString();
        xSSFName.setRefersToFormula(string2);
        return new XSSFAutoFilter(this);
    }

    public XSSFTable createTable() {
        if (!this.worksheet.isSetTableParts()) {
            this.worksheet.addNewTableParts();
        }
        CTTableParts cTTableParts = this.worksheet.getTableParts();
        CTTablePart cTTablePart = cTTableParts.addNewTablePart();
        int n = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.TABLE.getContentType()).size() + 1;
        XSSFTable xSSFTable = (XSSFTable)this.createRelationship(XSSFRelation.TABLE, XSSFFactory.getInstance(), n);
        cTTablePart.setId(xSSFTable.getPackageRelationship().getId());
        this.tables.put(cTTablePart.getId(), xSSFTable);
        return xSSFTable;
    }

    public List<XSSFTable> getTables() {
        return new ArrayList<XSSFTable>(this.tables.values());
    }

    @Override
    public XSSFSheetConditionalFormatting getSheetConditionalFormatting() {
        return new XSSFSheetConditionalFormatting(this);
    }

    public void setTabColor(int n) {
        CTSheetPr cTSheetPr = this.worksheet.getSheetPr();
        if (cTSheetPr == null) {
            cTSheetPr = this.worksheet.addNewSheetPr();
        }
        CTColor cTColor = CTColor.Factory.newInstance();
        cTColor.setIndexed((long)n);
        cTSheetPr.setTabColor(cTColor);
    }

    @Override
    public CellRangeAddress getRepeatingRows() {
        return this.getRepeatingRowsOrColums(true);
    }

    @Override
    public CellRangeAddress getRepeatingColumns() {
        return this.getRepeatingRowsOrColums(false);
    }

    @Override
    public void setRepeatingRows(CellRangeAddress cellRangeAddress) {
        CellRangeAddress cellRangeAddress2 = this.getRepeatingColumns();
        this.setRepeatingRowsAndColumns(cellRangeAddress, cellRangeAddress2);
    }

    @Override
    public void setRepeatingColumns(CellRangeAddress cellRangeAddress) {
        CellRangeAddress cellRangeAddress2 = this.getRepeatingRows();
        this.setRepeatingRowsAndColumns(cellRangeAddress2, cellRangeAddress);
    }

    private void setRepeatingRowsAndColumns(CellRangeAddress cellRangeAddress, CellRangeAddress cellRangeAddress2) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (cellRangeAddress != null) {
            n3 = cellRangeAddress.getFirstRow();
            n4 = cellRangeAddress.getLastRow();
            if (n3 == -1 && n4 != -1 || n3 < -1 || n4 < -1 || n3 > n4) {
                throw new IllegalArgumentException("Invalid row range specification");
            }
        }
        if (cellRangeAddress2 != null) {
            n = cellRangeAddress2.getFirstColumn();
            n2 = cellRangeAddress2.getLastColumn();
            if (n == -1 && n2 != -1 || n < -1 || n2 < -1 || n > n2) {
                throw new IllegalArgumentException("Invalid column range specification");
            }
        }
        int n5 = this.getWorkbook().getSheetIndex(this);
        boolean bl = cellRangeAddress == null && cellRangeAddress2 == null;
        XSSFName xSSFName = this.getWorkbook().getBuiltInName("_xlnm.Print_Titles", n5);
        if (bl) {
            if (xSSFName != null) {
                this.getWorkbook().removeName(xSSFName);
            }
            return;
        }
        if (xSSFName == null) {
            xSSFName = this.getWorkbook().createBuiltInName("_xlnm.Print_Titles", n5);
        }
        String string = XSSFSheet.getReferenceBuiltInRecord(xSSFName.getSheetName(), n, n2, n3, n4);
        xSSFName.setRefersToFormula(string);
        if (!this.worksheet.isSetPageSetup() || !this.worksheet.isSetPageMargins()) {
            this.getPrintSetup().setValidSettings(false);
        }
    }

    private static String getReferenceBuiltInRecord(String string, int n, int n2, int n3, int n4) {
        CellReference cellReference = new CellReference(string, 0, n, true, true);
        CellReference cellReference2 = new CellReference(string, 0, n2, true, true);
        CellReference cellReference3 = new CellReference(string, n3, 0, true, true);
        CellReference cellReference4 = new CellReference(string, n4, 0, true, true);
        String string2 = SheetNameFormatter.format(string);
        String string3 = "";
        String string4 = "";
        if (n != -1 || n2 != -1) {
            string3 = string2 + "!$" + cellReference.getCellRefParts()[2] + ":$" + cellReference2.getCellRefParts()[2];
        }
        if (!(n3 == -1 && n4 == -1 || cellReference3.getCellRefParts()[1].equals("0") || cellReference4.getCellRefParts()[1].equals("0"))) {
            string4 = string2 + "!$" + cellReference3.getCellRefParts()[1] + ":$" + cellReference4.getCellRefParts()[1];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        if (stringBuilder.length() > 0 && string4.length() > 0) {
            stringBuilder.append(',');
        }
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    private CellRangeAddress getRepeatingRowsOrColums(boolean bl) {
        int n = this.getWorkbook().getSheetIndex(this);
        XSSFName xSSFName = this.getWorkbook().getBuiltInName("_xlnm.Print_Titles", n);
        if (xSSFName == null) {
            return null;
        }
        String string = xSSFName.getRefersToFormula();
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        int n2 = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        int n3 = SpreadsheetVersion.EXCEL2007.getLastColumnIndex();
        for (String string2 : stringArray) {
            CellRangeAddress cellRangeAddress = CellRangeAddress.valueOf(string2);
            if (!(cellRangeAddress.getFirstColumn() == 0 && cellRangeAddress.getLastColumn() == n3 || cellRangeAddress.getFirstColumn() == -1 && cellRangeAddress.getLastColumn() == -1 ? bl : (cellRangeAddress.getFirstRow() == 0 && cellRangeAddress.getLastRow() == n2 || cellRangeAddress.getFirstRow() == -1 && cellRangeAddress.getLastRow() == -1) && !bl)) continue;
            return cellRangeAddress;
        }
        return null;
    }

    private XSSFPivotTable createPivotTable() {
        XSSFWorkbook xSSFWorkbook = this.getWorkbook();
        List<XSSFPivotTable> list = xSSFWorkbook.getPivotTables();
        int n = this.getWorkbook().getPivotTables().size() + 1;
        XSSFPivotTable xSSFPivotTable = (XSSFPivotTable)this.createRelationship(XSSFRelation.PIVOT_TABLE, XSSFFactory.getInstance(), n);
        xSSFPivotTable.setParentSheet(this);
        list.add(xSSFPivotTable);
        XSSFWorkbook xSSFWorkbook2 = this.getWorkbook();
        XSSFPivotCacheDefinition xSSFPivotCacheDefinition = (XSSFPivotCacheDefinition)xSSFWorkbook2.createRelationship(XSSFRelation.PIVOT_CACHE_DEFINITION, XSSFFactory.getInstance(), n);
        String string = xSSFWorkbook2.getRelationId(xSSFPivotCacheDefinition);
        PackagePart packagePart = xSSFPivotTable.getPackagePart();
        packagePart.addRelationship(xSSFPivotCacheDefinition.getPackagePart().getPartName(), TargetMode.INTERNAL, XSSFRelation.PIVOT_CACHE_DEFINITION.getRelation());
        xSSFPivotTable.setPivotCacheDefinition(xSSFPivotCacheDefinition);
        xSSFPivotTable.setPivotCache(new XSSFPivotCache(xSSFWorkbook2.addPivotCache(string)));
        XSSFPivotCacheRecords xSSFPivotCacheRecords = (XSSFPivotCacheRecords)xSSFPivotCacheDefinition.createRelationship(XSSFRelation.PIVOT_CACHE_RECORDS, XSSFFactory.getInstance(), n);
        xSSFPivotTable.getPivotCacheDefinition().getCTPivotCacheDefinition().setId(xSSFPivotCacheDefinition.getRelationId(xSSFPivotCacheRecords));
        xSSFWorkbook.setPivotTables(list);
        return xSSFPivotTable;
    }

    public XSSFPivotTable createPivotTable(AreaReference areaReference, CellReference cellReference, Sheet sheet) {
        if (areaReference.getFirstCell().getSheetName() != null && !areaReference.getFirstCell().getSheetName().equals(sheet.getSheetName())) {
            throw new IllegalArgumentException("The area is referenced in another sheet than the defined source sheet " + sheet.getSheetName() + ".");
        }
        XSSFPivotTable xSSFPivotTable = this.createPivotTable();
        xSSFPivotTable.setDefaultPivotTableDefinition();
        xSSFPivotTable.createSourceReferences(areaReference, cellReference, sheet);
        xSSFPivotTable.getPivotCacheDefinition().createCacheFields(sheet);
        xSSFPivotTable.createDefaultDataColumns();
        return xSSFPivotTable;
    }

    public XSSFPivotTable createPivotTable(AreaReference areaReference, CellReference cellReference) {
        if (areaReference.getFirstCell().getSheetName() != null && !areaReference.getFirstCell().getSheetName().equals(this.getSheetName())) {
            return this.createPivotTable(areaReference, cellReference, this.getWorkbook().getSheet(areaReference.getFirstCell().getSheetName()));
        }
        return this.createPivotTable(areaReference, cellReference, this);
    }

    public List<XSSFPivotTable> getPivotTables() {
        ArrayList<XSSFPivotTable> arrayList = new ArrayList<XSSFPivotTable>();
        for (XSSFPivotTable xSSFPivotTable : this.getWorkbook().getPivotTables()) {
            if (xSSFPivotTable.getParent() != this) continue;
            arrayList.add(xSSFPivotTable);
        }
        return arrayList;
    }

    @Override
    public int getColumnOutlineLevel(int n) {
        CTCol cTCol = this.columnHelper.getColumn(n, false);
        if (cTCol == null) {
            return 0;
        }
        return cTCol.getOutlineLevel();
    }
}

