/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.xssf.usermodel.XSSFAnchor;
import ai2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFShapeGroup;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNoFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetLineDashProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetLineDashVal;

public abstract class XSSFShape {
    public static final int EMU_PER_PIXEL = 9525;
    public static final int EMU_PER_POINT = 12700;
    public static final int POINT_DPI = 72;
    public static final int PIXEL_DPI = 96;
    protected XSSFDrawing drawing;
    protected XSSFShapeGroup parent;
    protected XSSFAnchor anchor;

    public XSSFDrawing getDrawing() {
        return this.drawing;
    }

    public XSSFShapeGroup getParent() {
        return this.parent;
    }

    public XSSFAnchor getAnchor() {
        return this.anchor;
    }

    protected abstract CTShapeProperties getShapeProperties();

    public boolean isNoFill() {
        return this.getShapeProperties().isSetNoFill();
    }

    public void setNoFill(boolean bl) {
        CTShapeProperties cTShapeProperties = this.getShapeProperties();
        if (cTShapeProperties.isSetPattFill()) {
            cTShapeProperties.unsetPattFill();
        }
        if (cTShapeProperties.isSetSolidFill()) {
            cTShapeProperties.unsetSolidFill();
        }
        cTShapeProperties.setNoFill(CTNoFillProperties.Factory.newInstance());
    }

    public void setFillColor(int n, int n2, int n3) {
        CTShapeProperties cTShapeProperties = this.getShapeProperties();
        CTSolidColorFillProperties cTSolidColorFillProperties = cTShapeProperties.isSetSolidFill() ? cTShapeProperties.getSolidFill() : cTShapeProperties.addNewSolidFill();
        CTSRgbColor cTSRgbColor = CTSRgbColor.Factory.newInstance();
        cTSRgbColor.setVal(new byte[]{(byte)n, (byte)n2, (byte)n3});
        cTSolidColorFillProperties.setSrgbClr(cTSRgbColor);
    }

    public void setLineStyleColor(int n, int n2, int n3) {
        CTShapeProperties cTShapeProperties = this.getShapeProperties();
        CTLineProperties cTLineProperties = cTShapeProperties.isSetLn() ? cTShapeProperties.getLn() : cTShapeProperties.addNewLn();
        CTSolidColorFillProperties cTSolidColorFillProperties = cTLineProperties.isSetSolidFill() ? cTLineProperties.getSolidFill() : cTLineProperties.addNewSolidFill();
        CTSRgbColor cTSRgbColor = CTSRgbColor.Factory.newInstance();
        cTSRgbColor.setVal(new byte[]{(byte)n, (byte)n2, (byte)n3});
        cTSolidColorFillProperties.setSrgbClr(cTSRgbColor);
    }

    public void setLineWidth(double d) {
        CTShapeProperties cTShapeProperties = this.getShapeProperties();
        CTLineProperties cTLineProperties = cTShapeProperties.isSetLn() ? cTShapeProperties.getLn() : cTShapeProperties.addNewLn();
        cTLineProperties.setW((int)(d * 12700.0));
    }

    public void setLineStyle(int n) {
        CTShapeProperties cTShapeProperties = this.getShapeProperties();
        CTLineProperties cTLineProperties = cTShapeProperties.isSetLn() ? cTShapeProperties.getLn() : cTShapeProperties.addNewLn();
        CTPresetLineDashProperties cTPresetLineDashProperties = CTPresetLineDashProperties.Factory.newInstance();
        cTPresetLineDashProperties.setVal(STPresetLineDashVal.Enum.forInt((int)(n + 1)));
        cTLineProperties.setPrstDash(cTPresetLineDashProperties);
    }
}

