/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.Font;
import ai2.org.apache.poi.ss.usermodel.RichTextString;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.model.ThemesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFFont;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRElt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRPrElt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STXstring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFRichTextString
implements RichTextString {
    private static final Pattern utfPtrn = Pattern.compile("_x([0-9A-F]{4})_");
    private CTRst st;
    private StylesTable styles;

    public XSSFRichTextString(String string) {
        this.st = CTRst.Factory.newInstance();
        this.st.setT(string);
        XSSFRichTextString.preserveSpaces(this.st.xgetT());
    }

    public XSSFRichTextString() {
        this.st = CTRst.Factory.newInstance();
    }

    public XSSFRichTextString(CTRst cTRst) {
        this.st = cTRst;
    }

    @Override
    public void applyFont(int n, int n2, short s) {
        XSSFFont xSSFFont;
        if (this.styles == null) {
            xSSFFont = new XSSFFont();
            xSSFFont.setFontName("#" + s);
        } else {
            xSSFFont = this.styles.getFontAt(s);
        }
        this.applyFont(n, n2, xSSFFont);
    }

    @Override
    public void applyFont(int n, int n2, Font font) {
        if (n > n2) {
            throw new IllegalArgumentException("Start index must be less than end index, but had " + n + " and " + n2);
        }
        if (n < 0 || n2 > this.length()) {
            throw new IllegalArgumentException("Start and end index not in range, but had " + n + " and " + n2);
        }
        if (n == n2) {
            return;
        }
        if (this.st.sizeOfRArray() == 0 && this.st.isSetT()) {
            this.st.addNewR().setT(this.st.getT());
            this.st.unsetT();
        }
        String string = this.getString();
        XSSFFont xSSFFont = (XSSFFont)font;
        TreeMap<Integer, CTRPrElt> treeMap = this.getFormatMap(this.st);
        CTRPrElt cTRPrElt = CTRPrElt.Factory.newInstance();
        this.setRunAttributes(xSSFFont.getCTFont(), cTRPrElt);
        this.applyFont(treeMap, n, n2, cTRPrElt);
        CTRst cTRst = this.buildCTRst(string, treeMap);
        this.st.set((XmlObject)cTRst);
    }

    @Override
    public void applyFont(Font font) {
        String string = this.getString();
        this.applyFont(0, string.length(), font);
    }

    @Override
    public void applyFont(short s) {
        XSSFFont xSSFFont;
        if (this.styles == null) {
            xSSFFont = new XSSFFont();
            xSSFFont.setFontName("#" + s);
        } else {
            xSSFFont = this.styles.getFontAt(s);
        }
        String string = this.getString();
        this.applyFont(0, string.length(), xSSFFont);
    }

    public void append(String string, XSSFFont xSSFFont) {
        CTRElt cTRElt;
        if (this.st.sizeOfRArray() == 0 && this.st.isSetT()) {
            cTRElt = this.st.addNewR();
            cTRElt.setT(this.st.getT());
            XSSFRichTextString.preserveSpaces(cTRElt.xgetT());
            this.st.unsetT();
        }
        cTRElt = this.st.addNewR();
        cTRElt.setT(string);
        XSSFRichTextString.preserveSpaces(cTRElt.xgetT());
        if (xSSFFont != null) {
            CTRPrElt cTRPrElt = cTRElt.addNewRPr();
            this.setRunAttributes(xSSFFont.getCTFont(), cTRPrElt);
        }
    }

    public void append(String string) {
        this.append(string, null);
    }

    private void setRunAttributes(CTFont cTFont, CTRPrElt cTRPrElt) {
        if (cTFont.sizeOfBArray() > 0) {
            cTRPrElt.addNewB().setVal(cTFont.getBArray(0).getVal());
        }
        if (cTFont.sizeOfUArray() > 0) {
            cTRPrElt.addNewU().setVal(cTFont.getUArray(0).getVal());
        }
        if (cTFont.sizeOfIArray() > 0) {
            cTRPrElt.addNewI().setVal(cTFont.getIArray(0).getVal());
        }
        if (cTFont.sizeOfColorArray() > 0) {
            CTColor cTColor = cTFont.getColorArray(0);
            CTColor cTColor2 = cTRPrElt.addNewColor();
            if (cTColor.isSetAuto()) {
                cTColor2.setAuto(cTColor.getAuto());
            }
            if (cTColor.isSetIndexed()) {
                cTColor2.setIndexed(cTColor.getIndexed());
            }
            if (cTColor.isSetRgb()) {
                cTColor2.setRgb(cTColor.getRgb());
            }
            if (cTColor.isSetTheme()) {
                cTColor2.setTheme(cTColor.getTheme());
            }
            if (cTColor.isSetTint()) {
                cTColor2.setTint(cTColor.getTint());
            }
        }
        if (cTFont.sizeOfSzArray() > 0) {
            cTRPrElt.addNewSz().setVal(cTFont.getSzArray(0).getVal());
        }
        if (cTFont.sizeOfNameArray() > 0) {
            cTRPrElt.addNewRFont().setVal(cTFont.getNameArray(0).getVal());
        }
        if (cTFont.sizeOfFamilyArray() > 0) {
            cTRPrElt.addNewFamily().setVal(cTFont.getFamilyArray(0).getVal());
        }
        if (cTFont.sizeOfSchemeArray() > 0) {
            cTRPrElt.addNewScheme().setVal(cTFont.getSchemeArray(0).getVal());
        }
        if (cTFont.sizeOfCharsetArray() > 0) {
            cTRPrElt.addNewCharset().setVal(cTFont.getCharsetArray(0).getVal());
        }
        if (cTFont.sizeOfCondenseArray() > 0) {
            cTRPrElt.addNewCondense().setVal(cTFont.getCondenseArray(0).getVal());
        }
        if (cTFont.sizeOfExtendArray() > 0) {
            cTRPrElt.addNewExtend().setVal(cTFont.getExtendArray(0).getVal());
        }
        if (cTFont.sizeOfVertAlignArray() > 0) {
            cTRPrElt.addNewVertAlign().setVal(cTFont.getVertAlignArray(0).getVal());
        }
        if (cTFont.sizeOfOutlineArray() > 0) {
            cTRPrElt.addNewOutline().setVal(cTFont.getOutlineArray(0).getVal());
        }
        if (cTFont.sizeOfShadowArray() > 0) {
            cTRPrElt.addNewShadow().setVal(cTFont.getShadowArray(0).getVal());
        }
        if (cTFont.sizeOfStrikeArray() > 0) {
            cTRPrElt.addNewStrike().setVal(cTFont.getStrikeArray(0).getVal());
        }
    }

    public boolean hasFormatting() {
        CTRElt[] cTREltArray = this.st.getRArray();
        if (cTREltArray == null || cTREltArray.length == 0) {
            return false;
        }
        for (CTRElt cTRElt : cTREltArray) {
            if (!cTRElt.isSetRPr()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearFormatting() {
        String string = this.getString();
        this.st.setRArray(null);
        this.st.setT(string);
    }

    @Override
    public int getIndexOfFormattingRun(int n) {
        if (this.st.sizeOfRArray() == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < this.st.sizeOfRArray(); ++i) {
            CTRElt cTRElt = this.st.getRArray(i);
            if (i == n) {
                return n2;
            }
            n2 += cTRElt.getT().length();
        }
        return -1;
    }

    public int getLengthOfFormattingRun(int n) {
        if (this.st.sizeOfRArray() == 0 || n >= this.st.sizeOfRArray()) {
            return -1;
        }
        CTRElt cTRElt = this.st.getRArray(n);
        return cTRElt.getT().length();
    }

    @Override
    public String getString() {
        if (this.st.sizeOfRArray() == 0) {
            return XSSFRichTextString.utfDecode(this.st.getT());
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (CTRElt cTRElt : this.st.getRArray()) {
            stringBuffer.append(cTRElt.getT());
        }
        return XSSFRichTextString.utfDecode(stringBuffer.toString());
    }

    public void setString(String string) {
        this.clearFormatting();
        this.st.setT(string);
        XSSFRichTextString.preserveSpaces(this.st.xgetT());
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int length() {
        return this.getString().length();
    }

    @Override
    public int numFormattingRuns() {
        return this.st.sizeOfRArray();
    }

    public XSSFFont getFontOfFormattingRun(int n) {
        if (this.st.sizeOfRArray() == 0 || n >= this.st.sizeOfRArray()) {
            return null;
        }
        CTRElt cTRElt = this.st.getRArray(n);
        if (cTRElt.getRPr() != null) {
            XSSFFont xSSFFont = new XSSFFont(XSSFRichTextString.toCTFont(cTRElt.getRPr()));
            xSSFFont.setThemesTable(this.getThemesTable());
            return xSSFFont;
        }
        return null;
    }

    public XSSFFont getFontAtIndex(int n) {
        if (this.st.sizeOfRArray() == 0) {
            return null;
        }
        int n2 = 0;
        for (int i = 0; i < this.st.sizeOfRArray(); ++i) {
            CTRElt cTRElt = this.st.getRArray(i);
            if (n >= n2 && n < n2 + cTRElt.getT().length()) {
                XSSFFont xSSFFont = new XSSFFont(XSSFRichTextString.toCTFont(cTRElt.getRPr()));
                xSSFFont.setThemesTable(this.getThemesTable());
                return xSSFFont;
            }
            n2 += cTRElt.getT().length();
        }
        return null;
    }

    @Internal
    public CTRst getCTRst() {
        return this.st;
    }

    protected void setStylesTableReference(StylesTable stylesTable) {
        this.styles = stylesTable;
        if (this.st.sizeOfRArray() > 0) {
            for (CTRElt cTRElt : this.st.getRArray()) {
                String string;
                CTRPrElt cTRPrElt = cTRElt.getRPr();
                if (cTRPrElt == null || cTRPrElt.sizeOfRFontArray() <= 0 || !(string = cTRPrElt.getRFontArray(0).getVal()).startsWith("#")) continue;
                int n = Integer.parseInt(string.substring(1));
                XSSFFont xSSFFont = this.styles.getFontAt(n);
                cTRPrElt.removeRFont(0);
                this.setRunAttributes(xSSFFont.getCTFont(), cTRPrElt);
            }
        }
    }

    protected static CTFont toCTFont(CTRPrElt cTRPrElt) {
        CTFont cTFont = CTFont.Factory.newInstance();
        if (cTRPrElt == null) {
            return cTFont;
        }
        if (cTRPrElt.sizeOfBArray() > 0) {
            cTFont.addNewB().setVal(cTRPrElt.getBArray(0).getVal());
        }
        if (cTRPrElt.sizeOfUArray() > 0) {
            cTFont.addNewU().setVal(cTRPrElt.getUArray(0).getVal());
        }
        if (cTRPrElt.sizeOfIArray() > 0) {
            cTFont.addNewI().setVal(cTRPrElt.getIArray(0).getVal());
        }
        if (cTRPrElt.sizeOfColorArray() > 0) {
            CTColor cTColor = cTRPrElt.getColorArray(0);
            CTColor cTColor2 = cTFont.addNewColor();
            if (cTColor.isSetAuto()) {
                cTColor2.setAuto(cTColor.getAuto());
            }
            if (cTColor.isSetIndexed()) {
                cTColor2.setIndexed(cTColor.getIndexed());
            }
            if (cTColor.isSetRgb()) {
                cTColor2.setRgb(cTColor.getRgb());
            }
            if (cTColor.isSetTheme()) {
                cTColor2.setTheme(cTColor.getTheme());
            }
            if (cTColor.isSetTint()) {
                cTColor2.setTint(cTColor.getTint());
            }
        }
        if (cTRPrElt.sizeOfSzArray() > 0) {
            cTFont.addNewSz().setVal(cTRPrElt.getSzArray(0).getVal());
        }
        if (cTRPrElt.sizeOfRFontArray() > 0) {
            cTFont.addNewName().setVal(cTRPrElt.getRFontArray(0).getVal());
        }
        if (cTRPrElt.sizeOfFamilyArray() > 0) {
            cTFont.addNewFamily().setVal(cTRPrElt.getFamilyArray(0).getVal());
        }
        if (cTRPrElt.sizeOfSchemeArray() > 0) {
            cTFont.addNewScheme().setVal(cTRPrElt.getSchemeArray(0).getVal());
        }
        if (cTRPrElt.sizeOfCharsetArray() > 0) {
            cTFont.addNewCharset().setVal(cTRPrElt.getCharsetArray(0).getVal());
        }
        if (cTRPrElt.sizeOfCondenseArray() > 0) {
            cTFont.addNewCondense().setVal(cTRPrElt.getCondenseArray(0).getVal());
        }
        if (cTRPrElt.sizeOfExtendArray() > 0) {
            cTFont.addNewExtend().setVal(cTRPrElt.getExtendArray(0).getVal());
        }
        if (cTRPrElt.sizeOfVertAlignArray() > 0) {
            cTFont.addNewVertAlign().setVal(cTRPrElt.getVertAlignArray(0).getVal());
        }
        if (cTRPrElt.sizeOfOutlineArray() > 0) {
            cTFont.addNewOutline().setVal(cTRPrElt.getOutlineArray(0).getVal());
        }
        if (cTRPrElt.sizeOfShadowArray() > 0) {
            cTFont.addNewShadow().setVal(cTRPrElt.getShadowArray(0).getVal());
        }
        if (cTRPrElt.sizeOfStrikeArray() > 0) {
            cTFont.addNewStrike().setVal(cTRPrElt.getStrikeArray(0).getVal());
        }
        return cTFont;
    }

    protected static void preserveSpaces(STXstring sTXstring) {
        String string = sTXstring.getStringValue();
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            char c2 = string.charAt(string.length() - 1);
            if (Character.isWhitespace(c) || Character.isWhitespace(c2)) {
                XmlCursor xmlCursor = sTXstring.newCursor();
                xmlCursor.toNextToken();
                xmlCursor.insertAttributeWithValue(new QName("http://www.w3.org/XML/1998/namespace", "space"), "preserve");
                xmlCursor.dispose();
            }
        }
    }

    static String utfDecode(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = utfPtrn.matcher(string);
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
            }
            String string2 = matcher.group(1);
            int n3 = Integer.decode("0x" + string2);
            stringBuffer.append((char)n3);
            n = matcher.end();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    void applyFont(TreeMap<Integer, CTRPrElt> treeMap, int n, int n2, CTRPrElt cTRPrElt) {
        int n3 = 0;
        Object object = treeMap.keySet().iterator();
        while (object.hasNext()) {
            int n4 = object.next();
            if (n3 >= n && n4 < n2) {
                object.remove();
            }
            n3 = n4;
        }
        if (n > 0 && !treeMap.containsKey(n)) {
            for (Map.Entry entry : treeMap.entrySet()) {
                if ((Integer)entry.getKey() <= n) continue;
                treeMap.put(n, (CTRPrElt)entry.getValue());
                break;
            }
        }
        treeMap.put(n2, cTRPrElt);
        object = treeMap.subMap(n, n2);
        while (object.size() > 1) {
            object.remove(object.lastKey());
        }
    }

    TreeMap<Integer, CTRPrElt> getFormatMap(CTRst cTRst) {
        int n = 0;
        TreeMap<Integer, CTRPrElt> treeMap = new TreeMap<Integer, CTRPrElt>();
        for (CTRElt cTRElt : cTRst.getRArray()) {
            String string = cTRElt.getT();
            CTRPrElt cTRPrElt = cTRElt.getRPr();
            treeMap.put(n += string.length(), cTRPrElt);
        }
        return treeMap;
    }

    CTRst buildCTRst(String string, TreeMap<Integer, CTRPrElt> treeMap) {
        if (string.length() != treeMap.lastKey().intValue()) {
            throw new IllegalArgumentException("Text length was " + string.length() + " but the last format index was " + treeMap.lastKey());
        }
        CTRst cTRst = CTRst.Factory.newInstance();
        int n = 0;
        for (int n2 : treeMap.keySet()) {
            CTRElt cTRElt = cTRst.addNewR();
            String string2 = string.substring(n, n2);
            cTRElt.setT(string2);
            XSSFRichTextString.preserveSpaces(cTRElt.xgetT());
            CTRPrElt cTRPrElt = treeMap.get(n2);
            if (cTRPrElt != null) {
                cTRElt.setRPr(cTRPrElt);
            }
            n = n2;
        }
        return cTRst;
    }

    private ThemesTable getThemesTable() {
        if (this.styles == null) {
            return null;
        }
        return this.styles.getTheme();
    }
}

