/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.usermodel.Sheet;
import ai2.org.apache.poi.ss.util.AreaReference;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.Internal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCacheField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCacheFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotCacheDefinition;

public class XSSFPivotCacheDefinition
extends POIXMLDocumentPart {
    private CTPivotCacheDefinition ctPivotCacheDefinition;

    public XSSFPivotCacheDefinition() {
        this.ctPivotCacheDefinition = CTPivotCacheDefinition.Factory.newInstance();
        this.createDefaultValues();
    }

    protected XSSFPivotCacheDefinition(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
            xmlOptions.setLoadReplaceDocumentElement(null);
            this.ctPivotCacheDefinition = CTPivotCacheDefinition.Factory.parse((InputStream)inputStream, (XmlOptions)xmlOptions);
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage());
        }
    }

    @Internal
    public CTPivotCacheDefinition getCTPivotCacheDefinition() {
        return this.ctPivotCacheDefinition;
    }

    private void createDefaultValues() {
        this.ctPivotCacheDefinition.setCreatedVersion((short)3);
        this.ctPivotCacheDefinition.setMinRefreshableVersion((short)3);
        this.ctPivotCacheDefinition.setRefreshedVersion((short)3);
        this.ctPivotCacheDefinition.setRefreshedBy("Apache POI");
        this.ctPivotCacheDefinition.setRefreshedDate((double)new Date().getTime());
        this.ctPivotCacheDefinition.setRefreshOnLoad(true);
    }

    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTPivotCacheDefinition.type.getName().getNamespaceURI(), "pivotCacheDefinition"));
        this.ctPivotCacheDefinition.save(outputStream, xmlOptions);
        outputStream.close();
    }

    protected void createCacheFields(Sheet sheet) {
        AreaReference areaReference = new AreaReference(this.ctPivotCacheDefinition.getCacheSource().getWorksheetSource().getRef());
        CellReference cellReference = areaReference.getFirstCell();
        CellReference cellReference2 = areaReference.getLastCell();
        int n = cellReference.getCol();
        short s = cellReference2.getCol();
        Row row = sheet.getRow(cellReference.getRow());
        CTCacheFields cTCacheFields = this.ctPivotCacheDefinition.getCacheFields() != null ? this.ctPivotCacheDefinition.getCacheFields() : this.ctPivotCacheDefinition.addNewCacheFields();
        for (int i = n; i <= s; ++i) {
            CTCacheField cTCacheField = cTCacheFields.addNewCacheField();
            if (i == s) {
                cTCacheFields.setCount((long)cTCacheFields.sizeOfCacheFieldArray());
            }
            cTCacheField.setNumFmtId(0L);
            Cell cell = row.getCell(i);
            cell.setCellType(1);
            cTCacheField.setName(row.getCell(i).getStringCellValue());
            cTCacheField.addNewSharedItems();
        }
    }
}

