/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.Color;
import ai2.org.apache.poi.ss.usermodel.PatternFormatting;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;

public class XSSFPatternFormatting
implements PatternFormatting {
    CTFill _fill;

    XSSFPatternFormatting(CTFill cTFill) {
        this._fill = cTFill;
    }

    public XSSFColor getFillBackgroundColorColor() {
        if (!this._fill.isSetPatternFill()) {
            return null;
        }
        return new XSSFColor(this._fill.getPatternFill().getBgColor());
    }

    public XSSFColor getFillForegroundColorColor() {
        if (!this._fill.isSetPatternFill() || !this._fill.getPatternFill().isSetFgColor()) {
            return null;
        }
        return new XSSFColor(this._fill.getPatternFill().getFgColor());
    }

    public short getFillPattern() {
        if (!this._fill.isSetPatternFill() || !this._fill.getPatternFill().isSetPatternType()) {
            return 0;
        }
        return (short)(this._fill.getPatternFill().getPatternType().intValue() - 1);
    }

    public short getFillBackgroundColor() {
        XSSFColor xSSFColor = this.getFillBackgroundColorColor();
        if (xSSFColor == null) {
            return 0;
        }
        return xSSFColor.getIndexed();
    }

    public short getFillForegroundColor() {
        XSSFColor xSSFColor = this.getFillForegroundColorColor();
        if (xSSFColor == null) {
            return 0;
        }
        return xSSFColor.getIndexed();
    }

    public void setFillBackgroundColor(Color color) {
        XSSFColor xSSFColor = XSSFColor.toXSSFColor(color);
        if (xSSFColor == null) {
            this.setFillBackgroundColor((CTColor)null);
        } else {
            this.setFillBackgroundColor(xSSFColor.getCTColor());
        }
    }

    public void setFillBackgroundColor(short s) {
        CTColor cTColor = CTColor.Factory.newInstance();
        cTColor.setIndexed((long)s);
        this.setFillBackgroundColor(cTColor);
    }

    private void setFillBackgroundColor(CTColor cTColor) {
        CTPatternFill cTPatternFill;
        CTPatternFill cTPatternFill2 = cTPatternFill = this._fill.isSetPatternFill() ? this._fill.getPatternFill() : this._fill.addNewPatternFill();
        if (cTColor == null) {
            cTPatternFill.unsetBgColor();
        } else {
            cTPatternFill.setBgColor(cTColor);
        }
    }

    public void setFillForegroundColor(Color color) {
        XSSFColor xSSFColor = XSSFColor.toXSSFColor(color);
        if (xSSFColor == null) {
            this.setFillForegroundColor((CTColor)null);
        } else {
            this.setFillForegroundColor(xSSFColor.getCTColor());
        }
    }

    public void setFillForegroundColor(short s) {
        CTColor cTColor = CTColor.Factory.newInstance();
        cTColor.setIndexed((long)s);
        this.setFillForegroundColor(cTColor);
    }

    private void setFillForegroundColor(CTColor cTColor) {
        CTPatternFill cTPatternFill;
        CTPatternFill cTPatternFill2 = cTPatternFill = this._fill.isSetPatternFill() ? this._fill.getPatternFill() : this._fill.addNewPatternFill();
        if (cTColor == null) {
            cTPatternFill.unsetFgColor();
        } else {
            cTPatternFill.setFgColor(cTColor);
        }
    }

    public void setFillPattern(short s) {
        CTPatternFill cTPatternFill;
        CTPatternFill cTPatternFill2 = cTPatternFill = this._fill.isSetPatternFill() ? this._fill.getPatternFill() : this._fill.addNewPatternFill();
        if (s == 0) {
            cTPatternFill.unsetPatternType();
        } else {
            cTPatternFill.setPatternType(STPatternType.Enum.forInt((int)(s + 1)));
        }
    }
}

