/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.formula.FormulaParser;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.usermodel.Name;
import ai2.org.apache.poi.ss.util.AreaReference;
import ai2.org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDefinedName;

public final class XSSFName
implements Name {
    public static final String BUILTIN_PRINT_AREA = "_xlnm.Print_Area";
    public static final String BUILTIN_PRINT_TITLE = "_xlnm.Print_Titles";
    public static final String BUILTIN_CRITERIA = "_xlnm.Criteria:";
    public static final String BUILTIN_EXTRACT = "_xlnm.Extract:";
    public static final String BUILTIN_FILTER_DB = "_xlnm._FilterDatabase";
    public static final String BUILTIN_CONSOLIDATE_AREA = "_xlnm.Consolidate_Area";
    public static final String BUILTIN_DATABASE = "_xlnm.Database";
    public static final String BUILTIN_SHEET_TITLE = "_xlnm.Sheet_Title";
    private XSSFWorkbook _workbook;
    private CTDefinedName _ctName;

    protected XSSFName(CTDefinedName cTDefinedName, XSSFWorkbook xSSFWorkbook) {
        this._workbook = xSSFWorkbook;
        this._ctName = cTDefinedName;
    }

    protected CTDefinedName getCTName() {
        return this._ctName;
    }

    public String getNameName() {
        return this._ctName.getName();
    }

    public void setNameName(String string) {
        XSSFName.validateName(string);
        int n = this.getSheetIndex();
        for (int i = 0; i < this._workbook.getNumberOfNames(); ++i) {
            XSSFName xSSFName = this._workbook.getNameAt(i);
            if (xSSFName == this || !string.equalsIgnoreCase(xSSFName.getNameName()) || n != xSSFName.getSheetIndex()) continue;
            String string2 = "The " + (n == -1 ? "workbook" : "sheet") + " already contains this name: " + string;
            throw new IllegalArgumentException(string2);
        }
        this._ctName.setName(string);
    }

    public String getRefersToFormula() {
        String string = this._ctName.getStringValue();
        if (string == null || string.length() < 1) {
            return null;
        }
        return string;
    }

    public void setRefersToFormula(String string) {
        XSSFEvaluationWorkbook xSSFEvaluationWorkbook = XSSFEvaluationWorkbook.create(this._workbook);
        FormulaParser.parse(string, xSSFEvaluationWorkbook, 4, this.getSheetIndex());
        this._ctName.setStringValue(string);
    }

    public boolean isDeleted() {
        String string = this.getRefersToFormula();
        if (string == null) {
            return false;
        }
        XSSFEvaluationWorkbook xSSFEvaluationWorkbook = XSSFEvaluationWorkbook.create(this._workbook);
        Ptg[] ptgArray = FormulaParser.parse(string, xSSFEvaluationWorkbook, 4, this.getSheetIndex());
        return Ptg.doesFormulaReferToDeletedCell(ptgArray);
    }

    public void setSheetIndex(int n) {
        int n2 = this._workbook.getNumberOfSheets() - 1;
        if (n < -1 || n > n2) {
            throw new IllegalArgumentException("Sheet index (" + n + ") is out of range" + (n2 == -1 ? "" : " (0.." + n2 + ")"));
        }
        if (n == -1) {
            if (this._ctName.isSetLocalSheetId()) {
                this._ctName.unsetLocalSheetId();
            }
        } else {
            this._ctName.setLocalSheetId((long)n);
        }
    }

    public int getSheetIndex() {
        return this._ctName.isSetLocalSheetId() ? (int)this._ctName.getLocalSheetId() : -1;
    }

    public void setFunction(boolean bl) {
        this._ctName.setFunction(bl);
    }

    public boolean getFunction() {
        return this._ctName.getFunction();
    }

    public void setFunctionGroupId(int n) {
        this._ctName.setFunctionGroupId((long)n);
    }

    public int getFunctionGroupId() {
        return (int)this._ctName.getFunctionGroupId();
    }

    public String getSheetName() {
        if (this._ctName.isSetLocalSheetId()) {
            int n = (int)this._ctName.getLocalSheetId();
            return this._workbook.getSheetName(n);
        }
        String string = this.getRefersToFormula();
        AreaReference areaReference = new AreaReference(string);
        return areaReference.getFirstCell().getSheetName();
    }

    public boolean isFunctionName() {
        return this.getFunction();
    }

    public String getComment() {
        return this._ctName.getComment();
    }

    public void setComment(String string) {
        this._ctName.setComment(string);
    }

    public int hashCode() {
        return this._ctName.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XSSFName)) {
            return false;
        }
        XSSFName xSSFName = (XSSFName)object;
        return this._ctName.toString().equals(xSSFName.getCTName().toString());
    }

    private static void validateName(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        char c = string.charAt(0);
        if (c != '_' && !Character.isLetter(c) || string.indexOf(32) != -1) {
            throw new IllegalArgumentException("Invalid name: '" + string + "'; Names must begin with a letter or underscore and not contain spaces");
        }
    }
}

