/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.ss.usermodel.Hyperlink;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import java.net.URI;
import java.net.URISyntaxException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHyperlink;

public class XSSFHyperlink
implements Hyperlink {
    private int _type;
    private PackageRelationship _externalRel;
    private CTHyperlink _ctHyperlink;
    private String _location;

    protected XSSFHyperlink(int n) {
        this._type = n;
        this._ctHyperlink = CTHyperlink.Factory.newInstance();
    }

    protected XSSFHyperlink(CTHyperlink cTHyperlink, PackageRelationship packageRelationship) {
        this._ctHyperlink = cTHyperlink;
        this._externalRel = packageRelationship;
        if (cTHyperlink.getLocation() != null) {
            this._type = 2;
            this._location = cTHyperlink.getLocation();
        } else if (this._externalRel == null) {
            if (cTHyperlink.getId() != null) {
                throw new IllegalStateException("The hyperlink for cell " + cTHyperlink.getRef() + " references relation " + cTHyperlink.getId() + ", but that didn't exist!");
            }
            this._type = 2;
        } else {
            URI uRI = this._externalRel.getTargetURI();
            this._location = uRI.toString();
            this._type = this._location.startsWith("http://") || this._location.startsWith("https://") || this._location.startsWith("ftp://") ? 1 : (this._location.startsWith("mailto:") ? 3 : 4);
        }
    }

    public CTHyperlink getCTHyperlink() {
        return this._ctHyperlink;
    }

    public boolean needsRelationToo() {
        return this._type != 2;
    }

    protected void generateRelationIfNeeded(PackagePart packagePart) {
        if (this._externalRel == null && this.needsRelationToo()) {
            PackageRelationship packageRelationship = packagePart.addExternalRelationship(this._location, XSSFRelation.SHEET_HYPERLINKS.getRelation());
            this._ctHyperlink.setId(packageRelationship.getId());
        }
    }

    public int getType() {
        return this._type;
    }

    public String getCellRef() {
        return this._ctHyperlink.getRef();
    }

    public String getAddress() {
        return this._location;
    }

    public String getLabel() {
        return this._ctHyperlink.getDisplay();
    }

    public String getLocation() {
        return this._ctHyperlink.getLocation();
    }

    public void setLabel(String string) {
        this._ctHyperlink.setDisplay(string);
    }

    public void setLocation(String string) {
        this._ctHyperlink.setLocation(string);
    }

    public void setAddress(String string) {
        this.validate(string);
        this._location = string;
        if (this._type == 2) {
            this.setLocation(string);
        }
    }

    private void validate(String string) {
        switch (this._type) {
            case 1: 
            case 3: 
            case 4: {
                try {
                    new URI(string);
                    break;
                }
                catch (URISyntaxException uRISyntaxException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Address of hyperlink must be a valid URI");
                    illegalArgumentException.initCause(uRISyntaxException);
                    throw illegalArgumentException;
                }
            }
        }
    }

    protected void setCellReference(String string) {
        this._ctHyperlink.setRef(string);
    }

    protected void setCellReference(CellReference cellReference) {
        this.setCellReference(cellReference.formatAsString());
    }

    private CellReference buildCellReference() {
        String string = this._ctHyperlink.getRef();
        if (string == null) {
            string = "A1";
        }
        return new CellReference(string);
    }

    public int getFirstColumn() {
        return this.buildCellReference().getCol();
    }

    public int getLastColumn() {
        return this.buildCellReference().getCol();
    }

    public int getFirstRow() {
        return this.buildCellReference().getRow();
    }

    public int getLastRow() {
        return this.buildCellReference().getRow();
    }

    public void setFirstColumn(int n) {
        this.setCellReference(new CellReference(this.getFirstRow(), n));
    }

    public void setLastColumn(int n) {
        this.setFirstColumn(n);
    }

    public void setFirstRow(int n) {
        this.setCellReference(new CellReference(n, this.getFirstColumn()));
    }

    public void setLastRow(int n) {
        this.setFirstRow(n);
    }

    public String getTooltip() {
        return this._ctHyperlink.getTooltip();
    }

    public void setTooltip(String string) {
        this._ctHyperlink.setTooltip(string);
    }
}

