/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.Color;
import ai2.org.apache.poi.ss.usermodel.FontFormatting;
import ai2.org.apache.poi.ss.usermodel.FontUnderline;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFontSize;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTUnderlineProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTVerticalAlignFontProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STUnderlineValues;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STVerticalAlignRun;

public class XSSFFontFormatting
implements FontFormatting {
    CTFont _font;

    XSSFFontFormatting(CTFont cTFont) {
        this._font = cTFont;
    }

    public short getEscapementType() {
        if (this._font.sizeOfVertAlignArray() == 0) {
            return 0;
        }
        CTVerticalAlignFontProperty cTVerticalAlignFontProperty = this._font.getVertAlignArray(0);
        return (short)(cTVerticalAlignFontProperty.getVal().intValue() - 1);
    }

    public void setEscapementType(short s) {
        this._font.setVertAlignArray(null);
        if (s != 0) {
            this._font.addNewVertAlign().setVal(STVerticalAlignRun.Enum.forInt((int)(s + 1)));
        }
    }

    public short getFontColorIndex() {
        if (this._font.sizeOfColorArray() == 0) {
            return -1;
        }
        int n = 0;
        CTColor cTColor = this._font.getColorArray(0);
        if (cTColor.isSetIndexed()) {
            n = (int)cTColor.getIndexed();
        }
        return (short)n;
    }

    public void setFontColorIndex(short s) {
        this._font.setColorArray(null);
        if (s != -1) {
            this._font.addNewColor().setIndexed((long)s);
        }
    }

    public XSSFColor getFontColor() {
        if (this._font.sizeOfColorArray() == 0) {
            return null;
        }
        return new XSSFColor(this._font.getColorArray(0));
    }

    public void setFontColor(Color color) {
        XSSFColor xSSFColor = XSSFColor.toXSSFColor(color);
        if (xSSFColor == null) {
            this._font.getColorList().clear();
        } else {
            this._font.setColorArray(0, xSSFColor.getCTColor());
        }
    }

    public XSSFColor getXSSFColor() {
        return this.getFontColor();
    }

    public int getFontHeight() {
        if (this._font.sizeOfSzArray() == 0) {
            return -1;
        }
        CTFontSize cTFontSize = this._font.getSzArray(0);
        return (short)(20.0 * cTFontSize.getVal());
    }

    public void setFontHeight(int n) {
        this._font.setSzArray(null);
        if (n != -1) {
            this._font.addNewSz().setVal((double)n / 20.0);
        }
    }

    public short getUnderlineType() {
        if (this._font.sizeOfUArray() == 0) {
            return 0;
        }
        CTUnderlineProperty cTUnderlineProperty = this._font.getUArray(0);
        switch (cTUnderlineProperty.getVal().intValue()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 33;
            }
            case 4: {
                return 34;
            }
        }
        return 0;
    }

    public void setUnderlineType(short s) {
        this._font.setUArray(null);
        if (s != 0) {
            FontUnderline fontUnderline = FontUnderline.valueOf(s);
            STUnderlineValues.Enum enum_ = STUnderlineValues.Enum.forInt((int)fontUnderline.getValue());
            this._font.addNewU().setVal(enum_);
        }
    }

    public boolean isBold() {
        return this._font.sizeOfBArray() == 1 && this._font.getBArray(0).getVal();
    }

    public boolean isItalic() {
        return this._font.sizeOfIArray() == 1 && this._font.getIArray(0).getVal();
    }

    public void setFontStyle(boolean bl, boolean bl2) {
        this._font.setIArray(null);
        this._font.setBArray(null);
        if (bl) {
            this._font.addNewI().setVal(true);
        }
        if (bl2) {
            this._font.addNewB().setVal(true);
        }
    }

    public void resetFontStyle() {
        this._font.set((XmlObject)CTFont.Factory.newInstance());
    }
}

