/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.POIXMLFactory;
import ai2.org.apache.poi.POIXMLRelation;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import java.lang.reflect.Constructor;

public final class XSSFFactory
extends POIXMLFactory {
    private static final POILogger logger = POILogFactory.getLogger(XSSFFactory.class);
    private static final XSSFFactory inst = new XSSFFactory();

    private XSSFFactory() {
    }

    public static XSSFFactory getInstance() {
        return inst;
    }

    public POIXMLDocumentPart createDocumentPart(POIXMLDocumentPart pOIXMLDocumentPart, PackageRelationship packageRelationship, PackagePart packagePart) {
        XSSFRelation xSSFRelation = XSSFRelation.getInstance(packageRelationship.getRelationshipType());
        if (xSSFRelation == null || xSSFRelation.getRelationClass() == null) {
            logger.log(1, new Object[]{"using default POIXMLDocumentPart for " + packageRelationship.getRelationshipType()});
            return new POIXMLDocumentPart(packagePart, packageRelationship);
        }
        try {
            Class<? extends POIXMLDocumentPart> clazz = xSSFRelation.getRelationClass();
            Constructor<? extends POIXMLDocumentPart> constructor = clazz.getDeclaredConstructor(PackagePart.class, PackageRelationship.class);
            return constructor.newInstance(packagePart, packageRelationship);
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }

    public POIXMLDocumentPart newDocumentPart(POIXMLRelation pOIXMLRelation) {
        try {
            Class<? extends POIXMLDocumentPart> clazz = pOIXMLRelation.getRelationClass();
            Constructor<? extends POIXMLDocumentPart> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }
}

