/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.DataValidation;
import ai2.org.apache.poi.ss.usermodel.DataValidationConstraint;
import ai2.org.apache.poi.ss.usermodel.DataValidationHelper;
import ai2.org.apache.poi.ss.util.CellRangeAddressList;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataValidation;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.util.ArrayList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationErrorStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationType;

public class XSSFDataValidationHelper
implements DataValidationHelper {
    private XSSFSheet xssfSheet;

    public XSSFDataValidationHelper(XSSFSheet xSSFSheet) {
        this.xssfSheet = xSSFSheet;
    }

    public DataValidationConstraint createDateConstraint(int n, String string, String string2, String string3) {
        return new XSSFDataValidationConstraint(4, n, string, string2);
    }

    public DataValidationConstraint createDecimalConstraint(int n, String string, String string2) {
        return new XSSFDataValidationConstraint(2, n, string, string2);
    }

    public DataValidationConstraint createExplicitListConstraint(String[] stringArray) {
        return new XSSFDataValidationConstraint(stringArray);
    }

    public DataValidationConstraint createFormulaListConstraint(String string) {
        return new XSSFDataValidationConstraint(3, string);
    }

    public DataValidationConstraint createNumericConstraint(int n, int n2, String string, String string2) {
        if (n == 1) {
            return this.createIntegerConstraint(n2, string, string2);
        }
        if (n == 2) {
            return this.createDecimalConstraint(n2, string, string2);
        }
        if (n == 6) {
            return this.createTextLengthConstraint(n2, string, string2);
        }
        return null;
    }

    public DataValidationConstraint createIntegerConstraint(int n, String string, String string2) {
        return new XSSFDataValidationConstraint(1, n, string, string2);
    }

    public DataValidationConstraint createTextLengthConstraint(int n, String string, String string2) {
        return new XSSFDataValidationConstraint(6, n, string, string2);
    }

    public DataValidationConstraint createTimeConstraint(int n, String string, String string2) {
        return new XSSFDataValidationConstraint(5, n, string, string2);
    }

    public DataValidationConstraint createCustomConstraint(String string) {
        return new XSSFDataValidationConstraint(7, string);
    }

    public DataValidation createValidation(DataValidationConstraint dataValidationConstraint, CellRangeAddressList cellRangeAddressList) {
        STDataValidationOperator.Enum enum_;
        XSSFDataValidationConstraint xSSFDataValidationConstraint = (XSSFDataValidationConstraint)dataValidationConstraint;
        CTDataValidation cTDataValidation = CTDataValidation.Factory.newInstance();
        int n = dataValidationConstraint.getValidationType();
        switch (n) {
            case 3: {
                cTDataValidation.setType(STDataValidationType.LIST);
                cTDataValidation.setFormula1(dataValidationConstraint.getFormula1());
                break;
            }
            case 0: {
                cTDataValidation.setType(STDataValidationType.NONE);
                break;
            }
            case 6: {
                cTDataValidation.setType(STDataValidationType.TEXT_LENGTH);
                break;
            }
            case 4: {
                cTDataValidation.setType(STDataValidationType.DATE);
                break;
            }
            case 1: {
                cTDataValidation.setType(STDataValidationType.WHOLE);
                break;
            }
            case 2: {
                cTDataValidation.setType(STDataValidationType.DECIMAL);
                break;
            }
            case 5: {
                cTDataValidation.setType(STDataValidationType.TIME);
                break;
            }
            case 7: {
                cTDataValidation.setType(STDataValidationType.CUSTOM);
                break;
            }
            default: {
                cTDataValidation.setType(STDataValidationType.NONE);
            }
        }
        if (n != 0 && n != 3) {
            enum_ = XSSFDataValidation.operatorTypeMappings.get(dataValidationConstraint.getOperator());
            if (enum_ != null) {
                cTDataValidation.setOperator(enum_);
            }
            if (dataValidationConstraint.getFormula1() != null) {
                cTDataValidation.setFormula1(dataValidationConstraint.getFormula1());
            }
            if (dataValidationConstraint.getFormula2() != null) {
                cTDataValidation.setFormula2(dataValidationConstraint.getFormula2());
            }
        }
        enum_ = cellRangeAddressList.getCellRangeAddresses();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < ((STDataValidationOperator.Enum)enum_).length; ++i) {
            STDataValidationOperator.Enum enum_2 = enum_[i];
            arrayList.add(enum_2.formatAsString());
        }
        cTDataValidation.setSqref(arrayList);
        cTDataValidation.setAllowBlank(true);
        cTDataValidation.setErrorStyle(STDataValidationErrorStyle.STOP);
        return new XSSFDataValidation(xSSFDataValidationConstraint, cellRangeAddressList, cTDataValidation);
    }
}

