/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.DataValidation;
import ai2.org.apache.poi.ss.usermodel.DataValidationConstraint;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellRangeAddressList;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import java.util.HashMap;
import java.util.Map;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationErrorStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationType;

public class XSSFDataValidation
implements DataValidation {
    private CTDataValidation ctDdataValidation;
    private XSSFDataValidationConstraint validationConstraint;
    private CellRangeAddressList regions;
    static Map<Integer, STDataValidationOperator.Enum> operatorTypeMappings = new HashMap<Integer, STDataValidationOperator.Enum>();
    static Map<STDataValidationOperator.Enum, Integer> operatorTypeReverseMappings = new HashMap<STDataValidationOperator.Enum, Integer>();
    static Map<Integer, STDataValidationType.Enum> validationTypeMappings = new HashMap<Integer, STDataValidationType.Enum>();
    static Map<STDataValidationType.Enum, Integer> validationTypeReverseMappings = new HashMap<STDataValidationType.Enum, Integer>();
    static Map<Integer, STDataValidationErrorStyle.Enum> errorStyleMappings = new HashMap<Integer, STDataValidationErrorStyle.Enum>();

    XSSFDataValidation(CellRangeAddressList cellRangeAddressList, CTDataValidation cTDataValidation) {
        this(XSSFDataValidation.getConstraint(cTDataValidation), cellRangeAddressList, cTDataValidation);
    }

    public XSSFDataValidation(XSSFDataValidationConstraint xSSFDataValidationConstraint, CellRangeAddressList cellRangeAddressList, CTDataValidation cTDataValidation) {
        this.validationConstraint = xSSFDataValidationConstraint;
        this.ctDdataValidation = cTDataValidation;
        this.regions = cellRangeAddressList;
    }

    CTDataValidation getCtDdataValidation() {
        return this.ctDdataValidation;
    }

    public void createErrorBox(String string, String string2) {
        this.ctDdataValidation.setErrorTitle(string);
        this.ctDdataValidation.setError(string2);
    }

    public void createPromptBox(String string, String string2) {
        this.ctDdataValidation.setPromptTitle(string);
        this.ctDdataValidation.setPrompt(string2);
    }

    public boolean getEmptyCellAllowed() {
        return this.ctDdataValidation.getAllowBlank();
    }

    public String getErrorBoxText() {
        return this.ctDdataValidation.getError();
    }

    public String getErrorBoxTitle() {
        return this.ctDdataValidation.getErrorTitle();
    }

    public int getErrorStyle() {
        return this.ctDdataValidation.getErrorStyle().intValue();
    }

    public String getPromptBoxText() {
        return this.ctDdataValidation.getPrompt();
    }

    public String getPromptBoxTitle() {
        return this.ctDdataValidation.getPromptTitle();
    }

    public boolean getShowErrorBox() {
        return this.ctDdataValidation.getShowErrorMessage();
    }

    public boolean getShowPromptBox() {
        return this.ctDdataValidation.getShowInputMessage();
    }

    public boolean getSuppressDropDownArrow() {
        return !this.ctDdataValidation.getShowDropDown();
    }

    public DataValidationConstraint getValidationConstraint() {
        return this.validationConstraint;
    }

    public void setEmptyCellAllowed(boolean bl) {
        this.ctDdataValidation.setAllowBlank(bl);
    }

    public void setErrorStyle(int n) {
        this.ctDdataValidation.setErrorStyle(errorStyleMappings.get(n));
    }

    public void setShowErrorBox(boolean bl) {
        this.ctDdataValidation.setShowErrorMessage(bl);
    }

    public void setShowPromptBox(boolean bl) {
        this.ctDdataValidation.setShowInputMessage(bl);
    }

    public void setSuppressDropDownArrow(boolean bl) {
        if (this.validationConstraint.getValidationType() == 3) {
            this.ctDdataValidation.setShowDropDown(!bl);
        }
    }

    public CellRangeAddressList getRegions() {
        return this.regions;
    }

    public String prettyPrint() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CellRangeAddress cellRangeAddress : this.regions.getCellRangeAddresses()) {
            stringBuilder.append(cellRangeAddress.formatAsString());
        }
        stringBuilder.append(" => ");
        stringBuilder.append(this.validationConstraint.prettyPrint());
        return stringBuilder.toString();
    }

    private static XSSFDataValidationConstraint getConstraint(CTDataValidation cTDataValidation) {
        XSSFDataValidationConstraint xSSFDataValidationConstraint = null;
        String string = cTDataValidation.getFormula1();
        String string2 = cTDataValidation.getFormula2();
        STDataValidationOperator.Enum enum_ = cTDataValidation.getOperator();
        STDataValidationType.Enum enum_2 = cTDataValidation.getType();
        Integer n = validationTypeReverseMappings.get(enum_2);
        Integer n2 = operatorTypeReverseMappings.get(enum_);
        xSSFDataValidationConstraint = new XSSFDataValidationConstraint(n, n2, string, string2);
        return xSSFDataValidationConstraint;
    }

    static {
        errorStyleMappings.put(2, STDataValidationErrorStyle.INFORMATION);
        errorStyleMappings.put(0, STDataValidationErrorStyle.STOP);
        errorStyleMappings.put(1, STDataValidationErrorStyle.WARNING);
        operatorTypeMappings.put(0, STDataValidationOperator.BETWEEN);
        operatorTypeMappings.put(1, STDataValidationOperator.NOT_BETWEEN);
        operatorTypeMappings.put(2, STDataValidationOperator.EQUAL);
        operatorTypeMappings.put(3, STDataValidationOperator.NOT_EQUAL);
        operatorTypeMappings.put(4, STDataValidationOperator.GREATER_THAN);
        operatorTypeMappings.put(6, STDataValidationOperator.GREATER_THAN_OR_EQUAL);
        operatorTypeMappings.put(5, STDataValidationOperator.LESS_THAN);
        operatorTypeMappings.put(7, STDataValidationOperator.LESS_THAN_OR_EQUAL);
        for (Map.Entry<Integer, STDataValidationOperator.Enum> entry : operatorTypeMappings.entrySet()) {
            operatorTypeReverseMappings.put(entry.getValue(), entry.getKey());
        }
        validationTypeMappings.put(7, STDataValidationType.CUSTOM);
        validationTypeMappings.put(4, STDataValidationType.DATE);
        validationTypeMappings.put(2, STDataValidationType.DECIMAL);
        validationTypeMappings.put(3, STDataValidationType.LIST);
        validationTypeMappings.put(0, STDataValidationType.NONE);
        validationTypeMappings.put(6, STDataValidationType.TEXT_LENGTH);
        validationTypeMappings.put(5, STDataValidationType.TIME);
        validationTypeMappings.put(1, STDataValidationType.WHOLE);
        for (Map.Entry<Integer, STDataValidationOperator.Enum> entry : validationTypeMappings.entrySet()) {
            validationTypeReverseMappings.put((STDataValidationType.Enum)entry.getValue(), entry.getKey());
        }
    }
}

