/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFShape;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STFontCollectionIndex;
import org.openxmlformats.schemas.drawingml.x2006.main.STSchemeColorVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTConnector;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTConnectorNonVisual;

public final class XSSFConnector
extends XSSFShape {
    private static CTConnector prototype = null;
    private CTConnector ctShape;

    protected XSSFConnector(XSSFDrawing xSSFDrawing, CTConnector cTConnector) {
        this.drawing = xSSFDrawing;
        this.ctShape = cTConnector;
    }

    protected static CTConnector prototype() {
        if (prototype == null) {
            CTConnector cTConnector = CTConnector.Factory.newInstance();
            CTConnectorNonVisual cTConnectorNonVisual = cTConnector.addNewNvCxnSpPr();
            CTNonVisualDrawingProps cTNonVisualDrawingProps = cTConnectorNonVisual.addNewCNvPr();
            cTNonVisualDrawingProps.setId(1L);
            cTNonVisualDrawingProps.setName("Shape 1");
            cTConnectorNonVisual.addNewCNvCxnSpPr();
            CTShapeProperties cTShapeProperties = cTConnector.addNewSpPr();
            CTTransform2D cTTransform2D = cTShapeProperties.addNewXfrm();
            CTPositiveSize2D cTPositiveSize2D = cTTransform2D.addNewExt();
            cTPositiveSize2D.setCx(0L);
            cTPositiveSize2D.setCy(0L);
            CTPoint2D cTPoint2D = cTTransform2D.addNewOff();
            cTPoint2D.setX(0L);
            cTPoint2D.setY(0L);
            CTPresetGeometry2D cTPresetGeometry2D = cTShapeProperties.addNewPrstGeom();
            cTPresetGeometry2D.setPrst(STShapeType.LINE);
            cTPresetGeometry2D.addNewAvLst();
            CTShapeStyle cTShapeStyle = cTConnector.addNewStyle();
            CTSchemeColor cTSchemeColor = cTShapeStyle.addNewLnRef().addNewSchemeClr();
            cTSchemeColor.setVal(STSchemeColorVal.ACCENT_1);
            cTShapeStyle.getLnRef().setIdx(1L);
            CTStyleMatrixReference cTStyleMatrixReference = cTShapeStyle.addNewFillRef();
            cTStyleMatrixReference.setIdx(0L);
            cTStyleMatrixReference.addNewSchemeClr().setVal(STSchemeColorVal.ACCENT_1);
            CTStyleMatrixReference cTStyleMatrixReference2 = cTShapeStyle.addNewEffectRef();
            cTStyleMatrixReference2.setIdx(0L);
            cTStyleMatrixReference2.addNewSchemeClr().setVal(STSchemeColorVal.ACCENT_1);
            CTFontReference cTFontReference = cTShapeStyle.addNewFontRef();
            cTFontReference.setIdx(STFontCollectionIndex.MINOR);
            cTFontReference.addNewSchemeClr().setVal(STSchemeColorVal.TX_1);
            prototype = cTConnector;
        }
        return prototype;
    }

    @Internal
    public CTConnector getCTConnector() {
        return this.ctShape;
    }

    public int getShapeType() {
        return this.ctShape.getSpPr().getPrstGeom().getPrst().intValue();
    }

    public void setShapeType(int n) {
        this.ctShape.getSpPr().getPrstGeom().setPrst(STShapeType.Enum.forInt((int)n));
    }

    protected CTShapeProperties getShapeProperties() {
        return this.ctShape.getSpPr();
    }
}

