/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.ConditionType;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;
import ai2.org.apache.poi.ss.usermodel.IconMultiStateFormatting;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFBorderFormatting;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import ai2.org.apache.poi.xssf.usermodel.XSSFColorScaleFormatting;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataBarFormatting;
import ai2.org.apache.poi.xssf.usermodel.XSSFFontFormatting;
import ai2.org.apache.poi.xssf.usermodel.XSSFIconMultiStateFormatting;
import ai2.org.apache.poi.xssf.usermodel.XSSFPatternFormatting;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.util.HashMap;
import java.util.Map;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfvo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColorScale;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataBar;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTIconSet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfvoType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STConditionalFormattingOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STIconSetType;

public class XSSFConditionalFormattingRule
implements ConditionalFormattingRule {
    private final CTCfRule _cfRule;
    private XSSFSheet _sh;
    private static Map<STCfType.Enum, ConditionType> typeLookup = new HashMap<STCfType.Enum, ConditionType>();

    XSSFConditionalFormattingRule(XSSFSheet xSSFSheet) {
        this._cfRule = CTCfRule.Factory.newInstance();
        this._sh = xSSFSheet;
    }

    XSSFConditionalFormattingRule(XSSFSheet xSSFSheet, CTCfRule cTCfRule) {
        this._cfRule = cTCfRule;
        this._sh = xSSFSheet;
    }

    CTCfRule getCTCfRule() {
        return this._cfRule;
    }

    CTDxf getDxf(boolean bl) {
        int n;
        StylesTable stylesTable = this._sh.getWorkbook().getStylesSource();
        CTDxf cTDxf = null;
        if (stylesTable._getDXfsSize() > 0 && this._cfRule.isSetDxfId()) {
            n = (int)this._cfRule.getDxfId();
            cTDxf = stylesTable.getDxfAt(n);
        }
        if (bl && cTDxf == null) {
            cTDxf = CTDxf.Factory.newInstance();
            n = stylesTable.putDxf(cTDxf);
            this._cfRule.setDxfId((long)(n - 1));
        }
        return cTDxf;
    }

    public XSSFBorderFormatting createBorderFormatting() {
        CTDxf cTDxf = this.getDxf(true);
        CTBorder cTBorder = !cTDxf.isSetBorder() ? cTDxf.addNewBorder() : cTDxf.getBorder();
        return new XSSFBorderFormatting(cTBorder);
    }

    public XSSFBorderFormatting getBorderFormatting() {
        CTDxf cTDxf = this.getDxf(false);
        if (cTDxf == null || !cTDxf.isSetBorder()) {
            return null;
        }
        return new XSSFBorderFormatting(cTDxf.getBorder());
    }

    public XSSFFontFormatting createFontFormatting() {
        CTDxf cTDxf = this.getDxf(true);
        CTFont cTFont = !cTDxf.isSetFont() ? cTDxf.addNewFont() : cTDxf.getFont();
        return new XSSFFontFormatting(cTFont);
    }

    public XSSFFontFormatting getFontFormatting() {
        CTDxf cTDxf = this.getDxf(false);
        if (cTDxf == null || !cTDxf.isSetFont()) {
            return null;
        }
        return new XSSFFontFormatting(cTDxf.getFont());
    }

    public XSSFPatternFormatting createPatternFormatting() {
        CTDxf cTDxf = this.getDxf(true);
        CTFill cTFill = !cTDxf.isSetFill() ? cTDxf.addNewFill() : cTDxf.getFill();
        return new XSSFPatternFormatting(cTFill);
    }

    public XSSFPatternFormatting getPatternFormatting() {
        CTDxf cTDxf = this.getDxf(false);
        if (cTDxf == null || !cTDxf.isSetFill()) {
            return null;
        }
        return new XSSFPatternFormatting(cTDxf.getFill());
    }

    public XSSFDataBarFormatting createDataBarFormatting(XSSFColor xSSFColor) {
        if (this._cfRule.isSetDataBar() && this._cfRule.getType() == STCfType.DATA_BAR) {
            return this.getDataBarFormatting();
        }
        this._cfRule.setType(STCfType.DATA_BAR);
        CTDataBar cTDataBar = null;
        cTDataBar = this._cfRule.isSetDataBar() ? this._cfRule.getDataBar() : this._cfRule.addNewDataBar();
        cTDataBar.setColor(xSSFColor.getCTColor());
        CTCfvo cTCfvo = cTDataBar.addNewCfvo();
        cTCfvo.setType(STCfvoType.Enum.forString((String)ConditionalFormattingThreshold.RangeType.MIN.name));
        CTCfvo cTCfvo2 = cTDataBar.addNewCfvo();
        cTCfvo2.setType(STCfvoType.Enum.forString((String)ConditionalFormattingThreshold.RangeType.MAX.name));
        return new XSSFDataBarFormatting(cTDataBar);
    }

    public XSSFDataBarFormatting getDataBarFormatting() {
        if (this._cfRule.isSetDataBar()) {
            CTDataBar cTDataBar = this._cfRule.getDataBar();
            return new XSSFDataBarFormatting(cTDataBar);
        }
        return null;
    }

    public XSSFIconMultiStateFormatting createMultiStateFormatting(IconMultiStateFormatting.IconSet iconSet) {
        if (this._cfRule.isSetIconSet() && this._cfRule.getType() == STCfType.ICON_SET) {
            return this.getMultiStateFormatting();
        }
        this._cfRule.setType(STCfType.ICON_SET);
        CTIconSet cTIconSet = null;
        cTIconSet = this._cfRule.isSetIconSet() ? this._cfRule.getIconSet() : this._cfRule.addNewIconSet();
        if (iconSet.name != null) {
            STIconSetType.Enum enum_ = STIconSetType.Enum.forString((String)iconSet.name);
            cTIconSet.setIconSet(enum_);
        }
        int n = 100 / iconSet.num;
        STCfvoType.Enum enum_ = STCfvoType.Enum.forString((String)ConditionalFormattingThreshold.RangeType.PERCENT.name);
        for (int i = 0; i < iconSet.num; ++i) {
            CTCfvo cTCfvo = cTIconSet.addNewCfvo();
            cTCfvo.setType(enum_);
            cTCfvo.setVal(Integer.toString(i * n));
        }
        return new XSSFIconMultiStateFormatting(cTIconSet);
    }

    public XSSFIconMultiStateFormatting getMultiStateFormatting() {
        if (this._cfRule.isSetIconSet()) {
            CTIconSet cTIconSet = this._cfRule.getIconSet();
            return new XSSFIconMultiStateFormatting(cTIconSet);
        }
        return null;
    }

    public XSSFColorScaleFormatting createColorScaleFormatting() {
        if (this._cfRule.isSetColorScale() && this._cfRule.getType() == STCfType.COLOR_SCALE) {
            return this.getColorScaleFormatting();
        }
        this._cfRule.setType(STCfType.COLOR_SCALE);
        CTColorScale cTColorScale = null;
        cTColorScale = this._cfRule.isSetColorScale() ? this._cfRule.getColorScale() : this._cfRule.addNewColorScale();
        if (cTColorScale.sizeOfCfvoArray() == 0) {
            CTCfvo cTCfvo = cTColorScale.addNewCfvo();
            cTCfvo.setType(STCfvoType.Enum.forString((String)ConditionalFormattingThreshold.RangeType.MIN.name));
            cTCfvo = cTColorScale.addNewCfvo();
            cTCfvo.setType(STCfvoType.Enum.forString((String)ConditionalFormattingThreshold.RangeType.PERCENTILE.name));
            cTCfvo.setVal("50");
            cTCfvo = cTColorScale.addNewCfvo();
            cTCfvo.setType(STCfvoType.Enum.forString((String)ConditionalFormattingThreshold.RangeType.MAX.name));
            for (int i = 0; i < 3; ++i) {
                cTColorScale.addNewColor();
            }
        }
        return new XSSFColorScaleFormatting(cTColorScale);
    }

    public XSSFColorScaleFormatting getColorScaleFormatting() {
        if (this._cfRule.isSetColorScale()) {
            CTColorScale cTColorScale = this._cfRule.getColorScale();
            return new XSSFColorScaleFormatting(cTColorScale);
        }
        return null;
    }

    public byte getConditionType() {
        ConditionType conditionType = this.getConditionTypeType();
        if (conditionType != null) {
            return conditionType.id;
        }
        return 0;
    }

    public ConditionType getConditionTypeType() {
        return typeLookup.get(this._cfRule.getType());
    }

    public byte getComparisonOperation() {
        STConditionalFormattingOperator.Enum enum_ = this._cfRule.getOperator();
        if (enum_ == null) {
            return 0;
        }
        switch (enum_.intValue()) {
            case 1: {
                return 6;
            }
            case 2: {
                return 8;
            }
            case 6: {
                return 5;
            }
            case 5: {
                return 7;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
        }
        return 0;
    }

    public String getFormula1() {
        return this._cfRule.sizeOfFormulaArray() > 0 ? this._cfRule.getFormulaArray(0) : null;
    }

    public String getFormula2() {
        return this._cfRule.sizeOfFormulaArray() == 2 ? this._cfRule.getFormulaArray(1) : null;
    }

    static {
        typeLookup.put(STCfType.CELL_IS, ConditionType.CELL_VALUE_IS);
        typeLookup.put(STCfType.EXPRESSION, ConditionType.FORMULA);
        typeLookup.put(STCfType.COLOR_SCALE, ConditionType.COLOR_SCALE);
        typeLookup.put(STCfType.DATA_BAR, ConditionType.DATA_BAR);
        typeLookup.put(STCfType.ICON_SET, ConditionType.ICON_SET);
        typeLookup.put(STCfType.TOP_10, ConditionType.FILTER);
        typeLookup.put(STCfType.UNIQUE_VALUES, ConditionType.FILTER);
        typeLookup.put(STCfType.DUPLICATE_VALUES, ConditionType.FILTER);
        typeLookup.put(STCfType.CONTAINS_TEXT, ConditionType.FILTER);
        typeLookup.put(STCfType.NOT_CONTAINS_TEXT, ConditionType.FILTER);
        typeLookup.put(STCfType.BEGINS_WITH, ConditionType.FILTER);
        typeLookup.put(STCfType.ENDS_WITH, ConditionType.FILTER);
        typeLookup.put(STCfType.CONTAINS_BLANKS, ConditionType.FILTER);
        typeLookup.put(STCfType.NOT_CONTAINS_BLANKS, ConditionType.FILTER);
        typeLookup.put(STCfType.CONTAINS_ERRORS, ConditionType.FILTER);
        typeLookup.put(STCfType.NOT_CONTAINS_ERRORS, ConditionType.FILTER);
        typeLookup.put(STCfType.TIME_PERIOD, ConditionType.FILTER);
        typeLookup.put(STCfType.ABOVE_AVERAGE, ConditionType.FILTER);
    }
}

