/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.ConditionalFormatting;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.xssf.usermodel.XSSFConditionalFormattingRule;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;

public class XSSFConditionalFormatting
implements ConditionalFormatting {
    private final CTConditionalFormatting _cf;
    private final XSSFSheet _sh;

    XSSFConditionalFormatting(XSSFSheet xSSFSheet) {
        this._cf = CTConditionalFormatting.Factory.newInstance();
        this._sh = xSSFSheet;
    }

    XSSFConditionalFormatting(XSSFSheet xSSFSheet, CTConditionalFormatting cTConditionalFormatting) {
        this._cf = cTConditionalFormatting;
        this._sh = xSSFSheet;
    }

    CTConditionalFormatting getCTConditionalFormatting() {
        return this._cf;
    }

    public CellRangeAddress[] getFormattingRanges() {
        ArrayList<CellRangeAddress> arrayList = new ArrayList<CellRangeAddress>();
        for (Object e : this._cf.getSqref()) {
            String[] stringArray = e.toString().split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(CellRangeAddress.valueOf(stringArray[i]));
            }
        }
        return arrayList.toArray(new CellRangeAddress[arrayList.size()]);
    }

    public void setRule(int n, ConditionalFormattingRule conditionalFormattingRule) {
        XSSFConditionalFormattingRule xSSFConditionalFormattingRule = (XSSFConditionalFormattingRule)conditionalFormattingRule;
        this._cf.getCfRuleArray(n).set((XmlObject)xSSFConditionalFormattingRule.getCTCfRule());
    }

    public void addRule(ConditionalFormattingRule conditionalFormattingRule) {
        XSSFConditionalFormattingRule xSSFConditionalFormattingRule = (XSSFConditionalFormattingRule)conditionalFormattingRule;
        this._cf.addNewCfRule().set((XmlObject)xSSFConditionalFormattingRule.getCTCfRule());
    }

    public XSSFConditionalFormattingRule getRule(int n) {
        return new XSSFConditionalFormattingRule(this._sh, this._cf.getCfRuleArray(n));
    }

    public int getNumberOfRules() {
        return this._cf.sizeOfCfRuleArray();
    }

    public String toString() {
        return this._cf.toString();
    }
}

