/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.ExtendedColor;
import ai2.org.apache.poi.util.Internal;
import java.awt.Color;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;

public class XSSFColor
extends ExtendedColor {
    private CTColor ctColor;

    public XSSFColor(CTColor cTColor) {
        this.ctColor = cTColor;
    }

    public XSSFColor() {
        this.ctColor = CTColor.Factory.newInstance();
    }

    public XSSFColor(Color color) {
        this();
        this.setColor(color);
    }

    public XSSFColor(byte[] byArray) {
        this();
        this.ctColor.setRgb(byArray);
    }

    public boolean isAuto() {
        return this.ctColor.getAuto();
    }

    public void setAuto(boolean bl) {
        this.ctColor.setAuto(bl);
    }

    public boolean isIndexed() {
        return this.ctColor.isSetIndexed();
    }

    public boolean isRGB() {
        return this.ctColor.isSetRgb();
    }

    public boolean isThemed() {
        return this.ctColor.isSetTheme();
    }

    public boolean hasTint() {
        if (!this.ctColor.isSetRgb()) {
            return false;
        }
        return this.ctColor.getRgb().length == 4;
    }

    public short getIndex() {
        return (short)this.ctColor.getIndexed();
    }

    public short getIndexed() {
        return this.getIndex();
    }

    public void setIndexed(int n) {
        this.ctColor.setIndexed((long)n);
    }

    public byte[] getRGB() {
        byte[] byArray = this.getRGBOrARGB();
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 4) {
            byte[] byArray2 = new byte[3];
            System.arraycopy(byArray, 1, byArray2, 0, 3);
            return byArray2;
        }
        return byArray;
    }

    public byte[] getRgb() {
        return this.getRGB();
    }

    public byte[] getARGB() {
        byte[] byArray = this.getRGBOrARGB();
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 3) {
            byte[] byArray2 = new byte[4];
            byArray2[0] = -1;
            System.arraycopy(byArray, 0, byArray2, 1, 3);
            return byArray2;
        }
        return byArray;
    }

    public byte[] getARgb() {
        return this.getARGB();
    }

    protected byte[] getStoredRBG() {
        return this.ctColor.getRgb();
    }

    public byte[] getRgbWithTint() {
        return this.getRGBWithTint();
    }

    public void setRgb(byte[] byArray) {
        this.setRGB(byArray);
    }

    public void setRGB(byte[] byArray) {
        this.ctColor.setRgb(byArray);
    }

    public int getTheme() {
        return (int)this.ctColor.getTheme();
    }

    public void setTheme(int n) {
        this.ctColor.setTheme((long)n);
    }

    public double getTint() {
        return this.ctColor.getTint();
    }

    public void setTint(double d) {
        this.ctColor.setTint(d);
    }

    @Internal
    public CTColor getCTColor() {
        return this.ctColor;
    }

    public static XSSFColor toXSSFColor(ai2.org.apache.poi.ss.usermodel.Color color) {
        if (color != null && !(color instanceof XSSFColor)) {
            throw new IllegalArgumentException("Only XSSFColor objects are supported");
        }
        return (XSSFColor)color;
    }

    public int hashCode() {
        return this.ctColor.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof XSSFColor)) {
            return false;
        }
        XSSFColor xSSFColor = (XSSFColor)object;
        return this.ctColor.toString().equals(xSSFColor.getCTColor().toString());
    }
}

