/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.usermodel.XSSFAnchor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;

public final class XSSFChildAnchor
extends XSSFAnchor {
    private CTTransform2D t2d;

    public XSSFChildAnchor(int n, int n2, int n3, int n4) {
        this.t2d = CTTransform2D.Factory.newInstance();
        CTPoint2D cTPoint2D = this.t2d.addNewOff();
        CTPositiveSize2D cTPositiveSize2D = this.t2d.addNewExt();
        cTPoint2D.setX((long)n);
        cTPoint2D.setY((long)n2);
        cTPositiveSize2D.setCx((long)Math.abs(n3 - n));
        cTPositiveSize2D.setCy((long)Math.abs(n4 - n2));
        if (n > n3) {
            this.t2d.setFlipH(true);
        }
        if (n2 > n4) {
            this.t2d.setFlipV(true);
        }
    }

    public XSSFChildAnchor(CTTransform2D cTTransform2D) {
        this.t2d = cTTransform2D;
    }

    @Internal
    public CTTransform2D getCTTransform2D() {
        return this.t2d;
    }

    public int getDx1() {
        return (int)this.t2d.getOff().getX();
    }

    public void setDx1(int n) {
        this.t2d.getOff().setX((long)n);
    }

    public int getDy1() {
        return (int)this.t2d.getOff().getY();
    }

    public void setDy1(int n) {
        this.t2d.getOff().setY((long)n);
    }

    public int getDy2() {
        return (int)((long)this.getDy1() + this.t2d.getExt().getCy());
    }

    public void setDy2(int n) {
        this.t2d.getExt().setCy((long)(n - this.getDy1()));
    }

    public int getDx2() {
        return (int)((long)this.getDx1() + this.t2d.getExt().getCx());
    }

    public void setDx2(int n) {
        this.t2d.getExt().setCx((long)(n - this.getDx1()));
    }
}

