/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.ss.usermodel.Chart;
import ai2.org.apache.poi.ss.usermodel.charts.AxisPosition;
import ai2.org.apache.poi.ss.usermodel.charts.ChartAxis;
import ai2.org.apache.poi.ss.usermodel.charts.ChartAxisFactory;
import ai2.org.apache.poi.ss.usermodel.charts.ChartData;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.usermodel.XSSFGraphicFrame;
import ai2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFCategoryAxis;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFChartAxis;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFChartDataFactory;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFChartLegend;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFManualLayout;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFValueAxis;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCatAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChartSpace;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPageMargins;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPrintSettings;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTitle;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.ChartSpaceDocument;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSSFChart
extends POIXMLDocumentPart
implements Chart,
ChartAxisFactory {
    private XSSFGraphicFrame frame;
    private CTChartSpace chartSpace;
    private CTChart chart;
    List<XSSFChartAxis> axis = new ArrayList<XSSFChartAxis>();

    protected XSSFChart() {
        this.createChart();
    }

    protected XSSFChart(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, XmlException {
        super(packagePart, packageRelationship);
        this.chartSpace = ChartSpaceDocument.Factory.parse((InputStream)packagePart.getInputStream()).getChartSpace();
        this.chart = this.chartSpace.getChart();
    }

    private void createChart() {
        this.chartSpace = CTChartSpace.Factory.newInstance();
        this.chart = this.chartSpace.addNewChart();
        CTPlotArea cTPlotArea = this.chart.addNewPlotArea();
        cTPlotArea.addNewLayout();
        this.chart.addNewPlotVisOnly().setVal(true);
        CTPrintSettings cTPrintSettings = this.chartSpace.addNewPrintSettings();
        cTPrintSettings.addNewHeaderFooter();
        CTPageMargins cTPageMargins = cTPrintSettings.addNewPageMargins();
        cTPageMargins.setB(0.75);
        cTPageMargins.setL(0.7);
        cTPageMargins.setR(0.7);
        cTPageMargins.setT(0.75);
        cTPageMargins.setHeader(0.3);
        cTPageMargins.setFooter(0.3);
        cTPrintSettings.addNewPageSetup();
    }

    @Internal
    public CTChartSpace getCTChartSpace() {
        return this.chartSpace;
    }

    @Internal
    public CTChart getCTChart() {
        return this.chart;
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTChartSpace.type.getName().getNamespaceURI(), "chartSpace", "c"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://schemas.openxmlformats.org/drawingml/2006/main", "a");
        hashMap.put("http://schemas.openxmlformats.org/drawingml/2006/chart", "c");
        hashMap.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.chartSpace.save(outputStream, xmlOptions);
        outputStream.close();
    }

    public XSSFGraphicFrame getGraphicFrame() {
        return this.frame;
    }

    protected void setGraphicFrame(XSSFGraphicFrame xSSFGraphicFrame) {
        this.frame = xSSFGraphicFrame;
    }

    @Override
    public XSSFChartDataFactory getChartDataFactory() {
        return XSSFChartDataFactory.getInstance();
    }

    @Override
    public XSSFChart getChartAxisFactory() {
        return this;
    }

    @Override
    public void plot(ChartData chartData, ChartAxis ... chartAxisArray) {
        chartData.fillChart(this, chartAxisArray);
    }

    @Override
    public XSSFValueAxis createValueAxis(AxisPosition axisPosition) {
        long l = this.axis.size() + 1;
        XSSFValueAxis xSSFValueAxis = new XSSFValueAxis(this, l, axisPosition);
        if (this.axis.size() == 1) {
            ChartAxis chartAxis = this.axis.get(0);
            chartAxis.crossAxis(xSSFValueAxis);
            xSSFValueAxis.crossAxis(chartAxis);
        }
        this.axis.add(xSSFValueAxis);
        return xSSFValueAxis;
    }

    @Override
    public XSSFCategoryAxis createCategoryAxis(AxisPosition axisPosition) {
        long l = this.axis.size() + 1;
        XSSFCategoryAxis xSSFCategoryAxis = new XSSFCategoryAxis(this, l, axisPosition);
        if (this.axis.size() == 1) {
            ChartAxis chartAxis = this.axis.get(0);
            chartAxis.crossAxis(xSSFCategoryAxis);
            xSSFCategoryAxis.crossAxis(chartAxis);
        }
        this.axis.add(xSSFCategoryAxis);
        return xSSFCategoryAxis;
    }

    public List<? extends XSSFChartAxis> getAxis() {
        if (this.axis.isEmpty() && this.hasAxis()) {
            this.parseAxis();
        }
        return this.axis;
    }

    @Override
    public XSSFManualLayout getManualLayout() {
        return new XSSFManualLayout(this);
    }

    public boolean isPlotOnlyVisibleCells() {
        return this.chart.getPlotVisOnly().getVal();
    }

    public void setPlotOnlyVisibleCells(boolean bl) {
        this.chart.getPlotVisOnly().setVal(bl);
    }

    public XSSFRichTextString getTitle() {
        if (!this.chart.isSetTitle()) {
            return null;
        }
        CTTitle cTTitle = this.chart.getTitle();
        StringBuffer stringBuffer = new StringBuffer();
        XmlObject[] xmlObjectArray = cTTitle.selectPath("declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//a:t");
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            NodeList nodeList = xmlObjectArray[i].getDomNode().getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                if (!(nodeList.item(j) instanceof Text)) continue;
                stringBuffer.append(nodeList.item(j).getNodeValue());
            }
        }
        return new XSSFRichTextString(stringBuffer.toString());
    }

    @Override
    public XSSFChartLegend getOrCreateLegend() {
        return new XSSFChartLegend(this);
    }

    @Override
    public void deleteLegend() {
        if (this.chart.isSetLegend()) {
            this.chart.unsetLegend();
        }
    }

    private boolean hasAxis() {
        CTPlotArea cTPlotArea = this.chart.getPlotArea();
        int n = cTPlotArea.sizeOfValAxArray() + cTPlotArea.sizeOfCatAxArray() + cTPlotArea.sizeOfDateAxArray() + cTPlotArea.sizeOfSerAxArray();
        return n > 0;
    }

    private void parseAxis() {
        this.parseCategoryAxis();
        this.parseValueAxis();
    }

    private void parseCategoryAxis() {
        for (CTCatAx cTCatAx : this.chart.getPlotArea().getCatAxArray()) {
            this.axis.add(new XSSFCategoryAxis(this, cTCatAx));
        }
    }

    private void parseValueAxis() {
        for (CTValAx cTValAx : this.chart.getPlotArea().getValAxArray()) {
            this.axis.add(new XSSFValueAxis(this, cTValAx));
        }
    }
}

