/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.ss.usermodel.BorderStyle;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.usermodel.FillPatternType;
import ai2.org.apache.poi.ss.usermodel.Font;
import ai2.org.apache.poi.ss.usermodel.HorizontalAlignment;
import ai2.org.apache.poi.ss.usermodel.IndexedColors;
import ai2.org.apache.poi.ss.usermodel.VerticalAlignment;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.model.ThemesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataFormat;
import ai2.org.apache.poi.xssf.usermodel.XSSFFont;
import ai2.org.apache.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import ai2.org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import ai2.org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;

public class XSSFCellStyle
implements CellStyle {
    private int _cellXfId;
    private StylesTable _stylesSource;
    private CTXf _cellXf;
    private CTXf _cellStyleXf;
    private XSSFFont _font;
    private XSSFCellAlignment _cellAlignment;
    private ThemesTable _theme;

    public XSSFCellStyle(int n, int n2, StylesTable stylesTable, ThemesTable themesTable) {
        this._cellXfId = n;
        this._stylesSource = stylesTable;
        this._cellXf = stylesTable.getCellXfAt(this._cellXfId);
        this._cellStyleXf = n2 == -1 ? null : stylesTable.getCellStyleXfAt(n2);
        this._theme = themesTable;
    }

    @Internal
    public CTXf getCoreXf() {
        return this._cellXf;
    }

    @Internal
    public CTXf getStyleXf() {
        return this._cellStyleXf;
    }

    public XSSFCellStyle(StylesTable stylesTable) {
        this._stylesSource = stylesTable;
        this._cellXf = CTXf.Factory.newInstance();
        this._cellStyleXf = null;
    }

    public void verifyBelongsToStylesSource(StylesTable stylesTable) {
        if (this._stylesSource != stylesTable) {
            throw new IllegalArgumentException("This Style does not belong to the supplied Workbook Stlyes Source. Are you trying to assign a style from one workbook to the cell of a differnt workbook?");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cloneStyleFrom(CellStyle cellStyle) {
        if (!(cellStyle instanceof XSSFCellStyle)) throw new IllegalArgumentException("Can only clone from one XSSFCellStyle to another, not between HSSFCellStyle and XSSFCellStyle");
        XSSFCellStyle xSSFCellStyle = (XSSFCellStyle)cellStyle;
        if (xSSFCellStyle._stylesSource == this._stylesSource) {
            this._cellXf.set((XmlObject)xSSFCellStyle.getCoreXf());
            this._cellStyleXf.set((XmlObject)xSSFCellStyle.getStyleXf());
        } else {
            try {
                if (this._cellXf.isSetAlignment()) {
                    this._cellXf.unsetAlignment();
                }
                if (this._cellXf.isSetExtLst()) {
                    this._cellXf.unsetExtLst();
                }
                this._cellXf = CTXf.Factory.parse((String)xSSFCellStyle.getCoreXf().toString());
                CTFill cTFill = CTFill.Factory.parse((String)xSSFCellStyle.getCTFill().toString());
                this.addFill(cTFill);
                this._stylesSource.replaceCellXfAt(this._cellXfId, this._cellXf);
            }
            catch (XmlException xmlException) {
                throw new POIXMLException(xmlException);
            }
            String string = xSSFCellStyle.getDataFormatString();
            this.setDataFormat(new XSSFDataFormat(this._stylesSource).getFormat(string));
            try {
                CTFont cTFont = CTFont.Factory.parse((String)xSSFCellStyle.getFont().getCTFont().toString());
                XSSFFont xSSFFont = new XSSFFont(cTFont);
                xSSFFont.registerTo(this._stylesSource);
                this.setFont(xSSFFont);
            }
            catch (XmlException xmlException) {
                throw new POIXMLException(xmlException);
            }
        }
        this._font = null;
        this._cellAlignment = null;
    }

    private void addFill(CTFill cTFill) {
        int n = this._stylesSource.putFill(new XSSFCellFill(cTFill));
        this._cellXf.setFillId((long)n);
        this._cellXf.setApplyFill(true);
    }

    public short getAlignment() {
        return (short)this.getAlignmentEnum().ordinal();
    }

    public HorizontalAlignment getAlignmentEnum() {
        CTCellAlignment cTCellAlignment = this._cellXf.getAlignment();
        if (cTCellAlignment != null && cTCellAlignment.isSetHorizontal()) {
            return HorizontalAlignment.values()[cTCellAlignment.getHorizontal().intValue() - 1];
        }
        return HorizontalAlignment.GENERAL;
    }

    public short getBorderBottom() {
        if (!this._cellXf.getApplyBorder()) {
            return 0;
        }
        int n = (int)this._cellXf.getBorderId();
        CTBorder cTBorder = this._stylesSource.getBorderAt(n).getCTBorder();
        STBorderStyle.Enum enum_ = cTBorder.isSetBottom() ? cTBorder.getBottom().getStyle() : null;
        return enum_ == null ? (short)0 : (short)(enum_.intValue() - 1);
    }

    public BorderStyle getBorderBottomEnum() {
        short s = this.getBorderBottom();
        return BorderStyle.values()[s];
    }

    public short getBorderLeft() {
        if (!this._cellXf.getApplyBorder()) {
            return 0;
        }
        int n = (int)this._cellXf.getBorderId();
        CTBorder cTBorder = this._stylesSource.getBorderAt(n).getCTBorder();
        STBorderStyle.Enum enum_ = cTBorder.isSetLeft() ? cTBorder.getLeft().getStyle() : null;
        return enum_ == null ? (short)0 : (short)(enum_.intValue() - 1);
    }

    public BorderStyle getBorderLeftEnum() {
        short s = this.getBorderLeft();
        return BorderStyle.values()[s];
    }

    public short getBorderRight() {
        if (!this._cellXf.getApplyBorder()) {
            return 0;
        }
        int n = (int)this._cellXf.getBorderId();
        CTBorder cTBorder = this._stylesSource.getBorderAt(n).getCTBorder();
        STBorderStyle.Enum enum_ = cTBorder.isSetRight() ? cTBorder.getRight().getStyle() : null;
        return enum_ == null ? (short)0 : (short)(enum_.intValue() - 1);
    }

    public BorderStyle getBorderRightEnum() {
        short s = this.getBorderRight();
        return BorderStyle.values()[s];
    }

    public short getBorderTop() {
        if (!this._cellXf.getApplyBorder()) {
            return 0;
        }
        int n = (int)this._cellXf.getBorderId();
        CTBorder cTBorder = this._stylesSource.getBorderAt(n).getCTBorder();
        STBorderStyle.Enum enum_ = cTBorder.isSetTop() ? cTBorder.getTop().getStyle() : null;
        return enum_ == null ? (short)0 : (short)(enum_.intValue() - 1);
    }

    public BorderStyle getBorderTopEnum() {
        short s = this.getBorderTop();
        return BorderStyle.values()[s];
    }

    public short getBottomBorderColor() {
        XSSFColor xSSFColor = this.getBottomBorderXSSFColor();
        return xSSFColor == null ? IndexedColors.BLACK.getIndex() : xSSFColor.getIndexed();
    }

    public XSSFColor getBottomBorderXSSFColor() {
        if (!this._cellXf.getApplyBorder()) {
            return null;
        }
        int n = (int)this._cellXf.getBorderId();
        XSSFCellBorder xSSFCellBorder = this._stylesSource.getBorderAt(n);
        return xSSFCellBorder.getBorderColor(XSSFCellBorder.BorderSide.BOTTOM);
    }

    public short getDataFormat() {
        return (short)this._cellXf.getNumFmtId();
    }

    public String getDataFormatString() {
        short s = this.getDataFormat();
        return new XSSFDataFormat(this._stylesSource).getFormat(s);
    }

    public short getFillBackgroundColor() {
        XSSFColor xSSFColor = this.getFillBackgroundXSSFColor();
        return xSSFColor == null ? IndexedColors.AUTOMATIC.getIndex() : xSSFColor.getIndexed();
    }

    public XSSFColor getFillBackgroundColorColor() {
        return this.getFillBackgroundXSSFColor();
    }

    public XSSFColor getFillBackgroundXSSFColor() {
        if (this._cellXf.isSetApplyFill() && !this._cellXf.getApplyFill()) {
            return null;
        }
        int n = (int)this._cellXf.getFillId();
        XSSFCellFill xSSFCellFill = this._stylesSource.getFillAt(n);
        XSSFColor xSSFColor = xSSFCellFill.getFillBackgroundColor();
        if (xSSFColor != null && this._theme != null) {
            this._theme.inheritFromThemeAsRequired(xSSFColor);
        }
        return xSSFColor;
    }

    public short getFillForegroundColor() {
        XSSFColor xSSFColor = this.getFillForegroundXSSFColor();
        return xSSFColor == null ? IndexedColors.AUTOMATIC.getIndex() : xSSFColor.getIndexed();
    }

    public XSSFColor getFillForegroundColorColor() {
        return this.getFillForegroundXSSFColor();
    }

    public XSSFColor getFillForegroundXSSFColor() {
        if (this._cellXf.isSetApplyFill() && !this._cellXf.getApplyFill()) {
            return null;
        }
        int n = (int)this._cellXf.getFillId();
        XSSFCellFill xSSFCellFill = this._stylesSource.getFillAt(n);
        XSSFColor xSSFColor = xSSFCellFill.getFillForegroundColor();
        if (xSSFColor != null && this._theme != null) {
            this._theme.inheritFromThemeAsRequired(xSSFColor);
        }
        return xSSFColor;
    }

    public short getFillPattern() {
        if (this._cellXf.isSetApplyFill() && !this._cellXf.getApplyFill()) {
            return 0;
        }
        int n = (int)this._cellXf.getFillId();
        XSSFCellFill xSSFCellFill = this._stylesSource.getFillAt(n);
        STPatternType.Enum enum_ = xSSFCellFill.getPatternType();
        if (enum_ == null) {
            return 0;
        }
        return (short)(enum_.intValue() - 1);
    }

    public FillPatternType getFillPatternEnum() {
        short s = this.getFillPattern();
        return FillPatternType.values()[s];
    }

    public XSSFFont getFont() {
        if (this._font == null) {
            this._font = this._stylesSource.getFontAt(this.getFontId());
        }
        return this._font;
    }

    public short getFontIndex() {
        return (short)this.getFontId();
    }

    public boolean getHidden() {
        if (!this._cellXf.isSetProtection() || !this._cellXf.getProtection().isSetHidden()) {
            return false;
        }
        return this._cellXf.getProtection().getHidden();
    }

    public short getIndention() {
        CTCellAlignment cTCellAlignment = this._cellXf.getAlignment();
        return (short)(cTCellAlignment == null ? 0L : cTCellAlignment.getIndent());
    }

    public short getIndex() {
        return (short)this._cellXfId;
    }

    protected int getUIndex() {
        return this._cellXfId;
    }

    public short getLeftBorderColor() {
        XSSFColor xSSFColor = this.getLeftBorderXSSFColor();
        return xSSFColor == null ? IndexedColors.BLACK.getIndex() : xSSFColor.getIndexed();
    }

    public XSSFColor getLeftBorderXSSFColor() {
        if (!this._cellXf.getApplyBorder()) {
            return null;
        }
        int n = (int)this._cellXf.getBorderId();
        XSSFCellBorder xSSFCellBorder = this._stylesSource.getBorderAt(n);
        return xSSFCellBorder.getBorderColor(XSSFCellBorder.BorderSide.LEFT);
    }

    public boolean getLocked() {
        if (!this._cellXf.isSetProtection() || !this._cellXf.getProtection().isSetLocked()) {
            return true;
        }
        return this._cellXf.getProtection().getLocked();
    }

    public short getRightBorderColor() {
        XSSFColor xSSFColor = this.getRightBorderXSSFColor();
        return xSSFColor == null ? IndexedColors.BLACK.getIndex() : xSSFColor.getIndexed();
    }

    public XSSFColor getRightBorderXSSFColor() {
        if (!this._cellXf.getApplyBorder()) {
            return null;
        }
        int n = (int)this._cellXf.getBorderId();
        XSSFCellBorder xSSFCellBorder = this._stylesSource.getBorderAt(n);
        return xSSFCellBorder.getBorderColor(XSSFCellBorder.BorderSide.RIGHT);
    }

    public short getRotation() {
        CTCellAlignment cTCellAlignment = this._cellXf.getAlignment();
        return (short)(cTCellAlignment == null ? 0L : cTCellAlignment.getTextRotation());
    }

    public boolean getShrinkToFit() {
        CTCellAlignment cTCellAlignment = this._cellXf.getAlignment();
        return cTCellAlignment != null && cTCellAlignment.getShrinkToFit();
    }

    public short getTopBorderColor() {
        XSSFColor xSSFColor = this.getTopBorderXSSFColor();
        return xSSFColor == null ? IndexedColors.BLACK.getIndex() : xSSFColor.getIndexed();
    }

    public XSSFColor getTopBorderXSSFColor() {
        if (!this._cellXf.getApplyBorder()) {
            return null;
        }
        int n = (int)this._cellXf.getBorderId();
        XSSFCellBorder xSSFCellBorder = this._stylesSource.getBorderAt(n);
        return xSSFCellBorder.getBorderColor(XSSFCellBorder.BorderSide.TOP);
    }

    public short getVerticalAlignment() {
        return (short)this.getVerticalAlignmentEnum().ordinal();
    }

    public VerticalAlignment getVerticalAlignmentEnum() {
        CTCellAlignment cTCellAlignment = this._cellXf.getAlignment();
        if (cTCellAlignment != null && cTCellAlignment.isSetVertical()) {
            return VerticalAlignment.values()[cTCellAlignment.getVertical().intValue() - 1];
        }
        return VerticalAlignment.BOTTOM;
    }

    public boolean getWrapText() {
        CTCellAlignment cTCellAlignment = this._cellXf.getAlignment();
        return cTCellAlignment != null && cTCellAlignment.getWrapText();
    }

    public void setAlignment(short s) {
        this.getCellAlignment().setHorizontal(HorizontalAlignment.values()[s]);
    }

    public void setAlignment(HorizontalAlignment horizontalAlignment) {
        this.setAlignment((short)horizontalAlignment.ordinal());
    }

    public void setBorderBottom(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetBottom() ? cTBorder.getBottom() : cTBorder.addNewBottom();
        if (s == 0) {
            cTBorder.unsetBottom();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        int n = this._stylesSource.putBorder(new XSSFCellBorder(cTBorder, this._theme));
        this._cellXf.setBorderId((long)n);
        this._cellXf.setApplyBorder(true);
    }

    public void setBorderBottom(BorderStyle borderStyle) {
        this.setBorderBottom((short)borderStyle.ordinal());
    }

    public void setBorderLeft(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetLeft() ? cTBorder.getLeft() : cTBorder.addNewLeft();
        if (s == 0) {
            cTBorder.unsetLeft();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        int n = this._stylesSource.putBorder(new XSSFCellBorder(cTBorder, this._theme));
        this._cellXf.setBorderId((long)n);
        this._cellXf.setApplyBorder(true);
    }

    public void setBorderLeft(BorderStyle borderStyle) {
        this.setBorderLeft((short)borderStyle.ordinal());
    }

    public void setBorderRight(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetRight() ? cTBorder.getRight() : cTBorder.addNewRight();
        if (s == 0) {
            cTBorder.unsetRight();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        int n = this._stylesSource.putBorder(new XSSFCellBorder(cTBorder, this._theme));
        this._cellXf.setBorderId((long)n);
        this._cellXf.setApplyBorder(true);
    }

    public void setBorderRight(BorderStyle borderStyle) {
        this.setBorderRight((short)borderStyle.ordinal());
    }

    public void setBorderTop(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetTop() ? cTBorder.getTop() : cTBorder.addNewTop();
        if (s == 0) {
            cTBorder.unsetTop();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        int n = this._stylesSource.putBorder(new XSSFCellBorder(cTBorder, this._theme));
        this._cellXf.setBorderId((long)n);
        this._cellXf.setApplyBorder(true);
    }

    public void setBorderTop(BorderStyle borderStyle) {
        this.setBorderTop((short)borderStyle.ordinal());
    }

    public void setBottomBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed(s);
        this.setBottomBorderColor(xSSFColor);
    }

    public void setBottomBorderColor(XSSFColor xSSFColor) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        if (xSSFColor == null && !cTBorder.isSetBottom()) {
            return;
        }
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetBottom() ? cTBorder.getBottom() : cTBorder.addNewBottom();
        if (xSSFColor != null) {
            cTBorderPr.setColor(xSSFColor.getCTColor());
        } else {
            cTBorderPr.unsetColor();
        }
        int n = this._stylesSource.putBorder(new XSSFCellBorder(cTBorder, this._theme));
        this._cellXf.setBorderId((long)n);
        this._cellXf.setApplyBorder(true);
    }

    public void setDataFormat(short s) {
        this.setDataFormat(s & 0xFFFF);
    }

    public void setDataFormat(int n) {
        this._cellXf.setApplyNumberFormat(true);
        this._cellXf.setNumFmtId((long)n);
    }

    public void setFillBackgroundColor(XSSFColor xSSFColor) {
        CTFill cTFill = this.getCTFill();
        CTPatternFill cTPatternFill = cTFill.getPatternFill();
        if (xSSFColor == null) {
            if (cTPatternFill != null) {
                cTPatternFill.unsetBgColor();
            }
        } else {
            if (cTPatternFill == null) {
                cTPatternFill = cTFill.addNewPatternFill();
            }
            cTPatternFill.setBgColor(xSSFColor.getCTColor());
        }
        this.addFill(cTFill);
    }

    public void setFillBackgroundColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed(s);
        this.setFillBackgroundColor(xSSFColor);
    }

    public void setFillForegroundColor(XSSFColor xSSFColor) {
        CTFill cTFill = this.getCTFill();
        CTPatternFill cTPatternFill = cTFill.getPatternFill();
        if (xSSFColor == null) {
            if (cTPatternFill != null) {
                cTPatternFill.unsetFgColor();
            }
        } else {
            if (cTPatternFill == null) {
                cTPatternFill = cTFill.addNewPatternFill();
            }
            cTPatternFill.setFgColor(xSSFColor.getCTColor());
        }
        this.addFill(cTFill);
    }

    public void setFillForegroundColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed(s);
        this.setFillForegroundColor(xSSFColor);
    }

    private CTFill getCTFill() {
        CTFill cTFill;
        if (!this._cellXf.isSetApplyFill() || this._cellXf.getApplyFill()) {
            int n = (int)this._cellXf.getFillId();
            XSSFCellFill xSSFCellFill = this._stylesSource.getFillAt(n);
            cTFill = (CTFill)xSSFCellFill.getCTFill().copy();
        } else {
            cTFill = CTFill.Factory.newInstance();
        }
        return cTFill;
    }

    private CTBorder getCTBorder() {
        CTBorder cTBorder;
        if (this._cellXf.getApplyBorder()) {
            int n = (int)this._cellXf.getBorderId();
            XSSFCellBorder xSSFCellBorder = this._stylesSource.getBorderAt(n);
            cTBorder = (CTBorder)xSSFCellBorder.getCTBorder().copy();
        } else {
            cTBorder = CTBorder.Factory.newInstance();
        }
        return cTBorder;
    }

    public void setFillPattern(short s) {
        CTPatternFill cTPatternFill;
        CTFill cTFill = this.getCTFill();
        CTPatternFill cTPatternFill2 = cTPatternFill = cTFill.isSetPatternFill() ? cTFill.getPatternFill() : cTFill.addNewPatternFill();
        if (s == 0 && cTPatternFill.isSetPatternType()) {
            cTPatternFill.unsetPatternType();
        } else {
            cTPatternFill.setPatternType(STPatternType.Enum.forInt((int)(s + 1)));
        }
        this.addFill(cTFill);
    }

    public void setFillPattern(FillPatternType fillPatternType) {
        this.setFillPattern((short)fillPatternType.ordinal());
    }

    public void setFont(Font font) {
        if (font != null) {
            long l = font.getIndex();
            this._cellXf.setFontId(l);
            this._cellXf.setApplyFont(true);
        } else {
            this._cellXf.setApplyFont(false);
        }
    }

    public void setHidden(boolean bl) {
        if (!this._cellXf.isSetProtection()) {
            this._cellXf.addNewProtection();
        }
        this._cellXf.getProtection().setHidden(bl);
    }

    public void setIndention(short s) {
        this.getCellAlignment().setIndent(s);
    }

    public void setLeftBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed(s);
        this.setLeftBorderColor(xSSFColor);
    }

    public void setLeftBorderColor(XSSFColor xSSFColor) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        if (xSSFColor == null && !cTBorder.isSetLeft()) {
            return;
        }
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetLeft() ? cTBorder.getLeft() : cTBorder.addNewLeft();
        if (xSSFColor != null) {
            cTBorderPr.setColor(xSSFColor.getCTColor());
        } else {
            cTBorderPr.unsetColor();
        }
        int n = this._stylesSource.putBorder(new XSSFCellBorder(cTBorder, this._theme));
        this._cellXf.setBorderId((long)n);
        this._cellXf.setApplyBorder(true);
    }

    public void setLocked(boolean bl) {
        if (!this._cellXf.isSetProtection()) {
            this._cellXf.addNewProtection();
        }
        this._cellXf.getProtection().setLocked(bl);
    }

    public void setRightBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed(s);
        this.setRightBorderColor(xSSFColor);
    }

    public void setRightBorderColor(XSSFColor xSSFColor) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        if (xSSFColor == null && !cTBorder.isSetRight()) {
            return;
        }
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetRight() ? cTBorder.getRight() : cTBorder.addNewRight();
        if (xSSFColor != null) {
            cTBorderPr.setColor(xSSFColor.getCTColor());
        } else {
            cTBorderPr.unsetColor();
        }
        int n = this._stylesSource.putBorder(new XSSFCellBorder(cTBorder, this._theme));
        this._cellXf.setBorderId((long)n);
        this._cellXf.setApplyBorder(true);
    }

    public void setRotation(short s) {
        this.getCellAlignment().setTextRotation(s);
    }

    public void setTopBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed(s);
        this.setTopBorderColor(xSSFColor);
    }

    public void setTopBorderColor(XSSFColor xSSFColor) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        if (xSSFColor == null && !cTBorder.isSetTop()) {
            return;
        }
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetTop() ? cTBorder.getTop() : cTBorder.addNewTop();
        if (xSSFColor != null) {
            cTBorderPr.setColor(xSSFColor.getCTColor());
        } else {
            cTBorderPr.unsetColor();
        }
        int n = this._stylesSource.putBorder(new XSSFCellBorder(cTBorder, this._theme));
        this._cellXf.setBorderId((long)n);
        this._cellXf.setApplyBorder(true);
    }

    public void setVerticalAlignment(short s) {
        this.getCellAlignment().setVertical(VerticalAlignment.values()[s]);
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.getCellAlignment().setVertical(verticalAlignment);
    }

    public void setWrapText(boolean bl) {
        this.getCellAlignment().setWrapText(bl);
    }

    public XSSFColor getBorderColor(XSSFCellBorder.BorderSide borderSide) {
        switch (borderSide) {
            case BOTTOM: {
                return this.getBottomBorderXSSFColor();
            }
            case RIGHT: {
                return this.getRightBorderXSSFColor();
            }
            case TOP: {
                return this.getTopBorderXSSFColor();
            }
            case LEFT: {
                return this.getLeftBorderXSSFColor();
            }
        }
        throw new IllegalArgumentException("Unknown border: " + (Object)((Object)borderSide));
    }

    public void setBorderColor(XSSFCellBorder.BorderSide borderSide, XSSFColor xSSFColor) {
        switch (borderSide) {
            case BOTTOM: {
                this.setBottomBorderColor(xSSFColor);
                break;
            }
            case RIGHT: {
                this.setRightBorderColor(xSSFColor);
                break;
            }
            case TOP: {
                this.setTopBorderColor(xSSFColor);
                break;
            }
            case LEFT: {
                this.setLeftBorderColor(xSSFColor);
            }
        }
    }

    public void setShrinkToFit(boolean bl) {
        this.getCellAlignment().setShrinkToFit(bl);
    }

    private int getFontId() {
        if (this._cellXf.isSetFontId()) {
            return (int)this._cellXf.getFontId();
        }
        return (int)this._cellStyleXf.getFontId();
    }

    protected XSSFCellAlignment getCellAlignment() {
        if (this._cellAlignment == null) {
            this._cellAlignment = new XSSFCellAlignment(this.getCTCellAlignment());
        }
        return this._cellAlignment;
    }

    private CTCellAlignment getCTCellAlignment() {
        if (this._cellXf.getAlignment() == null) {
            this._cellXf.setAlignment(CTCellAlignment.Factory.newInstance());
        }
        return this._cellXf.getAlignment();
    }

    public int hashCode() {
        return this._cellXf.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof XSSFCellStyle)) {
            return false;
        }
        XSSFCellStyle xSSFCellStyle = (XSSFCellStyle)object;
        return this._cellXf.toString().equals(xSSFCellStyle.getCoreXf().toString());
    }

    public Object clone() {
        CTXf cTXf = (CTXf)this._cellXf.copy();
        int n = this._stylesSource._getStyleXfsSize();
        int n2 = this._stylesSource.putCellXf(cTXf);
        return new XSSFCellStyle(n2 - 1, n - 1, this._stylesSource, this._theme);
    }
}

