/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.streaming;

import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.usermodel.FormulaError;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.TempFile;
import ai2.org.apache.poi.xssf.model.SharedStringsTable;
import ai2.org.apache.poi.xssf.streaming.SXSSFRow;
import ai2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellType;

public class SheetDataWriter {
    private final File _fd = this.createTempFile();
    private final Writer _out = this.createWriter(this._fd);
    private int _rownum;
    private int _numberOfFlushedRows;
    private int _lowestIndexOfFlushedRows;
    private int _numberOfCellsOfLastFlushedRow;
    private int _numberLastFlushedRow = -1;
    private SharedStringsTable _sharedStringSource;

    public SheetDataWriter() throws IOException {
    }

    public SheetDataWriter(SharedStringsTable sharedStringsTable) throws IOException {
        this();
        this._sharedStringSource = sharedStringsTable;
    }

    public File createTempFile() throws IOException {
        return TempFile.createTempFile("poi-sxssf-sheet", ".xml");
    }

    public Writer createWriter(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
    }

    public void close() throws IOException {
        this._out.flush();
        this._out.close();
    }

    File getTempFile() {
        return this._fd;
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        File file = this.getTempFile();
        return new FileInputStream(file);
    }

    public int getNumberOfFlushedRows() {
        return this._numberOfFlushedRows;
    }

    public int getNumberOfCellsOfLastFlushedRow() {
        return this._numberOfCellsOfLastFlushedRow;
    }

    public int getLowestIndexOfFlushedRows() {
        return this._lowestIndexOfFlushedRows;
    }

    public int getLastFlushedRow() {
        return this._numberLastFlushedRow;
    }

    protected void finalize() throws Throwable {
        this._fd.delete();
        super.finalize();
    }

    public void writeRow(int n, SXSSFRow sXSSFRow) throws IOException {
        if (this._numberOfFlushedRows == 0) {
            this._lowestIndexOfFlushedRows = n;
        }
        this._numberLastFlushedRow = Math.max(n, this._numberLastFlushedRow);
        this._numberOfCellsOfLastFlushedRow = sXSSFRow.getLastCellNum();
        ++this._numberOfFlushedRows;
        this.beginRow(n, sXSSFRow);
        Iterator<Cell> iterator = sXSSFRow.allCellsIterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this.writeCell(n2++, iterator.next());
        }
        this.endRow();
    }

    void beginRow(int n, SXSSFRow sXSSFRow) throws IOException {
        this._out.write("<row r=\"" + (n + 1) + "\"");
        if (sXSSFRow.hasCustomHeight()) {
            this._out.write(" customHeight=\"true\"  ht=\"" + sXSSFRow.getHeightInPoints() + "\"");
        }
        if (sXSSFRow.getZeroHeight()) {
            this._out.write(" hidden=\"true\"");
        }
        if (sXSSFRow.isFormatted()) {
            this._out.write(" s=\"" + sXSSFRow._style + "\"");
            this._out.write(" customFormat=\"1\"");
        }
        if (sXSSFRow.getOutlineLevel() != 0) {
            this._out.write(" outlineLevel=\"" + sXSSFRow.getOutlineLevel() + "\"");
        }
        if (sXSSFRow.getHidden() != null) {
            this._out.write(" hidden=\"" + (sXSSFRow.getHidden() != false ? "1" : "0") + "\"");
        }
        if (sXSSFRow.getCollapsed() != null) {
            this._out.write(" collapsed=\"" + (sXSSFRow.getCollapsed() != false ? "1" : "0") + "\"");
        }
        this._out.write(">\n");
        this._rownum = n;
    }

    void endRow() throws IOException {
        this._out.write("</row>\n");
    }

    public void writeCell(int n, Cell cell) throws IOException {
        if (cell == null) {
            return;
        }
        String string = new CellReference(this._rownum, n).formatAsString();
        this._out.write("<c r=\"" + string + "\"");
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle.getIndex() != 0) {
            this._out.write(" s=\"" + (cellStyle.getIndex() & 0xFFFF) + "\"");
        }
        int n2 = cell.getCellType();
        switch (n2) {
            case 3: {
                this._out.write(">");
                break;
            }
            case 2: {
                this._out.write(">");
                this._out.write("<f>");
                this.outputQuotedString(cell.getCellFormula());
                this._out.write("</f>");
                switch (cell.getCachedFormulaResultType()) {
                    case 0: {
                        double d = cell.getNumericCellValue();
                        if (Double.isNaN(d)) break;
                        this._out.write("<v>" + d + "</v>");
                    }
                }
                break;
            }
            case 1: {
                if (this._sharedStringSource != null) {
                    XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(cell.getStringCellValue());
                    int n3 = this._sharedStringSource.addEntry(xSSFRichTextString.getCTRst());
                    this._out.write(" t=\"" + STCellType.S.toString() + "\">");
                    this._out.write("<v>");
                    this._out.write(String.valueOf(n3));
                    this._out.write("</v>");
                    break;
                }
                this._out.write(" t=\"inlineStr\">");
                this._out.write("<is><t");
                if (this.hasLeadingTrailingSpaces(cell.getStringCellValue())) {
                    this._out.write(" xml:space=\"preserve\"");
                }
                this._out.write(">");
                this.outputQuotedString(cell.getStringCellValue());
                this._out.write("</t></is>");
                break;
            }
            case 0: {
                this._out.write(" t=\"n\">");
                this._out.write("<v>" + cell.getNumericCellValue() + "</v>");
                break;
            }
            case 4: {
                this._out.write(" t=\"b\">");
                this._out.write("<v>" + (cell.getBooleanCellValue() ? "1" : "0") + "</v>");
                break;
            }
            case 5: {
                FormulaError formulaError = FormulaError.forInt(cell.getErrorCellValue());
                this._out.write(" t=\"e\">");
                this._out.write("<v>" + formulaError.getString() + "</v>");
                break;
            }
            default: {
                throw new RuntimeException("Huh?");
            }
        }
        this._out.write("</c>");
    }

    boolean hasLeadingTrailingSpaces(String string) {
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            char c2 = string.charAt(string.length() - 1);
            return Character.isWhitespace(c) || Character.isWhitespace(c2);
        }
        return false;
    }

    protected void outputQuotedString(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = string.length();
        block9: for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            switch (c) {
                case '<': {
                    if (i > n) {
                        this._out.write(cArray, n, i - n);
                    }
                    n = i + 1;
                    this._out.write("&lt;");
                    continue block9;
                }
                case '>': {
                    if (i > n) {
                        this._out.write(cArray, n, i - n);
                    }
                    n = i + 1;
                    this._out.write("&gt;");
                    continue block9;
                }
                case '&': {
                    if (i > n) {
                        this._out.write(cArray, n, i - n);
                    }
                    n = i + 1;
                    this._out.write("&amp;");
                    continue block9;
                }
                case '\"': {
                    if (i > n) {
                        this._out.write(cArray, n, i - n);
                    }
                    n = i + 1;
                    this._out.write("&quot;");
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    if (i > n) {
                        this._out.write(cArray, n, i - n);
                    }
                    this._out.write("&#xa;");
                    n = i + 1;
                    continue block9;
                }
                case '\t': {
                    if (i > n) {
                        this._out.write(cArray, n, i - n);
                    }
                    this._out.write("&#x9;");
                    n = i + 1;
                    continue block9;
                }
                case '\u00a0': {
                    if (i > n) {
                        this._out.write(cArray, n, i - n);
                    }
                    this._out.write("&#xa0;");
                    n = i + 1;
                    continue block9;
                }
                default: {
                    if (c < ' ' || Character.isLowSurrogate(c) || Character.isHighSurrogate(c) || '\ufffe' <= c && c <= '\uffff') {
                        if (i > n) {
                            this._out.write(cArray, n, i - n);
                        }
                        this._out.write(63);
                        n = i + 1;
                        continue block9;
                    }
                    if (c <= '\u007f') continue block9;
                    if (i > n) {
                        this._out.write(cArray, n, i - n);
                    }
                    n = i + 1;
                    this._out.write("&#");
                    this._out.write(String.valueOf((int)c));
                    this._out.write(";");
                }
            }
        }
        if (n < n2) {
            this._out.write(cArray, n, n2 - n);
        }
    }

    boolean dispose() throws IOException {
        this._out.close();
        return this._fd.delete();
    }
}

